/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.ab.service;

import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbOrCompanyPayload;
import com.elitesland.tw.tw5.api.prd.ab.payload.PrdAbPayload;
import com.elitesland.tw.tw5.api.prd.ab.service.PrdAbService;
import com.elitesland.tw.tw5.api.prd.ab.vo.PrdAbVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.ab.convert.PrdAbConvert;
import com.elitesland.tw.tw5.server.prd.ab.dao.PrdAbDAO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbAddressDO;
import com.elitesland.tw.tw5.server.prd.ab.entity.PrdAbDO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SystemDefaultEnum;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgCompanyDO;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
public class PrdAbServiceImpl
implements PrdAbService {
    private static final Logger log = LoggerFactory.getLogger(PrdAbServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdAbDAO dao;

    @Transactional(propagation=Propagation.REQUIRED)
    public PrdAbVO saveAbOrCompany(PrdAbOrCompanyPayload payload) {
        PrdAbVO abVO = null;
        if (payload.getTaxNo() != null) {
            abVO = this.dao.queryCompanyByTaxNo(payload.getTaxNo());
        }
        boolean isNew = false;
        PrdAbDO abDO = null;
        if (abVO == null) {
            abDO = PrdAbConvert.INSTANCE.toDo(payload);
            abDO.setBookName(payload.getCompanyName());
            abDO = this.dao.save(abDO);
            isNew = true;
        }
        if (isNew) {
            PrdOrgCompanyDO companyDO = PrdAbConvert.INSTANCE.toCompanyDo(payload);
            companyDO.setCompanyNo(payload.getBookNo());
            companyDO.setBookId(abDO.getId());
            this.dao.saveCompany(companyDO);
            PrdAbAddressDO abAddressDO = new PrdAbAddressDO();
            abAddressDO.setBookId(abDO.getId());
            abAddressDO.setAddressEmail(payload.getCompanyEmail());
            abAddressDO.setAddressType(SystemDefaultEnum.DefaultAddressType.getCode());
            abAddressDO.setCity(payload.getCity());
            abAddressDO.setCityName(payload.getCityName());
            abAddressDO.setCountry("");
            abAddressDO.setDetailAddress(payload.getCompanyAddress());
            abAddressDO.setDistrict(payload.getDistrict());
            abAddressDO.setDistrictName(payload.getDistrictName());
            abAddressDO.setProvince(payload.getProvince());
            abAddressDO.setProvinceName(payload.getProvinceName());
            this.dao.saveAddress(abAddressDO);
        } else if (!abVO.getRelateType().contains(payload.getRelateType())) {
            PrdAbPayload ab = new PrdAbPayload();
            ab.setId(abVO.getId());
            if ("".equals(abVO.getRelateType())) {
                ab.setRelateType(payload.getRelateType());
            } else {
                ab.setRelateType(abVO.getRelateType() + "," + payload.getRelateType());
            }
            this.dao.updateByKeyDynamic(ab);
        } else {
            throw TwException.error("", "\u8be5\u7a0e\u53f7\u6863\u6848\u5e93\u5df2\u5b58\u5728");
        }
        return PrdAbConvert.INSTANCE.toVo(abDO);
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public boolean updateAbOrCompany(PrdAbOrCompanyPayload payload) {
        PrdAbVO abVO = null;
        if (StringUtils.hasText((String)payload.getTaxNo())) {
            abVO = this.dao.queryCompanyByTaxNo(payload.getTaxNo());
        }
        if (abVO == null || abVO.getId().longValue() == payload.getId().longValue()) {
            if (StringUtils.hasText((String)payload.getCompanyName())) {
                PrdAbPayload ab = new PrdAbPayload();
                ab.setId(payload.getId());
                ab.setBookName(payload.getCompanyName());
                this.dao.updateByKeyDynamic(ab);
            }
        } else {
            throw TwException.error("", "\u8be5\u7a0e\u53f7\u6863\u6848\u5e93\u5df2\u5b58\u5728");
        }
        this.dao.updateCompanyByKey(payload);
        return true;
    }

    public Long update(PrdAbPayload payload) {
        return null;
    }

    public List<PrdAbVO> queryList() {
        return null;
    }

    public PrdAbVO queryByKey(Long key) {
        PrdAbVO vo = this.dao.queryByKey(key);
        return vo;
    }

    public boolean deleteSoft(List<Long> keys) {
        return false;
    }

    public PrdAbServiceImpl(CacheUtil cacheUtil, PrdAbDAO dao) {
        this.cacheUtil = cacheUtil;
        this.dao = dao;
    }
}

