/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.budget.payload.PmsBudgetOccupyPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.PmsBudgetOccupyQuery;
import com.elitesland.tw.tw5.api.prd.budget.vo.PmsBudgetOccupyVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.budget.convert.PmsBudgetOccupyConvert;
import com.elitesland.tw.tw5.server.prd.budget.entity.PmsBudgetOccupyDO;
import com.elitesland.tw.tw5.server.prd.budget.entity.QPmsBudgetOccupyDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.PmsBudgetOccupyRepo;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PmsBudgetOccupyDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PmsBudgetOccupyRepo repo;
    private final QPmsBudgetOccupyDO qdo = QPmsBudgetOccupyDO.pmsBudgetOccupyDO;

    private JPAQuery<PmsBudgetOccupyDO> getJpaQuerySelect() {
        return (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo);
    }

    private JPAQuery<PmsBudgetOccupyDO> getJpaQueryWhere(PmsBudgetOccupyQuery query) {
        JPAQuery<PmsBudgetOccupyDO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PmsBudgetOccupyQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PmsBudgetOccupyQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocId())) {
            list.add(this.qdo.docId.eq((Object)query.getDocId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCostType())) {
            list.add(this.qdo.costType.eq((Object)query.getCostType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocType())) {
            list.add(this.qdo.docType.eq((Object)query.getDocType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocCode())) {
            list.add(this.qdo.docCode.like(SqlUtil.toSqlLikeString(query.getDocCode())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocName())) {
            list.add(this.qdo.docName.like(SqlUtil.toSqlLikeString(query.getDocName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBudgetId())) {
            list.add(this.qdo.budgetId.eq((Object)query.getBudgetId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBelongToId())) {
            list.add(this.qdo.belongToId.eq((Object)query.getBelongToId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PmsBudgetOccupyVO queryByKey(Long id) {
        JPAQuery<PmsBudgetOccupyDO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return PmsBudgetOccupyConvert.INSTANCE.toVo((PmsBudgetOccupyDO)jpaQuery.fetchFirst());
    }

    public PmsBudgetOccupyVO queryByBizKey(Long budgetId, String docType, Long belongToId, String costType, Long docId) {
        JPAQuery<PmsBudgetOccupyDO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.budgetId.eq((Object)budgetId));
        jpaQuery.where((Predicate)this.qdo.docType.eq((Object)docType));
        jpaQuery.where((Predicate)this.qdo.belongToId.eq((Object)belongToId));
        jpaQuery.where((Predicate)this.qdo.costType.eq((Object)costType));
        jpaQuery.where((Predicate)this.qdo.docId.eq((Object)docId));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return PmsBudgetOccupyConvert.INSTANCE.toVo((PmsBudgetOccupyDO)jpaQuery.fetchFirst());
    }

    public List<PmsBudgetOccupyVO> queryListDynamic(PmsBudgetOccupyQuery query) {
        JPAQuery<PmsBudgetOccupyDO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch().stream().map(PmsBudgetOccupyConvert.INSTANCE::toVo).toList();
    }

    public PagingVO<PmsBudgetOccupyVO> queryPaging(PmsBudgetOccupyQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PmsBudgetOccupyDO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        List<PmsBudgetOccupyVO> vos = result.stream().map(PmsBudgetOccupyConvert.INSTANCE::toVo).toList();
        return PagingVO.builder().records(vos).total(total).build();
    }

    public PmsBudgetOccupyDO save(PmsBudgetOccupyDO ado) {
        return (PmsBudgetOccupyDO)this.repo.save(ado);
    }

    public List<PmsBudgetOccupyDO> saveAll(List<PmsBudgetOccupyDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PmsBudgetOccupyPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getDocId() != null) {
            update.set(this.qdo.docId, (Object)payload.getDocId());
        }
        if (payload.getCostType() != null) {
            update.set((Path)this.qdo.costType, (Object)payload.getCostType());
        }
        if (payload.getDocType() != null) {
            update.set((Path)this.qdo.docType, (Object)payload.getDocType());
        }
        if (payload.getDocCode() != null) {
            update.set((Path)this.qdo.docCode, (Object)payload.getDocCode());
        }
        if (payload.getDocName() != null) {
            update.set((Path)this.qdo.docName, (Object)payload.getDocName());
        }
        if (payload.getBudgetId() != null) {
            update.set(this.qdo.budgetId, (Object)payload.getBudgetId());
        }
        if (payload.getBelongToId() != null) {
            update.set(this.qdo.belongToId, (Object)payload.getBelongToId());
        }
        if (payload.getOccupyAmt() != null) {
            update.set(this.qdo.occupyAmt, (Object)payload.getOccupyAmt());
        }
        if (payload.getUsedAmt() != null) {
            update.set(this.qdo.usedAmt, (Object)payload.getUsedAmt());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("docId")) {
                update.setNull(this.qdo.docId);
            }
            if (nullFields.contains("costType")) {
                update.setNull((Path)this.qdo.costType);
            }
            if (nullFields.contains("docType")) {
                update.setNull((Path)this.qdo.docType);
            }
            if (nullFields.contains("docCode")) {
                update.setNull((Path)this.qdo.docCode);
            }
            if (nullFields.contains("docName")) {
                update.setNull((Path)this.qdo.docName);
            }
            if (nullFields.contains("budgetId")) {
                update.setNull(this.qdo.budgetId);
            }
            if (nullFields.contains("belongToId")) {
                update.setNull(this.qdo.belongToId);
            }
            if (nullFields.contains("occupyAmt")) {
                update.setNull(this.qdo.occupyAmt);
            }
            if (nullFields.contains("usedAmt")) {
                update.setNull(this.qdo.usedAmt);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public PmsBudgetOccupyDAO(JPAQueryFactory jpaQueryFactory, PmsBudgetOccupyRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

