/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationDetailService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationDetailVO;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetAppropriationDetailConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetAppropriationDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetAppropriationDetailDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetAppropriationDetailRepo;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class BudgetAppropriationDetailServiceImpl
extends BaseServiceImpl
implements BudgetAppropriationDetailService {
    private static final Logger log = LoggerFactory.getLogger(BudgetAppropriationDetailServiceImpl.class);
    private final BudgetAppropriationDetailRepo budgetAppropriationDetailRepo;
    private final BudgetAppropriationDetailDAO budgetAppropriationDetailDAO;

    public void batchSave(Long appropriationId, List<BudgetAppropriationDetailPayload> list) {
        if (!ObjectUtils.isEmpty(list)) {
            ArrayList<BudgetAppropriationDetailDO> appropriationDetailDOS = new ArrayList<BudgetAppropriationDetailDO>();
            for (BudgetAppropriationDetailPayload payload : list) {
                BudgetAppropriationDetailDO entityDo = BudgetAppropriationDetailConvert.INSTANCE.toDo(payload);
                entityDo.setAppropriationId(appropriationId);
                appropriationDetailDOS.add(entityDo);
            }
            this.budgetAppropriationDetailDAO.saveAll(appropriationDetailDOS);
        }
    }

    public PagingVO<BudgetAppropriationDetailVO> queryPaging(BudgetAppropriationDetailQuery query) {
        return this.budgetAppropriationDetailDAO.queryPaging(query);
    }

    public List<BudgetAppropriationDetailVO> queryListDynamic(BudgetAppropriationDetailQuery query) {
        return this.budgetAppropriationDetailDAO.queryListDynamic(query);
    }

    public BudgetAppropriationDetailVO queryByKey(Long key) {
        BudgetAppropriationDetailDO entity = this.budgetAppropriationDetailRepo.findById(key).orElseGet(BudgetAppropriationDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BudgetAppropriationDetailVO vo = BudgetAppropriationDetailConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetAppropriationDetailVO insert(BudgetAppropriationDetailPayload payload) {
        BudgetAppropriationDetailDO entityDo = BudgetAppropriationDetailConvert.INSTANCE.toDo(payload);
        return BudgetAppropriationDetailConvert.INSTANCE.toVo((BudgetAppropriationDetailDO)this.budgetAppropriationDetailRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public BudgetAppropriationDetailVO update(BudgetAppropriationDetailPayload payload) {
        BudgetAppropriationDetailDO entity = this.budgetAppropriationDetailRepo.findById(payload.getId()).orElseGet(BudgetAppropriationDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BudgetAppropriationDetailDO entityDo = BudgetAppropriationDetailConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return BudgetAppropriationDetailConvert.INSTANCE.toVo((BudgetAppropriationDetailDO)this.budgetAppropriationDetailRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(BudgetAppropriationDetailPayload payload) {
        BudgetAppropriationDetailDO entity = this.budgetAppropriationDetailRepo.findById(payload.getId()).orElseGet(BudgetAppropriationDetailDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.budgetAppropriationDetailDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.budgetAppropriationDetailDAO.deleteSoft(keys);
        }
    }

    public void deleteSoftByAppId(Long appId) {
        this.budgetAppropriationDetailDAO.deleteSoftByAppId(appId);
    }

    public BudgetAppropriationDetailServiceImpl(BudgetAppropriationDetailRepo budgetAppropriationDetailRepo, BudgetAppropriationDetailDAO budgetAppropriationDetailDAO) {
        this.budgetAppropriationDetailRepo = budgetAppropriationDetailRepo;
        this.budgetAppropriationDetailDAO = budgetAppropriationDetailDAO;
    }
}

