/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationDetailPayload;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationDetailService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgOrganizationVO;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.SaleConContractVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.budget.convert.BudgetAppropriationConvert;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetAppropriationDAO;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.budget.entity.BudgetAppropriationDO;
import com.elitesland.tw.tw5.server.prd.budget.repo.BudgetAppropriationRepo;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjActivityAllocateStateEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjActivityAllocateTypeEnum;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
public class BudgetAppropriationServiceImpl
extends BaseServiceImpl
implements BudgetAppropriationService {
    private static final Logger log = LoggerFactory.getLogger(BudgetAppropriationServiceImpl.class);
    private final BudgetAppropriationRepo budgetAppropriationRepo;
    private final BudgetAppropriationDAO budgetAppropriationDAO;
    private final BudgetDAO budgetDAO;
    private final PmsProjectService pmsProjectService;
    private final BudgetAppropriationDetailService appropriationDetailService;
    private final PrdSystemRoleService roleService;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final BudgetCommonService budgetCommonService;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final SaleConContractService saleConContractService;

    public PagingVO<BudgetAppropriationVO> queryPaging(BudgetAppropriationQuery query) {
        PagingVO<BudgetAppropriationVO> pagingVO = this.budgetAppropriationDAO.queryPaging(query);
        if (!ObjectUtils.isEmpty(pagingVO)) {
            pagingVO.getRecords().forEach(vo -> vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId())));
        }
        return pagingVO;
    }

    public List<BudgetAppropriationVO> queryListDynamic(BudgetAppropriationQuery query) {
        return this.budgetAppropriationDAO.queryListDynamic(query);
    }

    public BudgetAppropriationVO queryByKey(Long key) {
        BudgetAppropriationDO entity = this.budgetAppropriationRepo.findById(key).orElseGet(BudgetAppropriationDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        BudgetAppropriationVO vo = BudgetAppropriationConvert.INSTANCE.toVo(entity);
        vo.setCreator(this.cacheUtil.getUserName(vo.getCreateUserId()));
        BudgetVO budgetVO = this.budgetCommonService.queryBudgetForAppropriation(entity.getBudgetId());
        vo.setBudgetCode(budgetVO.getBudgetCode());
        vo.setSourceType(budgetVO.getSourceType());
        vo.setSourceId(budgetVO.getSourceId());
        vo.setSourceName(budgetVO.getSourceName());
        vo.setBudgetName(budgetVO.getBudgetName());
        vo.setRemainingEqva(budgetVO.getRemainingEqva());
        vo.setRemainingAmt(budgetVO.getRemainingAmt());
        vo.setAllocatedAppropriation(budgetVO.getAllocatedAppropriation().multiply(new BigDecimal(100)));
        vo.setActivityVOS(budgetVO.getActivityVOS());
        vo.setContractId(budgetVO.getContractId());
        vo.setWorkType(budgetVO.getWorkType());
        vo.setPlatType(budgetVO.getPlatType());
        if (!WorkFlowStatusEnum.APPROVING_WORK.getCode().equals(vo.getAppropriationStatus())) {
            this.budgetCommonService.getAppropriationInfo(budgetVO);
            BudgetCommonVO commonVO = this.budgetCommonService.queryBudgetEqvaAndAmt(budgetVO.getSourceType(), budgetVO.getSourceId());
            vo.setAllocatedAmt(budgetVO.getAllocatedAmt());
            vo.setAllocatedEqva(budgetVO.getAllocatedEqva());
            vo.setAllocatedEqvaAmt(budgetVO.getAllocatedEqvaAmt());
            vo.setAllocatedTotalAmt(budgetVO.getAllocatedTotalAmt());
            vo.setOccupyEqva(commonVO.getOccupyEqva());
            vo.setUsedEqva(commonVO.getUsedEqva());
            vo.setPlanEqva(budgetVO.getPlanEqva());
            vo.setOccupyAmt(commonVO.getOccupyAmt());
            vo.setUsedAmt(commonVO.getUsedAmt());
            vo.setPlanAmt(budgetVO.getPlanAmt());
        }
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public void save(BudgetAppropriationPayload payload) {
        Long budgetId = payload.getBudgetId();
        if (ObjectUtils.isEmpty((Object)budgetId)) {
            throw TwException.error("", "\u9884\u7b97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        BudgetVO budgetVO = this.budgetDAO.queryByKey(budgetId);
        if (budgetVO == null) {
            throw TwException.error("", "\u9884\u7b97\u4e0d\u5b58\u5728");
        }
        BigDecimal eqvaPrice = budgetVO.getEqvaPrice();
        if (eqvaPrice == null || eqvaPrice.compareTo(BigDecimal.ZERO) <= 0) {
            eqvaPrice = BigDecimal.valueOf(2000L);
        }
        payload.setEqvaPrice(eqvaPrice);
        payload.setProjName(budgetVO.getSourceName());
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            payload.setResId(GlobalUtil.getLoginUserId());
        } else {
            BudgetAppropriationVO appropriationVO = this.budgetAppropriationDAO.queryByKey(payload.getId());
            payload.setProcInstId(appropriationVO.getProcInstId());
        }
        if (payload.getSubmitFlag().booleanValue() && ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            this.budgetCommonService.checkOnlyOneProc(budgetVO);
        }
        if (budgetVO.getSourceType().equals("PROJ_CONTRACT")) {
            Long projId = budgetVO.getSourceId();
            PmsProjectVO pmsProjectVO = this.pmsProjectService.queryByKey(projId);
            Long contractId = pmsProjectVO.getContractId();
            payload.setContractId(contractId);
        }
        this.checkAppropriation(payload, budgetVO);
        this.saveBudgetAppropriation(payload);
        if (payload.getSubmitFlag().booleanValue()) {
            if (ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
                this.getProjectInfo(payload);
                this.submitProc(payload);
            } else {
                BudgetAppropriationPayload payload0 = new BudgetAppropriationPayload();
                payload0.setId(payload.getId());
                payload0.setProcInstStatus(Integer.valueOf(ProcInstStatus.APPROVING.ordinal()));
                payload0.setAppropriationStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
                this.budgetAppropriationDAO.updateByKeyDynamic(payload0);
            }
        }
    }

    public void saveBudgetAppropriation(BudgetAppropriationPayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getBudgetId())) {
            throw TwException.error("", "\u9884\u7b97ID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getId())) {
            payload.setAppropriationNo(this.generateSeqNum("PMS_BUDGET_APPROPRIATE", new String[0]));
        }
        BudgetAppropriationDO entityDo = BudgetAppropriationConvert.INSTANCE.toDo(payload);
        entityDo = (BudgetAppropriationDO)this.budgetAppropriationRepo.save(entityDo);
        payload.setId(entityDo.getId());
        this.appropriationDetailService.batchSave(entityDo.getId(), payload.getAppropriationDetailPayloads());
        if (ProjActivityAllocateTypeEnum.ACTIVITY.getType().equals(payload.getAppropriationType()) && !ObjectUtils.isEmpty((Object)payload.getAppropriationDetailPayloads())) {
            BudgetAppropriationDetailPayload appropriationDetailPayload = (BudgetAppropriationDetailPayload)payload.getAppropriationDetailPayloads().get(0);
            this.pmsProjectActivityService.updateAllocate(appropriationDetailPayload.getActivityId(), appropriationDetailPayload.getAllocateEqva(), appropriationDetailPayload.getAllocateCost(), ProjActivityAllocateStateEnum.ING.getType());
        }
    }

    private void submitProc(BudgetAppropriationPayload payload) {
        boolean outerProjectFlag = this.budgetCommonService.isExternalProject(payload.getPlatType());
        HashMap<String, List> variables = new HashMap<String, List>();
        Object procInstName = "";
        String processDefinitionKey = "";
        if (outerProjectFlag) {
            procInstName = "P04.\u5916\u90e8\u9879\u76ee\u9884\u7b97\u62e8\u4ed8\u6d41\u7a0b-" + payload.getProjName();
            processDefinitionKey = PmsProcDefKey.PMS_BUDGET_ALLOCAT_EXTERNAL.name();
            variables.put("Activity_00x3shq", CollUtil.newArrayList((Object[])new Long[]{payload.getDeliUserId()}));
            PrdOrgOrganizationVO deliBu = this.cacheUtil.getOrg(payload.getDeliBuId());
            variables.put("Activity_1inir1s", CollUtil.newArrayList((Object[])new Long[]{deliBu.getManageId()}));
            variables.put("Activity_0uyx6zx", this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_CFO.getCode()));
            variables.put("Activity_05xypoo", this.roleService.queryUserIdByRoleCode(RoleEnum.OPERATION_PRESIDENT.getCode()));
            variables.putAll(this.budgetCommonService.getCheckParam(payload, payload.getBudgetId(), payload.getContractId()));
        } else {
            procInstName = "P10.\u5185\u90e8\u9879\u76ee\u9884\u7b97\u62e8\u4ed8\u6d41\u7a0b-" + payload.getProjName();
            processDefinitionKey = PmsProcDefKey.PMS_BUDGET_ALLOCAT_INTERNAL.name();
            variables.put("Activity_01iwzn2", CollUtil.newArrayList((Object[])new Long[]{payload.getDeliUserId()}));
        }
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)processDefinitionKey, (String)procInstName, (String)("" + payload.getId()), variables), new Long[0]);
        this.budgetCommonService.updateStatus(payload.getBudgetId(), payload.getId(), processInfo);
    }

    public void checkAppropriation(BudgetAppropriationPayload payload, BudgetVO budgetVO) {
        if (ObjectUtils.isEmpty((Object)payload.getAppropriationType())) {
            throw TwException.error("", "\u62e8\u4ed8\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List appropriationDetailPayloads = payload.getAppropriationDetailPayloads();
        if (ProjActivityAllocateTypeEnum.ACTIVITY.getType().equals(payload.getAppropriationType()) && this.budgetCommonService.isExternalProject(payload.getPlatType()).booleanValue()) {
            if (appropriationDetailPayloads.size() == 0) {
                throw TwException.error("", "\u6d3b\u52a8\u660e\u7ec6\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (appropriationDetailPayloads.size() > 1) {
                throw TwException.error("", "\u5982\u679c\u662f\u6d3b\u52a8\u62e8\u4ed8\uff0c\u5355\u6b21\u62e8\u4ed8\u53ea\u80fd\u62e8\u4ed8\u4e00\u6761\u6d3b\u52a8");
            }
            long count = appropriationDetailPayloads.stream().filter(v -> ObjectUtils.isEmpty((Object)v.getActivityId())).count();
            if (count > 0L) {
                throw TwException.error("", "\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        if (this.budgetCommonService.isExternalProject(payload.getPlatType()).booleanValue()) {
            this.countAmountByActivity(payload);
        }
        BigDecimal allocatedEqva = budgetVO.getAllocatedEqva() == null ? BigDecimal.ZERO : budgetVO.getAllocatedEqva();
        BigDecimal allocatedAmt = budgetVO.getAllocatedAmt() == null ? BigDecimal.ZERO : budgetVO.getAllocatedAmt();
        BigDecimal avalEqva = budgetVO.getPlanEqva().subtract(allocatedEqva);
        BigDecimal avalAmt = budgetVO.getPlanAmt().subtract(allocatedAmt);
        Long contractId = payload.getContractId();
        SaleConContractVO saleConContractVO = this.saleConContractService.queryByKey(contractId, new Boolean[0]);
        String status = saleConContractVO.getStatus();
        String platType = saleConContractVO.getPlatType();
        if (platType.equals(SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode()) && (status.equals(SaleConStatusEnum.ACTIVE_WAITING.getCode()) || status.equals(SaleConStatusEnum.APPROVING.getCode()))) {
            avalAmt = BigDecimal.ZERO;
            avalEqva = budgetVO.getPlanEqva().multiply(new BigDecimal("0.15")).setScale(4, RoundingMode.HALF_UP);
            if (allocatedEqva.add(payload.getApplyEqva()).compareTo(avalEqva) > 0) {
                throw TwException.error("", "\u65e0\u5408\u540c\u5165\u573a\u7684\u9879\u76ee\uff0c\u603b\u62e8\u4ed8\u5f53\u91cf\u4e0d\u80fd\u8d85\u8fc7\u603b\u5f53\u91cf\u768415%");
            }
            if (payload.getApplyFeeAmt().compareTo(avalAmt) > 0) {
                throw TwException.error("", "\u65e0\u5408\u540c\u5165\u573a\u7684\u9879\u76ee,\u603b\u62e8\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e0");
            }
        }
        if (payload.getApplyEqva().compareTo(avalEqva) > 0) {
            throw TwException.error("", "\u62e8\u4ed8\u5f53\u91cf\u4e0d\u80fd\u5927\u4e8e\u53ef\u62e8\u4ed8\u5f53\u91cf\u3010" + avalEqva + "\u3011");
        }
        if (payload.getApplyFeeAmt().compareTo(avalAmt) > 0) {
            throw TwException.error("", "\u62e8\u4ed8\u91d1\u989d\u4e0d\u80fd\u5927\u4e8e\u53ef\u62e8\u4ed8\u91d1\u989d\u3010" + avalAmt + "\u3011");
        }
    }

    public void processStatusChange(ProcessStatusChangePayload processStatusChangePayload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)processStatusChangePayload);
        String businessKey = processStatusChangePayload.getBusinessKey();
        BudgetAppropriationVO vo = this.budgetAppropriationDAO.queryByKey(Long.valueOf(businessKey));
        if (vo != null) {
            ProcInstStatus procInstStatus = processStatusChangePayload.getProcInstStatus();
            if (procInstStatus.name().equals(ProcInstStatus.INVALID.name())) {
                this.deleteSoft(vo.getId());
            } else {
                ProcessInfo processInfo = new ProcessInfo();
                processInfo.setProcInstStatus(procInstStatus);
                this.budgetCommonService.updateStatus(vo.getBudgetId(), vo.getId(), processInfo);
            }
        }
    }

    public void deleteSoft(Long key) {
        this.budgetAppropriationDAO.deleteSoft(Arrays.asList(key));
        this.appropriationDetailService.deleteSoftByAppId(key);
    }

    void countAmountByActivity(BudgetAppropriationPayload payload) {
        List appropriationDetailVOS = payload.getAppropriationDetailPayloads();
        if (!ObjectUtils.isEmpty((Object)appropriationDetailVOS)) {
            BigDecimal applyEqva = appropriationDetailVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getAllocateEqva())).map(BudgetAppropriationDetailPayload::getAllocateEqva).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal applyEqvaAmt = applyEqva.multiply(payload.getEqvaPrice());
            payload.setApplyEqva(applyEqva);
            payload.setApplyEqvaAmt(applyEqvaAmt);
            BigDecimal applyFeeAmt = appropriationDetailVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getAllocateCost())).map(BudgetAppropriationDetailPayload::getAllocateCost).reduce(BigDecimal.ZERO, BigDecimal::add);
            payload.setApplyFeeAmt(applyFeeAmt);
            payload.setApplyAmt(applyFeeAmt.add(applyEqvaAmt));
        } else {
            BigDecimal applyEqvaAmt = payload.getApplyEqva().multiply(payload.getEqvaPrice());
            payload.setApplyEqvaAmt(applyEqvaAmt);
            payload.setApplyAmt(payload.getApplyFeeAmt().add(applyEqvaAmt));
        }
    }

    public void getProjectInfo(BudgetAppropriationPayload payload) {
        PmsProjectVO projectVO;
        BudgetVO budgetVO = this.budgetDAO.queryByKey(payload.getBudgetId());
        if (!ObjectUtils.isEmpty((Object)budgetVO) && PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetVO.getSourceType()) && !ObjectUtils.isEmpty((Object)(projectVO = this.pmsProjectService.queryByKey(budgetVO.getSourceId())))) {
            if (!GlobalUtil.getLoginUserId().equals(projectVO.getPmResId())) {
                throw TwException.error("", " \u53ea\u6709\u9879\u76ee\u7ecf\u7406\u53ef\u4ee5\u8fdb\u884c\u9884\u7b97\u7f16\u5236\u3001\u53d8\u66f4\u3001\u62e8\u4ed8\u7b49\u7684\u64cd\u4f5c !");
            }
            payload.setEqvaPrice(projectVO.getEqvaPrice());
            payload.setWorkType(projectVO.getWorkType());
            payload.setPlatType(projectVO.getPlatType());
            payload.setPmoResId(projectVO.getPmoResId());
            payload.setDeliBuId(projectVO.getDeliBuId());
            payload.setDeliUserId(projectVO.getDeliUserId());
            payload.setProjName(projectVO.getProjName());
            payload.setContractId(projectVO.getContractId());
        }
    }

    public BudgetAppropriationServiceImpl(BudgetAppropriationRepo budgetAppropriationRepo, BudgetAppropriationDAO budgetAppropriationDAO, BudgetDAO budgetDAO, PmsProjectService pmsProjectService, BudgetAppropriationDetailService appropriationDetailService, PrdSystemRoleService roleService, WorkflowUtil workflowUtil, CacheUtil cacheUtil, BudgetCommonService budgetCommonService, PmsProjectActivityService pmsProjectActivityService, SaleConContractService saleConContractService) {
        this.budgetAppropriationRepo = budgetAppropriationRepo;
        this.budgetAppropriationDAO = budgetAppropriationDAO;
        this.budgetDAO = budgetDAO;
        this.pmsProjectService = pmsProjectService;
        this.appropriationDetailService = appropriationDetailService;
        this.roleService = roleService;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.budgetCommonService = budgetCommonService;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.saleConContractService = saleConContractService;
    }
}

