/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.budget.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitesland.tw.tw5.api.common.change.query.ComChangeQuery;
import com.elitesland.tw.tw5.api.common.change.service.ComChangeService;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccSubjectTemplateService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccBudgetItemVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimDetailVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimVO;
import com.elitesland.tw.tw5.api.prd.budget.payload.BudgetAppropriationPayload;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationDetailQuery;
import com.elitesland.tw.tw5.api.prd.budget.query.BudgetAppropriationQuery;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetAppropriationDetailService;
import com.elitesland.tw.tw5.api.prd.budget.service.BudgetCommonService;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetAppropriationVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetCommonVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetSubjectDetailVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetUsageDetailsVO;
import com.elitesland.tw.tw5.api.prd.budget.vo.BudgetVO;
import com.elitesland.tw.tw5.api.prd.pms.service.BuProjectService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectService;
import com.elitesland.tw.tw5.api.prd.pms.vo.BuProjectVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.task.vo.TaskInfoVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.change.changeEnum.ChangeTypeEnum;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimDetailDAO;
import com.elitesland.tw.tw5.server.prd.budget.common.functionEnum.BudgetControlType;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetAppropriationDAO;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetDAO;
import com.elitesland.tw.tw5.server.prd.budget.dao.BudgetSubjectDetailDAO;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsReasonTypeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjActivityAllocateStateEnum;
import com.elitesland.tw.tw5.server.prd.system.dao.PrdSystemRoleDAO;
import com.elitesland.tw.tw5.server.prd.task.dao.TaskInfoDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class BudgetCommonServiceImpl
extends BaseServiceImpl
implements BudgetCommonService {
    private static final Logger log = LoggerFactory.getLogger(BudgetCommonServiceImpl.class);
    private final BudgetDAO budgetDAO;
    private final PmsProjectActivityService pmsProjectActivityService;
    private final BudgetAppropriationDAO budgetAppropriationDAO;
    private final BudgetSubjectDetailDAO budgetSubjectDetailDAO;
    private final BudgetAppropriationDetailService appropriationDetailService;
    private final TransactionUtilService transactionUtilService;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PrdSystemRoleDAO daoRole;
    private final PrdMessageConfigService messageConfigService;
    private final ComChangeService changeService;
    private final PmsProjectService pmsProjectService;
    private final BuProjectService buProjectService;
    private final AccSubjectTemplateService accSubjectTemplateService;
    private final TaskInfoDAO taskInfoDAO;
    private final AccReimDAO accReimDAO;
    private final AccReimDetailDAO detailDAO;
    private final CacheUtil cacheUtil;

    public BudgetVO initBudget(Long sourceId, String sourceType) {
        BudgetVO budgetVO = new BudgetVO();
        budgetVO.setCreateUserId(GlobalUtil.getLoginUserId());
        budgetVO.setBudgetStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
        budgetVO.setVersionNo(Integer.valueOf(0));
        budgetVO.setControlType(BudgetControlType.STIFFNESS.getCode());
        budgetVO.setPlanAmt(BigDecimal.ZERO);
        budgetVO.setPlanEqva(BigDecimal.ZERO);
        budgetVO.setPlanEqvaAmt(BigDecimal.ZERO);
        budgetVO.setTotalAmt(BigDecimal.ZERO);
        budgetVO.setSourceId(sourceId);
        budgetVO.setSourceType(sourceType);
        this.addProjectInfo(budgetVO);
        return budgetVO;
    }

    public BudgetVO querySimpleBySource(Long sourceId, String sourceType) {
        if (ObjectUtils.isEmpty((Object)sourceId)) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578bID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)sourceType)) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (!(PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(sourceType) || PmsReasonTypeEnum.PROJ_OPPO.getCode().equals(sourceType) || PmsReasonTypeEnum.PROJ_BU.getCode().equals(sourceType))) {
            throw TwException.error("", "\u9884\u7b97\u7c7b\u578b\u4e0d\u7b26\u5408\u8981\u6c42 !");
        }
        return this.budgetDAO.querySimpleBySource(sourceId, sourceType);
    }

    public void addProjectInfo(BudgetVO budgetVO) {
        Long sourceId = budgetVO.getSourceId();
        String sourceType = budgetVO.getSourceType();
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(sourceType)) {
            PmsProjectVO projectVO = this.pmsProjectService.querySimpleProjectByKey(sourceId);
            budgetVO.setSourceCode(projectVO.getProjNo());
            budgetVO.setSourceName(projectVO.getProjName());
            budgetVO.setDeliBuId(projectVO.getDeliBuId());
            if (ObjectUtils.isEmpty((Object)budgetVO.getEqvaPrice())) {
                budgetVO.setEqvaPrice(projectVO.getEqvaPrice() == null ? new BigDecimal(2000) : projectVO.getEqvaPrice());
            }
            if (budgetVO.getSubjectTempId() == null) {
                budgetVO.setSubjectTempId(projectVO.getSubjectTempId());
            }
            budgetVO.setTotalEqva(projectVO.getTotalEqva());
            budgetVO.setTotalReimbursement(projectVO.getTotalReimbursement());
            budgetVO.setDeliUserId(projectVO.getDeliUserId());
            if (ObjectUtils.isEmpty((Object)budgetVO.getFinYear())) {
                budgetVO.setFinYear(projectVO.getPlanStartDate() == null ? null : "" + projectVO.getPlanStartDate().getYear());
            }
            budgetVO.setContractId(projectVO.getContractId());
            budgetVO.setContractStatus(projectVO.getContractStatus());
            budgetVO.setAmt(projectVO.getSumAmt());
            budgetVO.setEffectiveAmt(projectVO.getEffectiveAmt());
            budgetVO.setSaleManUserId(projectVO.getSaleManUserId());
            budgetVO.setPlatType(projectVO.getPlatType());
            budgetVO.setWorkType(projectVO.getWorkType());
            budgetVO.setPmoResId(projectVO.getPmoResId());
        } else if (PmsReasonTypeEnum.PROJ_BU.getCode().equals(sourceType)) {
            BuProjectVO projectVO = this.buProjectService.queryByKey(sourceId);
            budgetVO.setSourceCode(projectVO.getProjNo());
            budgetVO.setSourceName(projectVO.getProjName());
            budgetVO.setDeliBuId(projectVO.getDeliBuId());
            budgetVO.setTotalEqva(projectVO.getTotalEqva());
            budgetVO.setTotalReimbursement(projectVO.getTotalReimbursement());
            budgetVO.setDeliUserId(projectVO.getDeliUserId());
            if (ObjectUtils.isEmpty((Object)budgetVO.getFinYear())) {
                budgetVO.setFinYear(projectVO.getPlanStartDate() == null ? null : "" + projectVO.getPlanStartDate().getYear());
            }
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getBudgetName())) {
            budgetVO.setBudgetName(budgetVO.getSourceName());
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getEqvaPrice())) {
            budgetVO.setEqvaPrice(new BigDecimal(2000));
        }
    }

    public BudgetVO queryBudgetForAppropriation(Long key) {
        BudgetVO budgetVO = this.budgetDAO.queryByKey(key);
        this.getAppropriationInfo(budgetVO);
        if (PmsReasonTypeEnum.PROJ_CONTRACT.getCode().equals(budgetVO.getSourceType())) {
            this.addProjectInfo(budgetVO);
            budgetVO.setActivityVOS(this.pmsProjectActivityService.queryActiveList(budgetVO.getSourceId(), 1));
        }
        return budgetVO;
    }

    public BigDecimal getReceivedRate(Long saleConId) {
        List receivablePlanVOS = this.conReceivablePlanService.queryBySaleConId(saleConId);
        BigDecimal receAmt = receivablePlanVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceAmt())).map(ConReceivablePlanVO::getReceAmt).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal alreadyReceAmt = receivablePlanVOS.stream().map(ConReceivablePlanVO::getActualRecvAmt).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add);
        BigDecimal receivedRate = BigDecimal.ZERO;
        if (receAmt.doubleValue() > 0.0) {
            receivedRate = alreadyReceAmt.divide(receAmt, 4, RoundingMode.HALF_UP);
        }
        return receivedRate;
    }

    public BigDecimal getAllocatedProportion(BudgetAppropriationPayload payload, Long budgetId) {
        BudgetVO budgetVO = this.budgetDAO.queryByKey(budgetId);
        budgetVO.setAllocatedEqva(this.getValue(budgetVO.getAllocatedEqva()).add(this.getValue(payload.getApplyEqva())));
        budgetVO.setAllocatedEqvaAmt(this.getValue(budgetVO.getAllocatedEqvaAmt()).add(this.getValue(payload.getApplyEqvaAmt())));
        budgetVO.setAllocatedAmt(this.getValue(budgetVO.getAllocatedAmt()).add(this.getValue(payload.getApplyFeeAmt())));
        budgetVO.setAllocatedTotalAmt(this.getValue(budgetVO.getAllocatedTotalAmt()).add(this.getValue(payload.getApplyAmt())));
        this.getAppropriationInfo(budgetVO);
        log.info("budgetVO\u62e8\u4ed8\u6570\u636e :" + budgetVO.toString());
        return budgetVO.getAllocatedAppropriation();
    }

    BigDecimal getValue(BigDecimal value) {
        return value == null ? BigDecimal.ZERO : value;
    }

    public void getAppropriationInfo(BudgetVO budgetVO) {
        if (ObjectUtils.isEmpty((Object)budgetVO.getAllocatedAmt())) {
            budgetVO.setAllocatedAmt(BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getAllocatedEqva())) {
            budgetVO.setAllocatedEqva(BigDecimal.ZERO);
            budgetVO.setAllocatedEqvaAmt(BigDecimal.ZERO);
        }
        if (ObjectUtils.isEmpty((Object)budgetVO.getAllocatedTotalAmt())) {
            budgetVO.setAllocatedTotalAmt(BigDecimal.ZERO);
        }
        budgetVO.setRemainingEqva(budgetVO.getPlanEqva().subtract(budgetVO.getAllocatedEqva()));
        budgetVO.setRemainingAmt(budgetVO.getPlanAmt().subtract(budgetVO.getAllocatedAmt()));
        if (budgetVO.getTotalAmt().compareTo(BigDecimal.ZERO) > 0) {
            budgetVO.setAllocatedAppropriation(budgetVO.getAllocatedTotalAmt().divide(budgetVO.getTotalAmt(), 4, RoundingMode.HALF_UP));
        } else {
            budgetVO.setAllocatedAppropriation(BigDecimal.ZERO);
        }
    }

    @Transactional
    public void updateAppropriationInfo(Long budgetId) {
        BigDecimal allocatedAmt = BigDecimal.ZERO;
        BigDecimal allocatedEqva = BigDecimal.ZERO;
        BigDecimal allocatedEqvaAmt = BigDecimal.ZERO;
        BigDecimal allocatedTotalAmt = BigDecimal.ZERO;
        BudgetAppropriationQuery appropriationQuery = new BudgetAppropriationQuery();
        appropriationQuery.setBudgetId(budgetId);
        appropriationQuery.setAppropriationStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
        List<BudgetAppropriationVO> appropriationVOS = this.budgetAppropriationDAO.queryListDynamic(appropriationQuery);
        for (BudgetAppropriationVO appropriationVO : appropriationVOS) {
            allocatedAmt = allocatedAmt.add(appropriationVO.getApplyFeeAmt());
            allocatedEqva = allocatedEqva.add(appropriationVO.getApplyEqva());
            allocatedEqvaAmt = allocatedEqvaAmt.add(appropriationVO.getApplyEqvaAmt());
            allocatedTotalAmt = allocatedTotalAmt.add(appropriationVO.getApplyAmt());
        }
        this.budgetDAO.updateAllocatedAmt(budgetId, allocatedAmt, allocatedEqva, allocatedEqvaAmt, allocatedTotalAmt);
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateStatus(Long budgetId, Long appropriationId, ProcessInfo processInfo) {
        List activityIds;
        boolean messNoticeType = !ObjectUtils.isEmpty((Object)appropriationId);
        BudgetAppropriationPayload appropriationPayload = new BudgetAppropriationPayload();
        ProcInstStatus procInstStatus = processInfo.getProcInstStatus();
        appropriationPayload.setProcInstStatus(Integer.valueOf(procInstStatus.ordinal()));
        if (!ObjectUtils.isEmpty((Object)appropriationId)) {
            appropriationPayload.setId(appropriationId);
            appropriationPayload.setProcInstId(processInfo.getProcInstId());
            appropriationPayload.setApplyDate(LocalDate.now());
        } else {
            BudgetAppropriationVO appropriationVO = this.getAppropriationInfo(budgetId);
            if (!ObjectUtils.isEmpty((Object)appropriationVO)) {
                appropriationId = appropriationVO.getId();
                appropriationPayload.setId(appropriationId);
            }
        }
        if (ObjectUtils.isEmpty((Object)appropriationId)) {
            throw TwException.error("", "\u9884\u7b97\u62e8\u4ed8ID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        log.info("\u66f4\u65b0 \u62e8\u4ed8\u57fa\u672c\u4fe1\u606f\u72b6\u6001 {}", (Object)procInstStatus);
        String actStatus = "";
        if (procInstStatus.ordinal() == ProcInstStatus.APPROVED.ordinal()) {
            appropriationPayload.setAppropriationStatus(WorkFlowStatusEnum.APPROVED_WORK.getCode());
            actStatus = ProjActivityAllocateStateEnum.OK.getType();
        } else if (procInstStatus.ordinal() == ProcInstStatus.APPROVING.ordinal()) {
            appropriationPayload.setAppropriationStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            actStatus = ProjActivityAllocateStateEnum.ING.getType();
        } else if (procInstStatus.ordinal() == ProcInstStatus.NOTSUBMIT.ordinal()) {
            appropriationPayload.setAppropriationStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            actStatus = ProjActivityAllocateStateEnum.READY.getType();
        } else if (procInstStatus.ordinal() == ProcInstStatus.INTERRUPT.ordinal()) {
            appropriationPayload.setAppropriationStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
            actStatus = ProjActivityAllocateStateEnum.READY.getType();
        } else if (procInstStatus.ordinal() == ProcInstStatus.REJECTED.ordinal()) {
            appropriationPayload.setAppropriationStatus(WorkFlowStatusEnum.REJECTED_WORK.getCode());
            actStatus = ProjActivityAllocateStateEnum.NO.getType();
        }
        this.budgetAppropriationDAO.updateByKeyDynamic(appropriationPayload);
        BudgetAppropriationDetailQuery appropriationDetailQuery = new BudgetAppropriationDetailQuery();
        appropriationDetailQuery.setAppropriationId(appropriationId);
        List budgetAppropriationDetailVOS = this.appropriationDetailService.queryListDynamic(appropriationDetailQuery);
        if (!ObjectUtils.isEmpty((Object)budgetAppropriationDetailVOS) && !ObjectUtils.isEmpty(activityIds = budgetAppropriationDetailVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getActivityId())).map(v -> v.getActivityId()).collect(Collectors.toList()))) {
            this.pmsProjectActivityService.updateAllocateStatus(activityIds, actStatus);
        }
        if (procInstStatus.ordinal() == ProcInstStatus.APPROVED.ordinal()) {
            this.transactionUtilService.executeWithRunnable(() -> this.updateAppropriationInfo(budgetId));
        }
    }

    public BudgetAppropriationVO getAppropriationInfo(Long budgetId) {
        BudgetAppropriationQuery appropriationQuery = new BudgetAppropriationQuery();
        appropriationQuery.setBudgetId(budgetId);
        List<BudgetAppropriationVO> appropriationVOS = this.budgetAppropriationDAO.queryListDynamic(appropriationQuery);
        if (!ObjectUtils.isEmpty(appropriationVOS)) {
            BudgetAppropriationVO budgetAppropriationVO = appropriationVOS.get(0);
            String desc = this.cacheUtil.transferSystemSelection("budget:appropriationStatus", budgetAppropriationVO.getAppropriationStatus());
            budgetAppropriationVO.setAppropriationStatusDesc(desc);
            return budgetAppropriationVO;
        }
        return null;
    }

    public void messNotice(Long objectId, String messageTitle) {
    }

    public void checkOnlyOneProc(BudgetVO budgetVO) {
        if (!ObjectUtils.isEmpty((Object)budgetVO.getProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
            throw TwException.error("", "\u7b2c\u4e00\u6b21\u9884\u7b97\u5ba1\u6279\u6d41\u7a0b\u8fd8\u672a\u8d70\u5b8c\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u7533\u8bf7");
        }
        ComChangeQuery changeQuery = new ComChangeQuery();
        changeQuery.setChangeType(ChangeTypeEnum.BUDGET_CHANGE.getCode());
        changeQuery.setChangeDocId(budgetVO.getId().toString());
        List changeVOS = this.changeService.changeSearch(changeQuery);
        long count = changeVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getApprProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(v.getChangeStatus())).count();
        if (count > 0L) {
            throw TwException.error("", "\u4e0a\u4e00\u6b21\u7684\u9884\u7b97\u53d8\u66f4\u6d41\u7a0b\u8fd8\u672a\u8d70\u5b8c\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u53d8\u66f4");
        }
        BudgetAppropriationQuery appropriationQuery = new BudgetAppropriationQuery();
        appropriationQuery.setBudgetId(budgetVO.getId());
        List<BudgetAppropriationVO> appropriationVOS = this.budgetAppropriationDAO.queryListDynamic(appropriationQuery);
        count = appropriationVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getProcInstId()) && !WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(v.getAppropriationStatus())).count();
        if (count > 0L) {
            throw TwException.error("", "\u4e0a\u4e00\u6b21\u7684\u9884\u7b97\u62e8\u4ed8\u6d41\u7a0b\u8fd8\u672a\u8d70\u5b8c\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u62e8\u4ed8");
        }
    }

    public Map<String, Object> getCheckParam(BudgetAppropriationPayload payload, Long budgetId, Long contractId) {
        HashMap<String, Object> variables = new HashMap<String, Object>(4);
        BigDecimal allocatedProportion = this.getAllocatedProportion(payload, budgetId);
        BigDecimal receivedRate = this.getReceivedRate(contractId);
        BigDecimal dRate = allocatedProportion.subtract(receivedRate);
        log.info("\u6bd4\u4f8b\u5deedRate:" + dRate + " /\u7d2f\u8ba1\u62e8\u4ed8\u6bd4\u4f8b:" + allocatedProportion + " /\u7d2f\u8ba1\u6536\u6b3e\u6bd4\u4f8b:" + receivedRate);
        variables.put("check1", dRate.compareTo(BigDecimal.ZERO) <= 0);
        variables.put("check2", dRate.compareTo(BigDecimal.ZERO) > 0 && dRate.compareTo(new BigDecimal(0.05)) < 0);
        variables.put("check3", dRate.compareTo(new BigDecimal(0.05)) >= 0 && dRate.compareTo(new BigDecimal(0.1)) <= 0);
        variables.put("check4", dRate.compareTo(new BigDecimal(0.1)) > 0);
        return variables;
    }

    public Boolean isInnerProject(String platType) {
        return SaleConEnum.FICTITIOUS.getCode().equals(platType);
    }

    public Boolean isExternalProject(String platType) {
        return SaleConEnum.INTERNAL.getCode().equals(platType) || SaleConEnum.EXTERNAL.getCode().equals(platType) || SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType);
    }

    public Boolean isExternalContractProject(String platType, String contractStatus) {
        return this.isExternalProject(platType) != false && "ACTIVE".equals(contractStatus);
    }

    public Boolean isExternalNoContractProject(String platType, String contractStatus) {
        return SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType) && "ACTIVE_WAITING".equals(contractStatus);
    }

    public void countTotalChange(BudgetVO budgetVO) {
        if (budgetVO.getVersionNo() != null && budgetVO.getVersionNo() > 0) {
            budgetVO.setPlanAmtChange(budgetVO.getPlanAmt().subtract(budgetVO.getOriginalPlanAmt()));
            budgetVO.setPlanEqvaChange(budgetVO.getPlanEqva().subtract(budgetVO.getOriginalPlanEqva()));
            budgetVO.setPlanEqvaAmtChange(budgetVO.getPlanEqvaAmt().subtract(budgetVO.getOriginalPlanEqvaAmt()));
            budgetVO.setTotalAmtChange(budgetVO.getTotalAmt().subtract(budgetVO.getOriginalTotalAmt()));
        } else {
            budgetVO.setPlanAmtChange(BigDecimal.ZERO);
            budgetVO.setPlanEqvaChange(BigDecimal.ZERO);
            budgetVO.setPlanEqvaAmtChange(BigDecimal.ZERO);
            budgetVO.setTotalAmtChange(BigDecimal.ZERO);
        }
    }

    public void countCurrentChange(BudgetVO currentVersionBudge) {
        BudgetVO budgetVO = this.budgetDAO.queryByKey(currentVersionBudge.getId());
        currentVersionBudge.setCurrentPlanAmtChange(currentVersionBudge.getPlanAmt().subtract(budgetVO.getPlanAmt()));
        currentVersionBudge.setCurrentPlanEqvaChange(currentVersionBudge.getPlanEqva().subtract(budgetVO.getPlanEqva()));
        currentVersionBudge.setCurrentPlanEqvaAmtChange(currentVersionBudge.getPlanEqvaAmt().subtract(budgetVO.getPlanEqvaAmt()));
        currentVersionBudge.setCurrentTotalAmtChange(currentVersionBudge.getTotalAmt().subtract(budgetVO.getTotalAmt()));
        currentVersionBudge.setPlanAmtChange(currentVersionBudge.getPlanAmt().subtract(budgetVO.getOriginalPlanAmt()));
        currentVersionBudge.setPlanEqvaChange(currentVersionBudge.getPlanEqva().subtract(budgetVO.getOriginalPlanEqva()));
        currentVersionBudge.setPlanEqvaAmtChange(currentVersionBudge.getPlanEqvaAmt().subtract(budgetVO.getOriginalPlanEqvaAmt()));
        currentVersionBudge.setTotalAmtChange(currentVersionBudge.getTotalAmt().subtract(budgetVO.getOriginalTotalAmt()));
    }

    public List<BudgetUsageDetailsVO> queryBudgetUsageDetails(Long sourceId, String sourceType) {
        ArrayList<BudgetUsageDetailsVO> list = new ArrayList<BudgetUsageDetailsVO>();
        return list;
    }

    public void checkBudgetEqva(Long reasonId, String reasonType, Long relatedActId, BigDecimal eqva) {
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            BudgetVO budgetVO = this.querySimpleBySource(reasonId, reasonType);
            if (ObjectUtils.isEmpty((Object)budgetVO)) {
                throw TwException.error("", "\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "\u9884\u7b97\u8fd8\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (BudgetControlType.STIFFNESS.getCode().equals(budgetVO.getControlType())) {
                PmsProjectActivityVO activityVO;
                if (ObjectUtils.isEmpty((Object)budgetVO.getAllocatedEqva())) {
                    throw TwException.error("", "\u8be5\u9879\u76ee\u5df2\u62e8\u4ed8\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                this.queryBudgetEqva(commonVO, null);
                if (eqva.compareTo(budgetVO.getAllocatedEqva().subtract(commonVO.getOccupyEqva()).subtract(commonVO.getUsedEqva())) > 0) {
                    throw TwException.error("", "\u9879\u76ee\u5df2\u62e8\u4ed8\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!ObjectUtils.isEmpty((Object)relatedActId) && !ObjectUtils.isEmpty((Object)(activityVO = this.pmsProjectActivityService.queryByKey(relatedActId)).getDetailControlFlag()) && activityVO.getDetailControlFlag().booleanValue()) {
                    BigDecimal actOccupyEqva;
                    if (ObjectUtils.isEmpty((Object)activityVO.getAllocateEqva())) {
                        throw TwException.error("", "\u8be5\u6d3b\u52a8\u672a\u62e8\u4ed8\u5f53\u91cf\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    BigDecimal actUsedEqva = commonVO.getActUsedEqvaMap().get(relatedActId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getActUsedEqvaMap().get(relatedActId);
                    BigDecimal bigDecimal = actOccupyEqva = commonVO.getActOccupyEqvaMap().get(relatedActId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getActOccupyEqvaMap().get(relatedActId);
                    if (eqva.compareTo(activityVO.getAllocateEqva().subtract(actOccupyEqva).subtract(actUsedEqva)) > 0) {
                        log.info("\u6d3e\u53d1\u5f53\u91cf:" + eqva + " /\u5df2\u62e8\u4ed8\u5f53\u91cf\uff1a" + activityVO.getAllocateEqva() + " /\u5360\u7528\u5f53\u91cf\uff1a" + actOccupyEqva + " /\u4f7f\u7528\u5f53\u91cf\uff1a" + actUsedEqva);
                        throw TwException.error("", "\u8be5\u6d3b\u52a8\u5df2\u62e8\u4ed8\u5f53\u91cf\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                }
            }
        }
    }

    public void checkBudgetAmt(Long reasonId, String reasonType, Long budgetItemId, BigDecimal amt, Long ... reimId) {
        if (ObjectUtils.isEmpty((Object)reasonType)) {
            throw TwException.error("", "\u4e8b\u7531\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (reasonType.equals(PmsReasonTypeEnum.PROJ_CONTRACT.getCode())) {
            BudgetVO budgetVO = this.querySimpleBySource(reasonId, reasonType);
            if (ObjectUtils.isEmpty((Object)budgetVO)) {
                throw TwException.error("", "\u9884\u7b97\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (!WorkFlowStatusEnum.APPROVED_WORK.getCode().equals(budgetVO.getBudgetStatus())) {
                throw TwException.error("", "\u9884\u7b97\u8fd8\u672a\u5ba1\u6279\u901a\u8fc7\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (BudgetControlType.STIFFNESS.getCode().equals(budgetVO.getControlType())) {
                if (ObjectUtils.isEmpty((Object)budgetVO.getAllocatedEqva())) {
                    throw TwException.error("", "\u9884\u7b97\u5df2\u62e8\u4ed8\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                this.queryBudgetAmt(commonVO, null, reimId);
                if (amt.compareTo(budgetVO.getAllocatedAmt().subtract(commonVO.getOccupyAmt()).subtract(commonVO.getUsedAmt())) > 0) {
                    throw TwException.error("", "\u9884\u7b97\u5df2\u62e8\u4ed8\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                }
                if (!ObjectUtils.isEmpty((Object)budgetItemId)) {
                    BudgetSubjectDetailVO budgetSubjectDetailVO = this.budgetSubjectDetailDAO.queryByBudgetItemId(budgetItemId);
                    if (budgetSubjectDetailVO == null) {
                        throw TwException.error("", "\u8d39\u7528\u660e\u7ec6\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u9a8c\uff01");
                    }
                    if (!ObjectUtils.isEmpty((Object)budgetSubjectDetailVO.getDetailControlFlag()) && budgetSubjectDetailVO.getDetailControlFlag().booleanValue()) {
                        BigDecimal actcccupyAmt;
                        if (ObjectUtils.isEmpty((Object)budgetSubjectDetailVO.getFeeReleasedAmt())) {
                            throw TwException.error("", "\u8be5\u8d39\u7528\u660e\u7ec6\u5df2\u62e8\u4ed8\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                        BigDecimal accUsedAmt = commonVO.getAccUsedAmtMap().get(budgetItemId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getAccUsedAmtMap().get(budgetItemId);
                        BigDecimal bigDecimal = actcccupyAmt = commonVO.getAccOccupyAmtMap().get(budgetItemId) == null ? BigDecimal.ZERO : (BigDecimal)commonVO.getAccOccupyAmtMap().get(budgetItemId);
                        if (amt.compareTo(budgetSubjectDetailVO.getFeeReleasedAmt().subtract(actcccupyAmt).subtract(accUsedAmt)) > 0) {
                            throw TwException.error("", "\u8be5\u8d39\u7528\u660e\u7ec6\u5df2\u62e8\u4ed8\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u6838\u9a8c\uff01");
                        }
                    }
                }
            }
        }
    }

    public List<BudgetSubjectDetailVO> queryBySubjectTemplateId(String sourceType, Long subjectTemplateId) {
        if (ObjectUtils.isEmpty((Object)sourceType) || ObjectUtils.isEmpty((Object)subjectTemplateId)) {
            throw TwException.error("", "\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<BudgetSubjectDetailVO> subjectDetailVOS = new ArrayList<BudgetSubjectDetailVO>();
        List accTmpldVOS = this.accSubjectTemplateService.queryBudgetItemList(subjectTemplateId);
        for (AccBudgetItemVO accTmpldVO : accTmpldVOS) {
            BudgetSubjectDetailVO subjectDetailVO = new BudgetSubjectDetailVO();
            subjectDetailVO.setAccId(accTmpldVO.getId());
            subjectDetailVO.setAccParentId(accTmpldVO.getParentId());
            subjectDetailVO.setAccName(accTmpldVO.getBudgetName());
            subjectDetailVO.setBudgetAmt(BigDecimal.ZERO);
            subjectDetailVO.setDetailControlFlag(Boolean.valueOf(false));
            subjectDetailVOS.add(subjectDetailVO);
        }
        return subjectDetailVOS;
    }

    public BudgetCommonVO queryBudgetEqvaAndAmt(String reasonType, Long reasonId) {
        BudgetCommonVO commonVO = new BudgetCommonVO();
        commonVO.setReasonId(reasonId);
        commonVO.setReasonType(reasonType);
        this.queryBudgetEqva(commonVO, null);
        this.queryBudgetAmt(commonVO, null, new Long[0]);
        return commonVO;
    }

    public List<BudgetCommonVO> queryBudgetEqvaAndAmts(List<String> reasonTypes, List<Long> reasonIds) {
        ArrayList<BudgetCommonVO> commonVOList = new ArrayList<BudgetCommonVO>();
        List<TaskInfoVO> taskInfoAllVOS = this.taskInfoDAO.queryTaskByReasons(reasonTypes, reasonIds);
        HashMap<String, List> infoVOSMap = new HashMap<String, List>();
        if (!ObjectUtils.isEmpty(taskInfoAllVOS)) {
            taskInfoAllVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                ArrayList<TaskInfoVO> taskInfoVOS1 = (ArrayList<TaskInfoVO>)infoVOSMap.get(key);
                if (taskInfoVOS1 == null) {
                    taskInfoVOS1 = new ArrayList<TaskInfoVO>();
                }
                taskInfoVOS1.add((TaskInfoVO)vo);
                infoVOSMap.put(key, taskInfoVOS1);
            });
            infoVOSMap.forEach((key, taskInfoVOS) -> {
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                BudgetCommonVO commonVO = new BudgetCommonVO();
                commonVO.setReasonId(reasonId);
                commonVO.setReasonType(reasonType);
                this.queryBudgetEqva(commonVO, (List<TaskInfoVO>)taskInfoVOS);
                commonVOList.add(commonVO);
            });
        }
        AccReimQuery query = new AccReimQuery();
        query.setReasonIdList(reasonIds);
        query.setReasonTypeList(reasonTypes);
        List<AccReimVO> accReimVOS = this.accReimDAO.queryListDynamic(query);
        HashMap<String, List> accReimVOSMap = new HashMap<String, List>();
        if (!ObjectUtils.isEmpty(accReimVOS)) {
            accReimVOS.forEach(vo -> {
                String key = vo.getReasonType() + "-" + vo.getReasonId();
                ArrayList<AccReimVO> accReimVOS1 = (ArrayList<AccReimVO>)accReimVOSMap.get(key);
                if (accReimVOS1 == null) {
                    accReimVOS1 = new ArrayList<AccReimVO>();
                }
                accReimVOS1.add((AccReimVO)vo);
                accReimVOSMap.put(key, accReimVOS1);
            });
            accReimVOSMap.forEach((key, accReimVOS1) -> {
                String[] split = key.split("-");
                String reasonType = split[0];
                Long reasonId = Long.valueOf(split[1]);
                Optional<BudgetCommonVO> first = commonVOList.stream().filter(vo -> vo.getReasonType().equals(reasonType) && vo.getReasonId().equals(reasonId)).findFirst();
                BudgetCommonVO commonVO = null;
                if (first.isPresent()) {
                    commonVO = first.get();
                } else {
                    commonVO = new BudgetCommonVO();
                    commonVO.setReasonId(reasonId);
                    commonVO.setReasonType(reasonType);
                    commonVOList.add(commonVO);
                }
                this.queryBudgetAmt(commonVO, (List<AccReimVO>)accReimVOS1, new Long[0]);
            });
        }
        return commonVOList;
    }

    public void queryBudgetEqva(BudgetCommonVO commonVO, List<TaskInfoVO> taskInfoVOS) {
        if (taskInfoVOS == null) {
            taskInfoVOS = this.taskInfoDAO.queryTaskByReason(commonVO.getReasonType(), commonVO.getReasonId());
        }
        BigDecimal occupyEqva = BigDecimal.ZERO;
        BigDecimal usedEqva = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> actOccupyEqvaMap = new HashMap<Long, BigDecimal>();
        HashMap<Long, BigDecimal> actUsedEqvaMap = new HashMap<Long, BigDecimal>();
        if (!ObjectUtils.isEmpty(taskInfoVOS)) {
            for (TaskInfoVO infoVO : taskInfoVOS) {
                BigDecimal totalEqva = infoVO.getTotalEqva();
                BigDecimal settledEqva = infoVO.getSettledEqva() == null ? BigDecimal.ZERO : infoVO.getSettledEqva();
                BigDecimal subtract = totalEqva.subtract(settledEqva);
                usedEqva = usedEqva.add(settledEqva);
                occupyEqva = occupyEqva.add(subtract);
                if (infoVO.getRelatedActId() == null) continue;
                BigDecimal actOccupyEqva = (BigDecimal)actOccupyEqvaMap.get(infoVO.getRelatedActId());
                if (actOccupyEqva == null) {
                    actOccupyEqva = BigDecimal.ZERO;
                }
                actOccupyEqvaMap.put(infoVO.getRelatedActId(), actOccupyEqva.add(subtract));
                BigDecimal actUsedEqva = (BigDecimal)actUsedEqvaMap.get(infoVO.getRelatedActId());
                if (actUsedEqva == null) {
                    actUsedEqva = BigDecimal.ZERO;
                }
                actUsedEqvaMap.put(infoVO.getRelatedActId(), actUsedEqva.add(settledEqva));
            }
        }
        commonVO.setActOccupyEqvaMap(actOccupyEqvaMap);
        commonVO.setActUsedEqvaMap(actUsedEqvaMap);
        commonVO.setOccupyEqva(occupyEqva);
        commonVO.setUsedEqva(usedEqva);
    }

    void queryBudgetAmt(BudgetCommonVO commonVO, List<AccReimVO> accReimVOS, Long ... reimId) {
        List<Long> reimIds;
        if (accReimVOS == null) {
            AccReimQuery query = new AccReimQuery();
            query.setReasonId(commonVO.getReasonId());
            query.setReasonType(commonVO.getReasonType());
            if (reimId != null && reimId.length > 0) {
                query.setNotId(reimId[0]);
            }
            query.setNotReimStatusList(Arrays.asList(AccReimDocStatusEnum.CREATE.getCode()));
            accReimVOS = this.accReimDAO.queryListDynamic(query);
        }
        BigDecimal occupyAmt = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> accOccupyAmtMap = new HashMap<Long, BigDecimal>();
        BigDecimal usedAmt = BigDecimal.ZERO;
        HashMap<Long, BigDecimal> accUsedAmtMap = new HashMap<Long, BigDecimal>();
        if (!ObjectUtils.isEmpty(accReimVOS) && !ObjectUtils.isEmpty(reimIds = accReimVOS.stream().filter(vo -> !vo.getReimStatus().equals(AccReimDocStatusEnum.CREATE.getCode())).map(BaseViewModel::getId).collect(Collectors.toList()))) {
            BigDecimal amt;
            List<AccReimDetailVO> accReimDetailVOS = this.detailDAO.queryByMasIds(reimIds);
            ArrayList usedDetails = new ArrayList();
            ArrayList occupyDetails = new ArrayList();
            accReimVOS.forEach(vo -> {
                List details = accReimDetailVOS.stream().filter(detailVO -> detailVO.getMasId().equals(vo.getId())).collect(Collectors.toList());
                if (vo.getReimStatus().equals(AccReimDocStatusEnum.APPROVED.getCode())) {
                    usedDetails.addAll(details);
                } else {
                    occupyDetails.addAll(details);
                }
            });
            for (AccReimDetailVO infoVO : usedDetails) {
                amt = infoVO.getReimAmt();
                if (infoVO.getAdjustAmt() != null) {
                    amt = infoVO.getAdjustAmt();
                }
                usedAmt = usedAmt.add(amt);
                if (infoVO.getBudgetItemId() == null) continue;
                BigDecimal accUsedAmt = (BigDecimal)accUsedAmtMap.get(infoVO.getBudgetItemId());
                if (accUsedAmt == null) {
                    accUsedAmt = BigDecimal.ZERO;
                }
                accUsedAmtMap.put(infoVO.getBudgetItemId(), accUsedAmt.add(amt));
            }
            for (AccReimDetailVO infoVO : occupyDetails) {
                amt = infoVO.getReimAmt();
                if (infoVO.getAdjustAmt() != null) {
                    amt = infoVO.getAdjustAmt();
                }
                occupyAmt = occupyAmt.add(amt);
                if (infoVO.getBudgetItemId() == null) continue;
                BigDecimal accOccupyAmt = (BigDecimal)accOccupyAmtMap.get(infoVO.getBudgetItemId());
                if (accOccupyAmt == null) {
                    accOccupyAmt = BigDecimal.ZERO;
                }
                accOccupyAmtMap.put(infoVO.getBudgetItemId(), accOccupyAmt.add(amt));
            }
        }
        commonVO.setAccOccupyAmtMap(accOccupyAmtMap);
        commonVO.setAccUsedAmtMap(accUsedAmtMap);
        commonVO.setOccupyAmt(occupyAmt);
        commonVO.setUsedAmt(usedAmt);
    }

    public BudgetCommonServiceImpl(BudgetDAO budgetDAO, PmsProjectActivityService pmsProjectActivityService, BudgetAppropriationDAO budgetAppropriationDAO, BudgetSubjectDetailDAO budgetSubjectDetailDAO, BudgetAppropriationDetailService appropriationDetailService, TransactionUtilService transactionUtilService, ConReceivablePlanService conReceivablePlanService, PrdSystemRoleDAO daoRole, PrdMessageConfigService messageConfigService, ComChangeService changeService, PmsProjectService pmsProjectService, BuProjectService buProjectService, AccSubjectTemplateService accSubjectTemplateService, TaskInfoDAO taskInfoDAO, AccReimDAO accReimDAO, AccReimDetailDAO detailDAO, CacheUtil cacheUtil) {
        this.budgetDAO = budgetDAO;
        this.pmsProjectActivityService = pmsProjectActivityService;
        this.budgetAppropriationDAO = budgetAppropriationDAO;
        this.budgetSubjectDetailDAO = budgetSubjectDetailDAO;
        this.appropriationDetailService = appropriationDetailService;
        this.transactionUtilService = transactionUtilService;
        this.conReceivablePlanService = conReceivablePlanService;
        this.daoRole = daoRole;
        this.messageConfigService = messageConfigService;
        this.changeService = changeService;
        this.pmsProjectService = pmsProjectService;
        this.buProjectService = buProjectService;
        this.accSubjectTemplateService = accSubjectTemplateService;
        this.taskInfoDAO = taskInfoDAO;
        this.accReimDAO = accReimDAO;
        this.detailDAO = detailDAO;
        this.cacheUtil = cacheUtil;
    }
}

