/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalWideSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalWideSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalResourceService;
import com.elitesland.tw.tw5.api.prd.cal.service.CalWideSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalWideSettleVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalWideSettleConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalWideSettleDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalWideSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalWideSettleRepo;
import com.elitesland.tw.tw5.server.prd.common.FileUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTurTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalSettleStatusEnum;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class CalWideSettleServiceImpl
extends BaseServiceImpl
implements CalWideSettleService {
    private static final Logger log = LoggerFactory.getLogger(CalWideSettleServiceImpl.class);
    private final CalWideSettleRepo calWideSettleRepo;
    private final CalWideSettleDAO calWideSettleDAO;
    private final CalResourceService calResourceService;
    private final FileUtil fileUtil;

    public PagingVO<CalWideSettleVO> queryPaging(CalWideSettleQuery query) {
        return this.calWideSettleDAO.queryPaging(query);
    }

    public List<CalWideSettleVO> queryListDynamic(CalWideSettleQuery query) {
        return this.calWideSettleDAO.queryListDynamic(query);
    }

    public CalWideSettleVO queryByKey(Long key) {
        CalWideSettleVO calWideSettleVO = this.calWideSettleDAO.queryByKey(key);
        calWideSettleVO.setFileDatas(this.fileUtil.getFileDatas(calWideSettleVO.getFileCodes()));
        return calWideSettleVO;
    }

    @Transactional(rollbackFor={Exception.class})
    public CalWideSettleVO insertOrUpdate(CalWideSettlePayload payload) {
        this.checkData(payload);
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (payload.getId() == null) {
            String code = this.generateSeqNum("CAL_WIDE_SETTLE", new String[0]);
            payload.setSettleNo(code);
        } else {
            CalWideSettleVO calWideSettleVO = this.calWideSettleDAO.queryByKey(payload.getId());
            if (calWideSettleVO.getSettleStatus().equals(CalSettleStatusEnum.FINISH.getCode())) {
                throw TwException.error("", "\u4e0d\u652f\u6301\u6539\u72b6\u6001\u6570\u636e\u4fee\u6539");
            }
            loginUserId = calWideSettleVO.getApplyResId();
            payload.setCreateTime(calWideSettleVO.getCreateTime());
            payload.setCreateUserId(calWideSettleVO.getCreateUserId());
        }
        String status = CalSettleStatusEnum.CREATE.getCode();
        if (payload.getIsSubmit() != null && payload.getIsSubmit() == 1) {
            status = CalSettleStatusEnum.FINISH.getCode();
        }
        payload.setApplyResId(loginUserId);
        payload.setSettleStatus(status);
        CalWideSettleDO entityDo = CalWideSettleConvert.INSTANCE.toDo(payload);
        CalWideSettleVO calWideSettleVO = CalWideSettleConvert.INSTANCE.toVo((CalWideSettleDO)this.calWideSettleRepo.save(entityDo));
        if (status.equals(CalSettleStatusEnum.FINISH.getCode())) {
            this.calResourceService.wideSettleTurnover(calWideSettleVO);
        }
        return calWideSettleVO;
    }

    void checkData(CalWideSettlePayload payload) {
        if (payload.getSettleDate() == null) {
            throw TwException.error("", "\u7ed3\u7b97\u671f\u95f4\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getSettleType())) {
            throw TwException.error("", "\u7ed3\u7b97\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getFromSourceType())) {
            throw TwException.error("", "\u652f\u51fa\u6838\u7b97\u4e3b\u9898\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getFromSourceId() == null) {
            throw TwException.error("", "\u652f\u51fa\u6838\u7b97\u4e3b\u9898\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getFromSourceName())) {
            throw TwException.error("", "\u652f\u51fa\u6838\u7b97\u4e3b\u9898\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getToSourceType())) {
            throw TwException.error("", "\u6536\u5165\u6838\u7b97\u4e3b\u9898\u7c7b\u578b\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getToSourceId() == null) {
            throw TwException.error("", "\u6536\u5165\u6838\u7b97\u4e3b\u9898\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (ObjectUtils.isEmpty((Object)payload.getToSourceName())) {
            throw TwException.error("", "\u6536\u5165\u6838\u7b97\u4e3b\u9898\u540d\u79f0\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getFromSourceType().equals(payload.getToSourceType()) && payload.getFromSourceId().equals(payload.getToSourceId())) {
            throw TwException.error("", "\u652f\u51fa\u3001\u6536\u5165\u6838\u7b97\u4e3b\u4f53\u4e0d\u53ef\u76f8\u540c");
        }
        if (payload.getApplySettleEqva() == null) {
            throw TwException.error("", "\u7533\u8bf7\u7ed3\u7b97\u5f53\u91cf\u6570\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getApplySettleAmt() == null) {
            throw TwException.error("", "\u7533\u8bf7\u7ed3\u7b97\u603b\u989d\u4e0d\u53ef\u4e3a\u7a7a");
        }
        if (payload.getSettlePrice() == null) {
            throw TwException.error("", "\u7533\u8bf7\u7ed3\u7b97\u5355\u4ef7\u4e0d\u53ef\u4e3a\u7a7a");
        }
        List<String> types = Arrays.asList(CalAccTypeEnum.PROJ.getCode(), CalAccTypeEnum.BU.getCode(), CalAccTypeEnum.BU_PROJ.getCode(), CalAccTypeEnum.OPP.getCode());
        if (!types.contains(payload.getFromSourceType())) {
            throw TwException.error("", "\u4e0d\u652f\u6301\u7684\u6cdb\u7528\u5f53\u91cf\u4ea4\u6613\u7c7b\u578b");
        }
        if (!types.contains(payload.getToSourceType())) {
            throw TwException.error("", "\u4e0d\u652f\u6301\u7684\u6cdb\u7528\u5f53\u91cf\u4ea4\u6613\u7c7b\u578b");
        }
        if (payload.getSettleType().equals(CalAccTurTypeEnum.HANDWORK.getCode()) && payload.getFromSourceType().equals(CalAccTypeEnum.PROJ.getCode()) && payload.getToSourceType().equals(CalAccTypeEnum.BU.getCode())) {
            throw TwException.error("", "\u4e0d\u652f\u6301\u7684\u6cdb\u7528\u5f53\u91cf\u4ea4\u6613\u7c7b\u578b");
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(CalWideSettlePayload payload) {
        long result = this.calWideSettleDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List collect;
            List<CalWideSettleVO> calWideSettleVOS = this.calWideSettleDAO.queryByKeys(keys);
            if (calWideSettleVOS.size() > 0 && (collect = calWideSettleVOS.stream().filter(vo -> !vo.getSettleStatus().equals(CalSettleStatusEnum.CREATE.getCode())).collect(Collectors.toList())).size() > 0) {
                throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u5220\u9664");
            }
            this.calWideSettleDAO.deleteSoft(keys);
        }
    }

    public CalWideSettleServiceImpl(CalWideSettleRepo calWideSettleRepo, CalWideSettleDAO calWideSettleDAO, CalResourceService calResourceService, FileUtil fileUtil) {
        this.calWideSettleRepo = calWideSettleRepo;
        this.calWideSettleDAO = calWideSettleDAO;
        this.calResourceService = calResourceService;
        this.fileUtil = fileUtil;
    }
}

