/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.crm.visit.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.visit.payload.VisitPlanPayload;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitPlanQuery;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitPlanVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanStatusEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.QVisitPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.QVisitPlanDetailDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.entity.VisitPlanDO;
import com.elitesland.tw.tw5.server.prd.crm.visit.repo.VisitPlanRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Repository
public class VisitPlanDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final VisitPlanRepo repo;
    private final QVisitPlanDO qdo = QVisitPlanDO.visitPlanDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;
    private final CacheUtil cacheUtil;
    private final PrdOrgEmployeeService prdOrgEmployeeService;
    private final QVisitPlanDetailDO qVisitPlanDetailDO = QVisitPlanDetailDO.visitPlanDetailDO;

    private JPAQuery<VisitPlanVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(VisitPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.modifyUserId, this.qdo.updater, this.qdo.modifyTime, this.qdo.visitPlanType, this.qdo.visitPlanStatus, this.qdo.visitPlanName, this.qdo.customId, this.qdo.partnerId, this.qBusinessPartnerDO.partnerName.as("customerName"), this.qBusinessPartnerDO.bookId, this.qdo.customAdress, this.qdo.longitudeLatitude, this.qdo.bookAddressId, this.qBookAddressDO.detailAddress.as("bookAddressDesc"), this.qdo.visitDateFrom, this.qdo.visitDateTo, this.qdo.visitTimes, this.qdo.remindTime, this.qdo.extString1, this.qdo.extString2, this.qdo.extString3, this.qdo.extString4, this.qdo.extString5, this.qdo.objType, this.qdo.objId, this.qdo.objName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qdo.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qdo.bookAddressId));
    }

    private JPAQuery<VisitPlanVO> getJpaQueryWhere(VisitPlanQuery query) {
        JPAQuery<VisitPlanVO> jpaQuery = this.getJpaQuerySelect();
        if (query.getPermissionFlag().booleanValue()) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qVisitPlanDetailDO)).on((Predicate)this.qdo.id.eq(this.qVisitPlanDetailDO.visitPlanId));
        }
        jpaQuery.distinct();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(VisitPlanQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.countDistinct()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessPartnerDO)).on((Predicate)this.qBusinessPartnerDO.id.eq(this.qdo.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qBookAddressDO.id.eq(this.qdo.bookAddressId));
        if (query.getPermissionFlag().booleanValue()) {
            ((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qVisitPlanDetailDO)).on((Predicate)this.qdo.id.eq(this.qVisitPlanDetailDO.visitPlanId));
        }
        long total = (Long)((JPAQuery)jpaQuery.where(this.where(query))).fetchOne();
        return total;
    }

    private Predicate where(VisitPlanQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getVisitPlanType())) {
            list.add(this.qdo.visitPlanType.eq((Object)query.getVisitPlanType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitPlanStatus())) {
            list.add(this.qdo.visitPlanStatus.eq((Object)query.getVisitPlanStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitPlanName())) {
            list.add(this.qdo.visitPlanName.like(SqlUtil.toSqlLikeString(query.getVisitPlanName())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomId())) {
            list.add(this.qdo.customId.eq((Object)query.getCustomId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerId())) {
            list.add(this.qdo.partnerId.eq((Object)query.getPartnerId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomAdress())) {
            list.add(this.qdo.customAdress.like(SqlUtil.toSqlLikeString(query.getCustomAdress())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitTimes())) {
            list.add(this.qdo.visitTimes.eq((Object)query.getVisitTimes()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            list.add(this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitDateFrom())) {
            list.add(this.qdo.visitDateFrom.goe((Comparable)query.getVisitDateFrom()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitDateTo())) {
            list.add(this.qdo.visitDateTo.loe((Comparable)query.getVisitDateTo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            list.add(this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getVisitPersonNameStr())) {
            list.add(this.qdo.extString1.contains(query.getVisitPersonNameStr()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccompanyPersonNameStr())) {
            list.add(this.qdo.extString2.contains(query.getAccompanyPersonNameStr()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            Long userId = query.getLoginUserId();
            BooleanExpression booleanExpression = this.qdo.createUserId.eq((Object)userId);
            booleanExpression = booleanExpression.or((Predicate)this.qVisitPlanDetailDO.visitPersonId.in((Object[])new Long[]{userId}).and((Predicate)this.qVisitPlanDetailDO.deleteFlag.eq((Object)0)));
            list.add(booleanExpression);
        }
        return ExpressionUtils.allOf(list);
    }

    private void dataPermissionFlag(List<Predicate> list) {
        Long userId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLAT_SALE_PIC.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.SALE_VISIT_PIC.getCode()));
        if (rolePermission.booleanValue()) {
            return;
        }
        BooleanExpression booleanExpression = this.qdo.deleteFlag.eq((Object)0);
        List prdOrgEmployeeRefVOS = this.prdOrgEmployeeService.queryLowChildListByKey(null, userId);
        if (!CollectionUtils.isEmpty((Collection)prdOrgEmployeeRefVOS)) {
            List userIdList = prdOrgEmployeeRefVOS.stream().filter(p -> p.getUserId() != null).map(s -> s.getUserId()).collect(Collectors.toList());
            HashSet userIdSet = new HashSet(userIdList);
            userIdSet.add(userId);
            List prdSystemUserRoleVOS = this.prdOrgEmployeeService.queryUserListRole(new ArrayList(userIdSet), Arrays.asList(RoleEnum.SALE_RES.getCode()));
            if (!CollectionUtils.isEmpty((Collection)prdSystemUserRoleVOS)) {
                List saleUserIds = prdSystemUserRoleVOS.stream().filter(p -> p.getUserId() != null).map(s -> s.getUserId()).collect(Collectors.toList());
                booleanExpression.or((Predicate)this.qdo.createUserId.in(saleUserIds));
            }
            booleanExpression.or((Predicate)this.qVisitPlanDetailDO.visitPersonId.in(userIdSet));
        } else {
            if (this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SALE_RES.getCode())).booleanValue()) {
                booleanExpression.or((Predicate)this.qdo.createUserId.in((Object[])new Long[]{userId}));
            }
            booleanExpression.or((Predicate)this.qVisitPlanDetailDO.visitPersonId.in((Object[])new Long[]{userId}));
        }
        list.add((Predicate)booleanExpression);
    }

    public VisitPlanVO queryByKey(Long id) {
        JPAQuery<VisitPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (VisitPlanVO)jpaQuery.fetchFirst();
    }

    public int verifyVisitPlanName(String visitPlanName) {
        JPAQuery<VisitPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.visitPlanName.eq((Object)visitPlanName));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch().size();
    }

    public List<VisitPlanVO> queryListDynamic(VisitPlanQuery query) {
        JPAQuery<VisitPlanVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public VisitPlanVO findByKey(Long key) {
        JPAQuery<VisitPlanVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.id.eq((Object)key));
        jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (VisitPlanVO)jpaQuerySelect.fetchFirst();
    }

    public PagingVO<VisitPlanVO> queryPaging(VisitPlanQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<VisitPlanVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public VisitPlanDO save(VisitPlanDO ado) {
        return (VisitPlanDO)this.repo.save(ado);
    }

    public List<VisitPlanDO> saveAll(List<VisitPlanDO> dos) {
        return this.repo.saveAll(dos);
    }

    public long updateByKeyDynamic(VisitPlanPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getVisitPlanType() != null) {
            update.set((Path)this.qdo.visitPlanType, (Object)payload.getVisitPlanType());
        }
        if (payload.getVisitPlanStatus() != null) {
            update.set((Path)this.qdo.visitPlanStatus, (Object)payload.getVisitPlanStatus());
        }
        if (payload.getVisitPlanName() != null) {
            update.set((Path)this.qdo.visitPlanName, (Object)payload.getVisitPlanName());
        }
        if (payload.getCustomId() != null) {
            update.set(this.qdo.customId, (Object)payload.getCustomId());
        }
        if (payload.getPartnerId() != null) {
            update.set(this.qdo.partnerId, (Object)payload.getPartnerId());
        }
        if (payload.getCustomAdress() != null) {
            update.set((Path)this.qdo.customAdress, (Object)payload.getCustomAdress());
        }
        if (payload.getVisitDateFrom() != null) {
            update.set(this.qdo.visitDateFrom, (Object)payload.getVisitDateFrom());
        }
        if (payload.getVisitDateTo() != null) {
            update.set(this.qdo.visitDateTo, (Object)payload.getVisitDateTo());
        }
        if (payload.getVisitTimes() != null) {
            update.set((Path)this.qdo.visitTimes, (Object)payload.getVisitTimes());
        }
        if (payload.getRemindTime() != null) {
            update.set(this.qdo.remindTime, (Object)payload.getRemindTime());
        }
        if (payload.getObjType() != null) {
            update.set((Path)this.qdo.objType, (Object)payload.getObjType());
        }
        if (payload.getObjId() != null) {
            update.set(this.qdo.objId, (Object)payload.getObjId());
        }
        if (payload.getObjName() != null) {
            update.set((Path)this.qdo.objName, (Object)payload.getObjName());
        }
        if (payload.getExtString1() != null) {
            update.set((Path)this.qdo.extString1, (Object)payload.getExtString1());
        }
        if (payload.getExtString2() != null) {
            update.set((Path)this.qdo.extString2, (Object)payload.getExtString2());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("remindTime")) {
                update.setNull(this.qdo.remindTime);
            }
            if (nullFields.contains("visitPlanType")) {
                update.setNull((Path)this.qdo.visitPlanType);
            }
            if (nullFields.contains("visitPlanName")) {
                update.setNull((Path)this.qdo.visitPlanName);
            }
            if (nullFields.contains("customId")) {
                update.setNull(this.qdo.customId);
            }
            if (nullFields.contains("customAdress")) {
                update.setNull((Path)this.qdo.customAdress);
            }
            if (nullFields.contains("visitTimes")) {
                update.setNull((Path)this.qdo.visitTimes);
            }
            if (nullFields.contains("visitDateFrom")) {
                update.setNull(this.qdo.visitDateFrom);
            }
            if (nullFields.contains("visitDateTo")) {
                update.setNull(this.qdo.visitDateTo);
            }
            if (nullFields.contains("objType")) {
                update.setNull((Path)this.qdo.objType);
            }
            if (nullFields.contains("objId")) {
                update.setNull(this.qdo.objId);
            }
            if (nullFields.contains("objName")) {
                update.setNull((Path)this.qdo.objName);
            }
            if (nullFields.contains("extString1")) {
                update.setNull((Path)this.qdo.extString1);
            }
            if (nullFields.contains("extString2")) {
                update.setNull((Path)this.qdo.extString2);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long completeVisitPlan(Long visitPlanId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)visitPlanId)});
        update.set((Path)this.qdo.visitPlanStatus, (Object)VisitTaskPlanStatusEnum.completed.getCode());
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public VisitPlanDAO(JPAQueryFactory jpaQueryFactory, VisitPlanRepo repo, CacheUtil cacheUtil, PrdOrgEmployeeService prdOrgEmployeeService) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
        this.cacheUtil = cacheUtil;
        this.prdOrgEmployeeService = prdOrgEmployeeService;
    }
}

