/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.examination.callback;

import com.elitescloud.boot.exception.BusinessException;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamResultPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamGradeQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamResDtlQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamGradeService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResDtlService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdPerformanceExamResultService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamGradeVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResDtlVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamResultVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/PERFORMANCE_EXAM/callBack"})
@Transactional
public class PrdPerformanceExamCallback
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(PrdPerformanceExamCallback.class);
    public final PrdPerformanceExamResultService prdPerformanceExamResultService;
    public final PrdPerformanceExamResDtlService prdPerformanceExamResDtlService;
    public final PrdPerformanceExamGradeService prdPerformanceExamGradeService;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        log.info("\u52a8\u6001\u6307\u5b9a\u4efb\u52a1\u8d1f\u8d23\u4eba\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        if (StringUtils.isBlank((CharSequence)businessKey)) {
            throw new BusinessException("\u83b7\u53d6\u7684businessKey\u4e3a\u7a7a");
        }
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        Long id = Long.valueOf(businessKey);
        PrdPerformanceExamResultVO prdPerformanceExamResultVO = this.prdPerformanceExamResultService.get(id);
        PrdPerformanceExamResultPayload prdPerformanceExamResultPayload = new PrdPerformanceExamResultPayload();
        prdPerformanceExamResultPayload.setId(id);
        if (prdPerformanceExamResultVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: 
                case INVALID: {
                    prdPerformanceExamResultPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case REJECTED: {
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    prdPerformanceExamResultPayload.setState(ProcInstStatus.APPROVED.name());
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    prdPerformanceExamResultPayload.setApprovedTime(LocalDateTime.now());
                    PrdPerformanceExamResDtlQuery dtlQuery = new PrdPerformanceExamResDtlQuery();
                    dtlQuery.setResultId(id);
                    List list = this.prdPerformanceExamResDtlService.getList(dtlQuery);
                    BigDecimal sumScore = BigDecimal.ZERO;
                    for (PrdPerformanceExamResDtlVO dtlVO : list) {
                        if (null == dtlVO.getScoreRes()) {
                            dtlVO.setScoreRes(BigDecimal.ZERO);
                        }
                        if (null == dtlVO.getWeightRatio()) {
                            dtlVO.setScoreRes(BigDecimal.ZERO);
                        }
                        BigDecimal cScore = dtlVO.getWeightRatio().multiply(dtlVO.getScoreRes());
                        sumScore = sumScore.add(cScore);
                    }
                    prdPerformanceExamResultPayload.setScoreRes(sumScore);
                    PrdPerformanceExamGradeQuery gradeQuery = new PrdPerformanceExamGradeQuery();
                    gradeQuery.setExamId(prdPerformanceExamResultVO.getExamId());
                    List gradeVOList = this.prdPerformanceExamGradeService.getList(gradeQuery);
                    for (PrdPerformanceExamGradeVO gradeVO : gradeVOList) {
                        if (sumScore.compareTo(gradeVO.getScoreRatioStart()) != 1 && sumScore.compareTo(gradeVO.getScoreRatioStart()) != 0 || sumScore.compareTo(gradeVO.getScoreRatioEnd()) != -1 && sumScore.compareTo(gradeVO.getScoreRatioEnd()) != 0) continue;
                        prdPerformanceExamResultPayload.setGradeRes(gradeVO.getName());
                    }
                    break;
                }
                case APPROVING: {
                    prdPerformanceExamResultPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.prdPerformanceExamResultService.updateByCondition(prdPerformanceExamResultPayload);
        }
        return WorkflowResult.success(null);
    }

    public PrdPerformanceExamCallback(PrdPerformanceExamResultService prdPerformanceExamResultService, PrdPerformanceExamResDtlService prdPerformanceExamResDtlService, PrdPerformanceExamGradeService prdPerformanceExamGradeService) {
        this.prdPerformanceExamResultService = prdPerformanceExamResultService;
        this.prdPerformanceExamResDtlService = prdPerformanceExamResDtlService;
        this.prdPerformanceExamGradeService = prdPerformanceExamGradeService;
    }
}

