/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.personnel.service;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PersonWorkExperiencePayload;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PersonWorkExperienceService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PersonWorkExperienceVO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.convert.PersonWorkExperienceConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.dao.PersonWorkExperienceDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.entity.PersonWorkExperienceDO;
import com.elitesland.tw.tw5.server.prd.humanresources.personnel.repo.PersonWorkExperienceRepo;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class PersonWorkExperienceServiceImpl
implements PersonWorkExperienceService {
    private static final Logger log = LoggerFactory.getLogger(PersonWorkExperienceServiceImpl.class);
    private final PersonWorkExperienceRepo personWorkExperienceRepo;
    private final PersonWorkExperienceDAO personWorkExperienceDAO;

    public void save(PersonWorkExperiencePayload payload) {
        PersonWorkExperienceDO workExperienceDO = PersonWorkExperienceConvert.INSTANCE.toDo(payload);
        this.personWorkExperienceRepo.save((Object)workExperienceDO);
    }

    public List<PersonWorkExperienceVO> findAllByPersonId(Long personId) {
        List<PersonWorkExperienceDO> personWorkExperienceDOList = this.personWorkExperienceRepo.findAllByPersonId(personId);
        return PersonWorkExperienceConvert.INSTANCE.toVos(personWorkExperienceDOList);
    }

    public void saveAll(List<PersonWorkExperienceVO> workExperienceVOList, Long personId) {
        if (workExperienceVOList != null) {
            if (workExperienceVOList.size() == 0) {
                this.personWorkExperienceDAO.deleteAllByPersonId(personId);
            } else {
                for (PersonWorkExperienceVO workExperienceVO : workExperienceVOList) {
                    if (workExperienceVO.getPersonId() != null) continue;
                    workExperienceVO.setPersonId(personId);
                }
                this.personWorkExperienceDAO.saveAll(PersonWorkExperienceConvert.INSTANCE.toDos(workExperienceVOList));
            }
        }
    }

    public void deleteAllByPersonId(Long personId) {
        this.personWorkExperienceDAO.deleteAllByPersonId(personId);
    }

    public PersonWorkExperienceServiceImpl(PersonWorkExperienceRepo personWorkExperienceRepo, PersonWorkExperienceDAO personWorkExperienceDAO) {
        this.personWorkExperienceRepo = personWorkExperienceRepo;
        this.personWorkExperienceDAO = personWorkExperienceDAO;
    }
}

