/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.humanresources.resource.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalTaskSettleWithdrawPayload;
import com.elitesland.tw.tw5.api.prd.cal.service.CalTaskSettleService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalTaskSettleVO;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyDetailPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.payload.ResWithdrawApplyPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.ResWithdrawApplyQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.ResWithdrawApplyService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyDetailVO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyInfo;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.ResWithdrawApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.ResWithdrawApplyConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.convert.ResWithdrawApplyDetailConvert;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.dao.ResWithdrawApplyDetailDAO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.ResWithdrawApplyDetailDO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class ResWithdrawApplyServiceImpl
extends BaseServiceImpl
implements ResWithdrawApplyService {
    private static final Logger log = LoggerFactory.getLogger(ResWithdrawApplyServiceImpl.class);
    private final CacheUtil cacheUtil;
    private final PrdSystemRoleService prdSystemRoleService;
    private final ResWithdrawApplyDAO resWithdrawApplyDAO;
    private final ResWithdrawApplyDetailDAO resWithdrawApplyDetailDAO;
    private final WorkflowUtil workflowUtil;
    private final CalTaskSettleService calTaskSettleService;

    @Transactional
    public void submit(ResWithdrawApplyPayload payload) {
        if (payload.getProcInstId() == null) {
            this.startProc(payload);
        } else {
            this.updateWithdrawApply(payload);
        }
    }

    public void startProc(ResWithdrawApplyPayload payload) {
        ResWithdrawApplyDO payDO = ResWithdrawApplyConvert.INSTANCE.payloadToDo(payload);
        String withdrawApplyNo = this.generateSeqNum("RES_WITHDRAW_APPLY_NO", new String[0]);
        payDO.setWithdrawNo(withdrawApplyNo);
        List withdrawApplyDetailPayloadList = payload.getDetailPayloadList();
        BigDecimal withdrawAmt = new BigDecimal(0);
        BigDecimal withdrawEqva = new BigDecimal(0);
        for (ResWithdrawApplyDetailPayload detailPayload : withdrawApplyDetailPayloadList) {
            withdrawAmt = withdrawAmt.add(detailPayload.getAvalAmt());
            withdrawEqva = withdrawEqva.add(detailPayload.getAvalQty());
        }
        payDO.setWithdrawAmt(withdrawAmt);
        payDO.setWithdrawEqva(withdrawEqva);
        Long applyUserId = GlobalUtil.getLoginUserId();
        ResWithdrawApplyDO resWithdrawApplyDO = this.resWithdrawApplyDAO.save(payDO);
        List<ResWithdrawApplyDetailDO> resWithdrawApplyDetailDOList = ResWithdrawApplyDetailConvert.INSTANCE.payloadsToDos(withdrawApplyDetailPayloadList);
        resWithdrawApplyDetailDOList.forEach(resWithdrawApplyDetailDO -> resWithdrawApplyDetailDO.setApplyId(resWithdrawApplyDO.getId()));
        this.resWithdrawApplyDetailDAO.saveAll(resWithdrawApplyDetailDOList);
        List<Long> settleIds = withdrawApplyDetailPayloadList.stream().map(ResWithdrawApplyDetailPayload::getSettleId).toList();
        CalTaskSettleWithdrawPayload calTaskSettleWithdrawPayload = new CalTaskSettleWithdrawPayload();
        calTaskSettleWithdrawPayload.setWithdrawId(resWithdrawApplyDO.getId());
        calTaskSettleWithdrawPayload.setWithdrawNo(withdrawApplyNo);
        calTaskSettleWithdrawPayload.setWithdrawResId(applyUserId);
        calTaskSettleWithdrawPayload.setWithdrawStatus("1");
        calTaskSettleWithdrawPayload.setSettleIds(settleIds);
        calTaskSettleWithdrawPayload.setWithdrawQty(resWithdrawApplyDO.getWithdrawEqva());
        calTaskSettleWithdrawPayload.setWithdrawAmt(resWithdrawApplyDO.getWithdrawAmt());
        this.calTaskSettleService.taskSettleWithdraw(calTaskSettleWithdrawPayload);
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.APPROVED_WORK.getCode();
        Long currentUserId = GlobalUtil.getLoginUserId();
        HashMap<String, Object> variables = new HashMap<String, Object>();
        PrdOrgEmployeeRefVO refVO = this.cacheUtil.getUserDefaultOrg(currentUserId);
        PrdOrgEmployeeVO employeeVO = this.cacheUtil.getEmployee(currentUserId);
        variables.put("Activity_1ro83hm", CollUtil.newArrayList((Object[])new Long[]{refVO.getParentId()}));
        List resDirectors = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_DIRECTOR.getCode());
        variables.put("Activity_1gj69zo", resDirectors);
        variables.put("Activity_1n1w2bd", CollUtil.newArrayList((Object[])new Long[]{refVO.getManageId()}));
        List finLeaderIds = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_RESOURCE_PIC.getCode());
        variables.put("Activity_1viykwl", CollUtil.newArrayList((Collection)finLeaderIds));
        List salaryManageIds = this.prdSystemRoleService.queryUserIdByRoleCode(RoleEnum.PLAT_SALARY_MANAGER.getCode());
        variables.put("Activity_1k04zqt", CollUtil.newArrayList((Collection)salaryManageIds));
        variables.put("innerTypeFlag", employeeVO.getExtString6().equals("INTERNAL_RES"));
        processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.RES_WITHDRAW_APPLY.name(), (String)(employeeVO.getEmployeeName() + "-\u63d0\u73b0\u7533\u8bf7\u6d41\u7a0b"), (String)("" + resWithdrawApplyDO.getId()), variables), new Long[0]);
        payload.setId(resWithdrawApplyDO.getId());
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        this.resWithdrawApplyDAO.updatePrco(payload);
    }

    public void updateWithdrawApply(ResWithdrawApplyPayload payload) {
        ResWithdrawApplyDO payDO = ResWithdrawApplyConvert.INSTANCE.payloadToDo(payload);
        List withdrawApplyDetailPayloadList = payload.getDetailPayloadList();
        BigDecimal withdrawAmt = new BigDecimal(0);
        BigDecimal withdrawEqva = new BigDecimal(0);
        BigDecimal adjWithdrawAmt = new BigDecimal(0);
        for (ResWithdrawApplyDetailPayload detailPayload : withdrawApplyDetailPayloadList) {
            withdrawAmt = withdrawAmt.add(detailPayload.getAvalAmt());
            withdrawEqva = withdrawEqva.add(detailPayload.getAvalQty());
            adjWithdrawAmt = adjWithdrawAmt.add(detailPayload.getAdjWithdrawAmt());
        }
        payDO.setWithdrawAmt(withdrawAmt);
        payDO.setWithdrawEqva(withdrawEqva);
        payDO.setAdjWithdrawAmt(adjWithdrawAmt);
        ResWithdrawApplyDO resWithdrawApplyDO = this.resWithdrawApplyDAO.save(payDO);
        Long applyId = resWithdrawApplyDO.getId();
        List<ResWithdrawApplyDetailDO> resWithdrawApplyDetailDOList = ResWithdrawApplyDetailConvert.INSTANCE.payloadsToDos(withdrawApplyDetailPayloadList);
        resWithdrawApplyDetailDOList.forEach(resWithdrawApplyDetailDO -> resWithdrawApplyDetailDO.setApplyId(applyId));
        this.resWithdrawApplyDetailDAO.deleteAllByApplyId(applyId);
        this.resWithdrawApplyDetailDAO.saveAll(resWithdrawApplyDetailDOList);
    }

    public ResWithdrawApplyVO queryByProcId(String procId) {
        ResWithdrawApplyDO withdrawApplyDO = this.resWithdrawApplyDAO.findByProcId(procId);
        ResWithdrawApplyVO withdrawApplyVO = ResWithdrawApplyConvert.INSTANCE.doToVo(withdrawApplyDO);
        List<ResWithdrawApplyDetailDO> withdrawApplyDetailDOList = this.resWithdrawApplyDetailDAO.findAllByApplyId(withdrawApplyDO.getId());
        List<ResWithdrawApplyDetailVO> withdrawApplyDetailVOList = ResWithdrawApplyDetailConvert.INSTANCE.dosToVos(withdrawApplyDetailDOList);
        withdrawApplyVO.setDetailVOList(withdrawApplyDetailVOList);
        return withdrawApplyVO;
    }

    public PagingVO<ResWithdrawApplyVO> page(ResWithdrawApplyQuery query) {
        return this.resWithdrawApplyDAO.queryPaging(query);
    }

    public ResWithdrawApplyInfo getResWithdrawTotal(ResWithdrawApplyQuery query) {
        ResWithdrawApplyInfo resWithdrawApplyInfo = new ResWithdrawApplyInfo();
        PagingVO<ResWithdrawApplyVO> resWithdrawApplyVOPagingVO = this.resWithdrawApplyDAO.queryPaging(query);
        resWithdrawApplyInfo.setResWithdrawApplyPageVO(resWithdrawApplyVOPagingVO);
        BigDecimal withdrawEqvaTotal = this.resWithdrawApplyDAO.getWithdrawEqvaTotal(query);
        BigDecimal withdrawAmtTotal = this.resWithdrawApplyDAO.getWithdrawAmtTotal(query);
        resWithdrawApplyInfo.setWithdrawAmt(withdrawAmtTotal);
        resWithdrawApplyInfo.setWithdrawEqva(withdrawEqvaTotal);
        this.translate(resWithdrawApplyVOPagingVO.getRecords());
        return resWithdrawApplyInfo;
    }

    private void translate(List<ResWithdrawApplyVO> records) {
        records.forEach(resWithdrawApplyVO -> {
            resWithdrawApplyVO.setCooperationModeName(this.cacheUtil.transferSystemSelection("org:employee:COOPERATION_MODE", resWithdrawApplyVO.getCooperationMode()));
            resWithdrawApplyVO.setWithdrawPayStatusName(this.cacheUtil.transferSystemSelection("org:employee:withdrawPayStatus", resWithdrawApplyVO.getWithdrawPayStatus()));
            resWithdrawApplyVO.setApplyUserName(this.cacheUtil.getUserName(resWithdrawApplyVO.getApplyUserId()));
        });
    }

    public ResWithdrawApplyVO queryByKey(Long id) {
        ResWithdrawApplyDO withdrawApplyDO = this.resWithdrawApplyDAO.findById(id);
        ResWithdrawApplyVO withdrawApplyVO = ResWithdrawApplyConvert.INSTANCE.doToVo(withdrawApplyDO);
        withdrawApplyVO.setApplyUserName(this.cacheUtil.getUserName(withdrawApplyDO.getApplyUserId()));
        List<ResWithdrawApplyDetailDO> withdrawApplyDetailDOList = this.resWithdrawApplyDetailDAO.findAllByApplyId(withdrawApplyDO.getId());
        List<ResWithdrawApplyDetailVO> withdrawApplyDetailVOList = ResWithdrawApplyDetailConvert.INSTANCE.dosToVos(withdrawApplyDetailDOList);
        for (ResWithdrawApplyDetailVO resWithdrawApplyDetailVO : withdrawApplyDetailVOList) {
            CalTaskSettleVO calTaskSettleVO = this.calTaskSettleService.queryByKey(resWithdrawApplyDetailVO.getSettleId());
            if (ObjectUtils.isEmpty((Object)calTaskSettleVO)) continue;
            resWithdrawApplyDetailVO.setProjName(calTaskSettleVO.getProjName());
            resWithdrawApplyDetailVO.setTaskName(calTaskSettleVO.getTaskName());
            resWithdrawApplyDetailVO.setSettleNo(calTaskSettleVO.getSettleNo());
        }
        withdrawApplyVO.setDetailVOList(withdrawApplyDetailVOList);
        return withdrawApplyVO;
    }

    public List<ResWithdrawApplyVO> findWithdrawByAgreementNo(String agreementNo) {
        return this.resWithdrawApplyDAO.findWithdrawByAgreementNo(agreementNo);
    }

    public void updateWithdrawStatusAndPaymentApplyIdByIds(Long paymentApplyId, List<Long> withdrawIds, String withdrawStatus) {
        this.resWithdrawApplyDAO.updateWithdrawStatusAndPaymentApplyIdByIds(paymentApplyId, withdrawIds, withdrawStatus);
    }

    public void updateWithdrawStatusByPaymentApplyId(Long paymentApplyId, String withdrawStatus) {
        if (withdrawStatus == null) {
            this.resWithdrawApplyDAO.resetWithdrawByPaymentApplyId(paymentApplyId);
        } else {
            this.resWithdrawApplyDAO.updateWithdrawStatusByPaymentApplyId(paymentApplyId, withdrawStatus);
        }
    }

    public List<ResWithdrawApplyVO> queryListByPaymentApplyId(Long paymentApplyId) {
        return this.resWithdrawApplyDAO.queryListByPaymentApplyId(paymentApplyId);
    }

    public ResWithdrawApplyServiceImpl(CacheUtil cacheUtil, PrdSystemRoleService prdSystemRoleService, ResWithdrawApplyDAO resWithdrawApplyDAO, ResWithdrawApplyDetailDAO resWithdrawApplyDetailDAO, WorkflowUtil workflowUtil, CalTaskSettleService calTaskSettleService) {
        this.cacheUtil = cacheUtil;
        this.prdSystemRoleService = prdSystemRoleService;
        this.resWithdrawApplyDAO = resWithdrawApplyDAO;
        this.resWithdrawApplyDetailDAO = resWithdrawApplyDetailDAO;
        this.workflowUtil = workflowUtil;
        this.calTaskSettleService = calTaskSettleService;
    }
}

