/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.my.service;

import cn.hutool.core.collection.CollUtil;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.OutWorkApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.OutWorkApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.OutWorkApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.OutWorkApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgEmployeeRefVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.OutWorkApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.OutWorkApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.OutWorkApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.OutWorkApplyRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class OutWorkApplyServiceImpl
extends BaseServiceImpl
implements OutWorkApplyService {
    private static final Logger log = LoggerFactory.getLogger(OutWorkApplyServiceImpl.class);
    private final OutWorkApplyRepo outWorkApplyRepo;
    private final OutWorkApplyDAO outWorkApplyDAO;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final TransactionUtilService transactionUtilService;

    public PagingVO<OutWorkApplyVO> queryPaging(OutWorkApplyQuery query) {
        return this.outWorkApplyDAO.queryPaging(query);
    }

    public List<OutWorkApplyVO> queryListDynamic(OutWorkApplyQuery query) {
        return this.outWorkApplyDAO.queryListDynamic(query);
    }

    public OutWorkApplyVO queryByKey(Long key) {
        OutWorkApplyDO entity = this.outWorkApplyRepo.findById(key).orElseGet(OutWorkApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        OutWorkApplyVO vo = OutWorkApplyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public OutWorkApplyVO insertOrUpdate(OutWorkApplyPayload payload) {
        String procInstId = null;
        if (payload.getId() != null) {
            OutWorkApplyDO entity = this.outWorkApplyRepo.findById(payload.getId()).orElseGet(OutWorkApplyDO::new);
            if (entity.getId() == null) {
                throw TwException.error("", "\u53d8\u66f4\u6570\u636e\u4e0d\u5b58\u5728");
            }
            procInstId = entity.getProcInstId();
        } else {
            payload.setApplyDate(LocalDate.now());
        }
        OutWorkApplyDO entityDo = OutWorkApplyConvert.INSTANCE.toDo(payload);
        OutWorkApplyDO save = (OutWorkApplyDO)this.outWorkApplyRepo.save(entityDo);
        payload.setId(save.getId());
        payload.setProcInstId(procInstId);
        if (payload.getSubmitFlag().booleanValue() && !StringUtils.hasText((String)procInstId)) {
            this.startProcess(payload);
        }
        return OutWorkApplyConvert.INSTANCE.toVo(save);
    }

    void startProcess(OutWorkApplyPayload payload) {
        HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
        PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = this.cacheUtil.getUserDefaultOrg(payload.getApplyUserId());
        variables.put("Activity_0ixka9u", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getParentId()}));
        variables.put("Activity_0up3jog", CollUtil.newArrayList((Object[])new Long[]{prdOrgEmployeeRefVO.getManageId()}));
        String procInstName = "A38." + ProcDefKey.OUT_WORK.getDesc() + "-" + prdOrgEmployeeRefVO.getEmployeeName() + "-" + payload.getApplyDate();
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)ProcDefKey.OUT_WORK.name(), (String)procInstName, (String)("" + payload.getId()), variables), new Long[0]);
        OutWorkApplyPayload payload0 = new OutWorkApplyPayload();
        payload0.setId(payload.getId());
        payload0.setProcInstId(processInfo.getProcInstId());
        payload0.setProcInstStatus(processInfo.getProcInstStatus().name());
        payload0.setParentUserId(prdOrgEmployeeRefVO.getParentId());
        this.transactionUtilService.executeWithRunnable(() -> this.outWorkApplyDAO.updateByKeyDynamic(payload0));
    }

    @Transactional(rollbackFor={Exception.class})
    public OutWorkApplyVO update(OutWorkApplyPayload payload) {
        OutWorkApplyDO entity = this.outWorkApplyRepo.findById(payload.getId()).orElseGet(OutWorkApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        OutWorkApplyDO entityDo = OutWorkApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return OutWorkApplyConvert.INSTANCE.toVo((OutWorkApplyDO)this.outWorkApplyRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(OutWorkApplyPayload payload) {
        OutWorkApplyDO entity = this.outWorkApplyRepo.findById(payload.getId()).orElseGet(OutWorkApplyDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.outWorkApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.outWorkApplyDAO.deleteSoft(keys);
        }
    }

    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        Long applyId = Long.valueOf(businessKey);
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        OutWorkApplyPayload payload0 = new OutWorkApplyPayload();
        payload0.setId(applyId);
        payload0.setProcInstStatus(procInstStatus.name());
        switch (procInstStatus) {
            case NOTSUBMIT: {
                payload0.setProcInstStatus(ProcInstStatus.NOTSUBMIT.name());
                break;
            }
            case INTERRUPT: {
                payload0.setProcInstStatus(ProcInstStatus.INTERRUPT.name());
                break;
            }
            case INVALID: {
                payload0.setProcInstStatus(ProcInstStatus.INVALID.name());
                break;
            }
            case REJECTED: {
                payload0.setProcInstStatus(ProcInstStatus.NOTSUBMIT.name());
                break;
            }
            case APPROVED: {
                payload0.setProcInstStatus(ProcInstStatus.APPROVED.name());
                break;
            }
            case APPROVING: {
                payload0.setProcInstStatus(ProcInstStatus.APPROVING.name());
            }
        }
        this.outWorkApplyDAO.updateByKeyDynamic(payload0);
    }

    public OutWorkApplyServiceImpl(OutWorkApplyRepo outWorkApplyRepo, OutWorkApplyDAO outWorkApplyDAO, WorkflowUtil workflowUtil, CacheUtil cacheUtil, TransactionUtilService transactionUtilService) {
        this.outWorkApplyRepo = outWorkApplyRepo;
        this.outWorkApplyDAO = outWorkApplyDAO;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.transactionUtilService = transactionUtilService;
    }
}

