/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.partner.common.dao;

import cn.hutool.extra.pinyin.PinyinUtil;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BusinessPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BusinessPartnerQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessConfirmedCustomerVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerInfoVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerMainSyncVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerSimpleVO;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookContactsDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BusinessPartnerRepo;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessInsideOrOutSideEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerStageEnum;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCollaboratePartnerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessCustomerInfoDO;
import com.elitesland.tw.tw5.server.prd.partner.identity.entity.QBusinessSupplierInfoDO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class BusinessPartnerDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final BusinessPartnerRepo repo;
    private final QBusinessPartnerDO qdo = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAddressDO qBookAddressDO = QBookAddressDO.bookAddressDO;
    private final QBookContactsDO qBookContactsDO = QBookContactsDO.bookContactsDO;
    private final QBusinessCustomerInfoDO qBusinessCustomerInfoDO = QBusinessCustomerInfoDO.businessCustomerInfoDO;
    private final QBusinessSupplierInfoDO qBusinessSupplierInfoDO = QBusinessSupplierInfoDO.businessSupplierInfoDO;
    private final QBusinessCollaboratePartnerInfoDO qBusinessCollaboratePartnerInfoDO = QBusinessCollaboratePartnerInfoDO.businessCollaboratePartnerInfoDO;

    private JPAQuery<BusinessPartnerVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.customerFlag, this.qdo.collaborateFlag, this.qdo.supplierFlag, this.qdo.bookId, this.qdo.bookIdV4, this.qdo.businessPartnerNo, this.qdo.partnerType, this.qdo.partnerName, this.qdo.partnerIdentity, this.qdo.partnerIndustry, this.qdo.partnerNature, this.qdo.organizationScale, this.qdo.partnerWebsite, this.qdo.partnerEmail, this.qdo.partnerFax, this.qdo.partnerPhone, this.qdo.partnerRegion, this.qdo.currency, this.qdo.language, this.qdo.englishName, this.qdo.certificateType, this.qdo.certificateNo, this.qdo.partnerSex, this.qdo.partnerBirthday, this.qdo.nationality, this.qdo.nativePlace, this.qdo.nation, this.qdo.maritalStatus, this.qdo.certificateDateStart, this.qdo.certificateDateEnd, this.qdo.applyStatus, this.qdo.sortNo, this.qdo.ext1, this.qdo.ext2, this.qdo.ext3, this.qdo.ext4, this.qdo.ext5, this.qdo.parentId, this.qdo.thirdSystemNo, this.qBookAddressDO.country, this.qBookAddressDO.province, this.qBookAddressDO.city, this.qBookAddressDO.district, this.qBookAddressDO.provinceName, this.qBookAddressDO.cityName, this.qBookAddressDO.districtName, this.qBookAddressDO.detailAddress, this.qBusinessCustomerInfoDO.customerStatus, this.qBusinessCustomerInfoDO.confirmFlag, this.qBusinessCustomerInfoDO.customerNo, this.qBusinessCollaboratePartnerInfoDO.collaborateStatus, this.qBusinessSupplierInfoDO.supplierStatus, this.qBusinessSupplierInfoDO.supplierNo, this.qBookContactsDO.contactsPhone, this.qBookContactsDO.contactsEmail, this.qdo.insideOrOutSide})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBusinessCollaboratePartnerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCollaboratePartnerInfoDO.partnerId))).leftJoin((EntityPath)this.qBusinessSupplierInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessSupplierInfoDO.partnerId))).leftJoin((EntityPath)this.qBookContactsDO)).on((Predicate)this.qdo.bookId.eq(this.qBookContactsDO.bookId).and((Predicate)this.qBookContactsDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookContactsDO.deleteFlag.eq((Object)0)));
    }

    private JPAQuery<BusinessPartnerVO> getJpaQueryWhere(BusinessPartnerQuery query) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQuerySelect();
        Long loginUserId = GlobalUtil.getLoginUserId();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(BusinessPartnerQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBusinessCollaboratePartnerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCollaboratePartnerInfoDO.partnerId))).leftJoin((EntityPath)this.qBusinessSupplierInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessSupplierInfoDO.partnerId))).leftJoin((EntityPath)this.qBookContactsDO)).on((Predicate)this.qdo.bookId.eq(this.qBookContactsDO.bookId).and((Predicate)this.qBookContactsDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookContactsDO.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        return (Long)jpaQuery.fetchOne();
    }

    public long saleCount(BusinessPartnerQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        if (query.getUserIdList() != null && query.getUserIdList().size() > 0) {
            jpaQuery.where((Predicate)this.qdo.createUserId.in((Collection)query.getUserIdList()));
        }
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        return (Long)jpaQuery.fetchOne();
    }

    private Predicate where(BusinessPartnerQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getPartnerName())) {
            String pattern = "^[a-zA-Z]+$";
            Pattern p = Pattern.compile(pattern);
            Matcher m = p.matcher(query.getPartnerName());
            if (m.matches()) {
                list.add(this.qdo.partnerNamePinyin.like(SqlUtil.toSqlLikeString(query.getPartnerName())));
            } else {
                list.add(this.qdo.partnerName.like(SqlUtil.toSqlLikeString(query.getPartnerName())));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getInsideOrOutSide())) {
            list.add(this.qdo.insideOrOutSide.eq((Object)query.getInsideOrOutSide()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBusinessPartnerNo())) {
            list.add(this.qdo.businessPartnerNo.eq((Object)query.getBusinessPartnerNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerType())) {
            list.add(this.qdo.partnerType.eq((Object)query.getPartnerType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerIdentity())) {
            String[] identityArray = query.getPartnerIdentity().split(",");
            List<String> identityList = Arrays.asList(identityArray);
            if (identityList.contains(BusinessPartnerIdentityEnum.CUSTOMER.getCode())) {
                list.add(this.qdo.customerFlag.eq(Boolean.valueOf(true)));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.SUPPLIER.getCode())) {
                list.add(this.qdo.supplierFlag.eq(Boolean.valueOf(true)));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.COLLABORATE.getCode())) {
                list.add(this.qdo.collaborateFlag.eq(Boolean.valueOf(true)));
            }
            if (identityList.contains(BusinessPartnerIdentityEnum.DISTRIBUTOR.getCode())) {
                list.add(this.qdo.distributorFlag.eq(Boolean.valueOf(true)));
            }
        }
        if (!ObjectUtils.isEmpty((Object)query.getCreateUserId())) {
            list.add(this.qdo.createUserId.eq((Object)query.getCreateUserId()));
        }
        if (query.getUserIdList() != null && query.getUserIdList().size() > 0) {
            list.add(this.qdo.createUserId.in((Collection)query.getUserIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPartnerIndustry())) {
            List collect = Arrays.stream(query.getPartnerIndustry().split(",")).collect(Collectors.toList());
            list.add(this.qdo.partnerIndustry.in(collect));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvince())) {
            list.add(this.qBookAddressDO.province.eq((Object)query.getProvince()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCity())) {
            list.add(this.qBookAddressDO.city.eq((Object)query.getCity()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistrict())) {
            list.add(this.qBookAddressDO.district.eq((Object)query.getDistrict()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getProvinceName())) {
            list.add(this.qBookAddressDO.provinceName.eq((Object)query.getProvinceName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCityName())) {
            list.add(this.qBookAddressDO.cityName.eq((Object)query.getCityName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDistrictName())) {
            list.add(this.qBookAddressDO.districtName.eq((Object)query.getDistrictName()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCustomerStatus())) {
            list.add(this.qBusinessCustomerInfoDO.customerStatus.eq((Object)query.getCustomerStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierStatus())) {
            list.add(this.qBusinessSupplierInfoDO.supplierStatus.eq((Object)query.getSupplierStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCollaborateStatus())) {
            list.add(this.qBusinessCollaboratePartnerInfoDO.collaborateStatus.eq((Object)query.getCollaborateStatus()));
        }
        if (query.getPermissionFlag().booleanValue()) {
            list.add(this.qdo.createUserId.eq((Object)query.getLoginUserId()));
        }
        return ExpressionUtils.allOf(list);
    }

    public BusinessPartnerVO queryByKey(Long id) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (BusinessPartnerVO)jpaQuery.fetchFirst();
    }

    public BusinessPartnerDO queryById(Long id) {
        return (BusinessPartnerDO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo)).where((Predicate)this.qdo.id.eq((Object)id))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public List<BusinessPartnerVO> queryListDynamic(BusinessPartnerQuery query) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<BusinessPartnerSimpleVO> queryListSimple() {
        return ((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerSimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerName})).from((EntityPath)this.qdo)).fetch();
    }

    public Long judgePartnerName(String partnerName) {
        return (Long)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.eq((Object)partnerName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchOne();
    }

    public PagingVO<BusinessPartnerVO> queryPaging(BusinessPartnerQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public BusinessPartnerDO save(BusinessPartnerDO ado) {
        return (BusinessPartnerDO)this.repo.save(ado);
    }

    public List<BusinessPartnerDO> saveAll(List<BusinessPartnerDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(BusinessPartnerPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getBookId() != null) {
            update.set(this.qdo.bookId, (Object)payload.getBookId());
        }
        if (payload.getBusinessPartnerNo() != null) {
            update.set((Path)this.qdo.businessPartnerNo, (Object)payload.getBusinessPartnerNo());
        }
        if (payload.getPartnerType() != null) {
            update.set((Path)this.qdo.partnerType, (Object)payload.getPartnerType());
        }
        if (payload.getPartnerName() != null) {
            update.set((Path)this.qdo.partnerName, (Object)payload.getPartnerName());
            String pinyin = PinyinUtil.getPinyin((String)payload.getPartnerName(), (String)"");
            update.set((Path)this.qdo.partnerNamePinyin, (Object)pinyin);
        }
        if (payload.getPartnerIdentity() != null) {
            update.set((Path)this.qdo.partnerIdentity, (Object)payload.getPartnerIdentity());
        }
        if (payload.getPartnerIndustry() != null) {
            update.set((Path)this.qdo.partnerIndustry, (Object)payload.getPartnerIndustry());
        }
        if (payload.getPartnerNature() != null) {
            update.set((Path)this.qdo.partnerNature, (Object)payload.getPartnerNature());
        }
        if (payload.getOrganizationScale() != null) {
            update.set((Path)this.qdo.organizationScale, (Object)payload.getOrganizationScale());
        }
        if (payload.getCustomerFlag() != null) {
            update.set((Path)this.qdo.customerFlag, (Object)payload.getCustomerFlag());
        }
        if (payload.getPartnerWebsite() != null) {
            update.set((Path)this.qdo.partnerWebsite, (Object)payload.getPartnerWebsite());
        }
        if (payload.getPartnerEmail() != null) {
            update.set((Path)this.qdo.partnerEmail, (Object)payload.getPartnerEmail());
        }
        if (payload.getPartnerFax() != null) {
            update.set((Path)this.qdo.partnerFax, (Object)payload.getPartnerFax());
        }
        if (payload.getPartnerPhone() != null) {
            update.set((Path)this.qdo.partnerPhone, (Object)payload.getPartnerPhone());
        }
        if (payload.getPartnerRegion() != null) {
            update.set((Path)this.qdo.partnerRegion, (Object)payload.getPartnerRegion());
        }
        if (payload.getCurrency() != null) {
            update.set((Path)this.qdo.currency, (Object)payload.getCurrency());
        }
        if (payload.getLanguage() != null) {
            update.set((Path)this.qdo.language, (Object)payload.getLanguage());
        }
        if (payload.getPartnerSex() != null) {
            update.set((Path)this.qdo.partnerSex, (Object)payload.getPartnerSex());
        }
        if (payload.getPartnerBirthday() != null) {
            update.set((Path)this.qdo.partnerBirthday, (Object)payload.getPartnerBirthday());
        }
        if (payload.getSortNo() != null) {
            update.set(this.qdo.sortNo, (Object)payload.getSortNo());
        }
        if (payload.getExt1() != null) {
            update.set((Path)this.qdo.ext1, (Object)payload.getExt1());
        }
        if (payload.getExt2() != null) {
            update.set((Path)this.qdo.ext2, (Object)payload.getExt2());
        }
        if (payload.getExt3() != null) {
            update.set((Path)this.qdo.ext3, (Object)payload.getExt3());
        }
        if (payload.getExt4() != null) {
            update.set((Path)this.qdo.ext4, (Object)payload.getExt4());
        }
        if (payload.getExt5() != null) {
            update.set((Path)this.qdo.ext5, (Object)payload.getExt5());
        }
        if (payload.getParentId() != null) {
            update.set(this.qdo.parentId, (Object)payload.getParentId());
        }
        if (payload.getInsideOrOutSide() != null) {
            update.set((Path)this.qdo.insideOrOutSide, (Object)payload.getInsideOrOutSide());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApplyStatus())) {
            update.set((Path)this.qdo.applyStatus, (Object)payload.getApplyStatus());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("bookId")) {
                update.setNull(this.qdo.bookId);
            }
            if (nullFields.contains("businessPartnerNo")) {
                update.setNull((Path)this.qdo.businessPartnerNo);
            }
            if (nullFields.contains("partnerType")) {
                update.setNull((Path)this.qdo.partnerType);
            }
            if (nullFields.contains("partnerName")) {
                update.setNull((Path)this.qdo.partnerName);
                update.setNull((Path)this.qdo.partnerNamePinyin);
            }
            if (nullFields.contains("partnerIdentity")) {
                update.setNull((Path)this.qdo.partnerIdentity);
            }
            if (nullFields.contains("partnerIndustry")) {
                update.setNull((Path)this.qdo.partnerIndustry);
            }
            if (nullFields.contains("partnerNature")) {
                update.setNull((Path)this.qdo.partnerNature);
            }
            if (nullFields.contains("organizationScale")) {
                update.setNull((Path)this.qdo.organizationScale);
            }
            if (nullFields.contains("partnerWebsite")) {
                update.setNull((Path)this.qdo.partnerWebsite);
            }
            if (nullFields.contains("partnerEmail")) {
                update.setNull((Path)this.qdo.partnerEmail);
            }
            if (nullFields.contains("partnerFax")) {
                update.setNull((Path)this.qdo.partnerFax);
            }
            if (nullFields.contains("partnerPhone")) {
                update.setNull((Path)this.qdo.partnerPhone);
            }
            if (nullFields.contains("partnerRegion")) {
                update.setNull((Path)this.qdo.partnerRegion);
            }
            if (nullFields.contains("currency")) {
                update.setNull((Path)this.qdo.currency);
            }
            if (nullFields.contains("language")) {
                update.setNull((Path)this.qdo.language);
            }
            if (nullFields.contains("partnerSex")) {
                update.setNull((Path)this.qdo.partnerSex);
            }
            if (nullFields.contains("partnerBirthday")) {
                update.setNull((Path)this.qdo.partnerBirthday);
            }
            if (nullFields.contains("partnerWeChat")) {
                update.setNull((Path)this.qdo.partnerWeChat);
            }
            if (nullFields.contains("sortNo")) {
                update.setNull(this.qdo.sortNo);
            }
            if (nullFields.contains("ext1")) {
                update.setNull((Path)this.qdo.ext1);
            }
            if (nullFields.contains("ext2")) {
                update.setNull((Path)this.qdo.ext2);
            }
            if (nullFields.contains("ext3")) {
                update.setNull((Path)this.qdo.ext3);
            }
            if (nullFields.contains("ext4")) {
                update.setNull((Path)this.qdo.ext4);
            }
            if (nullFields.contains("ext5")) {
                update.setNull((Path)this.qdo.ext5);
            }
            if (nullFields.contains("parentId")) {
                update.setNull(this.qdo.parentId);
            }
            if (nullFields.contains("applyStatus")) {
                update.setNull((Path)this.qdo.applyStatus);
            }
            if (nullFields.contains("insideOrOutSide")) {
                update.setNull((Path)this.qdo.insideOrOutSide);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<BusinessPartnerVO> findByIds(List<Long> ids) {
        JPAQuery<BusinessPartnerVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(ids));
        jpaQuery.groupBy(this.qdo.id);
        List businessPartnerVOList = jpaQuery.fetch();
        return businessPartnerVOList;
    }

    public BusinessPartnerSimpleVO queryByPartnerName(String partnerName) {
        return (BusinessPartnerSimpleVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerSimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.customerFlag, this.qdo.partnerIdentity, this.qdo.partnerName, this.qdo.parentId})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.eq((Object)partnerName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetchFirst();
    }

    public List<BusinessPartnerDO> findByPartnerName(String partnerName) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.eq((Object)partnerName))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public List<BusinessPartnerVO> listForDm(List<String> partnerNameList) {
        List partnerDoList = ((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerName})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.partnerName.in(partnerNameList))).fetch();
        return partnerDoList;
    }

    public List<BusinessPartnerVO> queryCustPartnerListSimple() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.partnerName})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.customerFlag.eq(Boolean.valueOf(true)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.insideOrOutSide.eq((Object)BusinessInsideOrOutSideEnum.OUTSIDE.getCode()))).fetch();
    }

    public List<BusinessPartnerInfoVO> queryBusinessPartnerInfo(BusinessPartnerQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerInfoVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.createUserId, this.qdo.creator, this.qdo.createTime, this.qdo.bookId, this.qdo.businessPartnerNo, this.qdo.thirdSystemNo, this.qdo.partnerType, this.qdo.partnerName, this.qdo.partnerIdentity, this.qdo.parentId, this.qdo.partnerIndustry, this.qdo.partnerNature, this.qdo.organizationScale, this.qdo.partnerRegion, this.qdo.partnerWebsite, this.qdo.partnerEmail, this.qdo.partnerFax, this.qdo.partnerPhone, this.qdo.currency, this.qdo.language, this.qBookAddressDO.country, this.qBookAddressDO.province, this.qBookAddressDO.city, this.qBookAddressDO.district, this.qBookAddressDO.provinceName, this.qBookAddressDO.cityName, this.qBookAddressDO.districtName, this.qBookAddressDO.detailAddress, this.qBookContactsDO.contactsName, this.qBookContactsDO.contactsPhone, this.qdo.englishName, this.qdo.certificateType, this.qdo.certificateNo, this.qdo.partnerSex, this.qdo.partnerBirthday, this.qdo.nationality, this.qdo.nativePlace, this.qdo.nation, this.qdo.maritalStatus, this.qdo.certificateDateStart, this.qdo.certificateDateEnd, this.qdo.insideOrOutSide})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qBookContactsDO)).on((Predicate)this.qdo.bookId.eq(this.qBookContactsDO.bookId).and((Predicate)this.qBookContactsDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookContactsDO.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    public List<BusinessPartnerVO> queryByBookId(Long bookId) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.partnerIndustry, this.qdo.id, this.qdo.partnerIndustry, this.qdo.bookId, this.qdo.partnerName, this.qdo.idenNo, this.qdo.customerFlag, this.qdo.jdeCompanyNo, this.qdo.supplierFlag, this.qdo.applyStatus, this.qdo.collaborateFlag, this.qdo.insideOrOutSide})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.bookId.eq((Object)bookId))).fetch();
    }

    public BusinessPartnerVO findById(Long id) {
        return (BusinessPartnerVO)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.partnerName, this.qdo.customerFlag, this.qdo.supplierFlag, this.qdo.collaborateFlag, this.qdo.insideOrOutSide})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.id.eq((Object)id))).fetchFirst();
    }

    public BusinessPartnerVO queryCustomerByBookId(Long bookId) {
        return (BusinessPartnerVO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerIndustry, this.qdo.partnerRegion, this.qdo.businessPartnerNo, this.qdo.bookId, this.qdo.partnerName, this.qdo.customerFlag, this.qBusinessCustomerInfoDO.syncJdeFlag, this.qBusinessCustomerInfoDO.customerGradle, this.qBusinessCustomerInfoDO.customerNo, this.qBusinessCustomerInfoDO.customerStatus, this.qBusinessCustomerInfoDO.id.as("businessCustomerInfoId")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCustomerInfoDO.partnerId))).where((Predicate)this.qBusinessCustomerInfoDO.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.bookId.eq((Object)bookId))).fetchFirst();
    }

    public BusinessPartnerVO querySupplierByBookId(Long bookId) {
        return (BusinessPartnerVO)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerIndustry, this.qdo.partnerRegion, this.qdo.businessPartnerNo, this.qdo.bookId, this.qdo.partnerName, this.qdo.supplierFlag, this.qBusinessSupplierInfoDO.syncJdeFlag, this.qBusinessSupplierInfoDO.supplierNo, this.qBusinessSupplierInfoDO.id.as("businessSupplierInfoId")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessSupplierInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessSupplierInfoDO.partnerId))).where((Predicate)this.qBusinessSupplierInfoDO.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.bookId.eq((Object)bookId))).fetchFirst();
    }

    public long updateWorkFlow(BusinessPartnerPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (!ObjectUtils.isEmpty((Object)payload.getProcInstId())) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getApplyStatus())) {
            update.set((Path)this.qdo.applyStatus, (Object)payload.getApplyStatus());
        }
        if (!ObjectUtils.isEmpty((Object)payload.getDeleteFlag())) {
            update.set(this.qdo.deleteFlag, (Object)payload.getDeleteFlag());
        }
        if ((nullFields = payload.getNullFields()) != null) {
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("applyStatus")) {
                update.setNull((Path)this.qdo.applyStatus);
            }
        }
        return update.execute();
    }

    public PagingVO<BusinessConfirmedCustomerVO> queryConfirmedCustomer(BusinessPartnerQuery query) {
        Long total = this.countConfirmedCustomer();
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessConfirmedCustomerVO.class, (Expression[])new Expression[]{this.qdo.id.as("partnerId"), this.qdo.bookId, this.qBusinessCustomerInfoDO.id, this.qdo.businessPartnerNo, this.qdo.partnerName, this.qBusinessCustomerInfoDO.customerGradle, this.qBusinessCustomerInfoDO.customerStatus, this.qdo.partnerIndustry, this.qBusinessCustomerInfoDO.customerSource, this.qdo.partnerEmail, this.qdo.partnerPhone, this.qdo.partnerFax, this.qBookAddressDO.province, this.qBookAddressDO.city, this.qBookAddressDO.district, this.qBookAddressDO.provinceName, this.qBookAddressDO.cityName, this.qBookAddressDO.districtName})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessCustomerInfoDO.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessCustomerInfoDO.customerStage.eq((Object)BusinessPartnerStageEnum.POTENTIAL.getCode()))).where((Predicate)this.qBusinessCustomerInfoDO.confirmFlag.eq(Boolean.valueOf(false)));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total.longValue()).build();
    }

    public Long countConfirmedCustomer() {
        Long count = (Long)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.id.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCustomerInfoDO.partnerId))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessCustomerInfoDO.deleteFlag.eq((Object)0))).where((Predicate)this.qBusinessCustomerInfoDO.customerStage.eq((Object)BusinessPartnerStageEnum.POTENTIAL.getCode()))).where((Predicate)this.qBusinessCustomerInfoDO.confirmFlag.eq(Boolean.valueOf(false)))).fetchOne();
        if (count == null) {
            return 0L;
        }
        return count;
    }

    public void updateConfirmedCustomer(List<Long> keys) {
        this.jpaQueryFactory.update((EntityPath)this.qBusinessCustomerInfoDO).set((Path)this.qBusinessCustomerInfoDO.confirmFlag, (Object)true).where(new Predicate[]{this.qBusinessCustomerInfoDO.partnerId.in(keys)}).execute();
    }

    public List<BusinessPartnerSimpleVO> queryNearCustomerList() {
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerSimpleVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.partnerName})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.customerFlag.eq(Boolean.valueOf(true)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public List<BusinessPartnerMainSyncVO> queryBusinessPartSync(String businessPartnerNo) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerMainSyncVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId.as("bookId"), this.qdo.id, this.qdo.bookIdV4.as("bookIdV4"), this.qdo.businessPartnerNo.as("bookNo"), this.qdo.partnerName.as("customerName"), this.qBusinessCustomerInfoDO.customerGradle.as("customerGrade"), this.qBusinessCustomerInfoDO.customerStatus.as("customerStatus"), this.qdo.partnerIndustry.as("companyIndustry"), this.qBusinessCustomerInfoDO.customerSource.as("customerSource"), this.qdo.partnerEmail.as("companyEmail"), this.qdo.partnerPhone.as("companyPhone"), this.qdo.partnerFax.as("companyFax"), this.qBookAddressDO.province.as("province"), this.qBookAddressDO.city.as("city"), this.qBookAddressDO.district.as("district"), this.qBookAddressDO.provinceName.as("provinceName"), this.qBookAddressDO.cityName.as("cityName"), this.qBookAddressDO.districtName.as("districtName"), this.qBookAddressDO.detailAddress.as("companyAddress"), this.qdo.partnerNature.as("companyNature"), this.qdo.organizationScale.as("companyScale"), this.qdo.partnerWebsite.as("companyWebsite"), this.qdo.currency.as("currency"), this.qdo.language.as("language"), this.qdo.partnerType.as("abType"), this.qdo.partnerIdentity.as("relateType"), this.qdo.insideOrOutSide.as("innerType")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qBusinessCustomerInfoDO)).on((Predicate)this.qdo.id.eq(this.qBusinessCustomerInfoDO.partnerId).and((Predicate)this.qBusinessCustomerInfoDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qBookAddressDO)).on((Predicate)this.qdo.bookId.eq(this.qBookAddressDO.bookId).and((Predicate)this.qBookAddressDO.isDefault.eq(Boolean.valueOf(true))).and((Predicate)this.qBookAddressDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.insideOrOutSide.eq((Object)BusinessInsideOrOutSideEnum.OUTSIDE.getCode()))).where((Predicate)this.qdo.syncTime.lt(this.qdo.modifyTime).or((Predicate)this.qdo.syncTime.isNull()));
        if (StringUtils.hasText((String)businessPartnerNo)) {
            jpaQuery.where((Predicate)this.qdo.businessPartnerNo.eq((Object)businessPartnerNo));
        }
        return jpaQuery.fetch();
    }

    public void updateSyncTimeAndBookIdV4(Long id, Long bookIdV4, LocalDateTime sybcTime) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.syncTime, (Object)sybcTime).set(this.qdo.bookIdV4, (Object)bookIdV4).where(new Predicate[]{this.qdo.id.eq((Object)id)}).execute();
    }

    public void updateBusinessParnerModifyTime(List<Long> bookIdList) {
        this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.modifyTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qdo.bookId.in(bookIdList)}).execute();
    }

    public List<Tuple> findNameByBookIds(List<Long> bookIdList) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qdo.bookId, this.qdo.partnerName}).from((EntityPath)this.qdo)).where((Predicate)this.qdo.bookId.in(bookIdList))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public List<BusinessPartnerVO> queryByBookIdsAndType(List<Long> bookIds, String insideOrOutside) {
        return ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(BusinessPartnerVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.bookId, this.qdo.partnerName, this.qdo.jdeCompanyNo, this.qdo.customerFlag, this.qdo.insideOrOutSide})).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).where((Predicate)this.qdo.bookId.in(bookIds))).where((Predicate)this.qdo.insideOrOutSide.eq((Object)insideOrOutside))).fetch();
    }

    public BusinessPartnerDAO(JPAQueryFactory jpaQueryFactory, BusinessPartnerRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

