/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pay.service;

import com.elitesland.tw.tw5.api.prd.pay.service.BKGetVerificationCodeService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdMessageConfigService;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.api.prd.system.vo.PrdMessageConfigVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.util.RedisUtils;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class BKGetVerificationCodeServiceImpl
implements BKGetVerificationCodeService {
    private static final Logger log = LoggerFactory.getLogger(BKGetVerificationCodeServiceImpl.class);
    private static final String key = "TWBANK_VERIFICATION:";
    @Autowired
    private RedisUtils redisUtils;
    private final CacheUtil cacheUtil;
    private final PrdMessageConfigService messageConfigService;
    private final PrdSystemRoleService roleService;

    public void getVerificationCode() {
        Long loginUserId = GlobalUtil.getLoginUserId();
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.PLAT_ALL_PIC.getCode(), RoleEnum.PLAT_FIN_CASHIER.getCode(), RoleEnum.PLAT_BUSINESS_PIC.getCode()));
        if (!rolePermission.booleanValue()) {
            throw TwException.error("", "\u60a8\u6ca1\u6709\u6743\u9650\u67e5\u770b\u6b64\u9875\u9762");
        }
        String sixDigitCode = BKGetVerificationCodeServiceImpl.generateSixDigitCode();
        this.redisUtils.set(key + loginUserId, sixDigitCode, 3L, TimeUnit.MINUTES);
        try {
            String noticeSource = loginUserId.toString();
            if (this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode())).booleanValue()) {
                List finUserId = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_FIN_CASHIER.getCode());
                if (CollectionUtils.isEmpty((Collection)finUserId)) {
                    throw TwException.error("", "\u5e73\u53f0\u8d22\u52a1\u51fa\u7eb3\u4e0d\u5b58\u5728");
                }
                noticeSource = ((Long)finUserId.get(0)).toString();
            }
            HashMap<String, String> data = new HashMap<String, String>();
            data.put("sixDigitCode", sixDigitCode);
            PrdMessageConfigVO configVO = this.messageConfigService.queryByMessageCode("MC20240510000001");
            this.messageConfigService.sendMessageConfig(configVO, data, "appoint_people", noticeSource);
            log.info("\u90ae\u4ef6\u53d1\u9001\u6210\u529f");
        }
        catch (Exception e) {
            log.info("\u90ae\u4ef6\u53d1\u9001\u51fa\u73b0\u5f02\u5e38");
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public void confirmVerificationCode(String verificationCode) {
        if (!StringUtils.hasText((String)verificationCode)) {
            throw TwException.error("", "\u9a8c\u8bc1\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Long loginUserId = GlobalUtil.getLoginUserId();
        if (!this.redisUtils.hasKey(key + loginUserId)) {
            throw TwException.error("", "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        if (this.redisUtils.get(key + loginUserId) == null) {
            throw TwException.error("", "\u9a8c\u8bc1\u7801\u5df2\u8fc7\u671f");
        }
        if (!verificationCode.equals(this.redisUtils.get(key + loginUserId).toString())) {
            throw TwException.error("", "\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
    }

    private static String generateSixDigitCode() {
        Random random = new Random();
        StringBuilder codeBuilder = new StringBuilder();
        for (int i = 0; i < 6; ++i) {
            codeBuilder.append(random.nextInt(10));
        }
        return codeBuilder.toString();
    }

    public BKGetVerificationCodeServiceImpl(CacheUtil cacheUtil, PrdMessageConfigService messageConfigService, PrdSystemRoleService roleService) {
        this.cacheUtil = cacheUtil;
        this.messageConfigService = messageConfigService;
        this.roleService = roleService;
    }
}

