/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.controller;

import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityProcessVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.seata.spring.annotation.GlobalTransactional;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@Api(tags={"\u9879\u76ee\u6d3b\u52a8"})
@RestController
@RequestMapping(value={"/api/pms/pmsProjectActivity"})
public class PmsProjectActivityController {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectActivityController.class);
    private final PmsProjectActivityService pmsProjectActivityService;

    @PostMapping
    @ApiOperation(value="\u9879\u76ee\u6d3b\u52a8-\u65b0\u589e")
    public TwOutputUtil<PmsProjectActivityVO> insert(@RequestBody PmsProjectActivityPayload payload) {
        return TwOutputUtil.ok(this.pmsProjectActivityService.insert(payload));
    }

    @PutMapping
    @ApiOperation(value="\u9879\u76ee\u6d3b\u52a8-\u66f4\u65b0")
    public TwOutputUtil<PmsProjectActivityVO> update(@RequestBody PmsProjectActivityPayload payload) {
        this.pmsProjectActivityService.updateByKeyDynamic(payload);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/list"})
    @ApiOperation(value="\u9879\u76ee\u6d3b\u52a8-\u67e5\u8be2\u5217\u8868")
    public TwOutputUtil<List<PmsProjectActivityVO>> queryList(PmsProjectActivityQuery query) {
        return TwOutputUtil.ok(this.pmsProjectActivityService.queryListDynamic(query));
    }

    @GetMapping(value={"/listForTimesheet"})
    @ApiOperation(value="\u6839\u636e\u9879\u76ee\u62c9\u53d6\u6240\u6709\u9636\u6bb5")
    public TwOutputUtil<List<PmsProjectActivityVO>> listForTimesheet(PmsProjectActivityQuery query) {
        return TwOutputUtil.ok(this.pmsProjectActivityService.listForTimesheet(query));
    }

    @DeleteMapping(value={"/deleteSoft"})
    @ApiOperation(value="\u9879\u76ee\u6d3b\u52a8-\u5220\u9664")
    public TwOutputUtil deleteSoft(Long[] keys) {
        this.pmsProjectActivityService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/submit"})
    @ApiOperation(value="\u9879\u76ee\u6d3b\u52a8\u63d0\u4ea4")
    @GlobalTransactional
    public TwOutputUtil submit(Long projId) {
        this.pmsProjectActivityService.submit(projId);
        return TwOutputUtil.ok();
    }

    @GetMapping(value={"/getActivityStatus"})
    @ApiOperation(value="\u83b7\u53d6\u6d3b\u52a8\u72b6\u6001")
    public TwOutputUtil getActivityStatus(Long projId) {
        return TwOutputUtil.ok(this.pmsProjectActivityService.getActivityStatus(projId));
    }

    @GetMapping(value={"/byActivityProcessID"})
    @UdcNameClass
    @ApiOperation(value="\u9879\u76ee\u6d3b\u52a8\u6d41\u7a0b\u5f85\u529e\u8be6\u60c5-\u4e3b\u952e\u67e5\u8be2")
    public TwOutputUtil<PmsProjectActivityProcessVO> byActivityProcessID(Long activityProcessID) {
        return TwOutputUtil.ok(this.pmsProjectActivityService.byActivityProcessID(activityProcessID));
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ba1\u7406 \u6587\u4ef6\u5bfc\u5165")
    @PostMapping(value={"/importFile"}, consumes={"multipart/form-data"})
    public TwOutputUtil importFile(MultipartFile file, Long projId) {
        this.pmsProjectActivityService.importFile(file, projId);
        return TwOutputUtil.ok();
    }

    @ApiOperation(value="\u6d3b\u52a8\u7ba1\u7406\u6a21\u677f\u5bfc\u51fa")
    @GetMapping(value={"/downloadFile"})
    public void downloadFile(HttpServletResponse response) {
        this.pmsProjectActivityService.downloadFile(response);
    }

    @PostMapping(value={"/batchUpdateSortNo"})
    @ApiOperation(value="\u6d3b\u52a8\u5e8f\u53f7\u6279\u91cf\u66f4\u65b0")
    public TwOutputUtil<PmsProjectActivityVO> batchUpdateSortNo(@RequestBody List<PmsProjectActivityPayload> payloads) {
        this.pmsProjectActivityService.batchUpdateSortNo(payloads);
        return TwOutputUtil.ok();
    }

    public PmsProjectActivityController(PmsProjectActivityService pmsProjectActivityService) {
        this.pmsProjectActivityService = pmsProjectActivityService;
    }
}

