/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeCompositeAbilityQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.service.PrdEmployeCompositeAbilityService;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdCompositeAbilityVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributePayload;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsDistributeRespondPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistBroadcastQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeQuery;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsDistributeRespondQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistBroadcastService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeCommonService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeRespondService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsDistributeService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeRespondVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsDistributeVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.DistributeEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.RespondEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsDistributeConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsDistributeRespondDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsDistributeDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsDistributeRepo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.google.common.collect.Lists;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class PmsDistributeServiceImpl
extends BaseServiceImpl
implements PmsDistributeService {
    private static final Logger log = LoggerFactory.getLogger(PmsDistributeServiceImpl.class);
    private final PmsDistributeRepo pmsDistributeRepo;
    private final PmsDistributeDAO pmsDistributeDAO;
    private final PrdCompositeAbilityService prdCompositeAbilityService;
    private final PmsDistBroadcastService distBroadcastService;
    private final WorkflowUtil workflowUtil;
    private final CacheUtil cacheUtil;
    private final PmsDistributeRespondDAO pmsDistributeRespondDAO;
    private final PmsDistributeRespondService distributeRespondService;
    private final TransactionUtilService transactionUtilService;
    private final PmsDistributeCommonService distributeCommonService;
    private final PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService;

    @Transactional(rollbackFor={Exception.class})
    public void insertOrUpdate(PmsDistributePayload payload) {
        this.checkData(payload);
        PmsDistributeVO distributeVO = this.pmsDistributeDAO.queryByReason(payload.getReasonId(), payload.getReasonType());
        if (!ObjectUtils.isEmpty((Object)distributeVO)) {
            if (!distributeVO.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                throw TwException.error("", "\u6d41\u7a0b\u4e2d\u6d3e\u53d1\u4e0d\u53ef\u518d\u6b21\u53d1\u8d77");
            }
            payload.setId(distributeVO.getId());
            payload.setProcInstId(distributeVO.getProcInstId());
            payload.setApprStatus(distributeVO.getApprStatus());
        } else {
            payload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
            payload.setDistNo(this.generateSeqNum("PMS_DISTRIBUTE", new String[0]));
        }
        PmsDistributeDO entityDo = PmsDistributeConvert.INSTANCE.toDo(payload);
        entityDo = (PmsDistributeDO)this.pmsDistributeRepo.save(entityDo);
        Long disId = entityDo.getId();
        Long disterResId = entityDo.getCreateUserId();
        if (DistributeEnum.distMethod.BROADCASTING.getCode().equals(payload.getDistMethod())) {
            PmsDistBroadcastQuery query = new PmsDistBroadcastQuery();
            query.setDistId(disId);
            List broadcastVOS = this.distBroadcastService.queryListDynamic(query);
            if (ObjectUtils.isEmpty((Object)broadcastVOS)) {
                broadcastPayload = payload.getBroadcastPayload();
                broadcastPayload.setDistId(disId);
                this.distBroadcastService.insert(broadcastPayload);
            } else {
                broadcastPayload = payload.getBroadcastPayload();
                this.distBroadcastService.update(broadcastPayload);
            }
            List respondPayloads = payload.getRespondPayloads();
            respondPayloads.forEach(v -> {
                v.setDistId(disId);
                v.setReasonName(payload.getReasonName());
                v.setDisterResId(disterResId);
            });
            this.distributeRespondService.batchSave(respondPayloads, disId);
            PmsDistributePayload payload0 = new PmsDistributePayload();
            payload0.setId(disId);
            payload0.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
            this.pmsDistributeDAO.updateWorkFlow(payload0);
        } else {
            distributeVO = PmsDistributeConvert.INSTANCE.toVo(entityDo);
            Boolean samePeople = payload.getReceiverResId().equals(distributeVO.getReceiverResId());
            distributeVO.setSamePeople(samePeople);
            this.procStart(distributeVO);
        }
    }

    public PagingVO<PmsDistributeVO> queryPaging(PmsDistributeQuery query) {
        this.operPermissionFlag(query);
        PagingVO<PmsDistributeVO> pagingVO = this.pmsDistributeDAO.queryPaging(query);
        if (pagingVO.getRecords().size() > 0) {
            List list = pagingVO.getRecords();
            if (!ObjectUtils.isEmpty((Object)list)) {
                this.setCapasetLevelDesc(list);
                pagingVO.setRecords(list);
            }
            if (query.getMyDistFlag().booleanValue()) {
                ArrayList distIds = new ArrayList();
                pagingVO.getRecords().forEach(vo -> distIds.add(vo.getId()));
                PmsDistributeRespondQuery respondQuery = new PmsDistributeRespondQuery();
                respondQuery.setDistIds(distIds);
                List<PmsDistributeRespondVO> respondVOS = this.pmsDistributeRespondDAO.queryListDynamic(respondQuery);
                Map<Long, Long> groupCounts = respondVOS.stream().collect(Collectors.groupingBy(PmsDistributeRespondVO::getDistId, Collectors.counting()));
                pagingVO.getRecords().forEach(vo -> vo.setRepsePerson((Long)groupCounts.get(vo.getId())));
            }
        }
        return pagingVO;
    }

    void operPermissionFlag(PmsDistributeQuery query) {
        Long loginUserId = GlobalUtil.getLoginUserId();
        query.setLoginUserId(loginUserId);
        Boolean rolePermission = this.cacheUtil.hasSystemRolePermission(Arrays.asList(RoleEnum.SYS.getCode(), RoleEnum.OPS.getCode()));
        query.setPermissionFlag(Boolean.valueOf(rolePermission == false));
    }

    public PagingVO<PmsDistributeVO> iReceivedRespond(PmsDistributeQuery query) {
        query.setDisterResId(GlobalUtil.getLoginUserId());
        query.setDistInnerJoinRespondFlag(Boolean.valueOf(true));
        query.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
        return this.joinRespond(query);
    }

    public PagingVO<PmsDistributeVO> iReceivedInvitation(PmsDistributeQuery query) {
        List list;
        query.setRespondentResId(GlobalUtil.getLoginUserId());
        query.setInviteFlag(Integer.valueOf(1));
        query.setRespondInnerJoinDistFlag(Boolean.valueOf(true));
        query.setRespStatus(RespondEnum.NO_RESPONDING.getCode());
        PagingVO<PmsDistributeVO> pagingVO = this.joinRespond(query);
        if (!ObjectUtils.isEmpty(pagingVO) && !ObjectUtils.isEmpty((Object)(list = pagingVO.getRecords()))) {
            this.setCapasetLevelDesc(list);
            pagingVO.setRecords(list);
        }
        return pagingVO;
    }

    public PagingVO<PmsDistributeVO> broadcastTaskKanban(PmsDistributeQuery query) {
        List list;
        query.setRespondentResId(GlobalUtil.getLoginUserId());
        query.setBroadcastJoinDistFlag(Boolean.valueOf(true));
        query.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
        List dos = this.distBroadcastService.findListByRespondentResId(query.getRespondentResId());
        List notInIds = dos.stream().map(v -> v.getId()).collect(Collectors.toList());
        query.setNotInIds(notInIds);
        PagingVO<PmsDistributeVO> pagingVO = this.joinRespond(query);
        if (!ObjectUtils.isEmpty(pagingVO) && !ObjectUtils.isEmpty((Object)(list = pagingVO.getRecords()))) {
            this.setCapasetLevelDesc(list);
            pagingVO.setRecords(list);
        }
        return pagingVO;
    }

    void setCapasetLevelDesc(List<PmsDistributeVO> list) {
        ArrayList distIds = new ArrayList();
        ArrayList capasetLevelIds = new ArrayList();
        list.forEach(vo -> {
            distIds.add(vo.getId());
            if (!ObjectUtils.isEmpty((Object)vo.getCapasetLevelId())) {
                capasetLevelIds.add(vo.getCapasetLevelId());
            }
        });
        if (!ObjectUtils.isEmpty(capasetLevelIds)) {
            PrdCompositeAbilityQuery prdCompositeAbilityQuery = new PrdCompositeAbilityQuery();
            prdCompositeAbilityQuery.setIds(capasetLevelIds);
            List levelVOS = this.prdCompositeAbilityService.getList(prdCompositeAbilityQuery);
            Map info = levelVOS.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
            list.forEach(v -> {
                PrdCompositeAbilityVO levelVO;
                Long capasetLevelId = v.getCapasetLevelId();
                if (!ObjectUtils.isEmpty((Object)capasetLevelId) && !ObjectUtils.isEmpty((Object)(levelVO = (PrdCompositeAbilityVO)info.get(capasetLevelId)))) {
                    v.setEqvaRatio(levelVO.getDlRatio());
                    v.setCapasetLevelDesc(levelVO.getName());
                }
            });
        }
    }

    public PagingVO<PmsDistributeVO> irespondedBroadcast(PmsDistributeQuery query) {
        query.setRespondentResId(GlobalUtil.getLoginUserId());
        query.setDistInnerJoinRespondFlag(Boolean.valueOf(true));
        query.setDistStatus(DistributeEnum.distStatus.BROADCASTING.getCode());
        return this.joinRespond(query);
    }

    private PagingVO<PmsDistributeVO> joinRespond(PmsDistributeQuery query) {
        List<PmsDistributeVO> list = this.pmsDistributeDAO.queryListDynamic(query);
        long total = list.size();
        List result = list.stream().skip(query.getPageRequest().getOffset()).limit(query.getPageRequest().getPageSize()).collect(Collectors.toList());
        return PagingVO.builder().records(result).total(total).build();
    }

    public List<PmsDistributeVO> queryListDynamic(PmsDistributeQuery query) {
        return this.pmsDistributeDAO.queryListDynamic(query);
    }

    public PmsDistributeVO queryByKey(Long key) {
        PmsDistributeDO entity = this.pmsDistributeRepo.findById(key).orElseGet(PmsDistributeDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsDistributeVO vo = PmsDistributeConvert.INSTANCE.toVo(entity);
        PrdEmployeCompositeAbilityQuery compositeAbilityQuery = new PrdEmployeCompositeAbilityQuery();
        compositeAbilityQuery.setUserId(vo.getReceiverResId());
        List compositeAbilityVOS = this.prdEmployeCompositeAbilityService.getList(compositeAbilityQuery);
        if (!ObjectUtils.isEmpty((Object)compositeAbilityVOS)) {
            vo.setCompositeAbilityVOS(compositeAbilityVOS);
        }
        if (DistributeEnum.distMethod.BROADCASTING.getCode().equals(vo.getDistMethod())) {
            PmsDistributeRespondQuery query = new PmsDistributeRespondQuery();
            query.setDistId(key);
            List respondList = this.distributeRespondService.queryListDynamic(query);
            vo.setRespondList(respondList);
        }
        return vo;
    }

    public PmsDistributeVO queryByReason(Long reasonId, String reasonType) {
        return this.pmsDistributeDAO.queryByReason(reasonId, reasonType);
    }

    public List<PmsDistributeVO> queryByReasons(List<Long> reasonIds, String reasonType) {
        return this.pmsDistributeDAO.queryByReasons(reasonIds, reasonType);
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        List<PmsDistributeVO> pmsDistributeVOS;
        if (!keys.isEmpty() && !ObjectUtils.isEmpty(pmsDistributeVOS = this.pmsDistributeDAO.queryByKeys(keys))) {
            pmsDistributeVOS.forEach(vo -> {
                if (!vo.getDistStatus().equals(DistributeEnum.distStatus.CREATE.getCode())) {
                    throw TwException.error("", "\u4ec5\u652f\u6301\u65b0\u5efa\u72b6\u6001\u7684\u5220\u9664");
                }
                try {
                    if (StringUtils.hasText((String)vo.getProcInstId())) {
                        this.workflowUtil.deleteProcess(DeleteProcessPayload.of((String)vo.getProcInstId(), (String)"\u6536\u5230\u5220\u9664\u6d3e\u53d1\u6570\u636e"));
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            });
            this.distributeCommonService.deleteSoftByList(pmsDistributeVOS);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsDistributePayload distributePayload = new PmsDistributePayload();
        distributePayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        distributePayload.setDistStatus(DistributeEnum.distStatus.DISTRIBUTING.getCode());
        PmsDistributeVO distributeVO = this.pmsDistributeDAO.queryByKey(Long.valueOf(businessKey));
        if (distributeVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    distributePayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    distributePayload.setProcInstId(null);
                    distributePayload.setProcInstStatus(null);
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    break;
                }
                case INVALID: {
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    distributePayload.setDeleteFlag(Integer.valueOf(1));
                    distributePayload.setProcInstStatus(ProcInstStatus.INVALID);
                    distributeVO.setDeleteFlag(Integer.valueOf(1));
                    break;
                }
                case REJECTED: {
                    distributePayload.setDistStatus(DistributeEnum.distStatus.CREATE.getCode());
                    distributePayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    distributePayload.setDistStatus(DistributeEnum.distStatus.DISTRIBUTED.getCode());
                    distributePayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    distributePayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
            }
            this.pmsDistributeDAO.updateWorkFlow(distributePayload);
            distributeVO.setDistStatus(distributePayload.getDistStatus());
            this.distributeCommonService.updateReasonStatus(distributeVO);
        }
    }

    private void procStart(PmsDistributeVO distributeVO) {
        ProcInstStatus procInstStatus = distributeVO.getProcInstStatus();
        String procInstId = distributeVO.getProcInstId();
        String distStatus2 = DistributeEnum.distStatus.DISTRIBUTING.getCode();
        String apprStatus = distributeVO.getApprStatus();
        this.distributeCommonService.checkDistribute(distributeVO);
        if (procInstId == null) {
            batchMap = new HashMap<String, ArrayList>();
            batchMap.put("Activity_1sfw1m6", Lists.newArrayList((Object[])new Long[]{distributeVO.getReceiverResId()}));
            String disterResName = this.cacheUtil.getUserName(distributeVO.getDisterResId());
            String receiverResName = this.cacheUtil.getUserName(distributeVO.getReceiverResId());
            String procInstName = "P01." + distributeVO.getReasonName() + "-\u6d3e\u53d1(" + disterResName + "-" + receiverResName + ")";
            ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_DISTRIBUTE.name(), (String)procInstName, (String)("" + distributeVO.getId()), batchMap), new Long[0]);
            procInstId = processInfo.getProcInstId();
            procInstStatus = processInfo.getProcInstStatus();
            apprStatus = procInstStatus.name();
            if (procInstStatus.name().equals(ProcInstStatus.APPROVED.name())) {
                procInstId = null;
                distStatus2 = DistributeEnum.distStatus.DISTRIBUTED.getCode();
            }
        } else if (!distributeVO.getSamePeople().booleanValue()) {
            batchMap = new HashMap();
            batchMap.put("Activity_1sfw1m6", Lists.newArrayList((Object[])new Long[]{distributeVO.getReceiverResId()}));
            this.workflowUtil.setVariables(SetVariablesPayload.of((String)procInstId, batchMap));
        }
        PmsDistributePayload payload0 = new PmsDistributePayload();
        payload0.setId(distributeVO.getId());
        payload0.setProcInstId(procInstId);
        payload0.setProcInstStatus(procInstStatus);
        payload0.setApprStatus(apprStatus);
        payload0.setDistStatus(distStatus2);
        payload0.setNullFields(List.of("procInstId"));
        distributeVO.setDistStatus(distStatus2);
        this.transactionUtilService.executeWithRunnable(() -> {
            this.pmsDistributeDAO.updateWorkFlow(payload0);
            this.distributeCommonService.updateReasonStatus(distributeVO);
        });
    }

    private void checkData(PmsDistributePayload payload) {
        if (ObjectUtils.isEmpty((Object)payload.getReasonType())) {
            throw TwException.error("", "\u6d3e\u53d1\u7c7b\u578b \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getReasonId())) {
            throw TwException.error("", "\u6d3e\u53d1\u4e8b\u7531ID \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getReasonName())) {
            throw TwException.error("", "\u6d3e\u53d1\u4e8b\u7531 \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDistMethod())) {
            throw TwException.error("", "\u6d3e\u53d1\u65b9\u5f0f \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDisterResId())) {
            throw TwException.error("", "\u6d3e\u53d1\u8d44\u6e90ID \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (ObjectUtils.isEmpty((Object)payload.getDisterResName())) {
            throw TwException.error("", "\u6d3e\u53d1\u8d44\u6e90\u540d\u79f0 \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
        }
        if (DistributeEnum.distMethod.DESIGNATE.getCode().equals(payload.getDistMethod())) {
            if (ObjectUtils.isEmpty((Object)payload.getReceiverResId())) {
                throw TwException.error("", "\u63a5\u6536\u8d44\u6e90ID \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)payload.getReceiverResName())) {
                throw TwException.error("", "\u63a5\u6536\u8d44\u6e90\u540d\u79f0 \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        } else {
            if (ObjectUtils.isEmpty((Object)payload.getWorkStyle())) {
                throw TwException.error("", "\u73b0\u573a|\u8fdc\u7a0b \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)payload.getTimeRequirement())) {
                throw TwException.error("", "\u65f6\u95f4\u8981\u6c42 \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            if (ObjectUtils.isEmpty((Object)payload.getMinSecurityLevel())) {
                throw TwException.error("", "\u6700\u4f4e\u4fe1\u7528\u7ea7\u522b \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
            List respondPayloads = payload.getRespondPayloads();
            for (PmsDistributeRespondPayload respondPayload : respondPayloads) {
                if (!ObjectUtils.isEmpty((Object)respondPayload.getRespondentResId())) continue;
                throw TwException.error("", "\u54cd\u5e94\u8d44\u6e90 \u4e0d\u53ef\u4e3a\u7a7a\uff0c\u8bf7\u6838\u9a8c\uff01");
            }
        }
    }

    public PmsDistributeServiceImpl(PmsDistributeRepo pmsDistributeRepo, PmsDistributeDAO pmsDistributeDAO, PrdCompositeAbilityService prdCompositeAbilityService, PmsDistBroadcastService distBroadcastService, WorkflowUtil workflowUtil, CacheUtil cacheUtil, PmsDistributeRespondDAO pmsDistributeRespondDAO, PmsDistributeRespondService distributeRespondService, TransactionUtilService transactionUtilService, PmsDistributeCommonService distributeCommonService, PrdEmployeCompositeAbilityService prdEmployeCompositeAbilityService) {
        this.pmsDistributeRepo = pmsDistributeRepo;
        this.pmsDistributeDAO = pmsDistributeDAO;
        this.prdCompositeAbilityService = prdCompositeAbilityService;
        this.distBroadcastService = distBroadcastService;
        this.workflowUtil = workflowUtil;
        this.cacheUtil = cacheUtil;
        this.pmsDistributeRespondDAO = pmsDistributeRespondDAO;
        this.distributeRespondService = distributeRespondService;
        this.transactionUtilService = transactionUtilService;
        this.distributeCommonService = distributeCommonService;
        this.prdEmployeCompositeAbilityService = prdEmployeCompositeAbilityService;
    }
}

