/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.pms.service;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSON;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.pms.payload.PmsProjectActivityPayload;
import com.elitesland.tw.tw5.api.prd.pms.query.PmsProjectActivityQuery;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectActivityService;
import com.elitesland.tw.tw5.api.prd.pms.service.PmsProjectTemplateActService;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityProcessVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectActivityVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectTemplateActVO;
import com.elitesland.tw.tw5.api.prd.pms.vo.PmsProjectVO;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConReceivablePlanService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConReceivablePlanVO;
import com.elitesland.tw.tw5.api.prd.system.service.PrdSystemRoleService;
import com.elitesland.tw.tw5.server.common.ExcelUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.RoleEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.PmsProcDefKey;
import com.elitesland.tw.tw5.server.prd.pms.common.functionEnum.ProjActivityAllocateStateEnum;
import com.elitesland.tw.tw5.server.prd.pms.convert.PmsProjectActivityConvert;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActivityDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectActivityProcessDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectActivityDO;
import com.elitesland.tw.tw5.server.prd.pms.entity.PmsProjectActivityProcessDO;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityProcessRepo;
import com.elitesland.tw.tw5.server.prd.pms.repo.PmsProjectActivityRepo;
import com.elitesland.workflow.CommentInfo;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.enums.ActionType;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.io.InputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ClassPathResource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class PmsProjectActivityServiceImpl
extends BaseServiceImpl
implements PmsProjectActivityService {
    private static final Logger log = LoggerFactory.getLogger(PmsProjectActivityServiceImpl.class);
    private final PmsProjectActivityRepo pmsProjectActivityRepo;
    private final PmsProjectActivityDAO pmsProjectActivityDAO;
    private final ConReceivablePlanService conReceivablePlanService;
    private final PmsProjectActivityProcessDAO pmsProjectActivityProcessDAO;
    private final PmsProjectDAO pmsProjectDAO;
    private final WorkflowUtil workflowUtil;
    private final PmsProjectActivityProcessRepo pmsProjectActivityProcessRepo;
    private final PrdSystemRoleService roleService;
    private final PmsProjectTemplateActService pmsProjectTemplateActService;
    private final CacheUtil cacheUtil;
    private static String sheetName = "\u6d3b\u52a8\u7ba1\u7406\u5bfc\u5165\u6a21\u677f";

    public PagingVO<PmsProjectActivityVO> queryPaging(PmsProjectActivityQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getProjId())) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        return this.pmsProjectActivityDAO.queryPaging(query);
    }

    public long countListDynamic(PmsProjectActivityQuery query) {
        return this.pmsProjectActivityDAO.count(query);
    }

    public List<PmsProjectActivityVO> queryListDynamic(PmsProjectActivityQuery query) {
        Long projId = query.getProjId();
        if (ObjectUtils.isEmpty((Object)projId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projId);
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728 !");
        }
        List<Object> activityVOS = this.pmsProjectActivityDAO.queryListDynamic(query);
        if (!ObjectUtils.isEmpty(activityVOS)) {
            this.addPlanData(pmsProjectVO, activityVOS);
        } else {
            List actVOS = this.pmsProjectTemplateActService.queryByTemplateId(pmsProjectVO.getProjTempId());
            ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
            for (PmsProjectTemplateActVO actVO : actVOS) {
                PmsProjectActivityDO pmsProjectActivityDO = new PmsProjectActivityDO();
                pmsProjectActivityDO.setProjId(projId);
                pmsProjectActivityDO.setActNo(actVO.getActCode());
                pmsProjectActivityDO.setActName(actVO.getActName());
                pmsProjectActivityDO.setMilestoneFlag(actVO.getMilestoneFlag());
                pmsProjectActivityDO.setPhaseFlag(actVO.getActStageFlag());
                pmsProjectActivityDO.setFromtmplFlag(1);
                pmsProjectActivityDO.setSortNo(actVO.getSortNo());
                pmsProjectActivityDO.setWorkbenchFlag(1);
                pmsProjectActivityDO.setRemark(actVO.getRemark());
                activityDOS.add(pmsProjectActivityDO);
            }
            if (activityDOS.size() > 1) {
                activityVOS = PmsProjectActivityConvert.INSTANCE.toVoList(this.pmsProjectActivityDAO.saveAll(activityDOS));
            }
        }
        if (!ObjectUtils.isEmpty(activityVOS)) {
            activityVOS.forEach(v -> this.transferData((PmsProjectActivityVO)v, null));
        }
        return activityVOS;
    }

    public List<PmsProjectActivityVO> listForTimesheet(PmsProjectActivityQuery query) {
        Long projId = query.getProjId();
        if (ObjectUtils.isEmpty((Object)projId)) {
            throw TwException.error("", "\u9879\u76eeID\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projId);
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728 !");
        }
        query.setPhaseFlag(Integer.valueOf(1));
        List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryListDynamic(query);
        return activityVOS;
    }

    public List<PmsProjectActivityVO> queryActiveList(Long projId, int phaseFlag) {
        List activityVOS;
        PmsProjectActivityProcessVO maxData;
        List list = new ArrayList();
        List<PmsProjectActivityProcessVO> processDOList = this.pmsProjectActivityProcessDAO.queryByProjId(projId);
        if (!ObjectUtils.isEmpty(processDOList) && (maxData = processDOList.stream().filter(v -> WorkFlowStatusEnum.APPROVED.getCode().equals(v.getActivityStatus())).max(Comparator.comparing(PmsProjectActivityProcessVO::getDataVersion)).get()) != null) {
            String changeContent = maxData.getChangeContent();
            if (!ObjectUtils.isEmpty((Object)changeContent)) {
                list = JSON.parseArray((String)changeContent, PmsProjectActivityVO.class);
            } else {
                PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
                activityQuery.setProjId(projId);
                activityQuery.setPhaseFlag(Integer.valueOf(phaseFlag));
                return this.queryListDynamic(activityQuery);
            }
        }
        if (!ObjectUtils.isEmpty(list) && !ObjectUtils.isEmpty(activityVOS = list.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getPhaseFlag()) && phaseFlag == v.getPhaseFlag()).collect(Collectors.toList()))) {
            PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
            activityQuery.setProjId(projId);
            activityQuery.setPhaseFlag(Integer.valueOf(phaseFlag));
            activityQuery.setIds(activityVOS.stream().map(v -> v.getId()).collect(Collectors.toList()));
            return this.queryListDynamic(activityQuery);
        }
        return new ArrayList<PmsProjectActivityVO>();
    }

    public List<PmsProjectActivityVO> querySimpleActiveList(Long projId) {
        PmsProjectActivityQuery activityQuery = new PmsProjectActivityQuery();
        activityQuery.setProjId(projId);
        List<PmsProjectActivityVO> list = this.pmsProjectActivityDAO.queryListDynamic(activityQuery);
        if (!ObjectUtils.isEmpty(list)) {
            list.forEach(v -> {
                if (ObjectUtils.isEmpty((Object)v.getUsedEqva())) {
                    v.setUsedEqva(BigDecimal.ZERO);
                }
                if (ObjectUtils.isEmpty((Object)v.getOccupyEqva())) {
                    v.setOccupyEqva(BigDecimal.ZERO);
                }
            });
        }
        return list;
    }

    public PmsProjectActivityVO queryByKey(Long key) {
        PmsProjectActivityDO entity = this.pmsProjectActivityRepo.findById(key).orElseGet(PmsProjectActivityDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u9879\u76ee\u6d3b\u52a8\u4e0d\u5b58\u5728");
        PmsProjectActivityVO vo = PmsProjectActivityConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectActivityVO insert(PmsProjectActivityPayload payload) {
        this.checkData(payload, true);
        if (ObjectUtils.isEmpty((Object)payload.getFromtmplFlag())) {
            payload.setFromtmplFlag(Integer.valueOf(0));
        }
        if (ObjectUtils.isEmpty((Object)payload.getWorkbenchFlag())) {
            payload.setWorkbenchFlag(Integer.valueOf(1));
        }
        PmsProjectActivityDO entityDo = PmsProjectActivityConvert.INSTANCE.toDo(payload);
        return PmsProjectActivityConvert.INSTANCE.toVo((PmsProjectActivityDO)this.pmsProjectActivityRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public PmsProjectActivityVO update(PmsProjectActivityPayload payload) {
        this.checkData(payload, false);
        PmsProjectActivityDO entity = this.pmsProjectActivityRepo.findById(payload.getId()).orElseGet(PmsProjectActivityDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        PmsProjectActivityDO entityDo = PmsProjectActivityConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return PmsProjectActivityConvert.INSTANCE.toVo((PmsProjectActivityDO)this.pmsProjectActivityRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public long updateByKeyDynamic(PmsProjectActivityPayload payload) {
        PmsProjectActivityDO entity = this.pmsProjectActivityRepo.findById(payload.getId()).orElseGet(PmsProjectActivityDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        long result = this.pmsProjectActivityDAO.updateByKeyDynamic(payload);
        return result;
    }

    public void batchUpdateSortNo(List<PmsProjectActivityPayload> payloads) {
        ArrayList<Long> ids = new ArrayList<Long>();
        HashMap info = new HashMap();
        payloads.forEach(payload -> {
            Long id = payload.getId();
            if (ObjectUtils.isEmpty((Object)id)) {
                throw TwException.error("", "\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a !");
            }
            Integer sortNo = payload.getSortNo();
            if (ObjectUtils.isEmpty((Object)sortNo)) {
                throw TwException.error("", "\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a !");
            }
            ids.add(id);
            info.put(id, sortNo);
        });
        ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
        List<PmsProjectActivityVO> list = this.pmsProjectActivityDAO.queryByKeys(ids);
        for (PmsProjectActivityVO vo : list) {
            PmsProjectActivityDO entity = (PmsProjectActivityDO)PmsProjectActivityConvert.INSTANCE.toEntity(vo);
            entity.setSortNo((Integer)info.get(vo.getId()));
            activityDOS.add(entity);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            this.pmsProjectActivityRepo.saveAll(activityDOS);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryByKeys(keys);
            long count = activityVOS.stream().filter(v -> ProjActivityAllocateStateEnum.ING.getType().equals(v.getAllocateStatus()) || ProjActivityAllocateStateEnum.OK.getType().equals(v.getAllocateStatus())).count();
            if (count > 0L) {
                throw TwException.error("", "\u62e8\u4ed8\u4e2d\u548c\u62e8\u4ed8\u6210\u529f\u7684\u9636\u6bb5\u6d3b\u52a8\uff0c\u5728\u6d3b\u52a8\u7ba1\u7406\u4e2d\u662f\u4e0d\u53ef\u5220\u9664\u7684");
            }
            this.pmsProjectActivityDAO.deleteSoft(keys);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void submit(Long projId) {
        PmsProjectActivityProcessVO maxData = this.getMaxDataVersionData(projId);
        String status = null;
        Boolean creatProcInstIdFlag = true;
        if (!ObjectUtils.isEmpty((Object)maxData)) {
            status = maxData.getActivityStatus();
            if (!ObjectUtils.isEmpty((Object)maxData.getProcInstId()) && WorkFlowStatusEnum.CREATE_WORK.getCode().equals(status)) {
                creatProcInstIdFlag = false;
            }
        }
        if (creatProcInstIdFlag.booleanValue()) {
            List planVOList;
            boolean outerProjectFlag;
            if (WorkFlowStatusEnum.APPROVING_WORK.getCode().equals(status) || WorkFlowStatusEnum.REJECTED_WORK.getCode().equals(status)) {
                throw TwException.error("", "\u6d41\u7a0b \u5ba1\u6279\u4e2d \u65f6\uff0c\u4ee5\u53ca\u5ba1\u6279 \u88ab\u9a73\u56de \u65f6\uff0c\u6d3b\u52a8\u7ba1\u7406\u9875\u4e0d\u5141\u8bb8\u518d\u6b21\u63d0\u4ea4\u6570\u636e");
            }
            PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(projId);
            if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
                throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728 !");
            }
            if (ObjectUtils.isEmpty((Object)pmsProjectVO.getDeliUserId())) {
                throw TwException.error("", "\u4ea4\u4ed8\u8d1f\u8d23\u4eba \u4e0d\u80fd\u4e3a\u7a7a !");
            }
            List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryByProjId(projId);
            if (ObjectUtils.isEmpty(activityVOS)) {
                throw TwException.error("", "\u6d3b\u52a8\u6570\u636e\u4e0d\u53ef\u4e3a\u7a7a !");
            }
            Optional<PmsProjectActivityVO> optional = activityVOS.stream().filter(v -> v.getSortNo() == 1).findFirst();
            if (!optional.isPresent()) {
                throw TwException.error("", "\u7b2c\u4e00\u6761\u6d3b\u52a8\u5fc5\u987b\u662f\u9636\u6bb5 !");
            }
            PmsProjectActivityVO vo = optional.get();
            if (ObjectUtils.isEmpty((Object)vo.getPhaseFlag()) || 1 != vo.getPhaseFlag()) {
                throw TwException.error("", "\u7b2c\u4e00\u6761\u6d3b\u52a8\u5fc5\u987b\u662f\u9636\u6bb5 !");
            }
            for (PmsProjectActivityVO pmsProjectActivityVO : activityVOS) {
                if (ObjectUtils.isEmpty((Object)pmsProjectActivityVO.getPhaseFlag()) || 1 != pmsProjectActivityVO.getPhaseFlag() || !ObjectUtils.isEmpty((Object)pmsProjectActivityVO.getStartDate()) && !ObjectUtils.isEmpty((Object)pmsProjectActivityVO.getEndDate())) continue;
                throw TwException.error("", "\u9636\u6bb5\u6d3b\u52a8\u7684\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a !");
            }
            String platType = pmsProjectVO.getPlatType();
            boolean bl = outerProjectFlag = SaleConEnum.INTERNAL.getCode().equals(platType) || SaleConEnum.EXTERNAL.getCode().equals(platType) || SaleConEnum.NO_CONTRACT_VIRTUAL_CONTRACT.getCode().equals(platType);
            if (outerProjectFlag && !ObjectUtils.isEmpty((Object)pmsProjectVO.getContractId()) && !ObjectUtils.isEmpty((Object)(planVOList = this.conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId()))) && !ObjectUtils.isEmpty(planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList()))) {
                boolean isRepeat;
                List hasPlan = activityVOS.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getPhaseFlag()) && 1 == v.getPhaseFlag() && !ObjectUtils.isEmpty((Object)v.getReceivePlanId())).map(v -> v.getReceivePlanId()).collect(Collectors.toList());
                List distinctPlan = hasPlan.stream().distinct().collect(Collectors.toList());
                if (distinctPlan.size() != hasPlan.size()) {
                    throw TwException.error("", "\u6240\u6709\u6536\u6b3e\u9636\u6bb5\u5fc5\u987b\u88ab\u9636\u6bb5\u6d3b\u52a8\u5173\u8054\uff0c\u4e14\u88ab\u552f\u4e00\u5173\u8054!");
                }
                boolean bl2 = isRepeat = planVOList.size() != distinctPlan.size();
                if (isRepeat) {
                    throw TwException.error("", "\u6240\u6709\u6536\u6b3e\u9636\u6bb5\u5fc5\u987b\u88ab\u9636\u6bb5\u6d3b\u52a8\u5173\u8054\uff0c\u4e14\u88ab\u552f\u4e00\u5173\u8054 !");
                }
            }
            int dataVersion = 1;
            if (ObjectUtils.isEmpty((Object)maxData)) {
                ArrayList<PmsProjectActivityVO> preActivityVOS = new ArrayList<PmsProjectActivityVO>();
                List templateActVOS = this.pmsProjectTemplateActService.queryByTemplateId(pmsProjectVO.getProjTempId());
                for (PmsProjectTemplateActVO actVO : templateActVOS) {
                    PmsProjectActivityVO activityVO = new PmsProjectActivityVO();
                    activityVO.setActNo(actVO.getActCode());
                    activityVO.setActName(actVO.getActName());
                    activityVO.setMilestoneFlag(actVO.getMilestoneFlag());
                    activityVO.setPhaseFlag(actVO.getActStageFlag());
                    activityVO.setFromtmplFlag(Integer.valueOf(1));
                    activityVO.setSortNo(actVO.getSortNo());
                    activityVO.setWorkbenchFlag(Integer.valueOf(1));
                    activityVO.setRemark(actVO.getRemark());
                    preActivityVOS.add(activityVO);
                }
                this.procStart(pmsProjectVO, dataVersion, JSON.toJSONString(preActivityVOS));
            } else {
                dataVersion = maxData.getDataVersion() + 1;
                this.procStart(pmsProjectVO, dataVersion, maxData.getChangeContent());
            }
        } else {
            PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
            processDO.setId(maxData.getId());
            processDO.setActivityStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
            this.pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
        }
    }

    public String getActivityStatus(Long projId) {
        PmsProjectActivityProcessVO maxData = this.getMaxDataVersionData(projId);
        if (!ObjectUtils.isEmpty((Object)maxData)) {
            return maxData.getActivityStatus();
        }
        return null;
    }

    private PmsProjectActivityProcessVO getMaxDataVersionData(Long projId) {
        List<PmsProjectActivityProcessVO> processDOList = this.pmsProjectActivityProcessDAO.queryByProjId(projId);
        if (!ObjectUtils.isEmpty(processDOList)) {
            PmsProjectActivityProcessVO maxData = processDOList.stream().max(Comparator.comparing(PmsProjectActivityProcessVO::getDataVersion)).get();
            return maxData;
        }
        return null;
    }

    public PmsProjectActivityProcessVO byActivityProcessID(Long activityProcessID) {
        List planVOList;
        PmsProjectActivityProcessVO vo = this.pmsProjectActivityProcessDAO.queryByKey(activityProcessID);
        if (ObjectUtils.isEmpty((Object)vo)) {
            throw TwException.error("", "\u53d8\u66f4\u6d41\u7a0b\u4e0d\u5b58\u5728 !");
        }
        PmsProjectVO pmsProjectVO = this.pmsProjectDAO.queryByKey(vo.getProjId());
        if (ObjectUtils.isEmpty((Object)pmsProjectVO)) {
            throw TwException.error("", "\u9879\u76ee\u4e0d\u5b58\u5728 !");
        }
        vo.setProjNo(pmsProjectVO.getProjNo());
        vo.setProjName(pmsProjectVO.getProjName());
        vo.setContractId(pmsProjectVO.getContractId());
        vo.setPlatType(pmsProjectVO.getPlatType());
        vo.setWorkType(pmsProjectVO.getWorkType());
        if (!ObjectUtils.isEmpty((Object)pmsProjectVO.getPmResId())) {
            vo.setPmResName(this.cacheUtil.getUserName(pmsProjectVO.getPmResId()));
        }
        if (!ObjectUtils.isEmpty((Object)pmsProjectVO.getSaleManUserId())) {
            vo.setSaleManUserName(this.cacheUtil.getUserName(pmsProjectVO.getSaleManUserId()));
        }
        if (!ObjectUtils.isEmpty((Object)(planVOList = this.conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId())))) {
            planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
        }
        vo.setPlanVOS(planVOList);
        Map<Long, String> planInfo = planVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, ConReceivablePlanVO::getReceStage));
        if (!ObjectUtils.isEmpty((Object)vo.getPreChangeContent()) && !"[]".equals(vo.getPreChangeContent())) {
            List preActivityVOS = JSON.parseArray((String)vo.getPreChangeContent(), PmsProjectActivityVO.class);
            preActivityVOS.forEach(v -> this.transferData((PmsProjectActivityVO)v, planInfo));
            vo.setPreActivityVOS(preActivityVOS);
        }
        List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryByProjId(pmsProjectVO.getId());
        activityVOS.forEach(v -> this.transferData((PmsProjectActivityVO)v, planInfo));
        vo.setActivityVOS(activityVOS);
        return vo;
    }

    void transferData(PmsProjectActivityVO vo, Map<Long, String> planInfo) {
        if (!ObjectUtils.isEmpty((Object)vo.getAllocateStatus())) {
            vo.setAllocateStatusDesc(this.cacheUtil.transferSystemSelection("PMS:ACTIVITY:ALLOCATESTATUS", vo.getAllocateStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)vo.getReceStatus())) {
            vo.setReceStatusDesc(this.cacheUtil.transferSystemSelection("salecon:payment_status", vo.getReceStatus()));
        }
        if (!ObjectUtils.isEmpty(planInfo) && !ObjectUtils.isEmpty((Object)vo.getReceivePlanId())) {
            vo.setReceivePlanDesc(planInfo.get(vo.getReceivePlanId()));
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void importFile(MultipartFile file, Long projId) {
        if (file == null) {
            throw TwException.error("", "\u4e0a\u4f20\u6587\u4ef6\u5f02\u5e38");
        }
        Workbook workbook = null;
        try {
            workbook = WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error(e.getMessage());
            throw TwException.error("", "\u6587\u4ef6\u89e3\u6790\u5f02\u5e38");
        }
        Sheet sheet = workbook.getSheet(sheetName);
        if (sheet == null) {
            throw TwException.error("", "\u8868\u7ed3\u6784\u9519\u8bef");
        }
        List<PmsProjectActivityVO> fromDb = this.pmsProjectActivityDAO.queryByProjId(projId);
        List actNos = fromDb.stream().map(v -> v.getActNo()).collect(Collectors.toList());
        int maxSortNo = 0;
        if (!ObjectUtils.isEmpty(fromDb)) {
            maxSortNo = fromDb.stream().mapToInt(PmsProjectActivityVO::getSortNo).max().getAsInt();
        }
        int dataStartRow = 2;
        ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
        for (int i = dataStartRow; i <= sheet.getLastRowNum(); ++i) {
            Date endDate;
            Date startDate;
            Row row = sheet.getRow(i);
            String actNo = ExcelUtil.getCellFormatValue(row.getCell(0));
            String actName = ExcelUtil.getCellFormatValue(row.getCell(1));
            if (!StringUtils.hasText((String)actNo) || !StringUtils.hasText((String)actName)) break;
            if (actNos.contains(actNo)) continue;
            actNos.add(actNo);
            PmsProjectActivityDO pmsProjectActivityDO = new PmsProjectActivityDO();
            pmsProjectActivityDO.setProjId(projId);
            pmsProjectActivityDO.setFromtmplFlag(0);
            pmsProjectActivityDO.setWorkbenchFlag(1);
            pmsProjectActivityDO.setActNo(actNo);
            pmsProjectActivityDO.setActName(actName);
            pmsProjectActivityDO.setSortNo(maxSortNo + i - 1);
            String typeDesc = ExcelUtil.getCellFormatValue(row.getCell(2));
            if ("\u91cc\u7a0b\u7891".equals(typeDesc)) {
                pmsProjectActivityDO.setMilestoneFlag(1);
            }
            if ("\u9636\u6bb5".equals(typeDesc)) {
                pmsProjectActivityDO.setPhaseFlag(1);
            }
            if ((startDate = row.getCell(3).getDateCellValue()) != null) {
                pmsProjectActivityDO.setStartDate(startDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            if ((endDate = row.getCell(4).getDateCellValue()) != null) {
                pmsProjectActivityDO.setEndDate(endDate.toInstant().atZone(ZoneId.systemDefault()).toLocalDate());
            }
            pmsProjectActivityDO.setRemark(ExcelUtil.getCellFormatValue(row.getCell(5)));
            activityDOS.add(pmsProjectActivityDO);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            this.pmsProjectActivityDAO.saveAll(activityDOS);
        }
    }

    public void downloadFile(HttpServletResponse response) {
        ClassPathResource classPathResource = new ClassPathResource("template/pmsProjActivityTemplate.xlsx");
        try {
            InputStream inputStream = classPathResource.getInputStream();
            Workbook workbook = WorkbookFactory.create((InputStream)inputStream);
            String fileName = "\u6d3b\u52a8\u7ba1\u7406\u5bfc\u5165\u6a21\u677f-" + LocalDate.now();
            ExcelUtil.writeResponse(response, fileName, workbook);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void taskCreated(TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        CommentInfo commentInfo = payload.getCommentInfo();
        if (!ObjectUtils.isEmpty((Object)commentInfo)) {
            ActionType actionType = commentInfo.getType();
            String nextTaskKey = payload.getTaskKey();
            String activityStatus = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            switch (actionType) {
                case REJECTED: {
                    if ("Activity_0gmk4xa".equals(nextTaskKey) || "Activity_07jhdog".equals(nextTaskKey)) break;
                    activityStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
                    break;
                }
                case REVOKE: {
                    activityStatus = WorkFlowStatusEnum.CREATE_WORK.getCode();
                }
            }
            if (!ObjectUtils.isEmpty((Object)activityStatus)) {
                PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
                processDO.setId(Long.parseLong(businessKey));
                processDO.setActivityStatus(activityStatus);
                this.pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
            }
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAllocate(Long activityId, BigDecimal allocateEqva, BigDecimal allocateCost, String allocateStatus) {
        PmsProjectActivityPayload activityPayload = new PmsProjectActivityPayload();
        activityPayload.setId(activityId);
        activityPayload.setAllocateCost(allocateCost);
        activityPayload.setAllocateEqva(allocateEqva);
        activityPayload.setAllocateStatus(allocateStatus);
        this.pmsProjectActivityDAO.updateByKeyDynamic(activityPayload);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdate(List<PmsProjectActivityPayload> activityPayloads) {
        ArrayList<PmsProjectActivityDO> activityDOS = new ArrayList<PmsProjectActivityDO>();
        for (PmsProjectActivityPayload payload : activityPayloads) {
            PmsProjectActivityDO entity = PmsProjectActivityConvert.INSTANCE.toDo(payload);
            activityDOS.add(entity);
        }
        if (!ObjectUtils.isEmpty(activityDOS)) {
            this.pmsProjectActivityRepo.saveAll(activityDOS);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void updateAllocateStatus(List<Long> activityIds, String status) {
        this.pmsProjectActivityDAO.updateStatus(activityIds, status);
    }

    @Transactional(rollbackFor={Exception.class})
    public void processStatusChange(ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        PmsProjectActivityProcessVO processVO = this.pmsProjectActivityProcessDAO.queryByKey(Long.valueOf(businessKey));
        if (processVO != null) {
            PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
            processDO.setId(Long.parseLong(businessKey));
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    processDO.setActivityStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    processDO.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    processDO.setActivityStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    break;
                }
                case INVALID: {
                    processDO.setDeleteFlag(1);
                    processDO.setActivityStatus(WorkFlowStatusEnum.INVALID.getCode());
                    processDO.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    processDO.setActivityStatus(WorkFlowStatusEnum.CREATE_WORK.getCode());
                    processDO.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    processDO.setActivityStatus(WorkFlowStatusEnum.APPROVED.getCode());
                    processDO.setProcInstStatus(ProcInstStatus.APPROVED);
                    processDO.setApprovedTime(LocalDateTime.now());
                    List<PmsProjectActivityVO> activityVOS = this.pmsProjectActivityDAO.queryByProjId(processVO.getProjId());
                    processDO.setChangeContent(JSON.toJSONString(activityVOS));
                    break;
                }
            }
            this.pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
        }
    }

    private void procStart(PmsProjectVO pmsProjectVO, int dataVersion, String preChangeContent) {
        PmsProjectActivityProcessDO processDO = new PmsProjectActivityProcessDO();
        processDO.setProjId(pmsProjectVO.getId());
        processDO.setDataVersion(dataVersion);
        processDO.setPreChangeContent(preChangeContent);
        processDO = (PmsProjectActivityProcessDO)this.pmsProjectActivityProcessRepo.save(processDO);
        HashMap<String, ArrayList> variables = new HashMap<String, ArrayList>();
        List userIds = this.roleService.queryUserIdByRoleCode(RoleEnum.PLAT_PMO_AID.getCode());
        if (ObjectUtils.isEmpty((Object)userIds)) {
            throw TwException.error("", "\u516c\u53f8PMO\u52a9\u7406\u5ba1\u6279\u89d2\u8272\u4eba\u5458\u4e0d\u5b58\u5728");
        }
        variables.put("Activity_0gmk4xa", CollUtil.newArrayList((Collection)userIds));
        variables.put("Activity_07jhdog", CollUtil.newArrayList((Object[])new Long[]{pmsProjectVO.getDeliUserId()}));
        String procInstName = "P02.\u6d3b\u52a8\u7ba1\u7406\u5ba1\u6279-" + pmsProjectVO.getProjName();
        ProcessInfo processInfo = this.workflowUtil.startProcess(StartProcessPayload.of((String)PmsProcDefKey.PMS_PROJECT_ACTIVITY.name(), (String)procInstName, (String)("" + processDO.getId()), variables), new Long[0]);
        processDO.setProcInstId(processInfo.getProcInstId());
        processDO.setProcInstStatus(ProcInstStatus.APPROVING);
        processDO.setSubmitTime(LocalDateTime.now());
        processDO.setProcDefKey(PmsProcDefKey.PMS_PROJECT_ACTIVITY.name());
        processDO.setActivityStatus(WorkFlowStatusEnum.APPROVING_WORK.getCode());
        this.pmsProjectActivityProcessDAO.updateWorkFlow(processDO);
    }

    private void checkData(PmsProjectActivityPayload payload, Boolean isAdd) {
        if (ObjectUtils.isEmpty((Object)payload.getProjId())) {
            throw TwException.error("", "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (ObjectUtils.isEmpty((Object)payload.getActNo()) || ObjectUtils.isEmpty((Object)payload.getActName())) {
            throw TwException.error("", "\u6d3b\u52a8\u7f16\u53f7\u548c\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getPhaseFlag()) && 1 == payload.getPhaseFlag() && (ObjectUtils.isEmpty((Object)payload.getStartDate()) || ObjectUtils.isEmpty((Object)payload.getEndDate()))) {
            throw TwException.error("", "\u9636\u6bb5\u6d3b\u52a8\u7684\u8d77\u6b62\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        if (!ObjectUtils.isEmpty((Object)payload.getStartDate()) && !ObjectUtils.isEmpty((Object)payload.getEndDate()) && payload.getStartDate().isAfter(payload.getEndDate())) {
            throw TwException.error("", "\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u665a\u4e8e\u7ed3\u675f\u65e5\u671f !");
        }
        Integer sortNo = payload.getSortNo();
        if (ObjectUtils.isEmpty((Object)sortNo)) {
            throw TwException.error("", "\u5e8f\u53f7\u4e0d\u80fd\u4e3a\u7a7a !");
        }
        List<PmsProjectActivityVO> list = this.pmsProjectActivityDAO.queryByProjId(payload.getProjId());
        long count = 0L;
        if (isAdd.booleanValue()) {
            count = list.stream().filter(v -> payload.getActNo().equals(v.getActNo())).count();
        } else {
            if (ObjectUtils.isEmpty((Object)payload.getId())) {
                throw TwException.error("", "id\u4e0d\u80fd\u4e3a\u7a7a !");
            }
            count = list.stream().filter(v -> payload.getActNo().equals(v.getActNo()) && !payload.getId().equals(v.getId())).count();
        }
        if (count > 0L) {
            throw TwException.error("", "\u9879\u76ee\u6d3b\u52a8\u7f16\u53f7\u4e0d\u53ef\u91cd\u590d !");
        }
    }

    void addPlanData(PmsProjectVO pmsProjectVO, List<PmsProjectActivityVO> activityVOS) {
        if (!ObjectUtils.isEmpty((Object)pmsProjectVO.getContractId())) {
            List planVOList = this.conReceivablePlanService.queryBySaleConId(pmsProjectVO.getContractId());
            if (!ObjectUtils.isEmpty((Object)planVOList)) {
                planVOList = planVOList.stream().filter(v -> !ObjectUtils.isEmpty((Object)v.getReceStatus()) && !"INVALID".equals(v.getReceStatus())).collect(Collectors.toList());
            }
            if (!ObjectUtils.isEmpty((Object)planVOList)) {
                Map planInfo = planVOList.stream().collect(Collectors.toMap(BaseViewModel::getId, Function.identity()));
                activityVOS.forEach(v -> {
                    ConReceivablePlanVO planVO;
                    if (!ObjectUtils.isEmpty((Object)v.getReceivePlanId()) && !ObjectUtils.isEmpty((Object)(planVO = (ConReceivablePlanVO)planInfo.get(v.getReceivePlanId())))) {
                        v.setReceivePlanDesc(planVO.getReceStage());
                        v.setReceRatio(planVO.getReceRatio());
                        v.setReceAmt(planVO.getReceAmt());
                        v.setReceStatus(planVO.getReceStatus());
                        v.setExpectReceDate(planVO.getExpectReceDate());
                        if (v.getExpectReceDate() != null && v.getExpectReceDate().isAfter(v.getStartDate()) && v.getExpectReceDate().isBefore(v.getEndDate())) {
                            v.setExpectReceDateFlag(1);
                        } else {
                            v.setExpectReceDateFlag(0);
                        }
                    }
                });
            }
        }
    }

    public PmsProjectActivityServiceImpl(PmsProjectActivityRepo pmsProjectActivityRepo, PmsProjectActivityDAO pmsProjectActivityDAO, ConReceivablePlanService conReceivablePlanService, PmsProjectActivityProcessDAO pmsProjectActivityProcessDAO, PmsProjectDAO pmsProjectDAO, WorkflowUtil workflowUtil, PmsProjectActivityProcessRepo pmsProjectActivityProcessRepo, PrdSystemRoleService roleService, PmsProjectTemplateActService pmsProjectTemplateActService, CacheUtil cacheUtil) {
        this.pmsProjectActivityRepo = pmsProjectActivityRepo;
        this.pmsProjectActivityDAO = pmsProjectActivityDAO;
        this.conReceivablePlanService = conReceivablePlanService;
        this.pmsProjectActivityProcessDAO = pmsProjectActivityProcessDAO;
        this.pmsProjectDAO = pmsProjectDAO;
        this.workflowUtil = workflowUtil;
        this.pmsProjectActivityProcessRepo = pmsProjectActivityProcessRepo;
        this.roleService = roleService;
        this.pmsProjectTemplateActService = pmsProjectTemplateActService;
        this.cacheUtil = cacheUtil;
    }
}

