/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.controller;

import com.alibaba.fastjson.JSON;
import com.elitescloud.cloudt.common.base.ApiResult;
import com.elitesland.tw.tw5.api.bank.callback.cmb.CmbCallBackPayload;
import com.elitesland.tw.tw5.api.bank.callback.cmb.TwBankCmbCallBackService;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimPayload;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimService;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.service.TMoneyTransferService;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.service.PaymentSlipService;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimDocStatusEnum;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import java.time.LocalDate;
import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/tw-bank/CMB/callBack"})
public class BankCallBackController
implements TwBankCmbCallBackService {
    private static final Logger log = LoggerFactory.getLogger(BankCallBackController.class);
    private final PaymentSlipService paymentSlipService;
    private final AccReimService accReimService;
    private final TMoneyTransferService tMoneyTransferService;

    @PostMapping(value={"/payResultPrivate"})
    public ApiResult<String> payResultPrivate(@RequestBody CmbCallBackPayload payload) {
        log.info("\u94f6\u4f01\u76f4\u8fde\u5bf9\u79c1\u4ed8\u6b3e\u56de\u8c03\u4fe1\u606f is {}", (Object)JSON.toJSONString((Object)payload));
        if (!StringUtils.hasText((String)payload.getDocType())) {
            return ApiResult.fail((String)"docType\u8c03\u7528\u4e3a\u7a7a");
        }
        String payState = payload.getPayState();
        String payStatus = "";
        switch (payState) {
            case "5": {
                payStatus = PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode();
                break;
            }
            case "6": {
                payStatus = PurchasePaymentEnum.PayStatusEnum.FAIL.getCode();
                break;
            }
            case "7": {
                payStatus = PurchasePaymentEnum.PayStatusEnum.PAYRETRUN.getCode();
                break;
            }
        }
        if (!ObjectUtils.isEmpty((Object)payStatus)) {
            if (PurchasePaymentEnum.BankDocType.PAY.getCode().equals(payload.getDocType())) {
                PaymentSlipPayload paymentSlipPayload = new PaymentSlipPayload();
                paymentSlipPayload.setId(Long.valueOf(payload.getDocId()));
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    paymentSlipPayload.setState(PurchasePaymentEnum.PaymentSlipStatus.PAYMENT_ACCOUNT.getCode());
                    paymentSlipPayload.setActualDate(LocalDate.now());
                }
                paymentSlipPayload.setPayStatus(payStatus);
                paymentSlipPayload.setPayTime(LocalDateTime.now());
                this.paymentSlipService.updateBankCallBack(paymentSlipPayload);
                return ApiResult.ok((Object)PurchasePaymentEnum.BankDocType.PAY.getCode());
            }
            if (PurchasePaymentEnum.BankDocType.REIM.getCode().equals(payload.getDocType())) {
                AccReimPayload reimPayload = new AccReimPayload();
                reimPayload.setId(Long.valueOf(payload.getDocId()));
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    reimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_PAYMENT_CHARGE.getCode());
                }
                reimPayload.setPayStatus(payStatus);
                reimPayload.setPayDate(LocalDateTime.now());
                this.accReimService.updatePayStatus(reimPayload);
                return ApiResult.ok((Object)PurchasePaymentEnum.BankDocType.REIM.getCode());
            }
            if (PurchasePaymentEnum.BankDocType.TRAN.getCode().equals(payload.getDocType())) {
                TMoneyTransferPayload transferPayload = new TMoneyTransferPayload();
                transferPayload.setId(Long.valueOf(payload.getDocId()));
                transferPayload.setPayStatus(payStatus);
                transferPayload.setPayTime(LocalDateTime.now());
                this.tMoneyTransferService.updateByKeyDynamic(transferPayload);
                return ApiResult.ok((Object)PurchasePaymentEnum.BankDocType.TRAN.getCode());
            }
        }
        return ApiResult.fail((String)"docType\u4e0d\u5b58\u5728");
    }

    @PostMapping(value={"/payResultPublic"})
    public ApiResult<String> payResultPublic(@RequestBody CmbCallBackPayload payload) {
        log.info("\u94f6\u4f01\u76f4\u8fde\u5bf9\u516c\u4ed8\u6b3e\u56de\u8c03\u4fe1\u606f is {}", (Object)JSON.toJSONString((Object)payload));
        if (!StringUtils.hasText((String)payload.getDocType())) {
            return ApiResult.fail((String)"docType\u8c03\u7528\u4e3a\u7a7a");
        }
        String payState = payload.getPayState();
        String payStatus = "";
        switch (payState) {
            case "5": {
                payStatus = "S";
                break;
            }
            case "6": {
                payStatus = "F";
                break;
            }
            case "7": {
                payStatus = "G";
                break;
            }
        }
        if (!ObjectUtils.isEmpty((Object)payStatus)) {
            if (PurchasePaymentEnum.BankDocType.PAY.getCode().equals(payload.getDocType())) {
                PaymentSlipPayload paymentSlipPayload = new PaymentSlipPayload();
                paymentSlipPayload.setId(Long.valueOf(payload.getDocId()));
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    paymentSlipPayload.setState(PurchasePaymentEnum.PaymentSlipStatus.PAYMENT_ACCOUNT.getCode());
                }
                paymentSlipPayload.setPayStatus(payStatus);
                paymentSlipPayload.setPayTime(LocalDateTime.now());
                this.paymentSlipService.updateBankCallBack(paymentSlipPayload);
                return ApiResult.ok((Object)PurchasePaymentEnum.BankDocType.PAY.getCode());
            }
            if (PurchasePaymentEnum.BankDocType.REIM.getCode().equals(payload.getDocType())) {
                AccReimPayload reimPayload = new AccReimPayload();
                reimPayload.setId(Long.valueOf(payload.getDocId()));
                if (PurchasePaymentEnum.PayStatusEnum.SUCCESS.getCode().equals(payStatus)) {
                    reimPayload.setReimStatus(AccReimDocStatusEnum.PENDING_PAYMENT_CHARGE.getCode());
                }
                reimPayload.setPayStatus(payStatus);
                this.accReimService.updatePayStatus(reimPayload);
                return ApiResult.ok((Object)PurchasePaymentEnum.BankDocType.REIM.getCode());
            }
            if (PurchasePaymentEnum.BankDocType.TRAN.getCode().equals(payload.getDocType())) {
                TMoneyTransferPayload transferPayload = new TMoneyTransferPayload();
                transferPayload.setId(Long.valueOf(payload.getDocId()));
                transferPayload.setPayStatus(payStatus);
                transferPayload.setPayTime(LocalDateTime.now());
                this.tMoneyTransferService.updateByKeyDynamic(transferPayload);
                return ApiResult.ok((Object)PurchasePaymentEnum.BankDocType.TRAN.getCode());
            }
        }
        return ApiResult.fail((String)"docType\u4e0d\u5b58\u5728");
    }

    public BankCallBackController(PaymentSlipService paymentSlipService, AccReimService accReimService, TMoneyTransferService tMoneyTransferService) {
        this.paymentSlipService = paymentSlipService;
        this.accReimService = accReimService;
        this.tMoneyTransferService = tMoneyTransferService;
    }
}

