/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.PaymentSlipQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PaymentSlipVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.acc.entity.QAccFinancialSubjectDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PaymentSlipDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPaymentSlipDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchasePaymentDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PaymentSlipRepo;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Repository
public class PaymentSlipDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PaymentSlipRepo repo;
    private final QPaymentSlipDO qdo = QPaymentSlipDO.paymentSlipDO;
    private final QPurchasePaymentDO qPurchasePaymentDO = QPurchasePaymentDO.purchasePaymentDO;
    private final QAccFinancialSubjectDO qAccFinancialSubjectDO = QAccFinancialSubjectDO.accFinancialSubjectDO;

    private JPAQuery<PaymentSlipVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PaymentSlipVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.remark, this.qdo.paySerialNum, this.qdo.paymentApplyId, this.qPurchasePaymentDO.paymentNo.as("paymentApplyNo"), this.qPurchasePaymentDO.purchaseName.as("paymentApplyName"), this.qPurchasePaymentDO.reasonDesc, this.qPurchasePaymentDO.purchaseInchargeResId, this.qPurchasePaymentDO.paymentApplicationType, this.qPurchasePaymentDO.applicationDate, this.qdo.paymentAmt, this.qPurchasePaymentDO.currCode, this.qdo.paymentDate, this.qdo.apAccountantRemark, this.qdo.financeRemark, this.qdo.cfoRemark, this.qdo.cashierRemark, this.qdo.state, this.qdo.receivingCompanyBookId, this.qdo.receivingBank, this.qdo.receivingAccount, this.qdo.paymentBank, this.qdo.paymentAccount, this.qdo.payCompanyBookId, this.qdo.accMasId, this.qAccFinancialSubjectDO.accName.as("accMasName"), this.qdo.paymentMethod, this.qdo.payMode, this.qdo.payStatus, this.qdo.payTime, this.qdo.actualDate, this.qdo.apAccountantTime, this.qdo.financeTime, this.qdo.cfoTime, this.qdo.cashierTime, this.qdo.bankFlag, this.qdo.bankTime, this.qPurchasePaymentDO.payFlag, this.qdo.payPurpose, this.qdo.procInstId, this.qdo.procInstStatus, this.qdo.submitTime, this.qdo.approvedTime, this.qdo.payApprovedTime, this.qdo.payProofDigest, this.qdo.payProofNo, this.qdo.payProofStatus, this.qdo.payProofFailReason, this.qdo.jdeCompany, this.qdo.jdePaymentItem, this.qdo.jdeDocumentNo, this.qdo.jdePayNo, this.qdo.jdeVoucher, this.qdo.jdeDocumentType, this.qPurchasePaymentDO.accountingNote})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPurchasePaymentDO)).on((Predicate)this.qdo.paymentApplyId.eq(this.qPurchasePaymentDO.id).and((Predicate)this.qPurchasePaymentDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qAccFinancialSubjectDO)).on((Predicate)this.qdo.accMasId.eq(this.qAccFinancialSubjectDO.id).and((Predicate)this.qAccFinancialSubjectDO.deleteFlag.eq((Object)0)));
    }

    public List<PaymentSlipVO> queryPaymentSlipVOListByIdlist(List<Long> idList) {
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        jpaQuery.where((Predicate)this.qdo.id.in(idList));
        return jpaQuery.fetch();
    }

    private JPAQuery<PaymentSlipVO> getJpaQueryWhere(PaymentSlipQuery query) {
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PaymentSlipQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPurchasePaymentDO)).on((Predicate)this.qdo.paymentApplyId.eq(this.qPurchasePaymentDO.id).and((Predicate)this.qPurchasePaymentDO.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PaymentSlipQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentApplyId())) {
            list.add(this.qdo.paymentApplyId.eq((Object)query.getPaymentApplyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentApplyIdList())) {
            list.add(this.qdo.paymentApplyId.in((Collection)query.getPaymentApplyIdList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaySerialNum())) {
            list.add(this.qdo.paySerialNum.like(SqlUtil.toSqlLikeString(query.getPaySerialNum())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentApplyNo())) {
            list.add(this.qPurchasePaymentDO.paymentNo.like(SqlUtil.toSqlLikeString(query.getPaymentApplyNo())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseInchargeResId())) {
            list.add(this.qPurchasePaymentDO.purchaseInchargeResId.eq((Object)query.getPurchaseInchargeResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayCompanyBookId())) {
            list.add(this.qdo.payCompanyBookId.eq((Object)query.getPayCompanyBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierBookId())) {
            list.add(this.qPurchasePaymentDO.supplierLegalBookId.eq((Object)query.getSupplierBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReasonDesc())) {
            list.add(this.qPurchasePaymentDO.reasonDesc.like(SqlUtil.toSqlLikeString(query.getReasonDesc())));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccountingNote())) {
            list.add(this.qPurchasePaymentDO.accountingNote.like("%" + query.getAccountingNote() + "%"));
        }
        if (!ObjectUtils.isEmpty((Object)query.getState())) {
            list.add(this.qdo.state.eq((Object)query.getState()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getStateList())) {
            list.add(this.qdo.state.in((Collection)query.getStateList()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentDateStart())) {
            list.add(this.qdo.paymentDate.goe((Comparable)query.getPaymentDateStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentDateEnd())) {
            list.add(this.qdo.paymentDate.loe((Comparable)query.getPaymentDateEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayMode())) {
            list.add(this.qdo.payMode.eq((Object)query.getPayMode()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayStatus())) {
            list.add(this.qdo.payStatus.eq((Object)query.getPayStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentBank())) {
            list.add(this.qdo.paymentBank.eq((Object)query.getPaymentBank()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentAccount())) {
            list.add(this.qdo.paymentAccount.eq((Object)query.getPaymentAccount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentAmt())) {
            list.add(this.qdo.paymentAmt.eq((Object)query.getPaymentAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getAccMasId())) {
            list.add(this.qdo.accMasId.eq((Object)query.getAccMasId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentMethod())) {
            list.add(this.qdo.paymentMethod.eq((Object)query.getPaymentMethod()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceivingCompanyBookId())) {
            list.add(this.qdo.receivingCompanyBookId.eq((Object)query.getReceivingCompanyBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceivingBank())) {
            list.add(this.qdo.receivingBank.eq((Object)query.getReceivingBank()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getReceivingAccount())) {
            list.add(this.qdo.receivingAccount.eq((Object)query.getReceivingAccount()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCashierTime())) {
            list.add(this.qdo.cashierTime.eq((Object)query.getCashierTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCashierRemark())) {
            list.add(this.qdo.cashierRemark.eq((Object)query.getCashierRemark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApAccountantTime())) {
            list.add(this.qdo.apAccountantTime.eq((Object)query.getApAccountantTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getApAccountantRemark())) {
            list.add(this.qdo.apAccountantRemark.eq((Object)query.getApAccountantRemark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinanceTime())) {
            list.add(this.qdo.financeTime.eq((Object)query.getFinanceTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getFinanceRemark())) {
            list.add(this.qdo.financeRemark.eq((Object)query.getFinanceRemark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCfoTime())) {
            list.add(this.qdo.cfoTime.eq((Object)query.getCfoTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCfoRemark())) {
            list.add(this.qdo.cfoRemark.eq((Object)query.getCfoRemark()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getActualDate())) {
            list.add(this.qdo.actualDate.eq((Object)query.getActualDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayTime())) {
            list.add(this.qdo.payTime.eq((Object)query.getPayTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankFlag())) {
            list.add(this.qdo.bankFlag.eq((Object)query.getBankFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getBankTime())) {
            list.add(this.qdo.bankTime.eq((Object)query.getBankTime()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayFlag())) {
            list.add(this.qdo.payFlag.eq((Object)query.getPayFlag()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayPurpose())) {
            list.add(this.qdo.payPurpose.eq((Object)query.getPayPurpose()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayApprovedTimeStart())) {
            list.add(this.qdo.payApprovedTime.goe((Comparable)query.getPayApprovedTimeStart()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayApprovedTimeEnd())) {
            list.add(this.qdo.payApprovedTime.loe((Comparable)query.getPayApprovedTimeEnd()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayProofStatus())) {
            list.add(this.qdo.payProofStatus.eq((Object)query.getPayProofStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPayProofNo())) {
            list.add(this.qdo.payProofNo.eq((Object)query.getPayProofNo()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PaymentSlipVO queryByKey(Long id) {
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PaymentSlipVO)jpaQuery.fetchFirst();
    }

    public List<PaymentSlipVO> queryListDynamic(PaymentSlipQuery query) {
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public List<PaymentSlipVO> queryListByIds(List<Long> idList) {
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.in(idList));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuery.fetch();
    }

    public PagingVO<PaymentSlipVO> queryPaging(PaymentSlipQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PagingVO<PaymentSlipVO> queryAccountPaging(PaymentSlipQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PaymentSlipVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PagingVO<PaymentSlipVO> paymentApproveGroupPaging(PaymentSlipQuery query) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PaymentSlipVO.class, (Expression[])new Expression[]{this.qdo.paySerialNum, this.qdo.paymentAmt.sum().as("totalAmount")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPurchasePaymentDO)).on((Predicate)this.qdo.paymentApplyId.eq(this.qPurchasePaymentDO.id).and((Predicate)this.qPurchasePaymentDO.deleteFlag.eq((Object)0)));
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.groupBy((Expression)this.qdo.paySerialNum);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        if (CollectionUtils.isEmpty((Collection)result)) {
            return PagingVO.empty();
        }
        return PagingVO.builder().records(result).total((long)result.size()).build();
    }

    public PaymentSlipDO save(PaymentSlipDO ado) {
        return (PaymentSlipDO)this.repo.save(ado);
    }

    public List<PaymentSlipDO> saveAll(List<PaymentSlipDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PaymentSlipPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPaymentApplyId() != null) {
            update.set(this.qdo.paymentApplyId, (Object)payload.getPaymentApplyId());
        }
        if (payload.getPaySerialNum() != null) {
            update.set((Path)this.qdo.paySerialNum, (Object)payload.getPaySerialNum());
        }
        if (payload.getPaymentBank() != null) {
            update.set((Path)this.qdo.paymentBank, (Object)payload.getPaymentBank());
        }
        if (payload.getPaymentAccount() != null) {
            update.set((Path)this.qdo.paymentAccount, (Object)payload.getPaymentAccount());
        }
        if (payload.getPaymentAmt() != null) {
            update.set(this.qdo.paymentAmt, (Object)payload.getPaymentAmt());
        }
        if (payload.getPayCompanyBookId() != null) {
            update.set(this.qdo.payCompanyBookId, (Object)payload.getPayCompanyBookId());
        }
        if (payload.getAccMasId() != null) {
            update.set(this.qdo.accMasId, (Object)payload.getAccMasId());
        }
        if (payload.getPaymentMethod() != null) {
            update.set((Path)this.qdo.paymentMethod, (Object)payload.getPaymentMethod());
        }
        if (payload.getPaymentDate() != null) {
            update.set(this.qdo.paymentDate, (Object)payload.getPaymentDate());
        }
        if (payload.getReceivingCompanyBookId() != null) {
            update.set(this.qdo.receivingCompanyBookId, (Object)payload.getReceivingCompanyBookId());
        }
        if (payload.getReceivingBank() != null) {
            update.set((Path)this.qdo.receivingBank, (Object)payload.getReceivingBank());
        }
        if (payload.getReceivingAccount() != null) {
            update.set((Path)this.qdo.receivingAccount, (Object)payload.getReceivingAccount());
        }
        if (payload.getState() != null) {
            update.set((Path)this.qdo.state, (Object)payload.getState());
        }
        if (payload.getCashierTime() != null) {
            update.set(this.qdo.cashierTime, (Object)payload.getCashierTime());
        }
        if (payload.getCashierRemark() != null) {
            update.set((Path)this.qdo.cashierRemark, (Object)payload.getCashierRemark());
        }
        if (payload.getApAccountantTime() != null) {
            update.set(this.qdo.apAccountantTime, (Object)payload.getApAccountantTime());
        }
        if (payload.getApAccountantRemark() != null) {
            update.set((Path)this.qdo.apAccountantRemark, (Object)payload.getApAccountantRemark());
        }
        if (payload.getFinanceTime() != null) {
            update.set(this.qdo.financeTime, (Object)payload.getFinanceTime());
        }
        if (payload.getFinanceRemark() != null) {
            update.set((Path)this.qdo.financeRemark, (Object)payload.getFinanceRemark());
        }
        if (payload.getCfoTime() != null) {
            update.set(this.qdo.cfoTime, (Object)payload.getCfoTime());
        }
        if (payload.getCfoRemark() != null) {
            update.set((Path)this.qdo.cfoRemark, (Object)payload.getCfoRemark());
        }
        if (payload.getActualDate() != null) {
            update.set(this.qdo.actualDate, (Object)payload.getActualDate());
        }
        if (payload.getPayTime() != null) {
            update.set(this.qdo.payTime, (Object)payload.getPayTime());
        }
        if (payload.getPayStatus() != null) {
            update.set((Path)this.qdo.payStatus, (Object)payload.getPayStatus());
        }
        if (payload.getPayMode() != null) {
            update.set(this.qdo.payMode, (Object)payload.getPayMode());
        }
        if (payload.getBankFlag() != null) {
            update.set(this.qdo.bankFlag, (Object)payload.getBankFlag());
        }
        if (payload.getBankTime() != null) {
            update.set(this.qdo.bankTime, (Object)payload.getBankTime());
        }
        if (payload.getPayFlag() != null) {
            update.set(this.qdo.payFlag, (Object)payload.getPayFlag());
        }
        if (payload.getPayPurpose() != null) {
            update.set((Path)this.qdo.payPurpose, (Object)payload.getPayPurpose());
        }
        if (payload.getProcInstId() != null) {
            update.set((Path)this.qdo.procInstId, (Object)payload.getProcInstId());
        }
        if (payload.getProcInstStatus() != null) {
            update.set(this.qdo.procInstStatus, (Object)payload.getProcInstStatus());
        }
        if (payload.getSubmitTime() != null) {
            update.set(this.qdo.submitTime, (Object)payload.getSubmitTime());
        }
        if (payload.getApprovedTime() != null) {
            update.set(this.qdo.approvedTime, (Object)payload.getApprovedTime());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("paymentApplyId")) {
                update.setNull(this.qdo.paymentApplyId);
            }
            if (nullFields.contains("paySerialNum")) {
                update.setNull((Path)this.qdo.paySerialNum);
            }
            if (nullFields.contains("paymentBank")) {
                update.setNull((Path)this.qdo.paymentBank);
            }
            if (nullFields.contains("paymentAccount")) {
                update.setNull((Path)this.qdo.paymentAccount);
            }
            if (nullFields.contains("paymentAmt")) {
                update.setNull(this.qdo.paymentAmt);
            }
            if (nullFields.contains("payCompanyBookId")) {
                update.setNull(this.qdo.payCompanyBookId);
            }
            if (nullFields.contains("accMasId")) {
                update.setNull(this.qdo.accMasId);
            }
            if (nullFields.contains("paymentMethod")) {
                update.setNull((Path)this.qdo.paymentMethod);
            }
            if (nullFields.contains("paymentDate")) {
                update.setNull(this.qdo.paymentDate);
            }
            if (nullFields.contains("receivingCompanyBookId")) {
                update.setNull(this.qdo.receivingCompanyBookId);
            }
            if (nullFields.contains("receivingBank")) {
                update.setNull((Path)this.qdo.receivingBank);
            }
            if (nullFields.contains("receivingAccount")) {
                update.setNull((Path)this.qdo.receivingAccount);
            }
            if (nullFields.contains("state")) {
                update.setNull((Path)this.qdo.state);
            }
            if (nullFields.contains("cashierTime")) {
                update.setNull(this.qdo.cashierTime);
            }
            if (nullFields.contains("cashierRemark")) {
                update.setNull((Path)this.qdo.cashierRemark);
            }
            if (nullFields.contains("apAccountantTime")) {
                update.setNull(this.qdo.apAccountantTime);
            }
            if (nullFields.contains("apAccountantRemark")) {
                update.setNull((Path)this.qdo.apAccountantRemark);
            }
            if (nullFields.contains("financeTime")) {
                update.setNull(this.qdo.financeTime);
            }
            if (nullFields.contains("financeRemark")) {
                update.setNull((Path)this.qdo.financeRemark);
            }
            if (nullFields.contains("actualDate")) {
                update.setNull(this.qdo.actualDate);
            }
            if (nullFields.contains("payTime")) {
                update.setNull(this.qdo.payTime);
            }
            if (nullFields.contains("payStatus")) {
                update.setNull((Path)this.qdo.payStatus);
            }
            if (nullFields.contains("payMode")) {
                update.setNull(this.qdo.payMode);
            }
            if (nullFields.contains("bankFlag")) {
                update.setNull(this.qdo.bankFlag);
            }
            if (nullFields.contains("bankTime")) {
                update.setNull(this.qdo.bankTime);
            }
            if (nullFields.contains("payFlag")) {
                update.setNull(this.qdo.payFlag);
            }
            if (nullFields.contains("payPurpose")) {
                update.setNull((Path)this.qdo.payPurpose);
            }
            if (nullFields.contains("procInstId")) {
                update.setNull((Path)this.qdo.procInstId);
            }
            if (nullFields.contains("procInstStatus")) {
                update.setNull(this.qdo.procInstStatus);
            }
            if (nullFields.contains("submitTime")) {
                update.setNull(this.qdo.submitTime);
            }
            if (nullFields.contains("approvedTime")) {
                update.setNull(this.qdo.approvedTime);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long updateBankCallBack(PaymentSlipPayload payload) {
        JPAUpdateClause jpaUpdateClause = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.payStatus, (Object)payload.getPayStatus()).set(this.qdo.payTime, (Object)payload.getPayTime());
        if (StringUtils.hasText((String)payload.getState())) {
            jpaUpdateClause.set((Path)this.qdo.state, (Object)payload.getState());
        }
        long result = jpaUpdateClause.where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())}).execute();
        return result;
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<PaymentSlipVO> queryListByPaymentApplyId(Long paymentApplyId) {
        JPAQuery<PaymentSlipVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.paymentApplyId.eq((Object)paymentApplyId));
        return jpaQuerySelect.fetch();
    }

    public List<PaymentSlipVO> queryByPaymentApplyIdListAndState(List<Long> paymentApplyIdList, String state) {
        JPAQuery jpaQuerySelect = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PaymentSlipVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.paymentAmt, this.qdo.paymentApplyId})).from((EntityPath)this.qdo);
        jpaQuerySelect.where((Predicate)this.qdo.paymentApplyId.in(paymentApplyIdList));
        jpaQuerySelect.where((Predicate)this.qdo.state.eq((Object)state));
        jpaQuerySelect.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return jpaQuerySelect.fetch();
    }

    public void deleteByPaymentApplyId(Long paymentApplyId) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.paymentApplyId.eq((Object)paymentApplyId)});
        update.execute();
    }

    public void updateStatusByPaymentApplyId(Long paymentApplyId, String state) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.state, (Object)state).where(new Predicate[]{this.qdo.paymentApplyId.eq((Object)paymentApplyId)});
        update.execute();
    }

    public void updatePayPurpose(Long id, String payPurpose) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.payPurpose, (Object)payPurpose).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        update.execute();
    }

    public void updateReceiveAccount(Long id, String receivingBank, String receivingAccount) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.receivingBank, (Object)receivingBank).set((Path)this.qdo.receivingAccount, (Object)receivingAccount).set(this.qdo.cashierTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qdo.id.eq((Object)id)});
        update.execute();
    }

    public void updatePaySerialNumByIds(String generateSeqNum, List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.paySerialNum, (Object)generateSeqNum).where(new Predicate[]{this.qdo.id.in(keys)});
        update.execute();
    }

    public List<String> queryPaySerialNum() {
        List<String> list = Arrays.asList(PurchasePaymentEnum.PaymentSlipStatus.READY.getCode(), PurchasePaymentEnum.PaymentSlipStatus.FINANCE_REJECTED.getCode(), PurchasePaymentEnum.PaymentSlipStatus.CASHIER_TO_SUBMIT.getCode());
        return ((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.selectDistinct((Expression)this.qdo.paySerialNum).from((EntityPath)this.qdo)).where((Predicate)this.qdo.state.in(list))).where((Predicate)this.qdo.deleteFlag.eq((Object)0))).fetch();
    }

    public void updateStatusByIdList(List<Long> idList, String status, Integer payMode, String payStatus) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.state, (Object)status).set(this.qdo.payMode, (Object)payMode).set((Path)this.qdo.payStatus, (Object)payStatus).set(this.qdo.payTime, (Object)LocalDateTime.now()).where(new Predicate[]{this.qdo.id.in(idList)});
        update.execute();
    }

    public Boolean isOtherStatusByPaymentApplyId(Long paymentApplyId) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count().gt((Number)0)).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qdo.paymentApplyId.eq((Object)paymentApplyId)).and((Predicate)this.qdo.state.ne((Object)PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode())));
        return (Boolean)jpaQuery.fetchOne();
    }

    public List<Tuple> findNoPayAmtByPaymentApplyIdIn(Set<Long> paymentApplyIdSet) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qdo.paymentApplyId, this.qdo.paymentAmt.sum()}).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qdo.paymentApplyId.in(paymentApplyIdSet)).and((Predicate)this.qdo.state.ne((Object)PurchasePaymentEnum.PaymentSlipStatus.PAID.getCode())))).groupBy(this.qdo.paymentApplyId);
        return jpaQuery.fetch();
    }

    public void updatePayJdeById(Long paymentSlipId, String jdeVoucher, String jdePayNo, String payProofStatus, String payProofDigest, LocalDateTime payApprovedTime, String state) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.jdeVoucher, (Object)jdeVoucher).set((Path)this.qdo.jdePayNo, (Object)jdePayNo).set((Path)this.qdo.payProofStatus, (Object)payProofStatus).set(this.qdo.payApprovedTime, (Object)payApprovedTime).set((Path)this.qdo.payProofDigest, (Object)payProofDigest).set((Path)this.qdo.state, (Object)state).where(new Predicate[]{this.qdo.id.eq((Object)paymentSlipId)});
        update.execute();
    }

    public void updatePayVerJdeById(Long paymentSlipId, String payProofNo, String payProofStatus, String state) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set((Path)this.qdo.payProofNo, (Object)payProofNo).set((Path)this.qdo.payProofStatus, (Object)payProofStatus).set((Path)this.qdo.state, (Object)state).where(new Predicate[]{this.qdo.id.eq((Object)paymentSlipId)});
        update.execute();
    }

    public PaymentSlipDAO(JPAQueryFactory jpaQueryFactory, PaymentSlipRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

