/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.TwQueryParam;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PurchasePaymentPlanPayload;
import com.elitesland.tw.tw5.api.prd.purchase.query.LatePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchaseAgreementPaymentQuery;
import com.elitesland.tw.tw5.api.prd.purchase.query.PurchasePaymentPlanQuery;
import com.elitesland.tw.tw5.api.prd.purchase.vo.LatePaymentPlanVO;
import com.elitesland.tw.tw5.api.prd.purchase.vo.PurchasePaymentPlanVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.my.entity.QResActivityDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.PurchasePaymentPlanDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchaseContractManagerDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchasePaymentDO;
import com.elitesland.tw.tw5.server.prd.purchase.entity.QPurchasePaymentPlanDO;
import com.elitesland.tw.tw5.server.prd.purchase.purenum.PurchasePaymentEnum;
import com.elitesland.tw.tw5.server.prd.purchase.repo.PurchasePaymentPlanRepo;
import com.elitesland.tw.tw5.server.prd.salecon.entity.QConReceivablePlanDO;
import com.querydsl.core.Tuple;
import com.querydsl.core.types.EntityPath;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Path;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.core.types.dsl.BooleanExpression;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Repository
public class PurchasePaymentPlanDAO {
    private final JPAQueryFactory jpaQueryFactory;
    private final PurchasePaymentPlanRepo repo;
    private final QPurchasePaymentPlanDO qdo = QPurchasePaymentPlanDO.purchasePaymentPlanDO;
    private final QResActivityDO qResActivityDO = QResActivityDO.resActivityDO;
    private final QConReceivablePlanDO qConReceivablePlanDO = QConReceivablePlanDO.conReceivablePlanDO;
    private final QPurchasePaymentDO qPurchasePaymentDO = QPurchasePaymentDO.purchasePaymentDO;
    private final QPurchaseContractManagerDO qPurchaseContractManagerDO = QPurchaseContractManagerDO.purchaseContractManagerDO;

    private JPAQuery<PurchasePaymentPlanVO> getJpaQuerySelect() {
        return (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PurchasePaymentPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.paymentStage, this.qdo.paymentAmt, this.qdo.currentPaymentAmt, this.qdo.paymentProportion, this.qdo.estimatedPaymentDate, this.qdo.paymentApplyId, this.qPurchasePaymentDO.paymentNo.as("paymentApplyNo"), this.qPurchasePaymentDO.state.as("payApplyStatus"), this.qPurchasePaymentDO.paymentApplicationType.as("paymentApplicationType"), this.qdo.contractId, this.qdo.contractNo, this.qdo.paymentStatus, this.qdo.writeoffStatus, this.qdo.milestone, this.qResActivityDO.actName.as("milestoneName"), this.qdo.docType, this.qdo.paymentDate, this.qdo.contractNode, this.qConReceivablePlanDO.receStage.as("contractNodeName"), this.qConReceivablePlanDO.receStatus.as("receStatus"), this.qConReceivablePlanDO.receAmt, this.qConReceivablePlanDO.actualRecvAmt.as("actualReceAmt"), this.qdo.prePaymentPlanId})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPurchasePaymentDO)).on((Predicate)this.qdo.paymentApplyId.eq(this.qPurchasePaymentDO.id).and((Predicate)this.qPurchasePaymentDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qConReceivablePlanDO)).on((Predicate)this.qdo.contractNode.eq(this.qConReceivablePlanDO.id).and((Predicate)this.qConReceivablePlanDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qResActivityDO)).on((Predicate)this.qdo.milestone.eq(this.qResActivityDO.id).and((Predicate)this.qResActivityDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.deleteFlag.eq((Object)0));
    }

    private JPAQuery<PurchasePaymentPlanVO> getJpaQueryWhere(PurchasePaymentPlanQuery query) {
        JPAQuery<PurchasePaymentPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(this.qdo, query.getOrders()));
        return jpaQuery;
    }

    public long count(PurchasePaymentPlanQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.count()).from((EntityPath)this.qdo);
        jpaQuery.where(this.where(query));
        SqlUtil.handleCommonJpaQuery(jpaQuery, this.qdo._super, (TwQueryParam)query);
        long total = (Long)jpaQuery.fetchOne();
        return total;
    }

    private Predicate where(PurchasePaymentPlanQuery query) {
        ArrayList<BooleanExpression> list = new ArrayList<BooleanExpression>();
        if (!ObjectUtils.isEmpty((Object)query.getId())) {
            list.add(this.qdo.id.eq((Object)query.getId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentStage())) {
            list.add(this.qdo.paymentStage.eq((Object)query.getPaymentStage()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentAmt())) {
            list.add(this.qdo.paymentAmt.eq((Object)query.getPaymentAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getCurrentPaymentAmt())) {
            list.add(this.qdo.currentPaymentAmt.eq((Object)query.getCurrentPaymentAmt()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentProportion())) {
            list.add(this.qdo.paymentProportion.eq((Object)query.getPaymentProportion()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEstimatedPaymentDate())) {
            list.add(this.qdo.estimatedPaymentDate.eq((Object)query.getEstimatedPaymentDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentApplyId())) {
            list.add(this.qdo.paymentApplyId.eq((Object)query.getPaymentApplyId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractId())) {
            list.add(this.qdo.contractId.eq((Object)query.getContractId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractNo())) {
            list.add(this.qdo.contractNo.eq((Object)query.getContractNo()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentStatus())) {
            list.add(this.qdo.paymentStatus.eq((Object)query.getPaymentStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getWriteoffStatus())) {
            list.add(this.qdo.writeoffStatus.eq((Object)query.getWriteoffStatus()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getMilestone())) {
            list.add(this.qdo.milestone.eq((Object)query.getMilestone()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getDocType())) {
            list.add(this.qdo.docType.eq((Object)query.getDocType()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPaymentDate())) {
            list.add(this.qdo.paymentDate.eq((Object)query.getPaymentDate()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getContractNode())) {
            list.add(this.qdo.contractNode.eq((Object)query.getContractNode()));
        }
        return ExpressionUtils.allOf(list);
    }

    public PurchasePaymentPlanVO queryByKey(Long id) {
        JPAQuery<PurchasePaymentPlanVO> jpaQuery = this.getJpaQuerySelect();
        jpaQuery.where((Predicate)this.qdo.id.eq((Object)id));
        jpaQuery.where((Predicate)this.qdo.deleteFlag.eq((Object)0));
        return (PurchasePaymentPlanVO)jpaQuery.fetchFirst();
    }

    public List<PurchasePaymentPlanVO> queryListDynamic(PurchasePaymentPlanQuery query) {
        JPAQuery<PurchasePaymentPlanVO> jpaQuery = this.getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    public PagingVO<PurchasePaymentPlanVO> queryPaging(PurchasePaymentPlanQuery query) {
        long total = this.count(query);
        if (total == 0L) {
            return PagingVO.empty();
        }
        JPAQuery<PurchasePaymentPlanVO> jpaQuery = this.getJpaQueryWhere(query);
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(total).build();
    }

    public PurchasePaymentPlanDO save(PurchasePaymentPlanDO ado) {
        return (PurchasePaymentPlanDO)this.repo.save(ado);
    }

    public List<PurchasePaymentPlanDO> saveAll(List<PurchasePaymentPlanDO> dos) {
        return this.repo.saveAll(dos);
    }

    @Transactional
    public long updateByKeyDynamic(PurchasePaymentPlanPayload payload) {
        List nullFields;
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).where(new Predicate[]{this.qdo.id.eq((Object)payload.getId())});
        if (payload.getId() != null) {
            update.set(this.qdo.id, (Object)payload.getId());
        }
        if (payload.getPaymentStage() != null) {
            update.set((Path)this.qdo.paymentStage, (Object)payload.getPaymentStage());
        }
        if (payload.getPaymentAmt() != null) {
            update.set(this.qdo.paymentAmt, (Object)payload.getPaymentAmt());
        }
        if (payload.getCurrentPaymentAmt() != null) {
            update.set(this.qdo.currentPaymentAmt, (Object)payload.getCurrentPaymentAmt());
        }
        if (payload.getPaymentProportion() != null) {
            update.set(this.qdo.paymentProportion, (Object)payload.getPaymentProportion());
        }
        if (payload.getEstimatedPaymentDate() != null) {
            update.set(this.qdo.estimatedPaymentDate, (Object)payload.getEstimatedPaymentDate());
        }
        if (payload.getPaymentApplyId() != null) {
            update.set(this.qdo.paymentApplyId, (Object)payload.getPaymentApplyId());
        }
        if (payload.getContractId() != null) {
            update.set(this.qdo.contractId, (Object)payload.getContractId());
        }
        if (payload.getContractNo() != null) {
            update.set((Path)this.qdo.contractNo, (Object)payload.getContractNo());
        }
        if (payload.getPaymentStatus() != null) {
            update.set((Path)this.qdo.paymentStatus, (Object)payload.getPaymentStatus());
        }
        if (payload.getWriteoffStatus() != null) {
            update.set((Path)this.qdo.writeoffStatus, (Object)payload.getWriteoffStatus());
        }
        if (payload.getMilestone() != null) {
            update.set(this.qdo.milestone, (Object)payload.getMilestone());
        }
        if (payload.getDocType() != null) {
            update.set((Path)this.qdo.docType, (Object)payload.getDocType());
        }
        if (payload.getPaymentDate() != null) {
            update.set(this.qdo.paymentDate, (Object)payload.getPaymentDate());
        }
        if (payload.getContractNode() != null) {
            update.set(this.qdo.contractNode, (Object)payload.getContractNode());
        }
        if ((nullFields = payload.getNullFields()) != null && nullFields.size() > 0) {
            if (nullFields.contains("id")) {
                update.setNull(this.qdo.id);
            }
            if (nullFields.contains("paymentStage")) {
                update.setNull((Path)this.qdo.paymentStage);
            }
            if (nullFields.contains("paymentAmt")) {
                update.setNull(this.qdo.paymentAmt);
            }
            if (nullFields.contains("currentPaymentAmt")) {
                update.setNull(this.qdo.currentPaymentAmt);
            }
            if (nullFields.contains("paymentProportion")) {
                update.setNull(this.qdo.paymentProportion);
            }
            if (nullFields.contains("estimatedPaymentDate")) {
                update.setNull(this.qdo.estimatedPaymentDate);
            }
            if (nullFields.contains("paymentApplyId")) {
                update.setNull(this.qdo.paymentApplyId);
            }
            if (nullFields.contains("contractId")) {
                update.setNull(this.qdo.contractId);
            }
            if (nullFields.contains("contractNo")) {
                update.setNull((Path)this.qdo.contractNo);
            }
            if (nullFields.contains("paymentStatus")) {
                update.setNull((Path)this.qdo.paymentStatus);
            }
            if (nullFields.contains("writeoffStatus")) {
                update.setNull((Path)this.qdo.writeoffStatus);
            }
            if (nullFields.contains("milestone")) {
                update.setNull(this.qdo.milestone);
            }
            if (nullFields.contains("docType")) {
                update.setNull((Path)this.qdo.docType);
            }
            if (nullFields.contains("paymentDate")) {
                update.setNull(this.qdo.paymentDate);
            }
            if (nullFields.contains("contractNode")) {
                update.setNull(this.qdo.contractNode);
            }
        }
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.id.in(keys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public long logicalDeleteByContractIds(List<Long> contractIdkeys) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.contractId.in(contractIdkeys)});
        SqlUtil.updateCommonJpaQuery(update, this.qdo._super);
        return update.execute();
    }

    public List<PurchasePaymentPlanVO> findListByConNo(String docNo, Boolean applyIdIsNull) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PurchasePaymentPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.paymentStage, this.qdo.estimatedPaymentDate, this.qdo.currentPaymentAmt, this.qdo.paymentAmt, this.qdo.docType, this.qdo.contractNo, this.qdo.milestone, this.qResActivityDO.actName.as("milestoneName"), this.qdo.contractNode, this.qConReceivablePlanDO.receStage.as("contractNodeName")})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qResActivityDO)).on((Predicate)this.qdo.milestone.eq(this.qResActivityDO.id).and((Predicate)this.qResActivityDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qConReceivablePlanDO)).on((Predicate)this.qdo.contractNode.eq(this.qConReceivablePlanDO.id).and((Predicate)this.qConReceivablePlanDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.contractNo.eq((Object)docNo));
        if (applyIdIsNull.booleanValue()) {
            jpaQuery.where((Predicate)this.qdo.paymentApplyId.isNull());
        }
        return jpaQuery.fetch();
    }

    public List<PurchasePaymentPlanVO> queryListByPaymentApplyId(Long paymentApplyId) {
        JPAQuery jpaQuery = (JPAQuery)this.getJpaQuerySelect().where((Predicate)this.qdo.paymentApplyId.eq((Object)paymentApplyId));
        return jpaQuery.fetch();
    }

    public void resettingPlanByPaymentId(Long paymentApplyId) {
        JPAUpdateClause resetting = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.currentPaymentAmt, (Object)BigDecimal.ZERO).setNull(this.qdo.paymentApplyId).where(new Predicate[]{this.qdo.paymentApplyId.eq((Object)paymentApplyId)});
        resetting.execute();
    }

    public void updatePlan(PurchasePaymentPlanPayload purchasePaymentPlanPayload) {
        BigDecimal currentPayment = purchasePaymentPlanPayload.getCurrentPaymentAmt() == null ? BigDecimal.ZERO : purchasePaymentPlanPayload.getCurrentPaymentAmt();
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.currentPaymentAmt, (Object)currentPayment).set((Path)this.qdo.docType, (Object)purchasePaymentPlanPayload.getDocType()).set(this.qdo.paymentDate, (Object)purchasePaymentPlanPayload.getPaymentDate()).set(this.qdo.paymentApplyId, (Object)purchasePaymentPlanPayload.getPaymentApplyId()).where(new Predicate[]{this.qdo.id.eq((Object)purchasePaymentPlanPayload.getId())});
        update.execute();
    }

    public void deleteByPaymentId(Long id) {
        JPAUpdateClause update = this.jpaQueryFactory.update((EntityPath)this.qdo).set(this.qdo.deleteFlag, (Object)1).where(new Predicate[]{this.qdo.paymentApplyId.eq((Object)id)});
        update.execute();
    }

    public PagingVO<LatePaymentPlanVO> findLatePaymentPlanList(LatePaymentPlanQuery query) {
        JPAQuery jpaQuery = (JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(LatePaymentPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qPurchaseContractManagerDO.id.as("purchaseConId"), this.qPurchaseContractManagerDO.purchaseContractNo.as("purchaseConNo"), this.qPurchaseContractManagerDO.purchaseContractName.as("purchaseConName"), this.qPurchaseContractManagerDO.supplierBookId, this.qPurchaseContractManagerDO.purchaseInchargeResId, this.qdo.paymentStage, this.qdo.currentPaymentAmt, this.qdo.paymentProportion, this.qdo.estimatedPaymentDate, this.qdo.remark, this.qConReceivablePlanDO.receStatus.as("receivableStatus"), this.qConReceivablePlanDO.actualRecvAmt, this.qResActivityDO.actName.as("milestoneName")})).from((EntityPath)this.qdo);
        ((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)jpaQuery.leftJoin((EntityPath)this.qPurchaseContractManagerDO)).on((Predicate)this.qdo.contractId.eq(this.qPurchaseContractManagerDO.id).and((Predicate)this.qPurchaseContractManagerDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qConReceivablePlanDO)).on((Predicate)this.qdo.contractNode.eq(this.qConReceivablePlanDO.id).and((Predicate)this.qConReceivablePlanDO.deleteFlag.eq((Object)0)))).leftJoin((EntityPath)this.qResActivityDO)).on((Predicate)this.qdo.milestone.eq(this.qResActivityDO.id).and((Predicate)this.qResActivityDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qdo.paymentApplyId.isNull().and((Predicate)this.qPurchaseContractManagerDO.id.isNotNull()));
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseConNoOrName())) {
            jpaQuery.where((Predicate)this.qPurchaseContractManagerDO.purchaseContractNo.like("%" + query.getPurchaseConNoOrName() + "%").or((Predicate)this.qPurchaseContractManagerDO.purchaseContractName.like("%" + query.getPurchaseConNoOrName() + "%")));
        }
        if (!ObjectUtils.isEmpty((Object)query.getSupplierBookId())) {
            jpaQuery.where((Predicate)this.qPurchaseContractManagerDO.supplierBookId.eq((Object)query.getSupplierBookId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getPurchaseInchargeResId())) {
            jpaQuery.where((Predicate)this.qPurchaseContractManagerDO.purchaseInchargeResId.eq((Object)query.getPurchaseInchargeResId()));
        }
        if (!ObjectUtils.isEmpty((Object)query.getEstimatedPaymentDateStart()) && !ObjectUtils.isEmpty((Object)query.getEstimatedPaymentDateEnd())) {
            jpaQuery.where((Predicate)this.qdo.estimatedPaymentDate.between((Comparable)query.getEstimatedPaymentDateStart(), (Comparable)query.getEstimatedPaymentDateEnd()));
        }
        if (query.getLateFlag().booleanValue()) {
            jpaQuery.where((Predicate)this.qdo.estimatedPaymentDate.before((Comparable)LocalDate.now()));
        } else {
            jpaQuery.where((Predicate)this.qdo.estimatedPaymentDate.before((Comparable)LocalDate.now()).or((Predicate)this.qdo.estimatedPaymentDate.isNull()));
        }
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    public PagingVO<PurchasePaymentPlanVO> findPlanListByAgreementNo(PurchaseAgreementPaymentQuery query) {
        if (ObjectUtils.isEmpty((Object)query.getAgreementNo())) {
            return null;
        }
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)Projections.bean(PurchasePaymentPlanVO.class, (Expression[])new Expression[]{this.qdo.id, this.qdo.paymentStage, this.qdo.currentPaymentAmt, this.qdo.paymentAmt, this.qdo.estimatedPaymentDate, this.qdo.paymentStatus, this.qdo.paymentDate, this.qdo.paymentApplyId, this.qPurchasePaymentDO.paymentNo.as("paymentApplyNo"), this.qPurchasePaymentDO.paymentApplicationType, this.qPurchasePaymentDO.state.as("payApplyStatus"), this.qPurchasePaymentDO.payDate})).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPurchasePaymentDO)).on((Predicate)this.qdo.paymentApplyId.eq(this.qPurchasePaymentDO.id).and((Predicate)this.qPurchasePaymentDO.deleteFlag.eq((Object)0)))).where((Predicate)this.qPurchasePaymentDO.docNo.eq((Object)query.getAgreementNo()).and((Predicate)this.qPurchasePaymentDO.docType.eq((Object)PurchasePaymentEnum.PaymentDocType.AGREEMENT.getCode())));
        if (query.getIsIgnoreWriteOff().booleanValue()) {
            jpaQuery.where((Predicate)this.qPurchasePaymentDO.paymentApplicationType.ne((Object)PurchasePaymentEnum.PaymentType.ADVANCE_PAY_WRITE_OFF.getCode()).or((Predicate)this.qPurchasePaymentDO.paymentApplicationType.isNull()));
        }
        List result = ((JPAQuery)((JPAQuery)jpaQuery.offset(query.getPageRequest().getOffset())).limit((long)query.getPageRequest().getPageSize())).fetch();
        return PagingVO.builder().records(result).total(jpaQuery.fetchCount()).build();
    }

    public List<PurchasePaymentPlanVO> queryListByConId(Long purConId, Boolean isIgnoreWriteOff) {
        JPAQuery<PurchasePaymentPlanVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.contractId.eq((Object)purConId).and((Predicate)this.qdo.contractNo.like("PCN%")));
        if (isIgnoreWriteOff.booleanValue()) {
            jpaQuerySelect.where((Predicate)this.qPurchasePaymentDO.paymentApplicationType.ne((Object)PurchasePaymentEnum.PaymentType.ADVANCE_PAY_WRITE_OFF.getCode()).or((Predicate)this.qPurchasePaymentDO.paymentApplicationType.isNull()));
        }
        return jpaQuerySelect.fetch();
    }

    public List<PurchasePaymentPlanVO> findPlanListByConOrAgreementNoAndPrePaymentNo(String conOrAgreementNo, String prePaymentNo) {
        JPAQuery<PurchasePaymentPlanVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.contractNo.eq((Object)conOrAgreementNo).and((Predicate)this.qPurchasePaymentDO.paymentApplicationType.eq((Object)PurchasePaymentEnum.PaymentType.ADVANCE_PAY.getCode())).and((Predicate)this.qPurchasePaymentDO.paymentNo.eq((Object)prePaymentNo)));
        return jpaQuerySelect.fetch();
    }

    public List<PurchasePaymentPlanVO> queryListByPrePaymentPlanId(List<Long> prePaymentPlanId) {
        JPAQuery<PurchasePaymentPlanVO> jpaQuerySelect = this.getJpaQuerySelect();
        jpaQuerySelect.where((Predicate)this.qdo.prePaymentPlanId.in(prePaymentPlanId));
        return jpaQuerySelect.fetch();
    }

    public List<Tuple> findWriteOffAmtByPrePaymentPlanIdIn(List<Long> prePaymentPlanIds) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select(new Expression[]{this.qdo.prePaymentPlanId, this.qdo.currentPaymentAmt.sum()}).from((EntityPath)this.qdo)).where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qdo.prePaymentPlanId.in(prePaymentPlanIds)))).groupBy(this.qdo.prePaymentPlanId);
        return jpaQuery.fetch();
    }

    public BigDecimal findWriteOffAmtByPrePaymentNo(String prePaymentNo) {
        JPAQuery jpaQuery = (JPAQuery)((JPAQuery)((JPAQuery)((JPAQuery)this.jpaQueryFactory.select((Expression)this.qdo.currentPaymentAmt.sum()).from((EntityPath)this.qdo)).leftJoin((EntityPath)this.qPurchasePaymentDO)).on((Predicate)this.qdo.paymentApplyId.eq(this.qPurchasePaymentDO.id))).where((Predicate)this.qdo.deleteFlag.eq((Object)0).and((Predicate)this.qPurchasePaymentDO.deleteFlag.eq((Object)0)).and((Predicate)this.qPurchasePaymentDO.state.eq((Object)PurchasePaymentEnum.PaymentStatus.APPROVED.getCode())).and((Predicate)this.qPurchasePaymentDO.prePaymentNo.eq((Object)prePaymentNo)));
        return (BigDecimal)jpaQuery.fetchOne();
    }

    public PurchasePaymentPlanDAO(JPAQueryFactory jpaQueryFactory, PurchasePaymentPlanRepo repo) {
        this.jpaQueryFactory = jpaQueryFactory;
        this.repo = repo;
    }
}

