/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.purchase.purenum;

import com.elitesland.tw.tw5.server.common.TwException;

public interface PurchasePaymentEnum {

    public static enum WithdrawStatus implements PurchasePaymentEnum
    {
        PAID("PAID", "\u5df2\u4ed8\u6b3e"),
        APPROVED("APPROVED", "\u4ed8\u6b3e\u5df2\u5ba1\u6279"),
        APPROVING("APPROVING", "\u4ed8\u6b3e\u5ba1\u6279\u4e2d");

        private final String code;
        private final String desc;

        private WithdrawStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum AccountModuleType implements PurchasePaymentEnum
    {
        LEDGER("ledger", " \u603b\u8d26"),
        PAYABLE("payable", "\u5e94\u4ed8");

        private final String code;
        private final String desc;

        private AccountModuleType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum CurrCodeEnum implements PurchasePaymentEnum
    {
        CNY("CNY", "\u4eba\u6c11\u5e01");

        private final String code;
        private final String desc;

        private CurrCodeEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayNusage {
        NUSAGE1("\u62a5\u9500\u8f6c\u8d26"),
        NUSAGE2("\u9884\u4ed8\u6b3e\u652f\u4ed8"),
        NUSAGE3("\u5408\u540c\u4ed8\u6b3e");

        private final String desc;

        private PayNusage(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayHistDtl implements PurchasePaymentEnum
    {
        DTL1("\u8d22\u52a1\u786e\u8ba4\u7ebf\u4e0b\u652f\u4ed8"),
        DTL2("\u6536\u6b3e\u8d26\u53f7\u4fee\u6539"),
        DTL3("\u518d\u6b21\u63d0\u4ea4\u7f51\u94f6"),
        DTL4("\u8d22\u52a1\u63d0\u4ea4\u7f51\u94f6"),
        DTL5("\u8d22\u52a1\u4fee\u6539\u652f\u4ed8\u7528\u9014"),
        DTL6("\u624b\u52a8\u652f\u4ed8"),
        DTL7("\u7f51\u94f6\u652f\u4ed8");

        private final String desc;

        private PayHistDtl(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayHistType implements PurchasePaymentEnum
    {
        HISTTYPE1("\u7ebf\u4e0b\u652f\u4ed8"),
        HISTTYPE2("\u8d26\u53f7\u4fee\u6539"),
        HISTTYPE3("\u7f51\u94f6\u518d\u6b21\u63d0\u4ea4"),
        HISTTYPE4("\u7f51\u94f6\u63d0\u4ea4"),
        HISTTYPE5("\u4fee\u6539\u652f\u4ed8\u7528\u9014"),
        HISTTYPE6("\u652f\u4ed8\u65b9\u5f0f\u4fee\u6539");

        private final String desc;

        private PayHistType(String desc) {
            this.desc = desc;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayStlchnEnum implements PurchasePaymentEnum
    {
        HYPERNET("R", "\u5b9e\u65f6-\u8d85\u7f51"),
        FAST("Q", "\u5feb\u901f"),
        ORDINARY("G", "\u666e\u901a");

        private final String code;
        private final String desc;

        private PayStlchnEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum BankDocType implements PurchasePaymentEnum
    {
        PAY("PAY", "\u4ed8\u6b3e\u7533\u8bf7\u5355"),
        TRAN("TRAN", "\u8d44\u91d1\u5212\u62e8\u7533\u8bf7\u5355"),
        REIM("REIM", "\u62a5\u9500\u5355");

        private final String code;
        private final String desc;

        private BankDocType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayDocType implements PurchasePaymentEnum
    {
        REIM("REIM", "\u521b\u5efa"),
        CONTANT("CONTANT", "\u4ed8\u6b3e");

        private final String code;
        private final String desc;

        private PayDocType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayStatusDetailEnum implements PurchasePaymentEnum
    {
        SEND(1, "\u5f85\u53d1\u9001"),
        SELECT(2, "\u5f85\u67e5\u8be2"),
        PAYMENT(3, "\u5f85\u652f\u4ed8"),
        PAYIN(3, "\u652f\u4ed8\u4e2d"),
        SUCCESS(4, "\u6210\u529f"),
        FAIL(5, "\u5931\u8d25"),
        PAYRETURN(6, "\u652f\u4ed8\u9000\u7968");

        private final int code;
        private final String desc;

        private PayStatusDetailEnum(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaySystemEnum implements PurchasePaymentEnum
    {
        YES("Y", "\u6536\u65b9\u4e3a\u62db\u5546\u94f6\u884c\u8d26\u53f7"),
        NO("N", "\u6536\u65b9\u4e3a\u4ed6\u884c\u8d26\u6237");

        private final String code;
        private final String desc;

        private PaySystemEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum OrderTypeEnum implements PurchasePaymentEnum
    {
        REIM(1, "\u4ee3\u53d1"),
        CONTANT(2, "\u652f\u4ed8");

        private final Integer code;
        private final String desc;

        private OrderTypeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayStatusEnum implements PurchasePaymentEnum
    {
        SUCCESS("S", "\u6210\u529f"),
        FAIL("F", "\u5931\u8d25"),
        REVOKE("C", "\u64a4\u9500"),
        EXPIRE("D", "\u8fc7\u671f"),
        VETO("R", "\u5426\u51b3"),
        PAYRETRUN("G", "\u9000\u7968"),
        PAYIN("Z", "\u652f\u4ed8\u4e2d");

        private final String code;
        private final String desc;

        private PayStatusEnum(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayBankFlag implements PurchasePaymentEnum
    {
        BANKFALG1(1, "\u5df2\u63d0\u4ea4"),
        BANKFALG2(2, "\u672a\u63d0\u4ea4");

        private final int code;
        private final String desc;

        private PayBankFlag(int code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public int getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PayModeEnum implements PurchasePaymentEnum
    {
        PAYCURRENCY(1, "\u7f51\u94f6\u652f\u4ed8"),
        PAYMANUAL(2, "\u624b\u52a8\u652f\u4ed8");

        private final Integer code;
        private final String desc;

        private PayModeEnum(Integer code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public Integer getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum AcceptanceMethod implements PurchasePaymentEnum
    {
        SALARY_CASH("salary_cash", "\u85aa\u8d44\u6210\u672c"),
        ATTRIBUTION_AGREEMENT("attribution_agreement", "\u53c2\u7167\u5f52\u5c5e\u534f\u8bae"),
        WITHDRAW("withdraw", "\u63d0\u73b0\u7533\u8bf7\u5355"),
        TASK("task", "\u4efb\u52a1\u5305"),
        SETTLEMENT("settlement", "\u7ed3\u7b97\u5355"),
        MILE_CON_NODE("mile_con_node", "\u91cc\u7a0b\u7891+\u5408\u540c\u8282\u70b9"),
        CON_NODE("con_node", "\u5408\u540c\u8282\u70b9"),
        MILESTONE("milestone", "\u91cc\u7a0b\u7891");

        private final String code;
        private final String desc;

        private AcceptanceMethod(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static AcceptanceMethod match(String code) {
            for (AcceptanceMethod acceptanceMethod : AcceptanceMethod.values()) {
                if (!acceptanceMethod.getCode().equals(code)) continue;
                return acceptanceMethod;
            }
            return null;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaymentPlanPayStatus implements PurchasePaymentEnum
    {
        PARTIAL_PAYMENT("partial_payment", "\u90e8\u5206\u4ed8\u6b3e"),
        UNPAID("unpaid", "\u672a\u4ed8\u6b3e"),
        PAID("paid", "\u5df2\u5b8c\u6210");

        private final String code;
        private final String desc;

        private PaymentPlanPayStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaymentSlipStatus implements PurchasePaymentEnum
    {
        NEW("new", "\u65b0\u5efa"),
        READY("ready", "\u5f85\u5e94\u4ed8\u4f1a\u8ba1\u63d0\u4ea4"),
        FINANCE_MANAGER_APPR("finance_manager_appr", "\u8d22\u52a1\u7ecf\u7406\u5ba1\u6838"),
        CFO_APPR("cfo_appr", "CFO\u5ba1\u6838"),
        CASHIER_APPR("cashier_appr", "\u51fa\u7eb3\u5ba1\u6838"),
        PAID("paid", "\u5df2\u4ed8\u6b3e"),
        PAYMENT_ACCOUNT("payment_account", "\u4ed8\u6b3e\u5f85\u8bb0\u8d26"),
        FINANCE_REJECTED("finance_rejected", "\u8d22\u52a1\u7ecf\u7406\u9a73\u56de"),
        CASHIER_TO_SUBMIT("cashier_to_submit", "\u51fa\u7eb3\u9a73\u56de\u81f3\u5e94\u4ed8\u4f1a\u8ba1"),
        CASHIER_TO_FINANCE("cashier_to_finance", "\u51fa\u7eb3\u9a73\u56de\u81f3\u8d22\u52a1\u7ecf\u7406");

        private final String code;
        private final String desc;

        private PaymentSlipStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaymentStatus implements PurchasePaymentEnum
    {
        CREATE("create", "\u65b0\u5efa"),
        APPROVING("approving", "\u5ba1\u6279\u4e2d"),
        APPROVED("approved", "\u5df2\u5ba1\u6279"),
        PARTIAL_PAY("partial_pay", "\u90e8\u5206\u4ed8\u6b3e"),
        PAID("paid", "\u5df2\u4ed8\u6b3e"),
        WRITE_OFF_PROCESS("write_off_process", "\u6838\u9500\u4e2d"),
        WRITE_OFF_PART("write_off_part", "\u90e8\u5206\u6838\u9500"),
        WRITTEN_OFF("written_off", "\u5df2\u6838\u9500"),
        CLOSE("close", "\u5173\u95ed");

        private final String code;
        private final String desc;

        private PaymentStatus(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum AgreementType implements PurchasePaymentEnum
    {
        OTHER("other", "\u5176\u4ed6\u7c7b\u534f\u8bae"),
        ENTITY_OUTSOURCING("entity_outsourcing", "\u4e2a\u4f53\u8d44\u6e90\u5916\u5305"),
        PUBLIC_OUTSOURCING("public_outsourcing", "\u5bf9\u516c\u8d44\u6e90\u5916\u5305"),
        CON_AGREEMENT("con_agreement", "\u5408\u540c\u534f\u8bae");

        private final String code;
        private final String desc;

        private AgreementType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static AgreementType match(String code) {
            for (AgreementType agreementType : AgreementType.values()) {
                if (!agreementType.getCode().equals(code)) continue;
                return agreementType;
            }
            throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u91c7\u8d2d\u534f\u8bae\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaymentDocType implements PurchasePaymentEnum
    {
        CONTRACT("contract", "\u91c7\u8d2d\u5408\u540c"),
        AGREEMENT("agreement", "\u91c7\u8d2d\u534f\u8bae"),
        SALARY_PAYMENT("advance_pay", "\u85aa\u8d44\u6210\u672c\u5355"),
        OPPORTUNITY("opportunity", "\u5546\u673a"),
        TENTATIVE("tentative", "\u7a7a");

        private final String code;
        private final String desc;

        private PaymentDocType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PaymentDocType match(String paymentDocTypeCode) {
            if (paymentDocTypeCode == null) {
                return TENTATIVE;
            }
            for (PaymentDocType paymentDocType : PaymentDocType.values()) {
                if (!paymentDocType.getCode().equals(paymentDocTypeCode)) continue;
                return paymentDocType;
            }
            throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u5173\u8054\u5355\u636e\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaymentType implements PurchasePaymentEnum
    {
        CONTRACT("contract", "\u6309\u7167\u91c7\u8d2d\u5408\u540c\u4ed8\u6b3e"),
        AGREEMENT("agreement", "\u6309\u7167\u91c7\u8d2d\u534f\u8bae\u4ed8\u6b3e"),
        ADVANCE_PAY("advance_pay", "\u9884\u4ed8\u6b3e"),
        ADVANCE_PAY_WRITE_OFF("advance_pay_write_off", "\u9884\u4ed8\u6b3e\u6838\u9500"),
        SALARY_PAYMENT("salary_payment", "\u85aa\u916c\u798f\u5229\u652f\u4ed8"),
        OTHER_PAYMENT("other_payment", "\u5176\u4ed6\u4ed8\u6b3e\u7533\u8bf7");

        private final String code;
        private final String desc;

        private PaymentType(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PaymentType match(String code) {
            for (PaymentType paymentType : PaymentType.values()) {
                if (!paymentType.getCode().equals(code)) continue;
                return paymentType;
            }
            throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u7684\u4ed8\u6b3e\u5355\u7c7b\u578b\uff0c\u8bf7\u68c0\u67e5");
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }

    public static enum PaymentProcDefKey implements PurchasePaymentEnum
    {
        PUR_TRADE_SERVICE("PUR_TRADE_SERVICE", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u670d\u52a1\u8d38\u6613\u6d41\u7a0b"),
        PUR_TRADE_PRODUCT("PUR_TRADE_PRODUCT", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u4ea7\u54c1\u8d38\u6613\u6d41\u7a0b"),
        PUR_OUTSOURCING("PUR_OUTSOURCING", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u5916\u5305\u6d41\u7a0b"),
        PUR_BID_SECURITY("PUR_BID_SECURITY", "\u91c7\u8d2d\u5408\u540c\u6295\u6807\u4fdd\u8bc1\u91d1\u6d41\u7a0b"),
        PUR_HOUSE_RENTAL("PUR_HOUSE_RENTAL", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u623f\u5c4b\u79df\u8d41\u6d41\u7a0b"),
        PUR_MIS_PURCHASE("PUR_MIS_PURCHASE", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u6742\u9879\u91c7\u8d2d\u6d41\u7a0b"),
        PUR_PUBLIC_OUTSOURCE("PUR_PUBLIC_OUTSOURCE", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u5bf9\u516c\u8d44\u6e90\u5916\u5305\u6d41\u7a0b"),
        PUR_MARKET("PUR_MARKET", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u5e02\u573a\u6e20\u9053\u6d41\u7a0b"),
        PUR_RESEARCH("PUR_RESEARCH", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u7814\u53d1\u91c7\u8d2d\u6d41\u7a0b"),
        PUR_OPERATE("PUR_OPERATE", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u884c\u653f\u8fd0\u8425\u7c7b\u91c7\u8d2d\u6d41\u7a0b"),
        PUR_COMPANY("PUR_COMPANY", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u516c\u53f8\u7ba1\u7406\u7c7b\u6d41\u7a0b"),
        PUR_RESOURCE("PUR_RESOURCE", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u8d44\u6e90\u8d4b\u80fd\u7c7b\u6d41\u7a0b"),
        PUR_AGREEMENT("PUR_AGREEMENT", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u884c\u653f\u8fd0\u8425\u7c7b\u91c7\u8d2d\uff08\u534f\u8bae\uff09\u6d41\u7a0b"),
        PUR_SALARY_PAYMENT("PUR_SALARY_PAYMENT", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u85aa\u8d44\u798f\u5229\u6d41\u7a0b"),
        PUR_ADVANCE_PAY_W_O("PUR_ADVANCE_PAY_W_O", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u9884\u4ed8\u6b3e\u6838\u9500\u6d41\u7a0b"),
        PUR_ADVANCE_PAY_ONE("PUR_ADVANCE_PAY_ONE", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u9884\u4ed8\u6b3e\uff08\u5408\u540c\u91c7\u8d2d\u53ca\u516c\u53f8\u7ba1\u7406\u7c7b\u91c7\u8d2d\uff09\u6d41\u7a0b"),
        PUR_ADVANCE_PAY_TWO("PUR_ADVANCE_PAY_TWO", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u9884\u4ed8\u6b3e\u6d41\u7a0b"),
        PUR_ADVANCE_PAY_T("PUR_ADVANCE_PAY_T", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u9884\u4ed8\u6b3e\u6d41\u7a0b\uff08\u9879\u76ee\u91c7\u8d2d\u9884\u4ed8\u6b3e\uff09"),
        PUR_ADVANCE_PAY_FOUR("PUR_ADVANCE_PAY_FOUR", "\u4ed8\u6b3e\u7533\u8bf7\u5355\u9884\u4ed8\u6b3e\u6d41\u7a0b\uff08\u884c\u653f\u7c7b\u9884\u4ed8\u6b3e\uff09");

        private final String code;
        private final String desc;

        private PaymentProcDefKey(String code, String desc) {
            this.code = code;
            this.desc = desc;
        }

        public static PaymentProcDefKey match(String procCode) {
            for (PaymentProcDefKey paymentProcDefKey : PaymentProcDefKey.values()) {
                if (!paymentProcDefKey.getCode().equals(procCode)) continue;
                return paymentProcDefKey;
            }
            throw TwException.error("", "\u672a\u627e\u5230\u76f8\u5173\u6d41\u7a0b\uff0c\u8bf7\u68c0\u67e5\uff01");
        }

        public String getCode() {
            return this.code;
        }

        public String getDesc() {
            return this.desc;
        }
    }
}

