/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.salecon.service;

import cn.hutool.extra.spring.SpringUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterBuilder;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.partner.identity.service.BusinessCustomerInfoService;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConPurchaseDemandDPayload;
import com.elitesland.tw.tw5.api.prd.salecon.query.ConPurchaseDemandDQuery;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConPurchaseDemandDService;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConPurchaseDemandDVO;
import com.elitesland.tw.tw5.server.common.QueryHelp;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.util.PageUtil;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.partner.constants.BusinessPartnerIdentityEnum;
import com.elitesland.tw.tw5.server.prd.product.entity.PrdProductClassDO;
import com.elitesland.tw.tw5.server.prd.product.repo.PrdProductClassRepo;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConPurchaseDemandDConvert;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConPurchaseDemandDDAO;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConPurchaseDemandDDO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandDRepo;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConPurchaseDemandRepo;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class ConPurchaseDemandDServiceImpl
extends BaseServiceImpl
implements ConPurchaseDemandDService {
    private static final Logger log = LoggerFactory.getLogger(ConPurchaseDemandDServiceImpl.class);
    private final ConPurchaseDemandDRepo conPurchaseDemandDRepo;
    private final ConPurchaseDemandRepo conPurchaseDemandRepo;
    private final ConPurchaseDemandDDAO conPurchaseDemandDDAO;
    private final CacheUtil cacheUtil;
    private final PrdProductClassRepo productClassRepo;
    private final BusinessCustomerInfoService businessCustomerInfoService;
    private final UdcUtil udcUtil;

    public PagingVO<ConPurchaseDemandDVO> paging(ConPurchaseDemandDQuery query) {
        Page page = this.conPurchaseDemandDRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), (Pageable)query.getPageRequest());
        return PageUtil.toPageVo(page.map(ConPurchaseDemandDConvert.INSTANCE::toVo));
    }

    public PagingVO<ConPurchaseDemandDVO> queryPaging(ConPurchaseDemandDQuery query) {
        SaleConContractQuery saleConContractQuery = new SaleConContractQuery();
        SaleConContractService conContractService = (SaleConContractService)SpringUtil.getBean(SaleConContractService.class);
        conContractService.getPermissionParams(saleConContractQuery);
        List orgIdsByPermission = saleConContractQuery.getOrgIdsByPermission();
        List userIdsByPermission = saleConContractQuery.getUserIdsByPermission();
        query.setOrgIdsByPermission(orgIdsByPermission);
        query.setUserIdsByPermission(userIdsByPermission);
        PagingVO<ConPurchaseDemandDVO> conPurchaseDemandDVOPagingVO = this.conPurchaseDemandDDAO.queryPaging(query);
        this.transferList(conPurchaseDemandDVOPagingVO.getRecords());
        return conPurchaseDemandDVOPagingVO;
    }

    public List<ConPurchaseDemandDVO> queryList(ConPurchaseDemandDQuery query) {
        List<ConPurchaseDemandDVO> dvoList = ConPurchaseDemandDConvert.INSTANCE.toVoList(this.conPurchaseDemandDRepo.findAll((Specification & Serializable)(root, criteriaQuery, criteriaBuilder) -> QueryHelp.getPredicate(root, query, criteriaBuilder), query.getPageRequest().getSort()));
        dvoList.forEach(this::transfer);
        return dvoList;
    }

    public List<ConPurchaseDemandDVO> queryListDynamic(ConPurchaseDemandDQuery query) {
        List<ConPurchaseDemandDVO> dvoList = this.conPurchaseDemandDDAO.queryListDynamic(query);
        dvoList.forEach(this::transfer);
        return dvoList;
    }

    public ConPurchaseDemandDVO queryByKey(Long key) {
        ConPurchaseDemandDDO entity = this.conPurchaseDemandDRepo.findById(key).orElseGet(ConPurchaseDemandDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConPurchaseDemandDVO vo = ConPurchaseDemandDConvert.INSTANCE.toVo(entity);
        this.transfer(vo);
        return vo;
    }

    @Transactional(rollbackFor={Exception.class})
    public ConPurchaseDemandDVO insert(ConPurchaseDemandDPayload payload) {
        ConPurchaseDemandDDO entityDo = ConPurchaseDemandDConvert.INSTANCE.toDo(payload);
        entityDo.setDemandStatus("CREATE");
        this.countMoney(entityDo);
        this.conPurchaseDemandRepo.updateRemark(entityDo.getPurDemandId());
        return ConPurchaseDemandDConvert.INSTANCE.toVo((ConPurchaseDemandDDO)this.conPurchaseDemandDRepo.save(entityDo));
    }

    @Transactional(rollbackFor={Exception.class})
    public ConPurchaseDemandDVO update(ConPurchaseDemandDPayload payload) {
        ConPurchaseDemandDDO entity = this.conPurchaseDemandDRepo.findById(payload.getId()).orElseGet(ConPurchaseDemandDDO::new);
        Assert.notNull((Object)entity.getId(), (String)"\u4e0d\u5b58\u5728");
        ConPurchaseDemandDDO entityDo = ConPurchaseDemandDConvert.INSTANCE.toDo(payload);
        this.countMoney(entityDo);
        entity.copy(entityDo);
        this.conPurchaseDemandRepo.updateRemark(entityDo.getPurDemandId());
        return ConPurchaseDemandDConvert.INSTANCE.toVo((ConPurchaseDemandDDO)this.conPurchaseDemandDRepo.save(entity));
    }

    @Transactional(rollbackFor={Exception.class})
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            this.conPurchaseDemandDDAO.deleteSoft(keys);
        }
    }

    public List<ConPurchaseDemandDVO> queryByPurDemandId(Long purDemandId) {
        List<ConPurchaseDemandDVO> dvoList = this.conPurchaseDemandDDAO.queryByPurDemandId(purDemandId);
        dvoList.forEach(this::transfer);
        return dvoList;
    }

    public void downloadPurDemand(HttpServletResponse response, ConPurchaseDemandDQuery query) {
        try {
            log.info("=============================\u5f00\u59cb\u67e5\u8be2=======================================");
            PagingVO<ConPurchaseDemandDVO> paging = this.queryPaging(query);
            log.info("=============================\u7ed3\u675f\u67e5\u8be2=======================================");
            List records = paging.getRecords();
            this.download(this.udcUtil.translateList(records), response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void download(List<ConPurchaseDemandDVO> records, HttpServletResponse response) throws IOException {
        boolean order = true;
        String sheetName = "\u91c7\u8d2d\u9700\u6c42\u6570\u636e";
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        response.setCharacterEncoding("utf-8");
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);
        ExcelWriterSheetBuilder sheet = ((ExcelWriterBuilder)EasyExcel.write((OutputStream)response.getOutputStream(), ConPurchaseDemandDVO.class).registerWriteHandler((WriteHandler)new LongestMatchColumnWidthStyleStrategy())).sheet(sheetName);
        ExcelUtil.excelHelper(sheet, ConPurchaseDemandDVO.class, null);
        sheet.doWrite(records);
    }

    public ConPurchaseDemandDDO countMoney(ConPurchaseDemandDDO entityDo) {
        Integer demandNum = entityDo.getDemandNum();
        if (demandNum == null) {
            demandNum = 0;
        }
        BigDecimal num = new BigDecimal(demandNum.toString());
        BigDecimal taxPrice = entityDo.getTaxPrice() == null ? BigDecimal.ZERO : entityDo.getTaxPrice();
        BigDecimal taxRate = entityDo.getTaxRate() == null ? BigDecimal.ZERO : entityDo.getTaxRate();
        BigDecimal taxAmt = num.multiply(taxPrice);
        BigDecimal notTaxAmt = taxAmt.divide(BigDecimal.ONE.add(taxRate), 3, 1);
        entityDo.setTaxAmt(taxAmt);
        entityDo.setNotTaxAmt(notTaxAmt);
        return entityDo;
    }

    private void transfer(ConPurchaseDemandDVO vo) {
        Map<Long, String> productClassMap = this.productClassRepo.findAll().stream().collect(Collectors.toMap(BaseModel::getId, PrdProductClassDO::getClassName, (key1, key2) -> key2));
        List businessCustomerSimpleVOS = this.businessCustomerInfoService.listSimple(BusinessPartnerIdentityEnum.SUPPLIER.getCode(), null);
        Map<Long, String> supplierMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getCustomerName() == null ? "" : n.getCustomerName(), (key1, key2) -> key2));
        Map<Long, String> supplierNoMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBusinessPartnerNo() == null ? "" : n.getBusinessPartnerNo(), (key1, key2) -> key2));
        Long main = vo.getProductClassId();
        Long sub = vo.getProductSubClassId();
        vo.setProductClass(productClassMap.get(main));
        vo.setProductSubClass(productClassMap.get(sub));
        Long supplierId = vo.getSupplierId();
        vo.setSupplierName(supplierMap.get(supplierId));
    }

    private void transferList(List<ConPurchaseDemandDVO> voList) {
        Map<Long, String> productClassMap = this.productClassRepo.findAll().stream().collect(Collectors.toMap(BaseModel::getId, PrdProductClassDO::getClassName, (key1, key2) -> key2));
        List businessCustomerSimpleVOS = this.businessCustomerInfoService.listSimple(BusinessPartnerIdentityEnum.SUPPLIER.getCode(), null);
        Map<Long, String> supplierMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getCustomerName() == null ? "" : n.getCustomerName(), (key1, key2) -> key2));
        Map<Long, String> supplierNoMap = businessCustomerSimpleVOS.stream().collect(Collectors.toMap(e -> e.getId() == null ? -999L : e.getId(), n -> n.getBusinessPartnerNo() == null ? "" : n.getBusinessPartnerNo(), (key1, key2) -> key2));
        voList.forEach(conPurchaseDemandDVO -> {
            conPurchaseDemandDVO.setProductClass((String)productClassMap.get(conPurchaseDemandDVO.getProductClassId()));
            conPurchaseDemandDVO.setProductSubClass((String)productClassMap.get(conPurchaseDemandDVO.getProductSubClassId()));
            Long supplierId = conPurchaseDemandDVO.getSupplierId();
            conPurchaseDemandDVO.setSupplierName((String)supplierMap.get(supplierId));
            if (supplierNoMap.get(supplierId) != null) {
                conPurchaseDemandDVO.setSupplierId(Long.valueOf(Long.parseLong((String)supplierNoMap.get(supplierId))));
            }
        });
    }

    public ConPurchaseDemandDServiceImpl(ConPurchaseDemandDRepo conPurchaseDemandDRepo, ConPurchaseDemandRepo conPurchaseDemandRepo, ConPurchaseDemandDDAO conPurchaseDemandDDAO, CacheUtil cacheUtil, PrdProductClassRepo productClassRepo, BusinessCustomerInfoService businessCustomerInfoService, UdcUtil udcUtil) {
        this.conPurchaseDemandDRepo = conPurchaseDemandDRepo;
        this.conPurchaseDemandRepo = conPurchaseDemandRepo;
        this.conPurchaseDemandDDAO = conPurchaseDemandDDAO;
        this.cacheUtil = cacheUtil;
        this.productClassRepo = productClassRepo;
        this.businessCustomerInfoService = businessCustomerInfoService;
        this.udcUtil = udcUtil;
    }
}

