/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.my.payload.TBusiCardApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.service.TBusiCardApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TBusiCardApplyVO;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/BUSI_CARD_APPLY/callBack"})
@Transactional
public class BusiCardApplyWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(BusiCardApplyWorkflowCallBackController.class);
    private final TBusiCardApplyService service;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(TaskAssigneePayload payload) {
        return null;
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        TBusiCardApplyPayload busiCardApplyPayload = new TBusiCardApplyPayload();
        busiCardApplyPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        TBusiCardApplyVO tBusiCardApplyVO = this.service.queryByKey(Long.valueOf(businessKey));
        if (tBusiCardApplyVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    busiCardApplyPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    busiCardApplyPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    busiCardApplyPayload.setDeleteFlag(Integer.valueOf(1));
                    busiCardApplyPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    break;
                }
                case REJECTED: {
                    busiCardApplyPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    busiCardApplyPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    busiCardApplyPayload.setApprovedTime(LocalDateTime.now());
                    break;
                }
                case APPROVING: {
                    busiCardApplyPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                }
            }
            this.service.updateByKeyDynamic(busiCardApplyPayload);
        }
        return WorkflowResult.success(null);
    }

    public BusiCardApplyWorkflowCallBackController(TBusiCardApplyService service) {
        this.service = service;
    }
}

