/*
 * Decompiled with CFR 0.152.
 */
package com.elitesland.tw.tw5.server.prd.workflow;

import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvBatchPayload;
import com.elitesland.tw.tw5.api.prd.salecon.service.ConInvBatchService;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvBatchVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.BatchStatusEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.ReceStatusEnum;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConInvBatchDAO;
import com.elitesland.tw.tw5.server.prd.salecon.dao.ConReceivablePlanDAO;
import com.elitesland.tw.tw5.server.prd.salecon.repo.ConReceivablePlanRepo;
import com.elitesland.workflow.WorkflowCallBack;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.enums.ProcInstStatus;
import com.elitesland.workflow.payload.ProcessStatusChangePayload;
import com.elitesland.workflow.payload.TaskAssigneePayload;
import com.elitesland.workflow.payload.TaskCompletedPayload;
import com.elitesland.workflow.payload.TaskCreatedPayload;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rpc/workflow/SALE_CON_INVOICING/callBack"})
@Transactional
public class SaleConCloseInvoicingWorkflowCallBackController
implements WorkflowCallBack {
    private static final Logger log = LoggerFactory.getLogger(SaleConCloseInvoicingWorkflowCallBackController.class);
    private final ConInvBatchService invBatchService;
    private final ConInvBatchDAO invBatchDAO;
    private final ConReceivablePlanDAO receivablePlanDAO;
    private final ConReceivablePlanRepo receivablePlanRepo;

    @PostMapping(value={"/taskAssignee"})
    public WorkflowResult<ArrayList<String>> taskAssignee(@RequestBody TaskAssigneePayload payload) {
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCreated"})
    public WorkflowResult<Void> taskCreated(@RequestBody TaskCreatedPayload payload) {
        String taskKey = payload.getTaskKey();
        String businessKey = payload.getBusinessKey();
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setId(Long.valueOf(businessKey));
        switch (taskKey) {
            case "Activity_1uh82em": {
                conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPLYING.getCode());
                break;
            }
            case "Activity_03eqeup": {
                conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETOINV.getCode());
                ConInvBatchVO conInvBatchVO = this.invBatchService.queryByKey(Long.valueOf(businessKey));
                if (conInvBatchVO.getInvFlag() == null || conInvBatchVO.getInvFlag() != 1) break;
                this.invBatchService.outputInvoiceInBaiwang(Long.valueOf(businessKey), Integer.valueOf(1));
                break;
            }
            case "Activity_16uktyp": {
                conInvBatchPayload.setBatchStatus(BatchStatusEnum.APPROVETORECV.getCode());
                this.receivablePlanRepo.updateReceStatusByBatchId(Long.valueOf(businessKey), ReceStatusEnum.OK_INVOICE.getCode());
                this.receivablePlanRepo.updateInvAmt(Long.valueOf(businessKey));
                break;
            }
        }
        this.invBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        log.info("\u4efb\u52a1\u521b\u5efa\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/taskCompleted"})
    public WorkflowResult<Void> taskCompleted(@RequestBody TaskCompletedPayload payload) {
        log.info("\u4efb\u52a1\u5b8c\u6210\u540e\u56de\u8c03\u53c2\u6570: {}", (Object)payload);
        return WorkflowResult.success(null);
    }

    @PostMapping(value={"/processStatusChange"})
    public WorkflowResult<Void> processStatusChange(@RequestBody ProcessStatusChangePayload payload) {
        log.info("\u6d41\u7a0b\u72b6\u6001\u53d8\u5316\u56de\u8c03\u53c2\u6570:{}", (Object)payload);
        String businessKey = payload.getBusinessKey();
        ProcInstStatus procInstStatus = payload.getProcInstStatus();
        ConInvBatchPayload conInvBatchPayload = new ConInvBatchPayload();
        conInvBatchPayload.setId(Long.valueOf(Long.parseLong(businessKey)));
        ConInvBatchVO conInvBatchVO = this.invBatchService.queryByKey(Long.valueOf(businessKey));
        if (conInvBatchVO != null) {
            switch (procInstStatus) {
                case NOTSUBMIT: {
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.NOTSUBMIT);
                    break;
                }
                case INTERRUPT: {
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setNullFields(Arrays.asList("procInstStatus", "procInstId", "submitTime"));
                    break;
                }
                case INVALID: {
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setDeleteFlag(Integer.valueOf(1));
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.INVALID);
                    this.invBatchService.deleteInvInfoToBaiwang(Long.valueOf(businessKey), Integer.valueOf(1));
                    this.receivablePlanRepo.unbindBatchByBatchId(Long.valueOf(businessKey));
                    break;
                }
                case REJECTED: {
                    conInvBatchPayload.setBatchStatus(BatchStatusEnum.CREATE.getCode());
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.REJECTED);
                    break;
                }
                case APPROVED: {
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.APPROVED);
                    conInvBatchPayload.setApprovedTime(LocalDateTime.now());
                    this.receivablePlanRepo.updateReceStatusByBatchId(Long.valueOf(businessKey), ReceStatusEnum.OK_INVOICE.getCode());
                    this.receivablePlanRepo.updateInvAmt(Long.valueOf(businessKey));
                    if (conInvBatchVO.getEmailFlag() != null && conInvBatchVO.getEmailFlag() == 1) {
                        this.invBatchService.sendEmail(conInvBatchVO);
                    }
                    if (conInvBatchVO.getWorkType() == null || !conInvBatchVO.getWorkType().equals("T&M")) break;
                    conInvBatchPayload.setRecycleSettleFlag(Integer.valueOf(0));
                    break;
                }
                case APPROVING: {
                    conInvBatchPayload.setProcInstStatus(ProcInstStatus.APPROVING);
                    break;
                }
            }
            this.invBatchDAO.updateByKeyDynamic(conInvBatchPayload);
        }
        return WorkflowResult.success(null);
    }

    public SaleConCloseInvoicingWorkflowCallBackController(ConInvBatchService invBatchService, ConInvBatchDAO invBatchDAO, ConReceivablePlanDAO receivablePlanDAO, ConReceivablePlanRepo receivablePlanRepo) {
        this.invBatchService = invBatchService;
        this.invBatchDAO = invBatchDAO;
        this.receivablePlanDAO = receivablePlanDAO;
        this.receivablePlanRepo = receivablePlanRepo;
    }
}

