package com.elitesland.tw.tw5.server.common.funConfig.config;

import com.alibaba.nacos.api.config.annotation.NacosConfigurationProperties;
import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

/**
 * 页面配置 配置类
 *
 * @author duwh
 * @date 2022/11/15
 */
@Data
@ConfigurationProperties("funconfig")
// 支持动态刷新
@NacosConfigurationProperties(dataId = "funconfig", autoRefreshed = true)
public class FunConfigProperties {

    /**
     * 识别标识
     * 测试环境 testshow
     * 生产环境 tw5
     */
    // private String externalSource = "testshow";


    /**
     * 通用文档配置 相关配置
     * funconfig:
     * docType:
     * permissionFlag:true
     */
    private DocTypeConfig docType = new DocTypeConfig();

    public FunConfigProperties() {
    }
}
