package com.elitesland.tw.tw5.server.common.funConfig.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.common.funConfig.payload.BusinessTableFieldsPayload;
import com.elitesland.tw.tw5.api.common.funConfig.query.BusinessTableFieldsQuery;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableFieldsService;
import com.elitesland.tw.tw5.api.common.funConfig.service.BusinessTableService;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableFieldsVO;
import com.elitesland.tw.tw5.api.common.funConfig.vo.BusinessTableVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务对象字段明细
 *
 * @author duwh
 * @folder 页面配置
 * @date 2023-06-14
 */
@Api(tags = "业务对象字段明细")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/common/funConfig/businessTableFields")
@Slf4j
public class BusinessTableFieldsController {

    private final BusinessTableFieldsService businessTableFieldsService;
    private final BusinessTableService businessTableService;

    /**
     * 业务对象字段明细-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PostMapping
    @ApiOperation("业务对象字段明细-新增")
    public TwOutputUtil<BusinessTableFieldsVO> insert(@RequestBody BusinessTableFieldsPayload payload) {
        return TwOutputUtil.ok(businessTableFieldsService.insert(payload));
    }

    /**
     * 业务对象字段明细-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping
    @ApiOperation("业务对象字段明细-更新")
    public TwOutputUtil<BusinessTableFieldsVO> update(@RequestBody BusinessTableFieldsPayload payload) {
        return TwOutputUtil.ok(businessTableFieldsService.update(payload));
    }

    /**
     * 业务对象字段明细-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @PutMapping("update")
    @ApiOperation("业务对象字段明细-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody BusinessTableFieldsPayload payload) {
        return TwOutputUtil.ok(businessTableFieldsService.updateByKeyDynamic(payload));
    }

    /**
     * 业务对象字段明细-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-主键查询")
    public TwOutputUtil<BusinessTableFieldsVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessTableFieldsService.queryByKey(key));
    }

    /**
     * 业务对象字段明细-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-分页")
    public TwOutputUtil<PagingVO<BusinessTableFieldsVO>> paging(BusinessTableFieldsQuery query) {
        return TwOutputUtil.ok(businessTableFieldsService.queryPaging(query));
    }

    /**
     * 业务对象字段明细-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     * @folder 页面配置
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务对象字段明细-查询列表")
    public TwOutputUtil<List<BusinessTableFieldsVO>> queryList(BusinessTableFieldsQuery query) {
        return TwOutputUtil.ok(businessTableFieldsService.queryListDynamic(query));
    }

    /**
     * 查询数据库的表字段数据数据
     *
     * @param tableId   表id
     * @param tableName 表名
     * @return {@link TwOutputUtil}<{@link List}<{@link BusinessTableFieldsVO}>>
     */
    @GetMapping("/query")
    @ApiOperation("查询数据库的表字段数据数据")
    public TwOutputUtil<List<BusinessTableFieldsVO>> query(Long tableId, String tableName) {
        if (null != tableId) {
            BusinessTableVO businessTableVO = businessTableService.queryByKey(tableId);
            if (null != businessTableVO) {
                tableName = businessTableVO.getTableName();
            }
        }
        return TwOutputUtil.ok(businessTableFieldsService.query(tableName));
    }



    /**
     * 业务对象字段明细-删除
     *
     * @param keys 主键id
     * @return result
     * @folder 页面配置
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务对象字段明细-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessTableFieldsService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

