package com.elitesland.tw.tw5.server.common.permission.enums;

/**
 * 数据权限规则类型
 *
 * @author : JS
 * @date 2023/09/25
 */
public enum PermissionRuleType {

    /**
     * 用户，组织，角色，自定义
     */
    USER( "USER", "用户"),
    ORG("ORG","组织"),
    ROLE("ROLE","角色"),
    CUSTOM("CUSTOM","自定义"),
    BUSINESS_OBJECT_TYPE("BUSINESS_OBJECT_TYPE", "业务对象类型");

    private final String name;

    private final String desc;

    PermissionRuleType(String name, String desc) {
        this.name = name;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public String getName() {
        return name;
    }

    public static PermissionRuleType find(String name) {
        for (PermissionRuleType value : PermissionRuleType.values()) {
            if (value.getName().equals(name)) {
                return value;
            }
        }
        return null;
    }

}
