package com.elitesland.tw.tw5.server.prd.acc.controller;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimBusItemConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimBusItemConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimBusItemConfigService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimBusItemConfigVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 报销科目配置管理
 *
 * @author sunxw
 * @date 2023-12-15
 */
@Api(tags = "报销科目配置管理")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/acc/accReimBusItemConfig")
@Slf4j
public class AccReimBusItemConfigController {

    private final AccReimBusItemConfigService accReimBusItemConfigService;

    /**
     * 报销科目配置管理-新增
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("报销科目配置管理-新增")
    public TwOutputUtil<AccReimBusItemConfigVO> insert(@RequestBody AccReimBusItemConfigPayload payload) {
        return TwOutputUtil.ok(accReimBusItemConfigService.insert(payload));
    }

    /**
     * 报销科目配置管理-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("报销科目配置管理-更新")
    public TwOutputUtil<AccReimBusItemConfigVO> update(@RequestBody AccReimBusItemConfigPayload payload) {
        return TwOutputUtil.ok(accReimBusItemConfigService.update(payload));
    }

    /**
     * 报销科目配置管理-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("报销科目配置管理-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil updateByKeyDynamic(@RequestBody AccReimBusItemConfigPayload payload) {
        accReimBusItemConfigService.updateByKeyDynamic(payload);
        return TwOutputUtil.ok();
    }

    /**
     * 报销科目配置管理-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("报销科目配置管理-主键查询")
    public TwOutputUtil<AccReimBusItemConfigVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(accReimBusItemConfigService.queryByKey(key));
    }

    /**
     * 报销科目配置管理-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("报销科目配置管理-分页")
    public TwOutputUtil<PagingVO<AccReimBusItemConfigVO>> paging(AccReimBusItemConfigQuery query) {
        return TwOutputUtil.ok(accReimBusItemConfigService.queryPaging(query));
    }

    /**
     * 报销科目配置管理-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("报销科目配置管理-查询列表")
    public TwOutputUtil<List<AccReimBusItemConfigVO>> queryList(AccReimBusItemConfigQuery query) {
        return TwOutputUtil.ok(accReimBusItemConfigService.queryListDynamic(query));
    }

    /**
     * 报销科目配置管理-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("报销科目配置管理-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        accReimBusItemConfigService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

