package com.elitesland.tw.tw5.server.prd.acc.service;



import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverdueDiscuntPayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingOverduePayload;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSettingPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueDiscuntQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingOverdueQuery;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSettingQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueDiscuntService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingOverdueService;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSettingService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueDiscuntVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingOverdueVO;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSettingVO;
import com.elitesland.tw.tw5.api.prd.inv.query.InvInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.inv.service.InvInvoiceService;
import com.elitesland.tw.tw5.api.prd.inv.vo.InvInvoiceVO;
import com.elitesland.tw.tw5.api.prd.salecon.payload.ConInvSettingMonthPayload;
import com.elitesland.tw.tw5.api.prd.salecon.vo.ConInvSettingMonthVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.prd.acc.common.functionEnum.AccReimSettingTypeEnum;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingOverdueConvert;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSettingOverdueDiscuntConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingOverdueDAO;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSettingOverdueDiscuntDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSettingOverdueDiscuntDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueDiscuntRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingOverdueRepo;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSettingRepo;
import com.elitesland.tw.tw5.server.prd.common.GlobalUtil;
import com.elitesland.tw.tw5.server.prd.salecon.convert.ConInvSettingMonthConvert;
import com.elitesland.tw.tw5.server.prd.salecon.entity.ConInvSettingMonthDO;
import org.checkerframework.checker.units.qual.A;
import org.springframework.stereotype.Service;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import org.springframework.transaction.annotation.Transactional;
import com.elitescloud.cloudt.common.base.PagingVO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import java.util.*;
import java.util.stream.Collectors;

/**
 * 报销逾期配置
 *
 * @author zoey
 * @date 2024-04-08
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSettingOverdueServiceImpl extends BaseServiceImpl implements AccReimSettingOverdueService {

    private final AccReimSettingOverdueRepo accReimSettingOverdueRepo;
    private final AccReimSettingOverdueDAO accReimSettingOverdueDAO;
    private final AccReimSettingService accReimSettingService;
    private final AccReimSettingRepo accReimSettingRepo;
    private final AccReimSettingOverdueDiscuntRepo accReimSettingOverdueDiscuntRepo;
    private final AccReimSettingOverdueDiscuntDAO accReimSettingOverdueDiscuntDAO;
    private final AccReimSettingOverdueDiscuntService accReimSettingOverdueDiscuntService;
    private final InvInvoiceService invInvoiceService;
    @Override
    public PagingVO<AccReimSettingOverdueVO> queryPaging(AccReimSettingOverdueQuery query){
        return accReimSettingOverdueDAO.queryPaging(query);
    }

    @Override
    public List<AccReimSettingOverdueVO> queryListDynamic(AccReimSettingOverdueQuery query){
        return accReimSettingOverdueDAO.queryListDynamic(query);
    }

    @Override
    public AccReimSettingOverdueVO queryByKey(Long key) {
        // 查询当前配置表
        AccReimSettingOverdueDO entity = accReimSettingOverdueRepo.findById(key).orElseGet(AccReimSettingOverdueDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingOverdueVO vo = AccReimSettingOverdueConvert.INSTANCE.toVo(entity);
        // 查询基础配置表
        AccReimSettingQuery accReimSettingQuery = new AccReimSettingQuery();
        accReimSettingQuery.setSpecificReimSettingId(key);
        accReimSettingQuery.setReimSettingType(AccReimSettingTypeEnum.OVERDUE.getCode());
        List<AccReimSettingVO> accReimSettingVOS = accReimSettingService.queryListDynamic(accReimSettingQuery);
        if(!CollectionUtils.isEmpty(accReimSettingVOS)){
            vo.setAccReimSettingVO(accReimSettingVOS.get(0));
        }
        AccReimSettingOverdueDiscuntQuery accReimSettingOverdueDiscuntQuery = new AccReimSettingOverdueDiscuntQuery();
        accReimSettingOverdueDiscuntQuery.setReimSettingOverdueId(key);
        // 查询配置明细表
        List<AccReimSettingOverdueDiscuntVO> accReimSettingOverdueDiscuntVOS = accReimSettingOverdueDiscuntService.queryListDynamic(accReimSettingOverdueDiscuntQuery);
        vo.setAccReimSettingOverdueDiscuntVOList(accReimSettingOverdueDiscuntVOS);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingOverdueVO insert(AccReimSettingOverduePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        // 保存当前配置表
        AccReimSettingOverdueDO entityDo = AccReimSettingOverdueConvert.INSTANCE.toDo(payload);
        AccReimSettingOverdueVO accReimSettingOverdueVO = AccReimSettingOverdueConvert.INSTANCE.toVo(accReimSettingOverdueRepo.save(entityDo));
        // 保存基础配置表
        Long id = accReimSettingOverdueVO.getId();
        accReimSettingPayload.setSpecificReimSettingId(id);
        accReimSettingPayload.setReimSettingType(AccReimSettingTypeEnum.OVERDUE.getCode());
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingDO));
        accReimSettingOverdueVO.setAccReimSettingVO(accReimSettingVO);
        // 保存配置明细表
        List<AccReimSettingOverdueDiscuntPayload> accReimSettingOverdueDiscuntPayloadList = payload.getAccReimSettingOverdueDiscuntPayloadList();
        accReimSettingOverdueDiscuntPayloadList.stream().forEach(e->e.setReimSettingOverdueId(id));
        if(!accReimSettingOverdueDiscuntPayloadList.isEmpty()){
            List<AccReimSettingOverdueDiscuntDO> accReimSettingOverdueDiscuntDOS = AccReimSettingOverdueDiscuntConvert.INSTANCE.toDoList(accReimSettingOverdueDiscuntPayloadList);
            List<AccReimSettingOverdueDiscuntVO> accReimSettingOverdueDiscuntVOS = AccReimSettingOverdueDiscuntConvert.INSTANCE.toVoList(accReimSettingOverdueDiscuntRepo.saveAll(accReimSettingOverdueDiscuntDOS));
            accReimSettingOverdueVO.setAccReimSettingOverdueDiscuntVOList(accReimSettingOverdueDiscuntVOS);
        }
        return accReimSettingOverdueVO;

    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public AccReimSettingOverdueVO update(AccReimSettingOverduePayload payload) {
        AccReimSettingPayload accReimSettingPayload = payload.getAccReimSettingPayload();
        // 判断重复
        accReimSettingService.checkRepeat(accReimSettingPayload);
        // 删除明细
        List<Long> deleteAccReimSettingOverdueDiscuntKeys = payload.getDeleteAccReimSettingOverdueDiscuntKeys();
        if(!CollectionUtils.isEmpty(deleteAccReimSettingOverdueDiscuntKeys)){
            accReimSettingOverdueDiscuntDAO.deleteSoft(deleteAccReimSettingOverdueDiscuntKeys);
        }
        // 保存当前配置表
        AccReimSettingOverdueDO entity = accReimSettingOverdueRepo.findById(payload.getId()).orElseGet(AccReimSettingOverdueDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSettingOverdueDO entityDo = AccReimSettingOverdueConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        AccReimSettingOverdueVO accReimSettingOverdueVO = AccReimSettingOverdueConvert.INSTANCE.toVo(accReimSettingOverdueRepo.save(entity));
        // 保存基础配置表
        AccReimSettingDO accReimSettingEntity = accReimSettingRepo.findById(accReimSettingPayload.getId()).orElseGet(AccReimSettingDO::new);
        Assert.notNull(accReimSettingEntity.getId(), "不存在");
        AccReimSettingDO accReimSettingDO = AccReimSettingConvert.INSTANCE.toDo(accReimSettingPayload);
        accReimSettingEntity.copy(accReimSettingDO);
        AccReimSettingVO accReimSettingVO = AccReimSettingConvert.INSTANCE.toVo(accReimSettingRepo.save(accReimSettingEntity));
        accReimSettingOverdueVO.setAccReimSettingVO(accReimSettingVO);

        //保存子表数据,三种情况，新增，修改，删除
        List<AccReimSettingOverdueDiscuntPayload> accReimSettingOverdueDiscuntPayloadList = payload.getAccReimSettingOverdueDiscuntPayloadList();
        if(!accReimSettingOverdueDiscuntPayloadList.isEmpty()){
            List<AccReimSettingOverdueDiscuntDO> accReimSettingOverdueDiscuntDOS = AccReimSettingOverdueDiscuntConvert.INSTANCE.toDoList(accReimSettingOverdueDiscuntPayloadList);
            List<AccReimSettingOverdueDiscuntVO> accReimSettingOverdueDiscuntVOS= new ArrayList<>();
            for (AccReimSettingOverdueDiscuntDO accReimSettingOverdueDiscuntDO : accReimSettingOverdueDiscuntDOS) {
                if(accReimSettingOverdueDiscuntDO.getId()!=null){
                    AccReimSettingOverdueDiscuntDO accReimSettingOverdueDiscuntEntity = accReimSettingOverdueDiscuntRepo.findById(accReimSettingOverdueDiscuntDO.getId()).orElseGet(AccReimSettingOverdueDiscuntDO::new);
                    Assert.notNull(entity.getId(), "不存在");
                    accReimSettingOverdueDiscuntEntity.copy(accReimSettingOverdueDiscuntDO);
                    accReimSettingOverdueDiscuntVOS.add(AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo(accReimSettingOverdueDiscuntRepo.save(accReimSettingOverdueDiscuntEntity)));
                }else{
                    accReimSettingOverdueDiscuntDO.setReimSettingOverdueId(payload.getId());
                    accReimSettingOverdueDiscuntVOS.add(AccReimSettingOverdueDiscuntConvert.INSTANCE.toVo(accReimSettingOverdueDiscuntRepo.save(accReimSettingOverdueDiscuntDO)));
                }
            }
            accReimSettingOverdueVO.setAccReimSettingOverdueDiscuntVOList(accReimSettingOverdueDiscuntVOS);
        }

        return accReimSettingOverdueVO;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(AccReimSettingOverduePayload payload) {
        AccReimSettingOverdueDO entity = accReimSettingOverdueRepo.findById(payload.getId()).orElseGet(AccReimSettingOverdueDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = accReimSettingOverdueDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            accReimSettingOverdueDAO.deleteSoft(keys);
        }
    }

    @Override
    public AccReimSettingOverdueVO ruleCheck(Long key, String expenseDate,String invoiceNo,Long reimUserId) {

        // 默认对比日期为费用发生日期
        LocalDate compareDate=LocalDate.parse(expenseDate);

        AccReimSettingOverdueVO accReimSettingOverdueVO = queryByKey(key);
        AccReimSettingVO accReimSettingVO = accReimSettingOverdueVO.getAccReimSettingVO();
        // 剔除白名单人员
        String whiteList = accReimSettingVO.getWhiteList();
        if(StringUtils.hasText(whiteList)){
            List<Long> idList = Arrays.stream(whiteList.split(",")).map(Long::parseLong).collect(Collectors.toList());
            //报销人
            if(idList.contains(reimUserId)){
                return accReimSettingOverdueVO;
            }
        }
        String overdueStartDate = accReimSettingOverdueVO.getOverdueStartDate();
        if(overdueStartDate.equals("INVOICE_DATE")){
            InvInvoiceQuery invInvoiceQuery = new InvInvoiceQuery();
            invInvoiceQuery.setInvoiceNo(invoiceNo);
            List<InvInvoiceVO> invInvoiceVOS = invInvoiceService.queryListDynamic(invInvoiceQuery);
            InvInvoiceVO invInvoiceVO = new InvInvoiceVO();
            if(!CollectionUtils.isEmpty(invInvoiceVOS)){
                invInvoiceVO = invInvoiceVOS.get(0);
            }else{
                throw TwException.error("","未找到对应的发票");
            }
            // 对比日期为发票日期
            String invoiceDate = invInvoiceVO.getInvoiceDate();
            compareDate=LocalDate.parse(invoiceDate);
        }

        long daysBetween = ChronoUnit.DAYS.between(compareDate, LocalDate.now());

        List<AccReimSettingOverdueDiscuntVO> accReimSettingOverdueDiscuntVOList = accReimSettingOverdueVO.getAccReimSettingOverdueDiscuntVOList();

        for (AccReimSettingOverdueDiscuntVO accReimSettingOverdueDiscuntVO : accReimSettingOverdueDiscuntVOList) {
            Integer minDays = accReimSettingOverdueDiscuntVO.getMinDays();
            Integer maxDays = accReimSettingOverdueDiscuntVO.getMaxDays();
            if(daysBetween<minDays){
                continue;
            }else if((maxDays!=null && maxDays>=daysBetween) || maxDays==null){
                // 获取到折扣
                BigDecimal invLimit = accReimSettingOverdueDiscuntVO.getInvLimit();
                accReimSettingOverdueVO.setInvLimit(invLimit);
                if(accReimSettingVO.getRemindText()!=null){
                    accReimSettingVO.setRemindText(accReimSettingVO.getRemindText().replace("#{1}",String.valueOf(daysBetween)).replace("#{2}",String.valueOf(invLimit)));
                }
                if(accReimSettingVO.getErrorText()!=null){
                    accReimSettingVO.setErrorText(accReimSettingVO.getErrorText().replace("#{1}",String.valueOf(daysBetween)).replace("#{2}",String.valueOf(invLimit)));
                }
            }

        }
        return accReimSettingOverdueVO;
    }

}
