package com.elitesland.tw.tw5.server.prd.acc.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.acc.payload.AccReimSourceConfigPayload;
import com.elitesland.tw.tw5.api.prd.acc.query.AccReimSourceConfigQuery;
import com.elitesland.tw.tw5.api.prd.acc.service.AccReimSourceConfigService;
import com.elitesland.tw.tw5.api.prd.acc.vo.AccReimSourceConfigVO;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.server.prd.acc.convert.AccReimSourceConfigConvert;
import com.elitesland.tw.tw5.server.prd.acc.dao.AccReimSourceConfigDAO;
import com.elitesland.tw.tw5.server.prd.acc.entity.AccReimSourceConfigDO;
import com.elitesland.tw.tw5.server.prd.acc.repo.AccReimSourceConfigRepo;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.util.List;

/**
 * 报销金额来源配置管理
 *
 * @author sunxw
 * @date 2023-12-04
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class AccReimSourceConfigServiceImpl extends BaseServiceImpl implements AccReimSourceConfigService {

    private final AccReimSourceConfigRepo repo;
    private final AccReimSourceConfigDAO dao;
    private final PrdOrgEmployeeService employeeService;

    @Override
    public PagingVO<AccReimSourceConfigVO> queryPaging(AccReimSourceConfigQuery query) {
        return dao.queryPaging(query);
    }

    @Override
    public List<AccReimSourceConfigVO> queryListDynamic(AccReimSourceConfigQuery query) {
        return dao.queryListDynamic(query);
    }

    @Override
    public AccReimSourceConfigVO queryByKey(Long key) {
        return dao.queryByKey(key);
    }

    @Override
    @Transactional
    public AccReimSourceConfigVO insert(AccReimSourceConfigPayload payload) {
        AccReimSourceConfigDO entityDo = AccReimSourceConfigConvert.INSTANCE.toDo(payload);
        return AccReimSourceConfigConvert.INSTANCE.toVo(repo.save(entityDo));
    }

    @Override
    @Transactional
    public AccReimSourceConfigVO update(AccReimSourceConfigPayload payload) {
        AccReimSourceConfigDO entity = repo.findById(payload.getId()).orElseGet(AccReimSourceConfigDO::new);
        Assert.notNull(entity.getId(), "不存在");
        AccReimSourceConfigDO entityDo = AccReimSourceConfigConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return AccReimSourceConfigConvert.INSTANCE.toVo(repo.save(entity));
    }

    @Override
    @Transactional
    public long updateByKeyDynamic(AccReimSourceConfigPayload payload) {
        AccReimSourceConfigVO vo = dao.queryByKey(payload.getId());
        Assert.notNull(vo, "不存在");
        long result = dao.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            dao.deleteSoft(keys);
        }
    }

}
