package com.elitesland.tw.tw5.server.prd.budget.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;
import java.math.BigDecimal;


/**
 * 预算拨付明细
 *
 * @author xxb
 * @date 2023-11-01
 */
@Entity
@Table(name = "pms_budget_appropriation_detail", indexes = {
        @Index(name = "appropriation_index", columnList = "appropriation_id"),
        @Index(name = "activity_index", columnList = "activity_id"),
})
@org.hibernate.annotations.Table(appliesTo = "pms_budget_appropriation_detail", comment = "预算拨付明细")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class BudgetAppropriationDetailDO extends BaseModel implements Serializable {
    /**
     * 拨款ID
     */
    @Comment("拨款ID")
    @Column(name = "appropriation_id")
    private Long appropriationId;
    /**
     * 拨款金额
     */
    @Comment("拨款金额")
    @Column()
    private BigDecimal allocateCost;
    /**
     * 活动id
     */
    @Comment("活动id")
    @Column(name = "activity_id")
    private Long activityId;
    /**
     * 拨付当量
     */
    @Comment("拨付当量")
    @Column()
    private BigDecimal allocateEqva;
    /**
     * 预算科目明细ID
     */
    @Comment("预算科目明细ID")
    @Column()
    private Long budgetSubjectDetailId;
    /**
     * 可配置字段1
     */
    @Comment("可配置字段1")
    @Column()
    private String configurableField1;
    /**
     * 可配置字段2
     */
    @Comment("可配置字段2")
    @Column()
    private String configurableField2;
    /**
     * 可配置字段3
     */
    @Comment("可配置字段3")
    @Column()
    private String configurableField3;

    public void copy(BudgetAppropriationDetailDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
