package com.elitesland.tw.tw5.server.prd.cal.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalNormSettlePayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalNormSettleQuery;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalNormSettleVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalNormSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.entity.QCalAccountDO;
import com.elitesland.tw.tw5.server.prd.cal.entity.QCalNormSettleDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalNormSettleRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 泛用金额结算管理
 *
 * @author carl
 * @date 2023-11-20
 */
@Repository
@RequiredArgsConstructor
public class CalNormSettleDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CalNormSettleRepo repo;
    private final QCalNormSettleDO qdo = QCalNormSettleDO.calNormSettleDO;
    private final QCalAccountDO qdoAccount0 = new QCalAccountDO("calAccountDO0");
    private final QCalAccountDO qdoAccount1 = new QCalAccountDO("calAccountDO1");

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<CalNormSettleVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(CalNormSettleVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 结算单号
                qdo.settleNo,
                // 结算状态
                qdo.settleStatus,
                // 审批状态
                qdo.apprStatus,
                // 流程实例id
                qdo.procInstId,
                // 单据创建类型
                qdo.createType,
                // 业务类型
                qdo.busiType,
                // 相关业务单据号
                qdo.relevNo,
                // 申请日期
                qdo.applyDate,
                // 申请资源id
                qdo.applyResId,
                // 结算日期
                qdo.settleDate,
                // 财务期间id
                qdo.finPeriodId,
                // 子合同id
                qdo.contractId,
                qdo.contractName,
                // 项目id
                qdo.projId,
                qdo.projName,
                // 任务id
                qdo.taskId,
                // 收入方账户
                qdoAccount0.ledgerName.as("inAccount"),
                qdo.inAccountId,
                // 收入方科目
                qdo.inAcc,
                // 支出方账户
                qdoAccount1.ledgerName.as("outAccount"),
                qdo.outAccountId,
                // 支出方科目
                qdo.outAcc,
                // 实际结算总额
                qdo.approveSettleAmt,
                // 税额
                qdo.taxAmt,
                // 申请人bu_id
                qdo.applyBuId,
                // 收款计划id
                qdo.recvplanId,
                //收款阶段
                qdo.receStage

        )).from(qdo).leftJoin(qdoAccount0).on(qdo.inAccountId.eq(qdoAccount0.id)).leftJoin(qdoAccount1).on(qdo.outAccountId.eq(qdoAccount1.id));
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<CalNormSettleVO> getJpaQueryWhere(CalNormSettleQuery query) {
        JPAQuery<CalNormSettleVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(CalNormSettleQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(CalNormSettleQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 结算单号 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleNo())) {
            list.add(qdo.settleNo.eq(query.getSettleNo()));
        }
        /** 结算状态 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStatus())) {
            list.add(qdo.settleStatus.eq(query.getSettleStatus()));
        }
        /** 审批状态 精确 */
        if (!ObjectUtils.isEmpty(query.getApprStatus())) {
            list.add(qdo.apprStatus.eq(query.getApprStatus()));
        }
        /** 流程实例id 精确 */
        if (!ObjectUtils.isEmpty(query.getProcInstId())) {
            list.add(qdo.procInstId.eq(query.getProcInstId()));
        }
        /** 单据创建类型 精确 */
        if (!ObjectUtils.isEmpty(query.getCreateType())) {
            list.add(qdo.createType.eq(query.getCreateType()));
        }
        /** 业务类型 精确 */
        if (!ObjectUtils.isEmpty(query.getBusiType())) {
            list.add(qdo.busiType.eq(query.getBusiType()));
        }
        /** 相关业务单据号 精确 */
        if (!ObjectUtils.isEmpty(query.getRelevNo())) {
            list.add(qdo.relevNo.eq(query.getRelevNo()));
        }
        /** 申请日期 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyDate())) {
            list.add(qdo.applyDate.eq(query.getApplyDate()));
        }
        /** 申请资源id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyResId())) {
            list.add(qdo.applyResId.eq(query.getApplyResId()));
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleDate())) {
            list.add(qdo.settleDate.eq(query.getSettleDate()));
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleStartDate())) {
            list.add(qdo.settleDate.goe(query.getSettleStartDate()));
        }
        /** 结算日期 精确 */
        if (!ObjectUtils.isEmpty(query.getSettleEndDate())) {
            list.add(qdo.settleDate.loe(query.getSettleEndDate()));
        }
        /** 财务期间id 精确 */
        if (!ObjectUtils.isEmpty(query.getFinPeriodId())) {
            list.add(qdo.finPeriodId.eq(query.getFinPeriodId()));
        }
        /** 子合同id 精确 */
        if (!ObjectUtils.isEmpty(query.getContractId())) {
            list.add(qdo.contractId.eq(query.getContractId()));
        }
        /** 项目id 精确 */
        if (!ObjectUtils.isEmpty(query.getProjId())) {
            list.add(qdo.projId.eq(query.getProjId()));
        }
        /** 任务id 精确 */
        if (!ObjectUtils.isEmpty(query.getTaskId())) {
            list.add(qdo.taskId.eq(query.getTaskId()));
        }
        /** 收入方账户 精确 */
        if (!ObjectUtils.isEmpty(query.getInAccount())) {
            list.add(qdo.inAccount.eq(query.getInAccount()));
        }
        /** 收入方账户 精确 */
        if (!ObjectUtils.isEmpty(query.getInAccountId())) {
            list.add(qdo.inAccountId.eq(query.getInAccountId()));
        }
        /** 收入方科目 精确 */
        if (!ObjectUtils.isEmpty(query.getInAcc())) {
            list.add(qdo.inAcc.eq(query.getInAcc()));
        }
        /** 支出方账户 精确 */
        if (!ObjectUtils.isEmpty(query.getOutAccount())) {
            list.add(qdo.outAccount.eq(query.getOutAccount()));
        }
        /** 支出方账户 精确 */
        if (!ObjectUtils.isEmpty(query.getOutAccountId())) {
            list.add(qdo.outAccountId.eq(query.getOutAccountId()));
        }
        /** 支出方科目 精确 */
        if (!ObjectUtils.isEmpty(query.getOutAcc())) {
            list.add(qdo.outAcc.eq(query.getOutAcc()));
        }
        /** 实际结算总额 精确 */
        if (!ObjectUtils.isEmpty(query.getApproveSettleAmt())) {
            list.add(qdo.approveSettleAmt.eq(query.getApproveSettleAmt()));
        }
        /** 税额 精确 */
        if (!ObjectUtils.isEmpty(query.getTaxAmt())) {
            list.add(qdo.taxAmt.eq(query.getTaxAmt()));
        }
        /** 申请人bu_id 精确 */
        if (!ObjectUtils.isEmpty(query.getApplyBuId())) {
            list.add(qdo.applyBuId.eq(query.getApplyBuId()));
        }
        /** 收款计划id 精确 */
        if (!ObjectUtils.isEmpty(query.getRecvplanId())) {
            list.add(qdo.recvplanId.eq(query.getRecvplanId()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public CalNormSettleVO queryByKey(Long id) {
        JPAQuery<CalNormSettleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<CalNormSettleVO> queryListDynamic(CalNormSettleQuery query) {
        JPAQuery<CalNormSettleVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<CalNormSettleVO> queryPaging(CalNormSettleQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<CalNormSettleVO> jpaQuery = getJpaQueryWhere(query);
        List<CalNormSettleVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<CalNormSettleVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public CalNormSettleDO save(CalNormSettleDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<CalNormSettleDO> saveAll(List<CalNormSettleDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(CalNormSettlePayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 结算单号
        if (payload.getSettleNo() != null) {
            update.set(qdo.settleNo, payload.getSettleNo());
        }
        // 结算状态
        if (payload.getSettleStatus() != null) {
            update.set(qdo.settleStatus, payload.getSettleStatus());
        }
        // 审批状态
        if (payload.getApprStatus() != null) {
            update.set(qdo.apprStatus, payload.getApprStatus());
        }
        // 流程实例id
        if (payload.getProcInstId() != null) {
            update.set(qdo.procInstId, payload.getProcInstId());
        }
        // 单据创建类型
        if (payload.getCreateType() != null) {
            update.set(qdo.createType, payload.getCreateType());
        }
        // 业务类型
        if (payload.getBusiType() != null) {
            update.set(qdo.busiType, payload.getBusiType());
        }
        // 相关业务单据号
        if (payload.getRelevNo() != null) {
            update.set(qdo.relevNo, payload.getRelevNo());
        }
        // 申请日期
        if (payload.getApplyDate() != null) {
            update.set(qdo.applyDate, payload.getApplyDate());
        }
        // 申请资源id
        if (payload.getApplyResId() != null) {
            update.set(qdo.applyResId, payload.getApplyResId());
        }
        // 结算日期
        if (payload.getSettleDate() != null) {
            update.set(qdo.settleDate, payload.getSettleDate());
        }
        // 财务期间id
        if (payload.getFinPeriodId() != null) {
            update.set(qdo.finPeriodId, payload.getFinPeriodId());
        }
        // 子合同id
        if (payload.getContractId() != null) {
            update.set(qdo.contractId, payload.getContractId());
        }
        // 项目id
        if (payload.getProjId() != null) {
            update.set(qdo.projId, payload.getProjId());
        }
        // 任务id
        if (payload.getTaskId() != null) {
            update.set(qdo.taskId, payload.getTaskId());
        }
        // 收入方账户
        if (payload.getInAccount() != null) {
            update.set(qdo.inAccount, payload.getInAccount());
        }
        // 收入方科目
        if (payload.getInAcc() != null) {
            update.set(qdo.inAcc, payload.getInAcc());
        }
        // 支出方账户
        if (payload.getOutAccount() != null) {
            update.set(qdo.outAccount, payload.getOutAccount());
        }
        // 支出方科目
        if (payload.getOutAcc() != null) {
            update.set(qdo.outAcc, payload.getOutAcc());
        }
        // 实际结算总额
        if (payload.getApproveSettleAmt() != null) {
            update.set(qdo.approveSettleAmt, payload.getApproveSettleAmt());
        }
        // 税额
        if (payload.getTaxAmt() != null) {
            update.set(qdo.taxAmt, payload.getTaxAmt());
        }
        // 申请人bu_id
        if (payload.getApplyBuId() != null) {
            update.set(qdo.applyBuId, payload.getApplyBuId());
        }
        // 收款计划id
        if (payload.getRecvplanId() != null) {
            update.set(qdo.recvplanId, payload.getRecvplanId());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 结算单号
            if (nullFields.contains("settleNo")) {
                update.setNull(qdo.settleNo);
            }
            // 结算状态
            if (nullFields.contains("settleStatus")) {
                update.setNull(qdo.settleStatus);
            }
            // 审批状态
            if (nullFields.contains("apprStatus")) {
                update.setNull(qdo.apprStatus);
            }
            // 流程实例id
            if (nullFields.contains("procInstId")) {
                update.setNull(qdo.procInstId);
            }
            // 单据创建类型
            if (nullFields.contains("createType")) {
                update.setNull(qdo.createType);
            }
            // 业务类型
            if (nullFields.contains("busiType")) {
                update.setNull(qdo.busiType);
            }
            // 相关业务单据号
            if (nullFields.contains("relevNo")) {
                update.setNull(qdo.relevNo);
            }
            // 申请日期
            if (nullFields.contains("applyDate")) {
                update.setNull(qdo.applyDate);
            }
            // 申请资源id
            if (nullFields.contains("applyResId")) {
                update.setNull(qdo.applyResId);
            }
            // 结算日期
            if (nullFields.contains("settleDate")) {
                update.setNull(qdo.settleDate);
            }
            // 财务期间id
            if (nullFields.contains("finPeriodId")) {
                update.setNull(qdo.finPeriodId);
            }
            // 子合同id
            if (nullFields.contains("contractId")) {
                update.setNull(qdo.contractId);
            }
            // 项目id
            if (nullFields.contains("projId")) {
                update.setNull(qdo.projId);
            }
            // 任务id
            if (nullFields.contains("taskId")) {
                update.setNull(qdo.taskId);
            }
            // 收入方账户
            if (nullFields.contains("inAccount")) {
                update.setNull(qdo.inAccount);
            }
            // 收入方科目
            if (nullFields.contains("inAcc")) {
                update.setNull(qdo.inAcc);
            }
            // 支出方账户
            if (nullFields.contains("outAccount")) {
                update.setNull(qdo.outAccount);
            }
            // 支出方科目
            if (nullFields.contains("outAcc")) {
                update.setNull(qdo.outAcc);
            }
            // 实际结算总额
            if (nullFields.contains("approveSettleAmt")) {
                update.setNull(qdo.approveSettleAmt);
            }
            // 税额
            if (nullFields.contains("taxAmt")) {
                update.setNull(qdo.taxAmt);
            }
            // 申请人bu_id
            if (nullFields.contains("applyBuId")) {
                update.setNull(qdo.applyBuId);
            }
            // 收款计划id
            if (nullFields.contains("recvplanId")) {
                update.setNull(qdo.recvplanId);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据主键查询
     *
     * @param ids 主键
     * @return 结果
     */
    public List<CalNormSettleVO> queryByKeys(List<Long> ids) {
        JPAQuery<CalNormSettleVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.in(ids));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
}

