package com.elitesland.tw.tw5.server.prd.cal.service;

import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.cal.payload.CalAccountPayload;
import com.elitesland.tw.tw5.api.prd.cal.query.CalAccountQuery;
import com.elitesland.tw.tw5.api.prd.cal.service.CalAccountService;
import com.elitesland.tw.tw5.api.prd.cal.vo.CalAccountVO;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.prd.cal.convert.CalAccountConvert;
import com.elitesland.tw.tw5.server.prd.cal.dao.CalAccountDAO;
import com.elitesland.tw.tw5.server.prd.cal.entity.CalAccountDO;
import com.elitesland.tw.tw5.server.prd.cal.repo.CalAccountRepo;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CalAccTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgEmployeeDAO;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.tw.tw5.server.prd.pms.dao.PmsProjectDAO;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

/**
 * 核算-账号功能管理
 *
 * @author carl
 * @date 2023-11-13
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CalAccountServiceImpl extends BaseServiceImpl implements CalAccountService {
    private final TransactionUtilService transactionUtilService;
    private final CalAccountRepo calAccountRepo;
    private final CalAccountDAO calAccountDAO;

    @Override
    public PagingVO<CalAccountVO> queryPaging(CalAccountQuery query) {
        PagingVO<CalAccountVO> calAccountVOPagingVO = calAccountDAO.queryPaging(query);

        return calAccountVOPagingVO;
    }


    @Override
    public List<CalAccountVO> queryListDynamic(CalAccountQuery query) {
        List<CalAccountVO> calAccountVOS = calAccountDAO.queryListDynamic(query);

        return calAccountVOS;
    }

    @Override
    public CalAccountVO queryByKey(Long key) {
        CalAccountVO vo = calAccountDAO.queryByKey(key);
        return vo;
    }

    @Override
    public List<CalAccountVO> queryByKeys(List<Long> keys) {
        return calAccountDAO.queryByKeys(keys);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public CalAccountVO insert(CalAccountPayload payload) {
        //数据校验
        checkData(payload);

        CalAccountVO calAccountVO = calAccountDAO.queryByAuTypeAndAuId(payload.getAuType(), payload.getAuId());
        if (calAccountVO != null) {
            throw TwException.error("", "账号不可重复创建");
//            Optional<CalAccountVO> first = calAccountVOS.stream().filter(vo -> vo.getLedgerYear().equals(payload.getLedgerYear())).findFirst();
//            if (first.isPresent()) {
//                if (!StringUtils.hasText(payload.getLedgerName())) {
//                    throw TwException.error("", "账号不可重复创建");
//                }
//            }
        }
        CalAccountDO entityDo = CalAccountConvert.INSTANCE.toDo(payload);
        return CalAccountConvert.INSTANCE.toVo(calAccountRepo.save(entityDo));
    }

    /**
     * 数据核验
     *
     * @param payload
     */
    void checkData(CalAccountPayload payload) {
        if (!StringUtils.hasText(payload.getAuType())) {
            throw TwException.error("", "账户类型不可为空");
        }
        if (payload.getAuId() == null) {
            throw TwException.error("", "归属主题不可为空");
        }
        if (!StringUtils.hasText(payload.getLedgerNo())) {
            throw TwException.error("", "归属主题编号不可为空");
        }
        if (!StringUtils.hasText(payload.getLedgerName())) {
            throw TwException.error("", "名称不可为空");
        }
        String ledgerNo = payload.getAuType() + "-" + payload.getLedgerNo();
        payload.setLedgerNo(ledgerNo);
        payload.setLedgerStatus(1);//默认启用
        payload.setLedgerYear(LocalDate.now().getYear());
    }
//    @Override
//    @Transactional(rollbackFor = Exception.class)
//    public CalAccountVO update(CalAccountPayload payload) {
//        CalAccountDO entity = calAccountRepo.findById(payload.getId()).orElseGet(CalAccountDO::new);
//        Assert.notNull(entity.getId(), "不存在");
//        CalAccountDO entityDo = CalAccountConvert.INSTANCE.toDo(payload);
//        entity.copy(entityDo);
//        return CalAccountConvert.INSTANCE.toVo(calAccountRepo.save(entity));
//    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(CalAccountPayload payload) {
        long result = calAccountDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            calAccountDAO.deleteSoft(keys);
        }
    }

    @Override
    public CalAccountVO queryByAuTypeAndAuId(String auType, Long auId) {
        CalAccountVO calAccountVO = calAccountDAO.queryByAuTypeAndAuId(auType, auId);
        if (calAccountVO == null) {
            String name = "";
            if (auType.equals(CalAccTypeEnum.PROJ.getCode())) {
                name = CalAccTypeEnum.PROJ.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.BU.getCode())) {
                name = CalAccTypeEnum.BU.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.RES.getCode())) {
                name = CalAccTypeEnum.RES.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.OPP.getCode())) {
                name = CalAccTypeEnum.OPP.getDesc();
            }
            if (auType.equals(CalAccTypeEnum.BU_PROJ.getCode())) {
                name = CalAccTypeEnum.BU_PROJ.getDesc();
            }
            log.error(name + "账户不存在,auId:" + auId);
            throw TwException.error("", name + "账户不存在或已禁用");

        }
        return calAccountVO;
    }

    @Override
    public List<CalAccountVO> queryByAuTypeAndAuIds(String auType, List<Long> auIds) {
        return calAccountDAO.queryByAuTypeAndAuIds(auType, auIds);
    }

    @Override
    public List<CalAccountVO> queryByAuTypesAndAuIds(List<String> auTypes, List<Long> auIds) {
        return calAccountDAO.queryByAuTypesAndAuIds(auTypes, auIds);
    }

    /**
     * 因为是仅初始化使用一次，可以干掉所以直接使用了dao
     */
    private final PmsProjectDAO pmsProjectDAO;
    private final PrdOrgOrganizationDAO orgDao;
    private final PrdOrgEmployeeDAO daoEmployee;
    private final CrmOpportunityDAO daoOpportunity;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void initAccount() {
        List<CalAccountDO> accounts = new ArrayList<>();
        int year1 = LocalDate.now().getYear();
//        //项目账户
//        PmsProjectQuery query = new PmsProjectQuery();
//        query.setProjStatusType("0");
//        query.setProjStatus("CLOSE");
//        List<PmsProjectVO> pmsProjectVOS = pmsProjectDAO.queryListDynamic(query);
//
//        pmsProjectVOS.forEach(vo -> {
//            //创建项目账户
//            CalAccountDO account = new CalAccountDO();
//            account.setAuType(CalAccTypeEnum.PROJ.getCode());
//            account.setAuId(vo.getId());
//            account.setLedgerName(vo.getProjName());
//            account.setLedgerNo(CalAccTypeEnum.PROJ.getCode() + "-" + vo.getProjNo());
//            account.setLedgerStatus(1);
//            int year = vo.getCreateTime() == null ? year1 : vo.getCreateTime().getYear();
//            account.setLedgerYear(year);
//            accounts.add(account);
//        });
//        //组织账户
//        PrdOrgOrganizationQuery queryOrg = new PrdOrgOrganizationQuery();
//        List<PrdOrgOrganizationVO> prdOrgOrganizationVOS = orgDao.queryAll(queryOrg);
//        prdOrgOrganizationVOS.forEach(vo -> {
//            //创建项目账户
//            CalAccountDO account = new CalAccountDO();
//            account.setAuType(CalAccTypeEnum.BU.getCode());
//            account.setAuId(vo.getId());
//            account.setLedgerName(vo.getOrgName());
//            account.setLedgerNo(CalAccTypeEnum.BU.getCode() + "-" + vo.getOrgCode());
//            account.setLedgerStatus(1);
//            int year = vo.getCreateTime() == null ? year1 : vo.getCreateTime().getYear();
//            account.setLedgerYear(year);
//            accounts.add(account);
//        });
//        //员工账户
//        PrdOrgEmployeeQuery queryEmployee = new PrdOrgEmployeeQuery();
//        queryEmployee.setHrStatus(SystemDefaultEnum.DefaultHrStatus.getCode());
//        //  queryEmployee.setResourceStatus(SystemDefaultEnum.DefaultResourceStatus.getCode());
//        List<PrdOrgEmployeeVO> prdOrgEmployeeVOS = daoEmployee.queryList(queryEmployee);
//        prdOrgEmployeeVOS.forEach(vo -> {
//            //创建项目账户
//            CalAccountDO account = new CalAccountDO();
//            account.setAuType(CalAccTypeEnum.RES.getCode());
//            account.setAuId(vo.getUserId());
//            account.setLedgerName(vo.getEmployeeName());
//            account.setLedgerNo(CalAccTypeEnum.RES.getCode() + "-" + vo.getEmployeeNo());
//            account.setLedgerStatus(1);
//            int year = vo.getCreateTime() == null ? year1 : vo.getCreateTime().getYear();
//            account.setLedgerYear(year);
//            accounts.add(account);
//        });
        //商机账户
//        List<CrmOpportunityListVO> crmOpportunityListVOS = daoOpportunity.queryList();
//        List<CrmOpportunityListVO> opportunityListVOS = crmOpportunityListVOS.stream().filter(vo -> !vo.getProjectStatus().equals("CLOSED")).collect(Collectors.toList());
//        opportunityListVOS.forEach(vo -> {
//            //创建商机账户
//            CalAccountDO account = new CalAccountDO();
//            account.setAuType(CalAccTypeEnum.OPP.getCode());
//            account.setAuId(vo.getProjectId());
//            account.setLedgerName(vo.getProjectName());
//            account.setLedgerNo(CalAccTypeEnum.OPP.getCode() + "-" + vo.getProjectNo());
//            account.setLedgerStatus(1);
//            int year = vo.getCreateTime() == null ? year1 : vo.getCreateTime().getYear();
//            account.setLedgerYear(year);
//            accounts.add(account);
//        });
//
//        calAccountRepo.saveAll(accounts);
    }

    @Override
    public void closeAccount(Long key) {
        CalAccountPayload payload = new CalAccountPayload();
        payload.setId(key);
        payload.setLedgerStatus(0);
        calAccountDAO.updateByKeyDynamic(payload);
    }


}
