package com.elitesland.tw.tw5.server.prd.common;

import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.TaskInfo;
import com.elitesland.workflow.WorkflowResult;
import com.elitesland.workflow.WorkflowService;
import com.elitesland.workflow.payload.ApprovePayload;
import com.elitesland.workflow.payload.DeleteProcessPayload;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

@Component
@RequiredArgsConstructor
@Slf4j
public class WorkflowUtil {
    private final WorkflowService workflowService;

    /**
     * 创建工作流
     *
     * @param payload
     * @param startUserId 流程发起指定创建人
     * @return
     */
    public ProcessInfo startProcess(StartProcessPayload payload, Long... startUserId) {
        String starterId = null;
        if (startUserId != null && startUserId.length > 0) {
            starterId = startUserId[0] + "";
        }
        payload.setStarterId(starterId);
        WorkflowResult<ProcessInfo> workflowResult = workflowService.startProcess(payload);
        System.out.println("workflowResult:::" + workflowResult.toString());
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return workflowResult.getData();
            } else {
                throw TwException.error("", "工作流创建异常:" + workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流创建返回值异常，请联系管理员！");
        }

    }

    /**
     * 删除工作流
     *
     * @param payload
     */
    public void deleteProcess(DeleteProcessPayload payload) {
        WorkflowResult workflowResult = workflowService.deleteProcess(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流删除异常，请联系管理员！");
        }
    }

    /**
     * 修改流程实例节点审批人
     *
     * @param payload
     */
    public void setVariables(SetVariablesPayload payload) {
        WorkflowResult workflowResult = workflowService.setVariables(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "修改节点审批人异常，请联系管理员！");
        }
    }

    //设置属性值
    public void setVaribales(SetVariablesPayload payload) {
        WorkflowResult workflowResult = workflowService.setVariables(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流更改参数异常，请联系管理员！");
        }
    }

    //推流程
    public void approve(ApprovePayload payload) {
        WorkflowResult workflowResult = workflowService.approve(payload);
        if (workflowResult != null) {
            if (!workflowResult.isSuccess()) {
                throw TwException.error("", workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流推进异常，请联系管理员！");
        }
    }

    //获取工作流当前节点信息
    public TaskInfo currentTaskInfo(String procInstId) {
        WorkflowResult<TaskInfo> workflowResult = workflowService.currentTaskInfo(procInstId);
        if (workflowResult != null) {
            if (workflowResult.isSuccess()) {
                return workflowResult.getData();
            } else {
                throw TwException.error("", "工作流获取信息异常:" + workflowResult.getMsg());
            }
        } else {
            throw TwException.error("", "工作流信息获取异常，请联系管理员！");
        }
    }
}
