package com.elitesland.tw.tw5.server.prd.copartner.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.copartner.payload.PerformanceReadmeConfigDetailPayload;
import com.elitesland.tw.tw5.api.prd.copartner.query.PerformanceReadmeConfigDetailQuery;
import com.elitesland.tw.tw5.api.prd.copartner.vo.PerformanceReadmeConfigDetailVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.copartner.entity.PerformanceReadmeConfigDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.entity.QPerformanceReadmeConfigDetailDO;
import com.elitesland.tw.tw5.server.prd.copartner.repo.PerformanceReadmeConfigDetailRepo;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 合伙人绩效考核点维护
 *
 * @author carl
 * @date 2024-06-24
 */
@Repository
@RequiredArgsConstructor
public class PerformanceReadmeConfigDetailDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final PerformanceReadmeConfigDetailRepo repo;
    private final QPerformanceReadmeConfigDetailDO qdo = QPerformanceReadmeConfigDetailDO.performanceReadmeConfigDetailDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeConfigDetailVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(PerformanceReadmeConfigDetailVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 配置主键
                qdo.configId,
                // 考核来源
                qdo.detailSource,
                // 考核点
                qdo.detailPod,
                //类型
                qdo.detailType,
                // 详情状态
                qdo.detailStatus
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<PerformanceReadmeConfigDetailVO> getJpaQueryWhere(PerformanceReadmeConfigDetailQuery query) {
        JPAQuery<PerformanceReadmeConfigDetailVO> jpaQuery = getJpaQuerySelect();
        // 条件封装
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        // 动态排序
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(PerformanceReadmeConfigDetailQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
                .select(qdo.count())
                .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(PerformanceReadmeConfigDetailQuery query) {
        List<Predicate> list = new ArrayList<>();
        /** 主键 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 配置主键 精确 */
        if (!ObjectUtils.isEmpty(query.getConfigId())) {
            list.add(qdo.configId.eq(query.getConfigId()));
        }
        /** 考核来源 精确 */
        if (!ObjectUtils.isEmpty(query.getDetailSource())) {
            list.add(qdo.detailSource.eq(query.getDetailSource()));
        }
        /** 考核点 精确 */
        if (!ObjectUtils.isEmpty(query.getDetailPod())) {
            list.add(qdo.detailPod.eq(query.getDetailPod()));
        }
        /** 详情状态 精确 */
        if (!ObjectUtils.isEmpty(query.getDetailStatus())) {
            list.add(qdo.detailStatus.eq(query.getDetailStatus()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public PerformanceReadmeConfigDetailVO queryByKey(Long id) {
        JPAQuery<PerformanceReadmeConfigDetailVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.id.eq(id));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<PerformanceReadmeConfigDetailVO> queryListDynamic(PerformanceReadmeConfigDetailQuery query) {
        JPAQuery<PerformanceReadmeConfigDetailVO> jpaQuery = getJpaQueryWhere(query);
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<PerformanceReadmeConfigDetailVO> queryPaging(PerformanceReadmeConfigDetailQuery query) {
        long total = count(query);
        if (total == 0) {
            return PagingVO.empty();
        }
        JPAQuery<PerformanceReadmeConfigDetailVO> jpaQuery = getJpaQueryWhere(query);
        List<PerformanceReadmeConfigDetailVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<PerformanceReadmeConfigDetailVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public PerformanceReadmeConfigDetailDO save(PerformanceReadmeConfigDetailDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<PerformanceReadmeConfigDetailDO> saveAll(List<PerformanceReadmeConfigDetailDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(PerformanceReadmeConfigDetailPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .where(qdo.id.eq(payload.getId()));
        // 主键
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 配置主键
        if (payload.getConfigId() != null) {
            update.set(qdo.configId, payload.getConfigId());
        }
        // 考核来源
        if (payload.getDetailSource() != null) {
            update.set(qdo.detailSource, payload.getDetailSource());
        }
        // 考核点
        if (payload.getDetailPod() != null) {
            update.set(qdo.detailPod, payload.getDetailPod());
        }
        // 详情状态
        if (payload.getDetailStatus() != null) {
            update.set(qdo.detailStatus, payload.getDetailStatus());
        }
        // 详情类型
        if (payload.getDetailType() != null) {
            update.set(qdo.detailType, payload.getDetailType());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 主键
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 配置主键
            if (nullFields.contains("configId")) {
                update.setNull(qdo.configId);
            }
            // 考核来源
            if (nullFields.contains("detailSource")) {
                update.setNull(qdo.detailSource);
            }
            // 考核点
            if (nullFields.contains("detailPod")) {
                update.setNull(qdo.detailPod);
            }
            // 详情状态
            if (nullFields.contains("detailStatus")) {
                update.setNull(qdo.detailStatus);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

    /**
     * 根据配置id逻辑删除
     *
     * @param configId 配置主键
     * @return 删除的行数
     */
    public long deleteSoftByConfigId(Long configId) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.configId.eq(configId));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
}

