package com.elitesland.tw.tw5.server.prd.crm.dao;

import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerDataVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmCustomerOperationVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.crm.constant.CustomerOperationTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmCustomerOperationEnterpriseInfoDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmOpportunityDO;
import com.elitesland.tw.tw5.server.prd.crm.entity.QCrmPeopleDO;
import com.elitesland.tw.tw5.server.prd.crm.repo.CrmCustomerOperationRepo;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAccountDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookInvoiceDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBusinessPartnerDO;
import com.elitesland.tw.tw5.server.prd.prj.entity.QPrjProjectDO;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;

/**
 * 客户经营
 *
 * @author duwh
 * @date 2022/11/15
 */
@Repository
@RequiredArgsConstructor
public class CrmCustomerOperationDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final CrmCustomerOperationRepo repo;
    private final QCrmCustomerOperationDO qdo = QCrmCustomerOperationDO.crmCustomerOperationDO;
//    private final QPrdAbAccountDO qdoAbAccount = QPrdAbAccountDO.prdAbAccountDO;
//    private final QPrdAbInvoiceDO qdoAbInvoice = QPrdAbInvoiceDO.prdAbInvoiceDO;
//    private final QCrmCustomerDO qdoCustomer = QCrmCustomerDO.crmCustomerDO;
   // private final QPrdOrgCompanyDO qdoCompany = QPrdOrgCompanyDO.prdOrgCompanyDO;
    private final QBusinessPartnerDO qBusinessPartnerDO = QBusinessPartnerDO.businessPartnerDO;
    private final QBookAccountDO qBookAccountDO = QBookAccountDO.bookAccountDO;
    private final QBookInvoiceDO qBookInvoiceDO = QBookInvoiceDO.bookInvoiceDO;
    private final QCrmCustomerOperationEnterpriseInfoDO operationEnterpriseInfoDO = QCrmCustomerOperationEnterpriseInfoDO.crmCustomerOperationEnterpriseInfoDO;

    private JPAQuery<CrmCustomerOperationVO> getJpaQuerySelect() {
        JPAQuery<CrmCustomerOperationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerOperationVO.class,
                qdo.id,
                qdo.custNo,
                qdo.custName,
                qdo.customerId,
                qdo.parentId,
                qdo.parentCompany,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime
        )).from(qdo);
        return jpaQuery;
    }

    public CrmCustomerOperationVO queryCrmCustomerOperationVOByCustomerId(long customerId) {
        var query = getJpaQuerySelect();
        return query.where(qdo.deleteFlag.eq(0)).where(qdo.customerId.eq(customerId)).fetchFirst();
    }

    /**
     * 列表查询
     *
     * @return
     */
    public CrmCustomerOperationVO queryById(Long id) {
        JPAQuery<CrmCustomerOperationVO> jpaQuerySelect = getJpaQuerySelect();
        jpaQuerySelect.where(qdo.deleteFlag.eq(0)).where(qdo.id.eq(id));
        return jpaQuerySelect.fetchFirst();
    }

//    private JPAQuery<CrmCustomerDataVO> getJpaQuerySelect0() {
//        JPAQuery<CrmCustomerDataVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerDataVO.class,
//                qdoCustomer.id,
//                qdoCustomer.bookId,
//                qdoCustomer.customerName,
//                qdoCompany.taxNo,
//                qdoAbAccount.depositBank,
//                qdoAbAccount.accountNo,
//                qdoAbInvoice.invoiceAddress,
//                qdoAbInvoice.invoicePhone
//
//        )).from(qdoCustomer).leftJoin(qdoCompany).on(qdoCustomer.bookId.longValue().eq(qdoCompany.bookId.longValue()).and(qdoCompany.deleteFlag.eq(0)))
//                .leftJoin(qdoAbAccount).on(qdoAbAccount.bookId.longValue().eq(qdoCustomer.bookId.longValue()).and(qdoCompany.deleteFlag.eq(0)))
//                .leftJoin(qdoAbInvoice).on(qdoAbInvoice.bookId.longValue().eq(qdoCustomer.bookId.longValue()).and(qdoAbInvoice.deleteFlag.eq(0)));
//        return jpaQuery;
//    }

    private JPAQuery<CrmCustomerDataVO> getJpaQuerySelect0() {
        JPAQuery<CrmCustomerDataVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerDataVO.class,
                        qBusinessPartnerDO.id,
                        qBusinessPartnerDO.bookId,
                        qBusinessPartnerDO.partnerName.as("customerName"),
                        qBookAccountDO.depositBank,
                        qBookAccountDO.accountNo,
                        qBookInvoiceDO.invoiceAddress,
                        qBookInvoiceDO.invoicePhone
                )).from(qBusinessPartnerDO)
                .leftJoin(qBookAccountDO).on(qBookAccountDO.bookId.longValue().eq(qBusinessPartnerDO.bookId.longValue()).and(qBookAccountDO.deleteFlag.eq(0)).and(qBookAccountDO.isDefault.eq(true)))
                .leftJoin(qBookInvoiceDO).on(qBookInvoiceDO.bookId.longValue().eq(qBusinessPartnerDO.bookId.longValue()).and(qBookInvoiceDO.deleteFlag.eq(0)).and(qBookInvoiceDO.isDefault.eq(true)));
        return jpaQuery;
    }


    public CrmCustomerDataVO queryByCustomerId(Long customerId) {
        JPAQuery<CrmCustomerDataVO> jpaQuerySelect = getJpaQuerySelect0();
        jpaQuerySelect.where(qBusinessPartnerDO.deleteFlag.eq(0)).
                where(qBusinessPartnerDO.id.eq(customerId));
        return jpaQuerySelect.fetchFirst();
    }

    private final QCrmOpportunityDO qdoOpportunity = QCrmOpportunityDO.crmOpportunityDO;
    private final QPrjProjectDO qdoProject = QPrjProjectDO.prjProjectDO;
    private final QCrmPeopleDO qdoOperationPeople = QCrmPeopleDO.crmPeopleDO;

    /**
     * 获取客户相关商机数量
     *
     * @param customerId
     * @return
     */
    public long queryOpportunityCount(Long customerId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoOpportunity.id).from(qdoOpportunity).leftJoin(qdoProject).on(qdoProject.id.longValue().eq(qdoOpportunity.projectId.longValue()));
        jpaQuery.where(qdoOpportunity.formalCustomerId.eq(customerId));
        jpaQuery.where(qdoOpportunity.deleteFlag.eq(0));
        jpaQuery.where(qdoProject.deleteFlag.eq(0));

        return jpaQuery.fetchCount();
    }

    /**
     * 查询客户相关人脉数量
     *
     * @param operId
     * @return
     */
    public long queryOperationPeopleCount(Long operId) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory.select(qdoOperationPeople.id).from(qdoOperationPeople);
        jpaQuery.where(qdoOperationPeople.operId.eq(operId));
        jpaQuery.where(qdoOperationPeople.deleteFlag.eq(0));
        return jpaQuery.fetchCount();
    }

    /**
     * 关联客户
     *
     * @param key
     * @param customerId
     */
    public long relationCustomer(Long key, Long customerId) {
        JPAUpdateClause where = jpaQueryFactory.update(qdo).set(qdo.customerId, customerId).where(qdo.id.eq(key));
        return where.execute();
    }

    /**
     * 修改客户经营状态
     *
     * @param key    主键
     * @param custOperStatus 状态
     * @return
     */
    public long updateCustOperStatus(Long key, String custOperStatus) {
        return jpaQueryFactory.update(qdo)
                .set(qdo.custOperStatus, custOperStatus)
                .where(qdo.id.eq(key))
                .execute();
    }

    /**
     * 查询缺失工商信息的客户经营
     * @return
     */
    public List<CrmCustomerOperationVO> findOperationEnterpriseInfoAbsent(){
        return jpaQueryFactory.select(Projections.bean(CrmCustomerOperationVO.class,
                        qdo.id,
                        qdo.custName,
                        qdo.remark))
                .from(qdo).leftJoin(operationEnterpriseInfoDO).on(qdo.id.eq(operationEnterpriseInfoDO.operId).and(operationEnterpriseInfoDO.deleteFlag.eq(0)))
                .where(qdo.deleteFlag.eq(0)
                        .and(qdo.custType.in(CustomerOperationTypeEnum.ENTERPRISE.getCode(), CustomerOperationTypeEnum.ECO_PARTNER.getCode(), CustomerOperationTypeEnum.ENTERPRISE_ECO_PARTNER.getCode()))
                        .and(operationEnterpriseInfoDO.operId.isNull()))
                .fetch();
    }

    /**
     * 获取需要提醒的客户经营数据
     * @return
     */
    public List<CrmCustomerOperationVO> queryNeedOperas(LocalDate weekAgoTime) {
        LocalDateTime startOfDay = weekAgoTime.atStartOfDay();
        LocalDateTime endOfDay = weekAgoTime.atTime(LocalTime.MAX);
        JPAQuery<CrmCustomerOperationVO> jpaQuery = jpaQueryFactory.select(Projections.bean(CrmCustomerOperationVO.class,
                qdo.id,
                qdo.customerId,
                qdo.custName,
                qdo.custOperManagerId,
                qdo.saleOperManagerId)).from(qdo);
        jpaQuery.where(qdo.deleteFlag.eq(0));
        jpaQuery.where(qdo.industryStand.isEmpty().or(qdo.saleScale.isNull()).or(qdo.companyTightness.isEmpty()).or(qdo.digitalInvestment.isEmpty())
                        .or(qdo.saleOperBu.isNull()).or(qdo.historyCooOutput.isNull()).or(qdo.custOperBu.isNull()).or(qdo.saleOperManagerId.isNull())
                        .or(qdo.businessStrategy.isEmpty()).or(qdo.custOperManagerId.isNull()));
        jpaQuery.where(qdo.noticeTime.lt(endOfDay));
        //jpaQuery.where(qdo.noticeTime.between(startOfDay,endOfDay));
        return jpaQuery.fetch();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
                .set(qdo.deleteFlag, 1)
                .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }

}
