package com.elitesland.tw.tw5.server.prd.crm.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * 商机数据源字段
 * @author likunpeng
 * @date 2023/11/3
 */
@Entity
@Table(name = "crm_oppo_data_source_fields", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "crm_oppo_data_source_fields", comment = "商机数据源字段")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class CrmOppoDataSourceFieldsDO extends BaseModel {

    @Comment("数据源字段")
    @Column()
    private String name;

    @Comment("数据源字段值")
    @Column()
    private String field;

    @Comment("类型[选项类型、数值类型]")
    @Column()
    private String type;

    @Comment("系统选择项")
    @Column()
    private String selectionKey;
}
