package com.elitesland.tw.tw5.server.prd.crm.repo;

import com.elitesland.tw.tw5.server.prd.crm.entity.CrmOpenseaDO;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.JpaSpecificationExecutor;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.lang.Nullable;

import java.util.List;
import java.util.Optional;

/**
 * @author zoey
 * @Description:
 * @date 2022/5/19 - 14:13
 */
public interface CrmOpenseaRepo extends JpaRepository<CrmOpenseaDO,Long>, QuerydslPredicateExecutor<CrmOpenseaDO>, JpaSpecificationExecutor<CrmOpenseaDO> {
    @Override
    @EntityGraph(value = "opensea.rule.list")
    List<CrmOpenseaDO> findAll(@Nullable Specification<CrmOpenseaDO> spec);

    @Override
    @EntityGraph(value = "opensea.rule.list")
    Page<CrmOpenseaDO> findAll(@Nullable Specification<CrmOpenseaDO> spec, Pageable pageable);


    @Override
    @EntityGraph(value = "opensea.rule.detail")
    Optional<CrmOpenseaDO> findById(Long id);


    @EntityGraph(value = "opensea.rule.list")
    Optional<CrmOpenseaDO> findDistinctByOpenseaName(String id);

}
