package com.elitesland.tw.tw5.server.prd.humanresources.examination.dao;

import com.elitesland.tw.tw5.api.prd.humanresources.payload.PrdPerformanceExamPointPayload;
import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdPerformanceExamPointQuery;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdPerformanceExamPointVO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.PrdPerformanceExamPointDO;
import com.elitesland.tw.tw5.server.prd.humanresources.examination.entity.QPrdPerformanceExamPointDO;
import com.querydsl.jpa.impl.JPAUpdateClause;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.List;

import com.querydsl.core.types.ExpressionUtils;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-11-14
 * @desc : 绩效考核点RepoProc
 */

@Component
public class PrdPerformanceExamPointDao extends BaseRepoProc<PrdPerformanceExamPointDO> {

    private static final QPrdPerformanceExamPointDO qPrdPerformanceExamPointDO = QPrdPerformanceExamPointDO.prdPerformanceExamPointDO;


    protected PrdPerformanceExamPointDao() {

        super(qPrdPerformanceExamPointDO);

    }


    public PagingVO<PrdPerformanceExamPointVO> page(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        JPAQuery<PrdPerformanceExamPointVO> query =
                select(PrdPerformanceExamPointVO.class)
                        .where(bulidPredicate(prdPerformanceExamPointQuery));
        prdPerformanceExamPointQuery.setPaging(query);
        prdPerformanceExamPointQuery.fillOrders(query, qPrdPerformanceExamPointDO);
        return PagingVO.<PrdPerformanceExamPointVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdPerformanceExamPointDO)
                .set(qPrdPerformanceExamPointDO.deleteFlag, 1)
                .where(qPrdPerformanceExamPointDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdPerformanceExamPointVO get(Long id) {

        PrdPerformanceExamPointVO prdPerformanceExamPointVO = select(PrdPerformanceExamPointVO.class)
                .where(qPrdPerformanceExamPointDO.id.eq(id))
                .fetchOne();

        return prdPerformanceExamPointVO;

    }


    public List<PrdPerformanceExamPointVO> getList(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        List<PrdPerformanceExamPointVO> res =
                select(PrdPerformanceExamPointVO.class)
                        .where(bulidPredicate(prdPerformanceExamPointQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                        qPrdPerformanceExamPointDO.examId,
                        qPrdPerformanceExamPointDO.source,
                        qPrdPerformanceExamPointDO.name,
                        qPrdPerformanceExamPointDO.scoreType,
                        qPrdPerformanceExamPointDO.weightRatio,
                        qPrdPerformanceExamPointDO.standardDesc,
                        qPrdPerformanceExamPointDO.id,
                        qPrdPerformanceExamPointDO.createTime,
                        qPrdPerformanceExamPointDO.remark

                )).from(qPrdPerformanceExamPointDO);

    }


    private Predicate bulidPredicate(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(null != prdPerformanceExamPointQuery.getExamId(), qPrdPerformanceExamPointDO.examId, prdPerformanceExamPointQuery.getExamId())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamPointQuery.getSource()), qPrdPerformanceExamPointDO.source, prdPerformanceExamPointQuery.getSource())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamPointQuery.getName()), qPrdPerformanceExamPointDO.name, prdPerformanceExamPointQuery.getName())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamPointQuery.getScoreType()), qPrdPerformanceExamPointDO.scoreType, prdPerformanceExamPointQuery.getScoreType())
                .andEq(null != prdPerformanceExamPointQuery.getWeightRatio(), qPrdPerformanceExamPointDO.weightRatio, prdPerformanceExamPointQuery.getWeightRatio())
                .andEq(StringUtils.isNotBlank(prdPerformanceExamPointQuery.getStandardDesc()), qPrdPerformanceExamPointDO.standardDesc, prdPerformanceExamPointQuery.getStandardDesc())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 绩效id
        if (null != prdPerformanceExamPointQuery.getExamId()) {
            predicates.add(qPrdPerformanceExamPointDO.examId.eq(prdPerformanceExamPointQuery.getExamId()));
        }
        // 考核点来源
        if (StringUtils.isNotEmpty(prdPerformanceExamPointQuery.getSource())) {
            predicates.add(qPrdPerformanceExamPointDO.source.eq(prdPerformanceExamPointQuery.getSource()));
        }
        // 考核点名称
        if (StringUtils.isNotEmpty(prdPerformanceExamPointQuery.getName())) {
            predicates.add(qPrdPerformanceExamPointDO.name.eq(prdPerformanceExamPointQuery.getName()));
        }
        // 评分类型
        if (StringUtils.isNotEmpty(prdPerformanceExamPointQuery.getScoreType())) {
            predicates.add(qPrdPerformanceExamPointDO.scoreType.eq(prdPerformanceExamPointQuery.getScoreType()));
        }
        // 权重比率
        if (null != prdPerformanceExamPointQuery.getWeightRatio()) {
            predicates.add(qPrdPerformanceExamPointDO.weightRatio.eq(prdPerformanceExamPointQuery.getWeightRatio()));
        }
        // 评分标准
        if (StringUtils.isNotEmpty(prdPerformanceExamPointQuery.getStandardDesc())) {
            predicates.add(qPrdPerformanceExamPointDO.standardDesc.eq(prdPerformanceExamPointQuery.getStandardDesc()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdPerformanceExamPointQuery prdPerformanceExamPointQuery) {

        long res = select(PrdPerformanceExamPointVO.class)
                .where(bulidPredicate(prdPerformanceExamPointQuery))
                .fetchCount();

        return res;


    }

    public Long update(PrdPerformanceExamPointPayload prdPerformanceExamPointPayload) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamPointDO);

        // 绩效id
        if (null != prdPerformanceExamPointPayload.getExamId()) {
            update.set(qPrdPerformanceExamPointDO.examId, prdPerformanceExamPointPayload.getExamId());
        }
        // 考核点来源
        if (StringUtils.isNotEmpty(prdPerformanceExamPointPayload.getSource())) {
            update.set(qPrdPerformanceExamPointDO.source, prdPerformanceExamPointPayload.getSource());
        }
        // 考核点名称
        if (StringUtils.isNotEmpty(prdPerformanceExamPointPayload.getName())) {
            update.set(qPrdPerformanceExamPointDO.name, prdPerformanceExamPointPayload.getName());
        }
        // 评分类型
        if (StringUtils.isNotEmpty(prdPerformanceExamPointPayload.getScoreType())) {
            update.set(qPrdPerformanceExamPointDO.scoreType, prdPerformanceExamPointPayload.getScoreType());
        }
        // 权重比率
        if (null != prdPerformanceExamPointPayload.getWeightRatio()) {
            update.set(qPrdPerformanceExamPointDO.weightRatio, prdPerformanceExamPointPayload.getWeightRatio());
        }
        // 评分标准
        if (StringUtils.isNotEmpty(prdPerformanceExamPointPayload.getStandardDesc())) {
            update.set(qPrdPerformanceExamPointDO.standardDesc, prdPerformanceExamPointPayload.getStandardDesc());
        }
        long res = update.where(qPrdPerformanceExamPointDO.id.eq(prdPerformanceExamPointPayload.getId()))
                .execute();
        return res;

    }

    public Long delByExamId(Long id) {
        JPAUpdateClause update = jpaQueryFactory.update(qPrdPerformanceExamPointDO);
        long res = update.set(qPrdPerformanceExamPointDO.deleteFlag, 1)
                .where(qPrdPerformanceExamPointDO.examId.eq(id))
                .execute();
        return res;

    }
}

