package com.elitesland.tw.tw5.server.prd.humanresources.examination.entity;

import lombok.experimental.Accessors;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

import lombok.Data;

import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.LocalDate;

import org.hibernate.annotations.Where;
import com.elitescloud.boot.model.entity.BaseModel;


/**
 * @author : WWW
 * @date : 2023-11-15
 * @desc : 绩效考核结果明细
 */

@Entity
@Table(name = "prd_performance_exam_res_dtl")
@org.hibernate.annotations.Table(appliesTo = "prd_performance_exam_res_dtl", comment = "绩效考核结果明细")
@Data
@DynamicInsert
@DynamicUpdate
@Accessors(chain = true)
@Where(clause = "delete_flag = 0")
public class PrdPerformanceExamResDtlDO extends BaseModel {


    /**
     * 绩效考核结果id
     */
    @Column(name = "result_id", columnDefinition = "bigint(20) comment '绩效考核结果id'")
    private Long resultId;

    /**
     * 考核点id
     */
    @Column(name = "point_id", columnDefinition = "bigint(20) comment '考核点id'")
    private Long pointId;

    /**
     * 考核点名称
     */
    @Column(name = "point_name", columnDefinition = "varchar(255) comment '考核点名称'")
    private String pointName;

    /**
     * 评分类型
     */
    @Column(name = "score_type", columnDefinition = "varchar(50) comment '评分类型'")
    private String scoreType;

    /**
     * 考核点权重
     */
    @Column(name = "weight_ratio", columnDefinition = "decimal(20,2) comment '考核点权重'")
    private BigDecimal weightRatio;

    /**
     * 系统考核统计
     */
    @Column(name = "sys_exam", columnDefinition = "varchar(255) comment '系统考核统计'")
    private String sysExam;

    /**
     * 评分结果
     */
    @Column(name = "score_res", columnDefinition = "decimal(20,2) comment '评分结果'")
    private BigDecimal scoreRes;

    /**
     * 自评说明
     */
    @Column(name = "self_eval", columnDefinition = "varchar(2000) comment '自评说明'")
    private String selfEval;

    /**
     * 考评人
     */
    @Column(name = "eval_user", columnDefinition = "varchar(255) comment '考评人'")
    private String evalUser;

    /**
     * 考评人id
     */
    @Column(name = "eval_user_id", columnDefinition = "bigint(20) comment '考评人id'")
    private Long evalUserId;

    /**
     * 评语
     */
    @Column(name = "eval_desc", columnDefinition = "varchar(500) comment '评语'")
    private String evalDesc;

    /**
     * 评分标准
     */
    @Column(name = "standard_desc", columnDefinition = "varchar(1000) comment '评分标准'")
    private String standardDesc;
}

