package com.elitesland.tw.tw5.server.prd.humanresources.resource.dao;


import com.elitesland.tw.tw5.api.prd.humanresources.query.PrdEmployeIndividAbilityQuery;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdAbilityLevelDO;
import com.elitesland.tw.tw5.server.prd.humanresources.ability.entity.QPrdIndividAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.PrdEmployeIndividAbilityDO;
import com.elitesland.tw.tw5.server.prd.humanresources.resource.entity.QPrdEmployeIndividAbilityDO;
import com.elitesland.tw.tw5.api.prd.humanresources.vo.PrdEmployeIndividAbilityVO;
import org.springframework.stereotype.Component;
import com.elitescloud.boot.jpa.common.BaseRepoProc;
import com.querydsl.core.types.Predicate;
import org.apache.commons.lang3.StringUtils;
import com.elitescloud.cloudt.common.base.PagingVO;

import java.util.List;

import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;

import java.util.ArrayList;


/**
 * @author : WWW
 * @date : 2023-10-27
 * @desc : 员工-单项能力RepoProc
 */

@Component
public class PrdEmployeIndividAbilityDao extends BaseRepoProc<PrdEmployeIndividAbilityDO> {

    private static final QPrdEmployeIndividAbilityDO qPrdEmployeIndividAbilityDO = QPrdEmployeIndividAbilityDO.prdEmployeIndividAbilityDO;

    private static final QPrdAbilityLevelDO qPrdAbilityLevelDO = QPrdAbilityLevelDO.prdAbilityLevelDO;
    private static final QPrdIndividAbilityDO qPrdIndividAbilityDO = QPrdIndividAbilityDO.prdIndividAbilityDO;

    protected PrdEmployeIndividAbilityDao() {

        super(qPrdEmployeIndividAbilityDO);

    }


    public PagingVO<PrdEmployeIndividAbilityVO> page(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        JPAQuery<PrdEmployeIndividAbilityVO> query =
                select(PrdEmployeIndividAbilityVO.class)
                        .where(bulidPredicate(prdEmployeIndividAbilityQuery))
                        .where(qPrdIndividAbilityDO.state.eq(1));

        prdEmployeIndividAbilityQuery.setPaging(query);
        prdEmployeIndividAbilityQuery.fillOrders(query, qPrdEmployeIndividAbilityDO);
        return PagingVO.<PrdEmployeIndividAbilityVO>builder()
                .total(query.fetchCount())
                .records(query.fetch())
                .build();

    }


    public Long del(List<Long> ids) {

        Long res = jpaQueryFactory.update(qPrdEmployeIndividAbilityDO)
                .set(qPrdEmployeIndividAbilityDO.deleteFlag, 1)
                .where(qPrdEmployeIndividAbilityDO.id.in(ids))
                .execute();

        return res;

    }


    public PrdEmployeIndividAbilityVO get(Long id) {

        PrdEmployeIndividAbilityVO prdEmployeIndividAbilityVO = select(PrdEmployeIndividAbilityVO.class)
                .where(qPrdEmployeIndividAbilityDO.id.eq(id))
                .fetchOne();

        return prdEmployeIndividAbilityVO;

    }


    public List<PrdEmployeIndividAbilityVO> getList(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        List<PrdEmployeIndividAbilityVO> res =
                select(PrdEmployeIndividAbilityVO.class)
                        .where(bulidPredicate(prdEmployeIndividAbilityQuery))
                        .fetch();

        return res;

    }


    private <T> JPAQuery<T> select(Class<T> cls) {

        return
                jpaQueryFactory.select(Projections.bean(cls,
                                qPrdIndividAbilityDO.docNo,
                                qPrdIndividAbilityDO.name.as("abilityName"),
                                qPrdAbilityLevelDO.id.as("abilityLevelId"),
                                qPrdAbilityLevelDO.levelDtlName,
                                qPrdEmployeIndividAbilityDO.abilityId,
                                qPrdAbilityLevelDO.abilityDesc,
                                qPrdEmployeIndividAbilityDO.obtainTime,
                                qPrdEmployeIndividAbilityDO.lastCertTime,
                                qPrdEmployeIndividAbilityDO.expirateTime,
                                qPrdEmployeIndividAbilityDO.userId,
                                qPrdEmployeIndividAbilityDO.empName,
                                qPrdEmployeIndividAbilityDO.empDocNo,
                                qPrdEmployeIndividAbilityDO.id,
                                qPrdEmployeIndividAbilityDO.createTime,
                                qPrdEmployeIndividAbilityDO.remark

                        )).from(qPrdEmployeIndividAbilityDO)
                        .leftJoin(qPrdAbilityLevelDO).on(qPrdAbilityLevelDO.id.eq(qPrdEmployeIndividAbilityDO.abilityLevelId))
                        .leftJoin(qPrdIndividAbilityDO).on(qPrdIndividAbilityDO.id.eq(qPrdEmployeIndividAbilityDO.abilityId));

    }


    private Predicate bulidPredicate(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        Predicate predicate = PredicateBuilder.builder()
                .andEq(StringUtils.isNotBlank(prdEmployeIndividAbilityQuery.getDocNo()), qPrdEmployeIndividAbilityDO.docNo, prdEmployeIndividAbilityQuery.getDocNo())
                .andEq(StringUtils.isNotBlank(prdEmployeIndividAbilityQuery.getAbilityName()), qPrdEmployeIndividAbilityDO.abilityName, prdEmployeIndividAbilityQuery.getAbilityName())
                .andEq(null != prdEmployeIndividAbilityQuery.getAbilityId(), qPrdEmployeIndividAbilityDO.abilityId, prdEmployeIndividAbilityQuery.getAbilityId())
                .andEq(StringUtils.isNotBlank(prdEmployeIndividAbilityQuery.getAbilityDesc()), qPrdEmployeIndividAbilityDO.abilityDesc, prdEmployeIndividAbilityQuery.getAbilityDesc())
                .andEq(null != prdEmployeIndividAbilityQuery.getObtainTime(), qPrdEmployeIndividAbilityDO.obtainTime, prdEmployeIndividAbilityQuery.getObtainTime())
                .andEq(null != prdEmployeIndividAbilityQuery.getLastCertTime(), qPrdEmployeIndividAbilityDO.lastCertTime, prdEmployeIndividAbilityQuery.getLastCertTime())
                .andEq(null != prdEmployeIndividAbilityQuery.getExpirateTime(), qPrdEmployeIndividAbilityDO.expirateTime, prdEmployeIndividAbilityQuery.getExpirateTime())
                .andEq(null != prdEmployeIndividAbilityQuery.getUserId(), qPrdEmployeIndividAbilityDO.userId, prdEmployeIndividAbilityQuery.getUserId())
                .andEq(StringUtils.isNotBlank(prdEmployeIndividAbilityQuery.getEmpName()), qPrdEmployeIndividAbilityDO.empName, prdEmployeIndividAbilityQuery.getEmpName())
                .andEq(StringUtils.isNotBlank(prdEmployeIndividAbilityQuery.getEmpDocNo()), qPrdEmployeIndividAbilityDO.empDocNo, prdEmployeIndividAbilityQuery.getEmpDocNo())
                .build();

        return predicate;

    }


    private List<Predicate> bulidPredicates(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        List<Predicate> predicates = new ArrayList<>();
        // 编号
        if (StringUtils.isNotEmpty(prdEmployeIndividAbilityQuery.getDocNo())) {
            predicates.add(qPrdEmployeIndividAbilityDO.docNo.eq(prdEmployeIndividAbilityQuery.getDocNo()));
        }
        // 能力名称
        if (StringUtils.isNotEmpty(prdEmployeIndividAbilityQuery.getAbilityName())) {
            predicates.add(qPrdEmployeIndividAbilityDO.abilityName.eq(prdEmployeIndividAbilityQuery.getAbilityName()));
        }
        // 能力id
        if (null != prdEmployeIndividAbilityQuery.getAbilityId()) {
            predicates.add(qPrdEmployeIndividAbilityDO.abilityId.eq(prdEmployeIndividAbilityQuery.getAbilityId()));
        }
        // 能力描述
        if (StringUtils.isNotEmpty(prdEmployeIndividAbilityQuery.getAbilityDesc())) {
            predicates.add(qPrdEmployeIndividAbilityDO.abilityDesc.eq(prdEmployeIndividAbilityQuery.getAbilityDesc()));
        }
        // 获取时间
        if (null != prdEmployeIndividAbilityQuery.getObtainTime()) {
            predicates.add(qPrdEmployeIndividAbilityDO.obtainTime.eq(prdEmployeIndividAbilityQuery.getObtainTime()));
        }
        // 上次认证时间
        if (null != prdEmployeIndividAbilityQuery.getLastCertTime()) {
            predicates.add(qPrdEmployeIndividAbilityDO.lastCertTime.eq(prdEmployeIndividAbilityQuery.getLastCertTime()));
        }
        // 过期时间
        if (null != prdEmployeIndividAbilityQuery.getExpirateTime()) {
            predicates.add(qPrdEmployeIndividAbilityDO.expirateTime.eq(prdEmployeIndividAbilityQuery.getExpirateTime()));
        }
        // 员工id
        if (null != prdEmployeIndividAbilityQuery.getUserId()) {
            predicates.add(qPrdEmployeIndividAbilityDO.userId.eq(prdEmployeIndividAbilityQuery.getUserId()));
        }
        // 员工名称
        if (StringUtils.isNotEmpty(prdEmployeIndividAbilityQuery.getEmpName())) {
            predicates.add(qPrdEmployeIndividAbilityDO.empName.eq(prdEmployeIndividAbilityQuery.getEmpName()));
        }
        // 员工编号
        if (StringUtils.isNotEmpty(prdEmployeIndividAbilityQuery.getEmpDocNo())) {
            predicates.add(qPrdEmployeIndividAbilityDO.empDocNo.eq(prdEmployeIndividAbilityQuery.getEmpDocNo()));
        }

//      Predicate predicate = ExpressionUtils.allOf(predicates);

        return predicates;
    }


    public Long count(PrdEmployeIndividAbilityQuery prdEmployeIndividAbilityQuery) {

        long res = select(PrdEmployeIndividAbilityVO.class)
                .where(bulidPredicate(prdEmployeIndividAbilityQuery))
                .fetchCount();

        return res;


    }

}

