package com.elitesland.tw.tw5.server.prd.inv.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Getter;
import lombok.Setter;
import java.io.Serializable;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import javax.validation.constraints.*;

/**
 * 发票商品分类对象
 *
 * @author zoey
 * @date 2023-07-31
 */
@Entity
@Table(name = "inv_item_cat", indexes = {
})
@org.hibernate.annotations.Table(appliesTo = "inv_item_cat", comment = "发票商品分类对象")
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class InvItemCatDO extends BaseModel implements Serializable  {
    /** 省份 */
    @Comment("省份")
    @Column()
    private String province;
    /** 商品编码（税务局） */
    @Comment("商品编码（税务局）")
    @Column()
    private String goodsCode;
    /** 商品编码名称（税务局） */
    @Comment("商品编码名称（税务局）")
    @Column()
    private String goodsCodeName;

    public void copy(InvItemCatDO source){
        BeanUtil.copyProperties(source,this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
