package com.elitesland.tw.tw5.server.prd.my.controller;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitesland.tw.tw5.api.prd.my.payload.TMoneyTransferPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TMoneyTransferQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TMoneyTransferService;
import com.elitesland.tw.tw5.api.prd.my.vo.TMoneyTransferVO;
import com.elitesland.tw.tw5.api.prd.purchase.payload.PaymentSlipPayload;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.util.Arrays;
import java.util.List;

/**
 * 资金划款
 *
 * @folder 资金划款
 * @author wangluyu
 * @date 2024-02-27
 */
@Api(tags = "资金划款")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/tMoneyTransfer")
@Slf4j
public class TMoneyTransferController {

    private final TMoneyTransferService tMoneyTransferService;

    private final UdcUtil udcUtil;
    /**
     * 资金划款-新增
     *
     * @folder 资金划款
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("资金划款-新增")
    public TwOutputUtil<TMoneyTransferVO> insert(@RequestBody TMoneyTransferPayload payload){
         return TwOutputUtil.ok(tMoneyTransferService.insert(payload));
    }

    /**
     * 资金划款-更新
     *
         * @folder 资金划款
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("资金划款-更新")
    public TwOutputUtil<TMoneyTransferVO> update(@RequestBody TMoneyTransferPayload payload){
        return TwOutputUtil.ok(tMoneyTransferService.update(payload));
    }

    /**
     * 资金划款-更新,支持置空,置空的字段需需要借助 protected List<String> nullFields;
     *
     * @folder 资金划款
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping("update")
    @ApiOperation("资金划款-更新,支持置空 置空的字段需需要借助 protected List<String> nullFields;")
    public TwOutputUtil<Long> updateByKeyDynamic(@RequestBody TMoneyTransferPayload payload){
        return TwOutputUtil.ok(tMoneyTransferService.updateByKeyDynamic(payload));
    }

    /**
     * 资金划款-主键查询
     *
     * @folder 资金划款
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    @UdcNameClass
    @ApiOperation("资金划款-主键查询")
    public TwOutputUtil<TMoneyTransferVO> queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(tMoneyTransferService.queryByKey(key));
    }

    /**
     * 资金划款-分页
     *
         * @folder 资金划款
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    @UdcNameClass
    @ApiOperation("资金划款-分页")
    public TwOutputUtil<PagingVO<TMoneyTransferVO>> paging(TMoneyTransferQuery query) {
        return TwOutputUtil.ok(tMoneyTransferService.queryPaging(query));
    }


//    /**
//     * 确认线下付款
//     *
//     * @param payloadList 单据集合
//     * @return {@link TwOutputUtil}
//     * @folder 付款单记录-更新
//     */
//    @PostMapping("/confirmOfflinePayment")
//    @UdcNameClass
//    @ApiOperation("确认线下付款")
//    public TwOutputUtil<Boolean> confirmOfflinePayment(@RequestBody List<TMoneyTransferPayload> payloadList){
//
//        if (CollUtil.isEmpty(payloadList)) {
//            throw TwException.error("", "请选择数据");
//        }
//        tMoneyTransferService.confirmOfflinePayment(payloadList);
//        return TwOutputUtil.ok(true);
//    }


//    /**
//     * 提交网银支付
//     *
//     * @param payloadList 单据集合
//     * @return {@link TwOutputUtil}
//     * @folder
//     */
//    @PostMapping("/commitOnlinePayment")
//    @UdcNameClass
//    @ApiOperation("提交网银支付")
//    public TwOutputUtil commitOnlinePayment(@RequestBody List<TMoneyTransferPayload> payloadList) {
//
//
//        if (CollUtil.isEmpty(payloadList)) {
//            throw TwException.error("", "请选择数据");
//        }
//        if (payloadList.size() > 1) {
//            throw TwException.error("", "只能选择一条数据");
//        }
//        tMoneyTransferService.commitOnlinePayment(payloadList);
//        return TwOutputUtil.ok();
//    }




    @PostMapping("/test00")
    @UdcNameClass
    @ApiOperation("test00")
    public TwOutputUtil test00(){
        String str="{\n" +
                "            \"message\":{\n" +
                "              \"ServiceRequest: FREQ_55_Transactions_EL\":{\n" +
                "                \"App Stack Form Exception\":{\n" +
                "                  \"Expecting Form\":\"PEL0911_WEL0911A\",\n" +
                "                  \"Resulting Form\":\"PEL0911D_WEL0911DA_EL0001\"\n" +
                "                },\n" +
                "                \"JAS Response\":{\n" +
                "                  \"fs_PEL0911D_WEL0911DA\":{\n" +
                "                    \"title\":\"日记账分录\",\n" +
                "                    \"data\":{\n" +
                "                    },\n" +
                "                    \"errors\":[\n" +
                "                    ],\n" +
                "                    \"warnings\":[\n" +
                "                    ]\n" +
                "                  },\n" +
                "                  \"stackId\":1,\n" +
                "                  \"stateId\":1,\n" +
                "                  \"rid\":\"c3fb51c4aca23ef5\",\n" +
                "                  \"currentApp\":\"PEL0911D_WEL0911DA_EL0001\",\n" +
                "                  \"timeStamp\":\"2024-05-24:13.15.23\",\n" +
                "                  \"sysErrors\":[\n" +
                "                  ]\n" +
                "                }\n" +
                "              }\n" +
                "            },\n" +
                "            \"exception\":\"Exception\",\n" +
                "            \"timeStamp\":\"2024-05-24T13:15:24.008+0800\",\n" +
                "            \"userDefinedErrorText\":\"\",\n" +
                "            \"status\":\"ERROR\",\n" +
                "            \"jde__simpleMessage\":\"FREQ_55_Transactions_EL failed: App Stack Exception - Expecting Form: PEL0911_WEL0911A  Resulting Form: PEL0911D_WEL0911DA_EL0001\",\n" +
                "            \"jde__status\":\"ERROR\",\n" +
                "            \"jde__startTimestamp\":\"2024-05-24T13:15:23.460+0800\",\n" +
                "            \"jde__endTimestamp\":\"2024-05-24T13:15:24.013+0800\",\n" +
                "            \"jde__serverExecutionSeconds\":0.553\n" +
                "          }\n";

        cn.hutool.json.JSONObject jsonObject = JSONUtil.parseObj(str);
        String jde__status = jsonObject.get("jde__status").toString();
        return TwOutputUtil.ok(jde__status);
    }


    /**
     * 资金划款-查询列表
     *
     * @folder 资金划款
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("资金划款-查询列表")
    public TwOutputUtil<List<TMoneyTransferVO>> queryList(TMoneyTransferQuery query) {
        return TwOutputUtil.ok(tMoneyTransferService.queryListDynamic(query));
    }

    /**
     * 资金划款-导出
     *
     * @param
     * @return
     */
    @ApiModelProperty("资金划款-导出")
    @GetMapping("/exportExcel")
    public void exportExcel(TMoneyTransferQuery query, HttpServletResponse response) throws IOException {
        List<TMoneyTransferVO> list = tMoneyTransferService.queryListDynamic(query);
        if(!CollectionUtils.isEmpty(list)){
            list = udcUtil.translateList(list);
            //定义文件名称
            String sheetName = "资金划款导出";
            //对文件名进行固定格式编码
            String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
            //设置请求响应内容类型
            //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            //设置请求响应内容编码方式
            response.setCharacterEncoding("utf-8");
            //文件下载，指定默认名
            response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

            final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), TMoneyTransferVO.class)
                    .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                    .sheet(sheetName);
            // 列
            ExcelUtil.excelHelper(sheet, TMoneyTransferVO.class, null);
            //写入
            sheet.doWrite(list);
        }
    }


    /**
     * 资金划款-删除
     *
         * @folder 资金划款
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("资金划款-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
         tMoneyTransferService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}

