package com.elitesland.tw.tw5.server.prd.my.entity;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.bean.copier.CopyOptions;
import com.elitescloud.boot.model.entity.BaseModel;
import com.elitescloud.cloudt.common.annotation.Comment;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.*;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 工时表
 *
 * @author duwh
 * @date 2022-12-09
 */
@Entity
@Table(name = "t_timesheet", indexes = {
        @Index(name = "ts_user_index", columnList = "ts_user_id"),
        @Index(name = "task_index", columnList = "task_id"),
        @Index(name = "vacation_index", columnList = "vacation_apply_detail_id"),
        @Index(name = "proj_index", columnList = "proj_id"),
        @Index(name = "reason_id_index", columnList = "reason_id"),
        @Index(name = "reason_type_index", columnList = "reason_type")
})
@org.hibernate.annotations.Table(appliesTo = "t_timesheet", comment = "工时表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class TimesheetDO extends BaseModel {
    /**
     * 填报用户id
     */
    @Comment("填报用户id")
    @Column(name = "ts_user_id")
    private Long tsUserId;
    /**
     * 填报Bu主键
     */
    @Comment("填报用户Bu主键")
    @Column()
    private Long tsUserBuId;
    /**
     * 填报Bu名称
     */
    @Comment("填报用户Bu名称")
    @Column()
    private String tsUserBuName;
    /**
     * 状态
     */
    @Comment("状态")
    @Column()
    private String tsStatus;
    /**
     * 类型
     */
    @Comment("类型")
    @Column()
    private String type;
    /**
     * 审批用户id
     */
    @Comment("审批用户id")
    @Column()
    private Long apprUserId;
    /**
     * 客户经营计划主键
     */
    @Comment("客户经营计划主键")
    @Column()
    private Long operPlanId;
    /**
     * 客户经营计划名称冗余
     */
    @Comment("客户经营计划名称冗余")
    @Column()
    private String operPlanName;
    /**
     * 项目id
     */
    @Comment("项目id")
    @Column(name = "proj_id")
    private Long projId;
    /**
     * 项目编号冗余
     */
    @Comment("项目编号冗余")
    @Column()
    private String projNo;
    /**
     * 项目名称
     */
    @Comment("项目名称")
    @Column()
    private String projName;

    @Comment("事由id")
    @Column(name = "reason_id")
    private Long reasonId;
    @Comment("事由名称")
    @Column()
    private String reasonName;
    @Comment("事由类型 PROJ_CONTRACT 合同项目 PROJ_OPPO 售前商机项目 PROJ_BU bu项目")
    @Column(name = "reason_type")
    private String reasonType;

    /**
     * 项目阶段id（活动阶段）
     */
    @Comment("项目阶段id（活动阶段")
    @Column()
    private Long stageId;
    /**
     * 项目阶段编号（冗余）
     */
    @Comment("项目阶段编号（冗余）")
    @Column()
    private String stageNo;
    /**
     * 项目阶段名称冗余
     */
    @Comment("项目阶段名称冗余")
    @Column()
    private String stageName;

    /**
     * 任务包id
     */
    @Comment("任务包id")
    @Column()
    private Long taskPackageId;
    /**
     * 任务包编号 冗余
     */
    @Comment("任务包编号 冗余")
    @Column()
    private String taskPackageNo;
    /**
     * 任务包名称冗余
     */
    @Comment("任务包名称冗余")
    @Column()
    private String taskPackageName;
    /**
     * 任务id
     */
    @Comment("任务id")
    @Column(name = "task_id")
    private Long taskId;
    /**
     * 任务编号冗余
     */
    @Comment("任务编号冗余")
    @Column()
    private String taskNo;
    /**
     * 任务名称冗余
     */
    @Comment("任务名称冗余")
    @Column()
    private String taskName;
    /**
     * 任务包申请状态
     */
    @Comment("任务包申请状态")
    @Column()
    private String taskApplyStatus;
    /**
     * 活动id
     */
    @Comment("活动id")
    @Column()
    private Long actId;
    /**
     * 活动名称冗余
     */
    @Comment("活动名称冗余")
    @Column()
    private String actName;
    /**
     * 活动编号冗余
     */
    @Comment("活动编号冗余")
    @Column()
    private String actNo;
    /**
     * 当量
     */
    @Comment("当量")
    @Column()
    private BigDecimal eqva;
    /**
     * 11上午、22下午、33全天、44自定义
     */
    @Comment("11上午、22下午、33全天、44自定义")
    @Column()
    private String workType;
    /**
     * 工作日期
     */
    @Comment("工作日期")
    @Column()
    private LocalDate workDate;
    /**
     * 工时
     */
    @Comment("工时")
    @Column()
    private BigDecimal workHour;
    /**
     * 工作说明
     */
    @Comment("工作说明")
    @Column()
    private String workDesc;
    /**
     * 本周开始日期
     */
    @Comment("本周开始日期")
    @Column()
    private LocalDate weekStartDate;
    /**
     * 所在年周
     */
    @Comment("所在年周")
    @Column()
    private Integer yearWeek;
    /**
     * 总计人天
     */
    @Comment("总计人天")
    @Column()
    private BigDecimal totalManday;
    /**
     * 总计小时数
     */
    @Comment("总计小时数")
    @Column()
    private BigDecimal totalWorkHour;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprStatus;
    /**
     * 任务标识
     */
    @Comment("任务标识")
    @Column()
    private String tsTaskIden;
    /**
     * 活动标识
     */
    @Comment("活动标识")
    @Column()
    private String tsActIden;
    /**
     * 结算状态
     */
    @Comment("结算状态")
    @Column()
    private String settleStatus;
    /**
     * 审批状态
     */
    @Comment("审批状态")
    @Column()
    private String apprResult;
    /**
     * 是否加班、udc >> yesno
     */
    @Comment("是否加班、udc >> yesno")
    @Column()
    private String workFlag;
    /**
     * 可生成调休天数
     */
    @Comment("可生成调休天数")
    @Column()
    private Float workDayOff;
    /**
     * 相关加班安排id
     */
    @Comment("相关加班安排id")
    @Column()
    private Integer workRelId;
    /**
     * 可生成调休天数的状态
     */
    @Comment("可生成调休天数的状态")
    @Column()
    private String workDayOffStatus;
    /**
     * 工作计划id
     */
    @Comment("工作计划id")
    @Column()
    private Long workPlanId;
    /**
     * 审批时间
     */
    @Comment("审批时间")
    @Column()
    private LocalDateTime approvalTime;
    @Transient
    private String approvalTimeStr;
    /**
     * 提交时间
     */
    @Comment("提交时间")
    @Column()
    private LocalDateTime submitTime;
    @Transient
    private String submitTimeStr;
    /**
     * 最后提交时间
     */
    @Comment("最后提交时间")
    @Column()
    private LocalDateTime lastSubmitTime;
    /**
     * 是否是系统自动生成，0：否，1：是
     */
    @Comment("是否是系统自动生成，0：否，1：是")
    @Column()
    private Integer autoSaveFlag;
    /**
     * 请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1
     */
    @Comment("请假流程覆盖已填写工时标记 默认0 已覆盖拆分 1")
    @Column()
    private Integer autoUpdateFlag;
    /**
     * 流程实例id
     */
    @Comment("流程实例id")
    @Column()
    private String procId;

    /**
     * UT值
     */
    @Comment("UT值")
    @Column()
    private Integer ut;
    /**
     * 拓展1
     */
    @Comment("拓展1")
    @Column()
    private String ext1;
    /**
     * 拓展2
     */
    @Comment("拓展2--已使用（加班主键）")
    @Column()
    private String ext2;
    /**
     * 拓展3
     */
    @Comment("拓展3")
    @Column()
    private String ext3;
    /**
     * 出差类型 本地现场80，出差100，本地延迟0
     */
    @Comment("出差类型 本地现场80，出差100，本地延迟0")
    @Column()
    private String ext4;
    /**
     * 拓展5
     */
    @Comment("拓展5")
    @Column()
    private String ext5;
    /**
     * 4.0的工时id
     */
    @Column(name = "timesheet_id_v4")
    private Long timesheetIdV4;

    /**
     * 工时id,仅用于类型转换
     */
    @Transient
    private Long timesheetId;

    /**
     * 工作时间合计
     */
    @Transient
    private Double sumWorkHour;

    /**
     * 4.0删除标志
     */
    @Transient
    private Byte delFlag;

    /**
     * 上午or下午
     */
    private String vInterval;

    /**
     * 帮我吧工时
     */
    @Comment("版本我吧工时")
    @Column(name = "bangwo8_work_hour")
    private BigDecimal bangwo8WorkHour;


    /**
     * 帮我吧工单链接
     */
    @Comment("帮我吧工单链接")
    @Column()
    private String ticketUrl;


    /**
     * 帮我吧工时唯一标识
     */
    @Comment("版本我吧工时唯一标识")
    @Column(name = "bangwo8_no")
    private Long bangwo8No;

    /**
     * 地址
     */
    @Comment("工时填写地址")
    @Column()
    private String location;


    /**
     * 请假申请明细
     */
    @Comment("请假申请明细id")
    @Column(name = "vacation_apply_detail_id")
    private Long vacationApplyDetailId;

    @Comment("是否可退回标记")
    @Column()
    private Boolean returnFlag;

    public void copy(TimesheetDO source) {
        BeanUtil.copyProperties(source, this, CopyOptions.create().setIgnoreNullValue(true));
    }
}
