package com.elitesland.tw.tw5.server.prd.my.service;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.write.builder.ExcelWriterSheetBuilder;
import com.alibaba.excel.write.style.column.LongestMatchColumnWidthStyleStrategy;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.my.payload.TAttendanceNormalPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TAttendanceNormalQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TAttendanceNormalService;
import com.elitesland.tw.tw5.api.prd.my.service.VacationService;
import com.elitesland.tw.tw5.api.prd.my.vo.*;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgEmployeeService;
import com.elitesland.tw.tw5.api.prd.org.service.PrdOrgOrganizationService;
import com.elitesland.tw.tw5.server.common.HttpUtil;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.excel.ExcelUtil;
import com.elitesland.tw.tw5.server.common.util.BeanUtil;
import com.elitesland.tw.tw5.server.prd.my.convert.TAttendanceNormalConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalDAO;
import com.elitesland.tw.tw5.server.prd.my.dao.TAttendanceNormalMonthDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TAttendanceNormalDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TAttendanceNormalRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgSyncLogDAO;
import com.elitesland.tw.tw5.server.prd.org.entity.PrdOrgSyncLogDO;
import com.elitesland.tw.tw5.server.udc.UdcUtil;
import com.xxl.job.core.log.XxlJobLogger;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URLEncoder;
import java.time.*;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalAdjusters;
import java.util.*;
import java.util.stream.Collectors;

@Service
@RequiredArgsConstructor
@Slf4j
public class TAttendanceNormalServiceImpl extends BaseServiceImpl implements TAttendanceNormalService {

    private final TAttendanceNormalRepo tAttendanceNormalRepo;
    private final TAttendanceNormalDAO tAttendanceNormalDAO;
    private final TAttendanceNormalMonthDAO tAttendanceNormalMonthDAO;
    private final PrdOrgSyncLogDAO daoLog;
    private final HttpUtil httpUtil;
    private final PrdOrgEmployeeService employeeService;
    private final PrdOrgOrganizationService orgService;
    private final VacationService vacationService;
    private final UdcUtil udcUtil;

    @Value("${tw4.attendance.normal}")
    private String attendanceNormalTo5Url;

    @Override
    public PagingVO<TAttendanceNormalVO> queryPaging(TAttendanceNormalQuery query) {
        PagingVO<TAttendanceNormalVO> tAttendanceNormalVOPagingVO = tAttendanceNormalDAO.queryPaging(query);
        List<TAttendanceNormalVO> records = tAttendanceNormalVOPagingVO.getRecords();
        translateList(records);
        return tAttendanceNormalVOPagingVO;
    }

    @Override
    public PagingVO<TAttendanceNormalMonthVO> queryPagingMonth(TAttendanceNormalQuery query) {
        PagingVO<TAttendanceNormalMonthVO> tAttendanceNormalMonthVOPagingVO = tAttendanceNormalMonthDAO.queryPaging(query);
        List<TAttendanceNormalMonthVO> records = tAttendanceNormalMonthVOPagingVO.getRecords();
        translateMonthRecords(records);
        return tAttendanceNormalMonthVOPagingVO;
    }

    @Override
    public List<TAttendanceNormalMonthVO> queryListMonth(TAttendanceNormalQuery query) {
        List<TAttendanceNormalMonthVO> tAttendanceNormalMonthVOS = tAttendanceNormalMonthDAO.queryListDynamic(query);
        translateMonthRecords(tAttendanceNormalMonthVOS);
        return tAttendanceNormalMonthVOS;
    }

    @Override
    public List<TAttendanceNormalVO> queryListDynamic(TAttendanceNormalQuery query) {
        List<TAttendanceNormalVO> tAttendanceNormalVOS = tAttendanceNormalDAO.queryListDynamic(query);
        translateList(tAttendanceNormalVOS);
        return tAttendanceNormalVOS;
    }


    @Override
    public void exportListMonth(TAttendanceNormalQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "打卡月度报表";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        List<TAttendanceNormalMonthVO> tAttendanceNormalVOS = queryListMonth(query);
        if (tAttendanceNormalVOS.size() > 50000) {
            throw TwException.error("500", "导出数据过大，请分批操作，目前导出数量：" + tAttendanceNormalVOS.size());
        }
        List resultList = udcUtil.translateList(tAttendanceNormalVOS);
        List<TAttendanceNormalMonthExcelExport> excelList = TAttendanceNormalConvert.INSTANCE.voMonthListMonthVoExcelExport(resultList);
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), TAttendanceNormalMonthExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, TAttendanceNormalMonthExcelExport.class, null);
        //写入
        sheet.doWrite(excelList);
    }


    @Override
    public TAttendanceNormalVO queryByKey(Long key) {
        TAttendanceNormalDO entity = tAttendanceNormalRepo.findById(key).orElseGet(TAttendanceNormalDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceNormalVO vo = TAttendanceNormalConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceNormalVO insert(TAttendanceNormalPayload payload) {
        TAttendanceNormalDO entityDo = TAttendanceNormalConvert.INSTANCE.toDo(payload);
        return TAttendanceNormalConvert.INSTANCE.toVo(tAttendanceNormalRepo.save(entityDo));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TAttendanceNormalVO update(TAttendanceNormalPayload payload) {
        TAttendanceNormalDO entity = tAttendanceNormalRepo.findById(payload.getId()).orElseGet(TAttendanceNormalDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TAttendanceNormalDO entityDo = TAttendanceNormalConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        return TAttendanceNormalConvert.INSTANCE.toVo(tAttendanceNormalRepo.save(entity));
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TAttendanceNormalPayload payload) {
        TAttendanceNormalDO entity = tAttendanceNormalRepo.findById(payload.getId()).orElseGet(TAttendanceNormalDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tAttendanceNormalDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tAttendanceNormalDAO.deleteSoft(keys);
        }

    }

    @Override
    public List<Long> findResAttendanceLog(Long resId, LocalDate attendanceDate) {
        return tAttendanceNormalDAO.findResAttendanceLog(resId, attendanceDate);
    }

    @Override
    public String findStartTime(Long id) {
        return tAttendanceNormalDAO.findStartTime(id);
    }

    @Override
    public String findResAttendanceStatus(Long id) {
        return tAttendanceNormalDAO.findResAttendanceStatus(id);
    }

    @Override
    public String findResAttendanceResult(Long id) {
        return tAttendanceNormalDAO.findResAttendanceResult(id);
    }

    @Override
    public List<MobAttendanceLogVO> getResAttendanceLog(Long resId, LocalDate attendanceDateStart, LocalDate attendanceDateEnd) {
        return tAttendanceNormalDAO.getResAttendanceLog(resId, attendanceDateStart, attendanceDateEnd);
    }

    @Override
    public void attendanceNormalTo5(String param) {
        String syncType = "attendanceNormalTo5";
        LocalDateTime localDateTime = daoLog.queryOrgSyncLog(syncType);
        if (localDateTime == null) {
            localDateTime = LocalDateTime.of(1970, 1, 1, 0, 0);
        } else {
            //将同步时间提前10秒，防止拉数据遗漏
            localDateTime = localDateTime.minusSeconds(10);
        }
        XxlJobLogger.log("syncVacationApply localDateTime：" + localDateTime);
        //TODO参数内容待确定
        //同步到5.0
        Map<String, Long> reqMap = new HashMap<>();
        final long asyncTimeLong = localDateTime.toEpochSecond(ZoneOffset.of("+8"));
        reqMap.put("asyncTime", asyncTimeLong);
        //同步到5.0
        XxlJobLogger.log("syncVacationApplyDetail syncTime：" + asyncTimeLong);
        String result = httpUtil.sendSyncGet(attendanceNormalTo5Url, reqMap);
        Map<String, Object> data = (Map) JSONObject.parse(result);
        PrdOrgSyncLogDO logDO = new PrdOrgSyncLogDO();
        String syncData = "";
        if (("true".equals(data.get("ok") + ""))) {
            if (!ObjectUtils.isEmpty(data.get("datum"))) {
                Map<Long, Long> v4AndV5UserIds = employeeService.getV4AndV5UserIds();
                final Object datum = data.get("datum");
                List<Map<String, Object>> attendanceNormalData = (List<Map<String, Object>>) datum;
                //用户请假申请数据构建
                List<TAttendanceNormalDO> tAttendanceNormalDOList = new ArrayList<>();
                //查询5.0已有的数据，对新旧数据进行对比，如有变动，进行更新操作
                List<Long> tw4AttendanceNormalIds = attendanceNormalData.stream()
                        .map(attendanceNormal -> ((Integer) (attendanceNormal.get("id") == null ? 0 : attendanceNormal.get("id"))).longValue())
                        .collect(Collectors.toList());
                //根据4.0id获取表中旧值，决定进行插入或更新
                List<TAttendanceNormalDO> oldTAttendanceNormalDOs = tAttendanceNormalRepo.selectByIdV4List(tw4AttendanceNormalIds);
                //idV4相等的进行更新操作
                for (TAttendanceNormalDO attendanceNormalDO : oldTAttendanceNormalDOs) {
                    Long attendanceNormalIdV4 = attendanceNormalDO.getAttendanceNormalIdV4();
                    for (Map applyData : attendanceNormalData) {
                        Long attendanceNormalIdV4FromV4 = ((Integer) ((null == applyData.get("id") ? 0 : applyData.get("id")))).longValue();
                        if (attendanceNormalIdV4.equals(attendanceNormalIdV4FromV4)) {
                            //有则更新表中记录,并跳出内层循环
                            TAttendanceNormalDO attendanceNormalDO1 = this.translateFromV4(applyData, v4AndV5UserIds);
                            attendanceNormalDO1.setId(attendanceNormalDO.getId());
                            tAttendanceNormalDOList.add(attendanceNormalDO1);
                            break;
                        }
                    }
                }
                tAttendanceNormalRepo.saveAll(tAttendanceNormalDOList);

                //筛选出不存在的，直接插入
                List<Map<String, Object>> newDatas = attendanceNormalData.stream().filter(applyData -> {
                    boolean flag = true;
                    Long applyId = ((Integer) (applyData.get("id") == null ? 0 : applyData.get("id"))).longValue();
                    for (TAttendanceNormalDO attendanceNormalDO : oldTAttendanceNormalDOs) {
                        if (attendanceNormalDO.getAttendanceNormalIdV4().equals(applyId)) {
                            flag = false;
                        }
                    }
                    return flag;
                }).collect(Collectors.toList());
                List<TAttendanceNormalDO> newTAttendanceNormalDOs = new ArrayList<>();
                //插入新数据
                for (Map<String, Object> newData : newDatas) {
                    TAttendanceNormalDO attendanceNormalDO1 = this.translateFromV4(newData, v4AndV5UserIds);
                    newTAttendanceNormalDOs.add(attendanceNormalDO1);
                }
                tAttendanceNormalRepo.saveAll(newTAttendanceNormalDOs);
                syncData = "更新了正常打卡" + attendanceNormalData.size() + "条数据";
            } else {
                syncData = "正常打卡数据未变化";
            }
        } else {
            syncData = data.get("reason") + "";
        }
        logDO.setSyncType(syncType);
        logDO.setSyncData(syncData);
        daoLog.save(logDO);
        log.info("【正常打卡信息同步，同步日志：{}】", logDO);
    }

    @Override
    public void export(TAttendanceNormalQuery query, HttpServletResponse response) throws IOException {
        //定义文件名称
        String sheetName = "打卡报表";
        //导出顺序是反的
        OrderItem orderItem = OrderItem.asc("createTime");
        query.defaultOrder(orderItem);
        List<TAttendanceNormalVO> tAttendanceNormalVOS = queryListDynamic(query);
        if (tAttendanceNormalVOS.size() > 50000) {
            throw TwException.error("500", "导出数据过大，请分批操作，目前导出数量：" + tAttendanceNormalVOS.size());
        }
        List<TAttendanceNormalVO> resultList = udcUtil.translateList(tAttendanceNormalVOS);
        List<TAttendanceNormalExcelExport> excelList = TAttendanceNormalConvert.INSTANCE.voListVoExcelExport(resultList);
        for (TAttendanceNormalExcelExport tAttendanceNormalExcelExport : excelList) {
            for (TAttendanceNormalVO attendanceNormalVO : resultList) {
                if (attendanceNormalVO.getId().equals(tAttendanceNormalExcelExport.getId())) {
                    tAttendanceNormalExcelExport.setAttendanceDateStr(attendanceNormalVO.getAttendanceDate() + "");
                }
            }
        }
        //对文件名进行固定格式编码
        String fileName = URLEncoder.encode(sheetName + System.currentTimeMillis() + ".xlsx", "UTF-8");
        //设置请求响应内容类型
        //作用:使客户端浏览器，区分不同种类的数据，并根据不同的MIME调用浏览器内不同的程序嵌入模块来处理相应的数据。
        response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
        //设置请求响应内容编码方式
        response.setCharacterEncoding("utf-8");
        //文件下载，指定默认名
        response.addHeader("Content-Disposition", "attachment;filename=" + fileName);

        final ExcelWriterSheetBuilder sheet = EasyExcel.write(response.getOutputStream(), TAttendanceNormalExcelExport.class)
                .registerWriteHandler(new LongestMatchColumnWidthStyleStrategy())
                .sheet(sheetName);
        // 列
        ExcelUtil.excelHelper(sheet, TAttendanceNormalExcelExport.class, null);
        //写入
        sheet.doWrite(excelList);
    }


    /**
     * 翻译
     *
     * @param attendanceNormalData v4的数据
     * @param v4AndV5UserIds       v4与v5对应的userId
     * @return
     */
    private TAttendanceNormalDO translateFromV4(Map attendanceNormalData, Map<Long, Long> v4AndV5UserIds) {
        TAttendanceNormalDO attendanceNormalDO = BeanUtil.mapToBean(TAttendanceNormalDO.class, attendanceNormalData, Arrays.asList("id", "createTime", "createUserId"));
        if (null != attendanceNormalData.get("id")) {
            attendanceNormalDO.setAttendanceNormalIdV4(((Integer) attendanceNormalData.get("id")).longValue());
        }
        if (null != attendanceNormalData.get("attendanceResId")) {
            Long attendanceResId = ((Integer) attendanceNormalData.get("attendanceResId")).longValue();
            attendanceNormalDO.setAttendanceResId(v4AndV5UserIds.get(attendanceResId));
        }
        return attendanceNormalDO;
    }

    private void translateList(List<TAttendanceNormalVO> tAttendanceNormalVOS) {
        for (TAttendanceNormalVO tAttendanceNormalVO : tAttendanceNormalVOS) {
            if (StringUtils.hasText(tAttendanceNormalVO.getAttendanceTimeStart()) && StringUtils.hasText(tAttendanceNormalVO.getAttendanceTimeEnd())) {
                tAttendanceNormalVO.setAttendanceTime(getDuration(tAttendanceNormalVO.getAttendanceTimeStart(), tAttendanceNormalVO.getAttendanceTimeEnd()));
            }
        }
    }


    private String getDuration(String time1String, String time2String) {

        LocalTime time1 = LocalTime.parse(time1String, DateTimeFormatter.ofPattern("HH:mm"));
        LocalTime time2 = LocalTime.parse(time2String, DateTimeFormatter.ofPattern("HH:mm"));

        long minutesBetween = ChronoUnit.MINUTES.between(time1, time2);
        int hours = (int) minutesBetween / 60;
        int minutes = (int) minutesBetween % 60;

        String durationString = String.format("%d:%02d", hours, minutes);
        return durationString;
    }

    private void translateMonthRecords(List<TAttendanceNormalMonthVO> records) {
        for (TAttendanceNormalMonthVO record : records) {
            String attendanceMonth = record.getAttendanceMonth();
            // 解析月份字符串为YearMonth对象
            YearMonth yearMonth = YearMonth.parse(attendanceMonth);
            // 获取该月的总天数
            Integer daysInMonth = yearMonth.lengthOfMonth();

            // 使用DateTimeFormatter解析字符串
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd");

            LocalDate monthDayFirst = LocalDate.parse(attendanceMonth + "-01", formatter);  // 添加"-01"来表示月的第一天
            // 查询这个月的节假日天数
            LocalDate monthDayLast = monthDayFirst.with(TemporalAdjusters.lastDayOfMonth());
            // 获取当月的节假日
            List<LocalDate> vacationDays = vacationService.findVacationDay(monthDayFirst, monthDayLast);
            Integer vacationDaysSize = vacationDays == null ? 0 : vacationDays.size();
            long shouldClockDays = Long.parseLong(String.valueOf(daysInMonth - vacationDaysSize));
            record.setShouldColock(shouldClockDays);

            String attendanceResultDetailStr = record.getAttendanceResultDetailStr();
            // 解析这个月打卡正常的天数
            if (StringUtils.hasText(attendanceResultDetailStr)) {
                String[] split = attendanceResultDetailStr.split(",");
                long normalCount = Arrays.stream(split)
                        .filter("NORMAL"::equals)
                        .count();
                record.setNormalDays(normalCount);
                record.setAbnormalDays(shouldClockDays - normalCount);
            } else {
                record.setNormalDays(0L);
                record.setAbnormalDays(shouldClockDays);
            }
        }
    }

}

