package com.elitesland.tw.tw5.server.prd.my.service;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.core.common.BaseServiceImpl;
import com.elitesland.tw.tw5.api.prd.my.payload.TServerApplyPayload;
import com.elitesland.tw.tw5.api.prd.my.query.TServerApplyQuery;
import com.elitesland.tw.tw5.api.prd.my.service.TServerApplyService;
import com.elitesland.tw.tw5.api.prd.my.vo.TServerApplyVO;
import com.elitesland.tw.tw5.api.prd.org.vo.PrdOrgRoleVO;
import com.elitesland.tw.tw5.server.common.GenerateSeqNumConstants;
import com.elitesland.tw.tw5.server.common.TwException;
import com.elitesland.tw.tw5.server.common.service.TransactionUtilService;
import com.elitesland.tw.tw5.server.common.workFlow.ProcDefKey;
import com.elitesland.tw.tw5.server.prd.common.CacheUtil;
import com.elitesland.tw.tw5.server.prd.common.WorkflowUtil;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.WorkFlowStatusEnum;
import com.elitesland.tw.tw5.server.prd.my.convert.TServerApplyConvert;
import com.elitesland.tw.tw5.server.prd.my.dao.TServerApplyDAO;
import com.elitesland.tw.tw5.server.prd.my.entity.TServerApplyDO;
import com.elitesland.tw.tw5.server.prd.my.repo.TServerApplyRepo;
import com.elitesland.tw.tw5.server.prd.org.dao.PrdOrgOrganizationDAO;
import com.elitesland.workflow.ProcessInfo;
import com.elitesland.workflow.payload.SetVariablesPayload;
import com.elitesland.workflow.payload.StartProcessPayload;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Optional;

/**
 * 服务器申请
 *
 * @author lemon
 * @date 2023-09-23
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class TServerApplyServiceImpl extends BaseServiceImpl implements TServerApplyService {

    private final TServerApplyRepo tServerApplyRepo;
    private final TServerApplyDAO tServerApplyDAO;
    private final CacheUtil cacheUtil;

    private final WorkflowUtil workflowUtil;

    private final PrdOrgOrganizationDAO daoOrg;
    @Value("${tw5.workflow.enabled}")
    private Boolean workflow_enabled;

    @Value("${tw5.workflow.orgId}")
    private Long workflow_orgId;
    private final TransactionUtilService transactionUtilService;
    @Override
    public PagingVO<TServerApplyVO> queryPaging(TServerApplyQuery query){
        PagingVO<TServerApplyVO> paging = tServerApplyDAO.queryPaging(query);
        return paging;
    }

    @Override
    public List<TServerApplyVO> queryListDynamic(TServerApplyQuery query){
        return tServerApplyDAO.queryListDynamic(query);
    }

    @Override
    public TServerApplyVO queryByKey(Long key) {
        TServerApplyDO entity = tServerApplyRepo.findById(key).orElseGet(TServerApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TServerApplyVO vo = TServerApplyConvert.INSTANCE.toVo(entity);
        return vo;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TServerApplyVO insert(TServerApplyPayload payload) {
        payload.setApplyDate(LocalDate.now());
        payload.setApplyNo(generateSeqNum(GenerateSeqNumConstants.SERVER_APPLY_NO));
        TServerApplyDO entityDo = TServerApplyConvert.INSTANCE.toDo(payload);
        TServerApplyDO save = tServerApplyRepo.save(entityDo);
        if (payload.getSubmit() != null && payload.getSubmit()) {
            serverApplyProc(save);
        }
        return TServerApplyConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public TServerApplyVO update(TServerApplyPayload payload) {
        TServerApplyDO entity = tServerApplyRepo.findById(payload.getId()).orElseGet(TServerApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        TServerApplyDO entityDo = TServerApplyConvert.INSTANCE.toDo(payload);
        entity.copy(entityDo);
        TServerApplyDO save = tServerApplyRepo.save(entity);
        if (StringUtils.hasText(payload.getProcInstId())) {
            SetVariablesPayload setVariablesPayload = new SetVariablesPayload();
            setVariablesPayload.setProcInstId(payload.getProcInstId());
            HashMap<String, Object> variables = new HashMap<>();
            if ("CLOUD".equals(payload.getType())) {
                variables.put("cloudServerFlag", true);
            } else {
                variables.put("cloudServerFlag", false);
            }
            setVariablesPayload.setVariables(variables);
            workflowUtil.setVaribales(setVariablesPayload);
        }
        if (payload.getSubmit() != null && payload.getSubmit()) {
            serverApplyProc(save);
        }
        return TServerApplyConvert.INSTANCE.toVo(save);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public long updateByKeyDynamic(TServerApplyPayload payload) {
        TServerApplyDO entity = tServerApplyRepo.findById(payload.getId()).orElseGet(TServerApplyDO::new);
        Assert.notNull(entity.getId(), "不存在");
        long result = tServerApplyDAO.updateByKeyDynamic(payload);
        return result;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void deleteSoft(List<Long> keys) {
        if (!keys.isEmpty()) {
            tServerApplyDAO.deleteSoft(keys);
        }
    }

    private void serverApplyProc(TServerApplyDO applyDo) {
        ProcessInfo processInfo = new ProcessInfo();
        String status = WorkFlowStatusEnum.CREATE_WORK.getCode();
        if (workflow_enabled) {
            status = WorkFlowStatusEnum.APPROVING_WORK.getCode();
            HashMap<String, Object> variables = new HashMap<>();

            //获取申请人
            Long applyResId = applyDo.getUserResId();
            // 判断是否是云服务器
            if ("CLOUD".equals(applyDo.getType())) {
                variables.put("cloudServerFlag", true);
                //获取费用承担部门
//                Long expenseBuId = applyDo.getExpenseBuId();
//                Long expenseBuManageUserId = daoOrg.queryManageIdById(expenseBuId);
//                variables.put("Activity_0zkpvgk", expenseBuManageUserId);
//                variables.put("Activity_0ph077t", null);
            } else {
                variables.put("cloudServerFlag", false);
                // 获取使用人部门负责人
//                Long userBuId = applyDo.getUserBuId();
////                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(applyDo.getUserResId());
//                Long userBuManageUserId = daoOrg.queryManageIdById(userBuId);
//                variables.put("Activity_0ph077t", userBuManageUserId);
//                variables.put("Activity_0zkpvgk", null);
            }
            //获取费用承担部门
            Long expenseBuId = applyDo.getExpenseBuId();
            Long expenseBuManageUserId = daoOrg.queryManageIdById(expenseBuId);
            variables.put("Activity_0zkpvgk", expenseBuManageUserId);
//            variables.put("Activity_0ph077t", null);
            // 获取使用人部门负责人
            Long userBuId = applyDo.getUserBuId();
            Long userBuManageUserId = daoOrg.queryManageIdById(userBuId);
            variables.put("Activity_0ph077t", userBuManageUserId);
//            variables.put("Activity_0zkpvgk", null);

//
//            Long userBuId = applyDo.getUserBuId();
////                PrdOrgEmployeeRefVO prdOrgEmployeeRefVO = employeeDAO.queryUserOrgData(applyDo.getUserResId());
//            Long userBuManageUserId = daoOrg.queryManageIdById(userBuId);
//            variables.put("Activity_0ph077t", userBuManageUserId);

            String applyResName = cacheUtil.getUserName(applyResId);
            // 平台IT负责人
            PrdOrgRoleVO platItAdmin = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, "PLAT_IT_ADMIN");
            if (ObjectUtils.isEmpty(platItAdmin)) {
                throw TwException.error("","平台IT负责人角色不存在！");
            }
            String[] splitByPlatItAdmin = platItAdmin.getRoleEmployees().split(",");
            variables.put("Activity_1tge65e", Arrays.asList(splitByPlatItAdmin));

            // 平台采购主管
            PrdOrgRoleVO purchaseManager = daoOrg.queryRoleByOrgIdAndRoleCode(workflow_orgId, "PURCHASE_MANAGER");
            if (ObjectUtils.isEmpty(purchaseManager)) {
                throw TwException.error("","平台采购主管角色不存在！");
            }
            String[] splitByPurchaseManager = purchaseManager.getRoleEmployees().split(",");
            variables.put("Activity_1gcgq14", Arrays.asList(splitByPurchaseManager));

            //发起流程审批
            processInfo = workflowUtil.startProcess(StartProcessPayload.of(
                    ProcDefKey.SERVER_APPLY.name(),
                    applyResName + "-服务器申请流程",
                    applyDo.getId() + "",
                    variables)
            );
        }
        //流程启动成功后，回写业务表数据
        TServerApplyPayload payload = new TServerApplyPayload();
        payload.setProcInstId(processInfo.getProcInstId());
        payload.setId(applyDo.getId());
        payload.setProcInstStatus(processInfo.getProcInstStatus());
        payload.setSubmitTime(LocalDateTime.now());
        payload.setApplyStatus(status);
//        payload.setApplyNo(String.valueOf(applyDo.getId()));
        //开启事务执行修改，主要是修改审批状态
        transactionUtilService.executeWithRunnable(() -> {
            tServerApplyDAO.updateByKeyDynamic(payload);
        });
    }

}
