package com.elitesland.tw.tw5.server.prd.org.entity;

import com.elitescloud.cloudt.common.annotation.Comment;
import com.elitescloud.boot.model.entity.BaseModel;
import lombok.Data;
import lombok.Getter;
import lombok.Setter;
import org.hibernate.annotations.Where;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.io.Serializable;

@Entity
@Table(name = "prd_org_version", indexes = {@Index(name = "dimension_index", columnList = "dimension_id")})
@org.hibernate.annotations.Table(appliesTo = "prd_org_version", comment = "组织维度版本表")
@Data
@Getter
@Setter
@Where(clause = "delete_flag= 0")
public class PrdOrgVersionDO extends BaseModel implements Serializable {

    private static final long serialVersionUID = 1L;

    @Comment("维度id")
    @Column(name = "dimension_id", nullable = false)
    private Long dimensionId;

    @Comment("版本号")
    @Column()
    private String versionNo;

    @Comment("版本变更原因")
    @Column()
    private String changeRecord;


}
