package com.elitesland.tw.tw5.server.prd.partner.business.controller;

import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.query.BusinessOperationSitesQuery;
import com.elitesland.tw.tw5.api.prd.partner.business.service.BusinessOperationSitesService;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;

/**
 * 业务合作伙伴-年报网址
 *
 * @author wangly
 * @date 2023-05-18
 */
@Api(tags = "业务合作伙伴-年报网址")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/businessOperationSites")
@Slf4j
public class BusinessOperationSitesController {

    private final BusinessOperationSitesService businessOperationSitesService;

    /**
     * 业务合作伙伴-年报网址-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务合作伙伴-年报网址-新增")
    public TwOutputUtil insert(@RequestBody BusinessOperationSitesPayload payload){
        if (null == payload.getPartnerId()) {
            return TwOutputUtil.error("999", "partnerId参数缺失", payload);
        }
        return TwOutputUtil.ok(businessOperationSitesService.insert(payload));
    }

    /**
     * 业务合作伙伴-年报网址-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务合作伙伴-年报网址-更新")
    public TwOutputUtil update(@RequestBody BusinessOperationSitesPayload payload){
        return TwOutputUtil.ok(businessOperationSitesService.update(payload));
    }

    /**
     * 业务合作伙伴-年报网址-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/{key}")
    // @UdcNameClass
    @ApiOperation("业务合作伙伴-年报网址-主键查询")
    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
        return TwOutputUtil.ok(businessOperationSitesService.queryByKey(key));
    }

    /**
     * 业务合作伙伴-年报网址-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/paging")
    // @UdcNameClass
    @ApiOperation("业务合作伙伴-年报网址-分页")
    public TwOutputUtil paging(BusinessOperationSitesQuery query) {
        if (null == query.getPartnerId()) {
            return TwOutputUtil.error("999", "partnerId参数缺失", null);
        }
        return TwOutputUtil.ok(businessOperationSitesService.queryPaging(query));
    }

    /**
     * 业务合作伙伴-年报网址-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    // @UdcNameClass
    @ApiOperation("业务合作伙伴-年报网址-查询列表")
    public TwOutputUtil queryList(BusinessOperationSitesQuery query) {
        if (null == query.getPartnerId()) {
            return TwOutputUtil.error("999", "partnerId参数缺失", null);
        }
        return TwOutputUtil.ok(businessOperationSitesService.queryListDynamic(query));
    }

    /**
     * 业务合作伙伴-年报网址-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务合作伙伴-年报网址-删除")
    public TwOutputUtil deleteSoft(Long[] keys) {
        businessOperationSitesService.deleteSoft(Arrays.asList(keys));
        return TwOutputUtil.ok();
    }

}
