package com.elitesland.tw.tw5.server.prd.partner.business.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.elitescloud.boot.common.param.BaseViewModel;
import com.elitescloud.boot.core.base.BaseServiceImpl;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmLeadsQuery;
import com.elitesland.tw.tw5.api.prd.crm.query.CrmOpportunityQuery;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmLeadsService;
import com.elitesland.tw.tw5.api.prd.crm.service.CrmOpportunityService;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmActDynamicVO;
import com.elitesland.tw.tw5.api.prd.crm.vo.CrmFollowVO;
import com.elitesland.tw.tw5.api.prd.partner.business.constants.PartnerBusinessTypeEnum;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEmployeesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationEnterpriseInfoPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationPartnerPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.payload.BusinessOperationSitesPayload;
import com.elitesland.tw.tw5.api.prd.partner.business.service.*;
import com.elitesland.tw.tw5.api.prd.partner.business.vo.PartnerBusinessCountVO;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BusinessPartnerService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BusinessPartnerVO;
import com.elitesland.tw.tw5.api.prd.salecon.query.SaleConContractQuery;
import com.elitesland.tw.tw5.api.prd.salecon.service.SaleConContractService;
import com.elitesland.tw.tw5.api.prd.visit.query.VisitTaskQuery;
import com.elitesland.tw.tw5.api.prd.visit.service.VisitTaskService;
import com.elitesland.tw.tw5.api.prd.visit.vo.VisitTaskVO;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.CrmFollowObjectEnum;
import com.elitesland.tw.tw5.server.prd.common.functionEnum.SaleConEnum;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmActActivityDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmFollowDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmLeadsDAO;
import com.elitesland.tw.tw5.server.prd.crm.dao.CrmOpportunityDAO;
import com.elitesland.tw.tw5.server.prd.crm.entity.CrmFollowDO;
import com.elitesland.tw.tw5.server.prd.crm.service.CrmFollowServiceImpl;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskPlanObjTypeEnum;
import com.elitesland.tw.tw5.server.prd.crm.visit.constants.VisitTaskStatusEnum;
import com.elitesland.tw.tw5.server.prd.qixin.dto.*;
import com.elitesland.tw.tw5.server.prd.qixin.service.QiXinService;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

import javax.annotation.Resource;
import java.util.*;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

/**
 * CRM业务伙伴管理
 *
 * @author wangluyu
 * @date 2023-05-16
 */
@Service
@RequiredArgsConstructor
@Slf4j
public class CrmBusinessPartnerServiceImpl extends BaseServiceImpl implements CrmBusinessPartnerService {

    private final BusinessOperationEnterpriseInfoService enterpriseInfoService;
    private final BusinessOperationSitesService sitesService;
    private final BusinessOperationPartnerService partnersService;
    private final BusinessOperationEmployeesService employeesService;
    private final QiXinService qiXinService;
    private final CrmFollowDAO followDAO;
    private final CrmFollowServiceImpl followService;
    private final CrmLeadsDAO leadsDAO;
    private final CrmOpportunityDAO opportunityDAO;
    private final CrmActActivityDAO actActivityDAO;
    @Resource
    private VisitTaskService visitTaskService;
    @Resource
    private BusinessPartnerService businessPartnerService;

    private final CrmOpportunityService crmOpportunityService;

    private final CrmLeadsService crmLeadsService;

    private final SaleConContractService contractService;

//    @Resource
//    private ContractService contractService;

    /**
     * 启信宝type_new字段翻译
     */
    private static final Map<String, String> qxbTypeNewMap = new HashMap<>() {{
        put("01", "大陆企业");
        put("02", "社会组织");
        put("03", "机关及事业单位");
        put("04", "港澳台及国外企业");
        put("05", "律所及其他组织机构");
    }};

    /**
     * 补充启信宝信息
     *
     * @param partnerName 伙伴名称
     * @param partnerId   业务伙伴主键 business_partner.id
     * @param bookId      地址簿主键
     * @return boolean
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean fillQxbInfo(String partnerName, long partnerId, Long bookId) {
        if (!StringUtils.hasText(partnerName)) {
            log.error("补充启信宝信息 参数缺失partnerName:{}", partnerName);
            return false;
        }
        partnerName = partnerName.trim();

        //基本信息
        String qxbBasicInfoStr = qiXinService.getBasicInfo(partnerName);
        log.info("根据关键字[{}]查询启信宝企业基本信息结果:{}", partnerName, qxbBasicInfoStr);
        QxbRootDTO qxbBasicInfoRoot = JSON.parseObject(qxbBasicInfoStr, QxbRootDTO.class);
        if (!QxbRootDTO.SUCCESS.equals(qxbBasicInfoRoot.getStatus())) {
            log.error("启信宝查询企业基本信息异常：{}",qxbBasicInfoStr);
            //基本信息接口失败，就认为所有接口都失败
            return false;
        }

        QxbBasicInfoDTO qxbBasicInfoDTO = qxbBasicInfoRoot.getData().toJavaObject(QxbBasicInfoDTO.class);
        BusinessOperationEnterpriseInfoPayload operationEnterpriseInfoPayload = new BusinessOperationEnterpriseInfoPayload();
        operationEnterpriseInfoPayload.setOrgNo(qxbBasicInfoDTO.getOrgNo());
        operationEnterpriseInfoPayload.setStartDate(qxbBasicInfoDTO.getStartDate());
        operationEnterpriseInfoPayload.setOperName(qxbBasicInfoDTO.getOperName());
        operationEnterpriseInfoPayload.setCreditNo(qxbBasicInfoDTO.getCreditNo());
        operationEnterpriseInfoPayload.setNewStatus(qxbBasicInfoDTO.getNew_status());
        operationEnterpriseInfoPayload.setActualCapi(qxbBasicInfoDTO.getActualCapi());
        operationEnterpriseInfoPayload.setTitle(qxbBasicInfoDTO.getTitle());
        operationEnterpriseInfoPayload.setCheckDate(qxbBasicInfoDTO.getCheckDate());
        if (StringUtils.hasText(qxbBasicInfoDTO.getType_new())) {
            String typeNew = qxbTypeNewMap.get(qxbBasicInfoDTO.getType_new());
            operationEnterpriseInfoPayload.setTypeNew(typeNew);
        }
        operationEnterpriseInfoPayload.setScope(qxbBasicInfoDTO.getScope());

        //联系方式
//        String contactInfoStr = qiXinService.getContactInfo(partnerName);
//        log.info("根据关键字[{}]查询启信宝企业联系方式结果:{}", partnerName, contactInfoStr);
//        QxbRootDTO qxbContactInfoRoot = JSON.parseObject(contactInfoStr, QxbRootDTO.class);
//        if (QxbRootDTO.SUCCESS.equals(qxbContactInfoRoot.getStatus())) {
//            QxbContactInfoDTO qxbContactInfoDTO = qxbContactInfoRoot.getData().toJavaObject(QxbContactInfoDTO.class);
//
//            // TODO 设置客户地址
////            CrmCustomerOperationDO operationDO = repo.findById(partnerId).get();
////            boolean changed = false;
////            if (StringUtils.hasText(qxbContactInfoDTO.getAddress())) {
////                operationDO.setCustAddress(qxbContactInfoDTO.getAddress());
////                changed = true;
////            }
////            if (StringUtils.hasText(qxbContactInfoDTO.getTelephone())) {
////                operationDO.setLandline(qxbContactInfoDTO.getTelephone());
////                changed = true;
////            }
////            if (StringUtils.hasText(qxbContactInfoDTO.getEmail())) {
////                operationDO.setEmail(qxbContactInfoDTO.getEmail());
////                changed = true;
////            }
////            if (changed) {
////                repo.save(operationDO);
////            }
//
//        }

        //企业简介
        String entBriefStr = qiXinService.getEntBriefByName(partnerName);
        log.info("根据关键字[{}]查询启信宝企业简介结果:{}", partnerName, entBriefStr);
        QxbRootDTO qxbEntBriefRoot = JSON.parseObject(entBriefStr, QxbRootDTO.class);
        if (QxbRootDTO.SUCCESS.equals(qxbEntBriefRoot.getStatus())) {
            QxbEntBriefDTO qxbEntBriefDTO = qxbEntBriefRoot.getData().toJavaObject(QxbEntBriefDTO.class);
            operationEnterpriseInfoPayload.setEnterpriseDesc(qxbEntBriefDTO.getBrief());
        }
//        operationPayload.setEnterpriseInfo(operationEnterpriseInfoPayload);
        saveEnterpriseInfo(operationEnterpriseInfoPayload, partnerId, bookId, partnerName);
        //年报网址
        String qxbGetWebsitesStr = qiXinService.getGetWebsites(partnerName, null);
        log.info("根据关键字[{}]查询启信宝企业年报网址结果:{}", partnerName, qxbGetWebsitesStr);
        QxbRootDTO qxbGetWebsitesRoot = JSON.parseObject(qxbGetWebsitesStr, QxbRootDTO.class);
        if (QxbRootDTO.SUCCESS.equals(qxbGetWebsitesRoot.getStatus())) {
            JSONObject data = qxbGetWebsitesRoot.getData();
            JSONArray items = data.getJSONArray("items");
            List<QxbGetWebSiteDTO> qxbGetWebSiteDTOList = items.toJavaList(QxbGetWebSiteDTO.class);
            List<BusinessOperationSitesPayload> sitesList = qxbGetWebSiteDTOList.stream().map(qxbGetWebSiteDTO -> {
                BusinessOperationSitesPayload sitesPayload = new BusinessOperationSitesPayload();
                sitesPayload.setDate(qxbGetWebSiteDTO.getDate());
                sitesPayload.setUrl(qxbGetWebSiteDTO.getUrl());
                return sitesPayload;
            }).collect(Collectors.toList());
//            operationPayload.setSitesList(sitesList);
            saveSites(sitesList, partnerId, bookId, partnerName);
        }
        //股东
        String qxbPartnersStr = qiXinService.getPartners(partnerName, null);
        log.info("根据关键字[{}]查询启信宝股东信息结果:{}", partnerName, qxbPartnersStr);
        QxbRootDTO qxbPartnersDTO = JSON.parseObject(qxbPartnersStr, QxbRootDTO.class);
        if (QxbRootDTO.SUCCESS.equals(qxbPartnersDTO.getStatus())) {
            JSONObject data = qxbPartnersDTO.getData();
            JSONArray items = data.getJSONArray("items");
            List<QxbPartnersDTO> qxbPartnersDTOList = items.toJavaList(QxbPartnersDTO.class);
            List<BusinessOperationPartnerPayload> partnersList = qxbPartnersDTOList.stream().map(qxbPartnersDTO1 -> {
                BusinessOperationPartnerPayload partnersPayload = new BusinessOperationPartnerPayload();
                partnersPayload.setName(qxbPartnersDTO1.getName());
                partnersPayload.setStockPercent(qxbPartnersDTO1.getStockPercent());
                partnersPayload.setTotalShouldCapi(qxbPartnersDTO1.getTotalShouldCapi());
                partnersPayload.setTotalRealCapi(qxbPartnersDTO1.getTotalRealCapi());
                return partnersPayload;
            }).collect(Collectors.toList());
//            operationPayload.setPartnersList(partnersList);
            savePartners(partnersList, partnerId, bookId,partnerName);
        }

        //主要人员
        String qxbGetEmployeesStr = qiXinService.getGetEmployees(partnerName, null);
        log.info("根据关键字[{}]查询启信宝主要人员字段结果:{}", partnerName, qxbGetEmployeesStr);
        QxbRootDTO qxbGetEmployeesRoot = JSON.parseObject(qxbGetEmployeesStr, QxbRootDTO.class);
        if (QxbRootDTO.SUCCESS.equals(qxbGetEmployeesRoot.getStatus())) {
            JSONObject data = qxbGetEmployeesRoot.getData();
            JSONArray items = data.getJSONArray("items");
            List<QxbGetEmployeeDTO> qxbGetEmployeeDTOList = items.toJavaList(QxbGetEmployeeDTO.class);
            List<BusinessOperationEmployeesPayload> employeesList = qxbGetEmployeeDTOList.stream().map(qxbGetEmployeeDTO -> {
                BusinessOperationEmployeesPayload employeesPayload = new BusinessOperationEmployeesPayload();
                employeesPayload.setName(qxbGetEmployeeDTO.getName());
                employeesPayload.setTitle(qxbGetEmployeeDTO.getTitle());
                employeesPayload.setIsHistory(qxbGetEmployeeDTO.getIs_history());
                return employeesPayload;
            }).collect(Collectors.toList());
//            operationPayload.setEmployeesList(employeesList);
            saveEmployees(employeesList, partnerId, bookId,partnerName);
        }
        return true;
    }

    @Override
    @Transactional
    public void deleteQxbInfo(long partnerId) {
        //删除企业简介
        enterpriseInfoService.deleteByPartnerId(partnerId);
        //年报网址
        sitesService.deleteByPartnerId(partnerId);
        //股东
        partnersService.deleteByPartnerId(partnerId);
        //主要人员
        employeesService.deleteByPartnerId(partnerId);
    }

    /**
     * 补充启信宝信息
     *
     * @param keys 键
     * @return boolean
     */
    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean fillQxbInfo(List<Long> keys) {
        AtomicBoolean result = new AtomicBoolean(false);
        if (!keys.isEmpty()) {
            List<BusinessPartnerVO> businessPartnerVOS = businessPartnerService.queryListByIds(keys);
            businessPartnerVOS.forEach(businessPartnerVO -> {
                result.set(fillQxbInfo(businessPartnerVO.getPartnerName(), businessPartnerVO.getId(), businessPartnerVO.getBookId()));
            });
        }
        return result.get();
    }

    /**
     * 经营往来
     *
     * @param customerId 合作伙伴id
     * @return {@link List}<{@link CrmFollowVO}>
     */
    @Override
    public List<CrmFollowVO> followList(Long customerId,String type) {
        if (null == customerId) {
            return Collections.emptyList();
        }
        //线索
        if("0".equals(type)){
            //分别查询并排序
            List<CrmFollowVO> followVOS = new ArrayList<>();
            //客户关联的线索列表
            List<Long> leadIds = leadsDAO.queryLeadsByPartnerId(customerId);
            if (!CollectionUtils.isEmpty(leadIds)) {
                // 线索跟进
                List<CrmFollowDO> leadsFollowDos = followDAO.queryByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
                followVOS.addAll(followService.toListVo(CrmFollowObjectEnum.Leads, leadsFollowDos));

                //线索关联的市场活动列表
                List<Long> activiyProjIds = actActivityDAO.queryByLeadsIds(leadIds);
                if (!CollectionUtils.isEmpty(activiyProjIds)) {
                    List<Long> actIds = actActivityDAO.queryByIds(activiyProjIds);
                    if (actIds != null && !actIds.isEmpty()) {
                        List<CrmFollowVO> activityFollowVOS = new ArrayList<>();
                        List<CrmActDynamicVO> dynamicVOS = actActivityDAO.queryActDynamicByPrjIds(actIds);
                        for (CrmActDynamicVO dynamicVO : dynamicVOS) {
                            CrmFollowVO followVO = new CrmFollowVO();
                            followVO.setCreateTime(dynamicVO.getCreateTime());
                            followVO.setCreateUserId(dynamicVO.getCreateUserId());
                            followVO.setCreateUserName(dynamicVO.getEmployeeName());
                            followVO.setFollowContent(dynamicVO.getDynamicContent());
                            followVO.setFollowObject("activity");
                            followVO.setFollowObjectDesc("市场活动");
                            followVO.setFollowType(dynamicVO.getDynamicType());
                            followVO.setFollowTypeDesc(dynamicVO.getDynamicTypeName());
                            followVO.setId(dynamicVO.getId());
                            followVO.setModifyTime(dynamicVO.getModifyTime());
                            followVO.setModifyUserId(dynamicVO.getModifyUserId());
                            activityFollowVOS.add(followVO);
                        }
                        followVOS.addAll(activityFollowVOS);
                    }
                }
            }
            return followVOS.stream().sorted(Comparator.comparing(BaseViewModel::getCreateTime)).collect(Collectors.toList());
        }

        if("1".equals(type)){
            List<CrmFollowVO> followVOS = new ArrayList<>();

            //客户关联的商机列表
            List<Long> oppoIds = opportunityDAO.queryByFormalCustomerId(customerId);
            if (!CollectionUtils.isEmpty(oppoIds)) {
                List<CrmFollowDO> oppoFollowDos = followDAO.queryByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
                followVOS.addAll(followService.toListVo(CrmFollowObjectEnum.Opportunity, oppoFollowDos));
            }
            return followVOS.stream().sorted(Comparator.comparing(BaseViewModel::getCreateTime)).collect(Collectors.toList());

        }

        if("2".equals(type)){
            List<CrmFollowVO> followVOS = new ArrayList<>();
            // duwh 销售拜访
            VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
            visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
            visitTaskQuery.setPartnerId(customerId);
            //默认按照时间倒叙排序
            OrderItem orderItem = OrderItem.desc("submitTime");
            List<OrderItem> orderItemList = new ArrayList<>();
            orderItemList.add(orderItem);
            visitTaskQuery.setOrders(orderItemList);
            List<VisitTaskVO> visitTaskVOS = visitTaskService.queryListDynamicWithoutPermission(visitTaskQuery);
            if (!CollectionUtils.isEmpty(visitTaskVOS)) {
                List<CrmFollowVO> activityFollowVOS = new ArrayList<>();
                for (VisitTaskVO visitTaskVO : visitTaskVOS) {
                    CrmFollowVO followVO = new CrmFollowVO();
                    followVO.setCreateTime(visitTaskVO.getSubmitTime());
                    followVO.setFollowType("task");
                    //往来类型
                    followVO.setFollowTypeDesc("见面拜访");
                    //拜访人员
                    followVO.setVisitMemberName(visitTaskVO.getVisitMemberName());
                    //协防人员
                    followVO.setTeamMemberNames(visitTaskVO.getTeamMemberNames());
                    //关联信息
                    if(StringUtils.hasText(visitTaskVO.getObjType())){
                        String content = visitTaskVO.getObjType();
                        VisitTaskPlanObjTypeEnum visitTaskPlanObjTypeEnum = VisitTaskPlanObjTypeEnum.valueOf(visitTaskVO.getObjType());
                        if(StringUtils.hasText(visitTaskVO.getObjName())){
                            content = visitTaskPlanObjTypeEnum.getDesc()+"-"+visitTaskVO.getObjName();
                        }
                        followVO.setRelationContent(content);
                    }

                    //关联信息id
                    followVO.setRelationId(visitTaskVO.getObjId());
                    //客户情况说明
                    followVO.setCustomerDesc(visitTaskVO.getCustomerDesc());
                    //拜访进展与结果
                    followVO.setResult(visitTaskVO.getResult());
                    //下次拜访时间
                    followVO.setNextVisitTime(visitTaskVO.getNextVisitTime());

                    followVO.setFollowObject("VISIT_TASK");
                    followVO.setFollowObjectDesc("销售拜访");

                    followVO.setId(visitTaskVO.getId());
                    followVO.setModifyTime(visitTaskVO.getModifyTime());
                    followVO.setModifyUserId(visitTaskVO.getModifyUserId());
                    activityFollowVOS.add(followVO);
                }
                followVOS.addAll(activityFollowVOS);
                return followVOS.stream().sorted(Comparator.comparing(BaseViewModel::getCreateTime)).collect(Collectors.toList());
            }
        }

        return null;
    }

    /**
     * 经营往来统计个数
     *
     * @param customerId 合作伙伴id
     * @return long
     */
    @Override
    public long countFollowList(Long customerId) {
        int result = 0;
        if (null == customerId) {
            return result;
        }
        //分别查询并排序
        List<CrmFollowVO> followVOS = new ArrayList<>();
        //客户关联的线索列表
        List<Long> leadIds = leadsDAO.queryLeadsByPartnerId(customerId);
        if (!CollectionUtils.isEmpty(leadIds)) {
            // 线索跟进
            long leadCount = followDAO.countByObjectIdsAndObjectType(leadIds, CrmFollowObjectEnum.Leads.getCode());
            result += leadCount;

            //线索关联的市场活动列表
            List<Long> activiyProjIds = actActivityDAO.queryByLeadsIds(leadIds);
            if (!CollectionUtils.isEmpty(activiyProjIds)) {
                List<Long> actIds = actActivityDAO.queryByIds(activiyProjIds);
                if (actIds != null && !actIds.isEmpty()) {
                    List<CrmFollowVO> activityFollowVOS = new ArrayList<>();
                    List<CrmActDynamicVO> dynamicVOS = actActivityDAO.queryActDynamicByPrjIds(actIds);
                    result+= dynamicVOS.size();
                }
            }
        }

        //客户关联的商机列表
        List<Long> oppoIds = opportunityDAO.queryByFormalCustomerId(customerId);
        if (!CollectionUtils.isEmpty(oppoIds)) {
            long oppoCount = followDAO.countByObjectIdsAndObjectType(oppoIds, CrmFollowObjectEnum.Opportunity.getCode());
            result += oppoCount;
        }

        // duwh 销售拜访
        VisitTaskQuery visitTaskQuery = new VisitTaskQuery();
        visitTaskQuery.setStatus(VisitTaskStatusEnum.OK.getCode());
        visitTaskQuery.setPartnerId(customerId);
        //默认按照时间倒叙排序
        OrderItem orderItem = OrderItem.desc("submitTime");
        List<OrderItem> orderItemList = new ArrayList<>();
        orderItemList.add(orderItem);
        visitTaskQuery.setOrders(orderItemList);
        long visitTaskCount = visitTaskService.count(visitTaskQuery);
        result += visitTaskCount;
        //按时间正序排序
        return result;
    }

    @Override
    public long countBusiness(Long partnerId,Long bookId) {
        int result = 0;
        if(null == partnerId){
            return result;
        }
        //业务往来 todo
        // 业务往来 -商机
        CrmOpportunityQuery opportunityQuery = new CrmOpportunityQuery();
        opportunityQuery.setFormalCustomerId(partnerId);
        long oppoCount = crmOpportunityService.count(opportunityQuery);
        result += oppoCount;

        // 业务往来- 线索
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setFormalCustomerId(partnerId);
        long leadCount = crmLeadsService.count(leadsQuery);
        result += leadCount;

        // 业务往来 - 合同
        SaleConContractQuery contractQuery = new SaleConContractQuery();
        contractQuery.setCustId(bookId);
        contractQuery.setMainType(SaleConEnum.SUB.getCode());
        long contractCount = contractService.count(contractQuery);
        result += contractCount;
        return result;
    }

    @Override
    public List<PartnerBusinessCountVO> businessCount(Long partnerId) {
        if(null == partnerId){
            return Collections.emptyList();
        }
        List<PartnerBusinessCountVO> result = new ArrayList<>();
        //业务往来 todo
        // 业务往来 -商机
        CrmOpportunityQuery opportunityQuery = new CrmOpportunityQuery();
        opportunityQuery.setFormalCustomerId(partnerId);
        long oppoCount = crmOpportunityService.count(opportunityQuery);
        result.add(new PartnerBusinessCountVO(PartnerBusinessTypeEnum.OPPO,Long.valueOf(oppoCount).intValue()));

        // 业务往来- 线索
        CrmLeadsQuery leadsQuery = new CrmLeadsQuery();
        leadsQuery.setFormalCustomerId(partnerId);
        long leadCount = crmLeadsService.count(leadsQuery);
        result.add(new PartnerBusinessCountVO(PartnerBusinessTypeEnum.LEAD,Long.valueOf(leadCount).intValue()));

        // 业务往来 - 合同
        SaleConContractQuery contractQuery = new SaleConContractQuery();
        contractQuery.setCustId(partnerId);
        long contractCount = contractService.count(contractQuery);
        result.add(new PartnerBusinessCountVO(PartnerBusinessTypeEnum.CONTRACT,Long.valueOf(contractCount).intValue()));
        return result;
    }

    /**
     * 1.45 主要人员 保存
     *
     * @param employeesList 有效载荷
     * @param partnerId     ③id
     * @param bookId
     */
    private void saveEmployees(List<BusinessOperationEmployeesPayload> employeesList, Long partnerId, Long bookId,String partnerName) {
        if (!CollectionUtils.isEmpty(employeesList)) {
            employeesList.forEach(employeesPayload -> {
                employeesPayload.setPartnerId(partnerId);
                employeesPayload.setBookId(bookId);
                employeesPayload.setPartnerName(partnerName);
                employeesService.insert(employeesPayload);
            });
        }
    }

    /**
     * 1.43 工商股东（含历史） 保存
     *
     * @param partnersList 有效载荷
     * @param partnerId    业务伙伴主键 business_partner.id
     * @param bookId
     */
    private void savePartners(List<BusinessOperationPartnerPayload> partnersList, Long partnerId, Long bookId,String partnerName) {
        if (!CollectionUtils.isEmpty(partnersList)) {
            partnersList.forEach(partnersPayload -> {
                partnersPayload.setPartnerId(partnerId);
                partnersPayload.setBookId(bookId);
                partnersPayload.setPartnerName(partnerName);
                partnersService.insert(partnersPayload);
            });
        }
    }

    /**
     * 1.53 企业年报网址 保存
     *
     * @param sitesList 有效载荷
     * @param partnerId 业务伙伴主键 business_partner.id
     * @param bookId
     */
    private void saveSites(List<BusinessOperationSitesPayload> sitesList, Long partnerId, Long bookId, String partnerName) {
        if (!CollectionUtils.isEmpty(sitesList)) {
            sitesList.forEach(site -> {
                site.setPartnerId(partnerId);
                site.setBookId(bookId);
                site.setPartnerName(partnerName);
                sitesService.insert(site);
            });
        }
    }

    /**
     * 工商照面信息保存
     *
     * @param enterpriseInfo 有效载荷
     * @param partnerId      业务伙伴主键 business_partner.id
     * @param bookId
     */
    private void saveEnterpriseInfo(BusinessOperationEnterpriseInfoPayload enterpriseInfo, Long partnerId, Long bookId,String partnerName) {
        if (null != enterpriseInfo) {
            enterpriseInfo.setPartnerId(partnerId);
            enterpriseInfo.setBookId(bookId);
            enterpriseInfo.setPartnerName(partnerName);
            enterpriseInfoService.insert(enterpriseInfo);
        }
    }

}
