package com.elitesland.tw.tw5.server.prd.partner.common.controller;

import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookInvoicePayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookInvoiceQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.service.BookInvoiceService;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookInvoiceVO;
import com.elitesland.tw.tw5.server.common.TwOutputUtil;
import com.elitesland.tw.tw5.server.udc.UdcNameClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.RequiredArgsConstructor;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.*;

import java.util.Arrays;
import java.util.List;

/**
 * 业务伙伴-发票信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Api(tags = "业务伙伴-发票信息")
@RestController
@RequiredArgsConstructor
@RequestMapping("/api/crm/bookInvoice")
@Slf4j
public class BookInvoiceController {

    private final BookInvoiceService bookInvoiceService;

    /**
     * 业务伙伴-发票信息-新增
     *

     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PostMapping
    @ApiOperation("业务伙伴-发票信息-新增")
    public TwOutputUtil insert(@RequestBody BookInvoicePayload payload){
        return TwOutputUtil.ok(bookInvoiceService.insert(payload,true));
    }

    /**
     * 业务伙伴-发票信息-更新
     *
     * @param payload 有效载荷
     * @return {@link TwOutputUtil}
     */
    @PutMapping
    @ApiOperation("业务伙伴-发票信息-更新")
    public TwOutputUtil update(@RequestBody BookInvoicePayload payload){
        return TwOutputUtil.ok(bookInvoiceService.update(payload,true));
    }

    /**
     * 业务伙伴-发票信息-主键查询
     *
     * @param key 关键
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/{key}")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-发票信息-主键查询")
//    public TwOutputUtil queryOneByKey(@PathVariable Long key) {
//        return TwOutputUtil.ok(bookInvoiceService.queryByKey(key));
//    }

    /**
     * 业务伙伴-发票信息-分页
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
//    @GetMapping("/paging")
//    // @UdcNameClass
//    @ApiOperation("业务伙伴-发票信息-分页")
//    public TwOutputUtil paging(BookInvoiceQuery query) {
//        return TwOutputUtil.ok(bookInvoiceService.queryPaging(query));
//    }

    /**
     * 业务伙伴-发票信息-查询列表
     *
     * @param query 查询
     * @return {@link TwOutputUtil}
     */
    @GetMapping("/list")
    @UdcNameClass
    @ApiOperation("业务伙伴-发票信息-查询列表")
    public TwOutputUtil<List<BookInvoiceVO>> queryList(BookInvoiceQuery query) {
        return TwOutputUtil.ok(bookInvoiceService.queryListDynamic(query));
    }

    /**
     * 业务伙伴-发票信息-删除
     *
     * @param keys 主键id
     * @return result
     */
    @DeleteMapping("/deleteSoft")
    @ApiOperation("业务伙伴-发票信息-删除")
    public TwOutputUtil deleteSoft(Long[] keys,Long bookId,Long partnerId) {
        bookInvoiceService.deleteSoft(Arrays.asList(keys),bookId,partnerId,true);
        return TwOutputUtil.ok();
    }

}
