package com.elitesland.tw.tw5.server.prd.partner.common.dao;

import com.elitescloud.cloudt.common.base.PagingVO;
import com.elitescloud.cloudt.common.base.param.OrderItem;
import com.elitesland.tw.tw5.api.prd.partner.common.payload.BookAddressPayload;
import com.elitesland.tw.tw5.api.prd.partner.common.query.BookAddressQuery;
import com.elitesland.tw.tw5.api.prd.partner.common.vo.BookAddressVO;
import com.elitesland.tw.tw5.server.common.util.SqlUtil;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.BookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.entity.QBookAddressDO;
import com.elitesland.tw.tw5.server.prd.partner.common.repo.BookAddressRepo;
import com.elitesland.tw.tw5.server.prd.partner.constants.BookAddressTypeEnum;
import com.querydsl.core.types.ExpressionUtils;
import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.Projections;
import com.querydsl.jpa.impl.JPAQuery;
import com.querydsl.jpa.impl.JPAQueryFactory;
import com.querydsl.jpa.impl.JPAUpdateClause;
import lombok.RequiredArgsConstructor;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.List;

/**
 * 业务伙伴-地址信息
 *
 * @author wangly
 * @date 2023-05-16
 */
@Repository
@RequiredArgsConstructor
public class BookAddressDAO {

    private final JPAQueryFactory jpaQueryFactory;
    private final BookAddressRepo repo;
    private final QBookAddressDO qdo = QBookAddressDO.bookAddressDO;

    /**
     * 拼装查询字段
     *
     * @return jpaQuery对象
     */
    private JPAQuery<BookAddressVO> getJpaQuerySelect() {
        return jpaQueryFactory.select(Projections.bean(BookAddressVO.class,
                qdo.id,
                qdo.remark,
                qdo.createUserId,
                qdo.creator,
                qdo.createTime,
                //qdo.modifyUserId,
                //qdo.updater,
                //qdo.modifyTime,
                // 地址薄id
                qdo.bookId,
                // 地址类型
                qdo.addressType,
                // 国家
                qdo.country,
                // 省
                qdo.province,
                // 市
                qdo.city,
                // 区
                qdo.district,
                // 详细地址
                qdo.detailAddress,
                // 电话
                qdo.phone,
                // 邮箱
                qdo.email,
                //传真
                qdo.fax,
                // 联系人名称
                qdo.contractName,
                // 省
                qdo.provinceName,
                // 市
                qdo.cityName,
                // 区
                qdo.districtName,
                // 是否为默认地址信息
                qdo.isDefault,
                // 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标
                qdo.longitudeLatitude
        )).from(qdo);
    }

    /**
     * 拼装查询条件
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    private JPAQuery<BookAddressVO> getJpaQueryWhere(BookAddressQuery query) {
        JPAQuery<BookAddressVO> jpaQuery = getJpaQuerySelect();
            // 条件封装
            jpaQuery.where(where(query));
            // 常用基础查询条件拼装
            SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
            // 动态排序
          //  jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
            return jpaQuery;
    }

    /**
     * 统计
     *
     * @param query 查询参数
     * @return jpaQuery对象
     */
    public long count(BookAddressQuery query) {
        JPAQuery<Long> jpaQuery = jpaQueryFactory
        .select(qdo.count())
        .from(qdo);
        jpaQuery.where(where(query));
        // 常用基础查询条件拼装
        SqlUtil.handleCommonJpaQuery(jpaQuery, qdo._super, query);
        long total = jpaQuery.fetchOne();
        return total;
    }

    /**
     * 查询条件封装
     *
     * @param query 条件
     * @return {@link Predicate}
     */
    private Predicate where(BookAddressQuery query){
        List<Predicate> list = new ArrayList<>();
        /** 记录唯一ID 精确 */
        if (!ObjectUtils.isEmpty(query.getId())) {
            list.add(qdo.id.eq(query.getId()));
        }
        /** 地址薄id 精确 */
        if (!ObjectUtils.isEmpty(query.getBookId())) {
            list.add(qdo.bookId.eq(query.getBookId()));
        }
        /** 地址类型 精确 */
        if (!ObjectUtils.isEmpty(query.getAddressType())) {
            list.add(qdo.addressType.eq(query.getAddressType()));
        }
        /** 国家 精确 */
        if (!ObjectUtils.isEmpty(query.getCountry())) {
            list.add(qdo.country.eq(query.getCountry()));
        }
        /** 省 精确 */
        if (!ObjectUtils.isEmpty(query.getProvince())) {
            list.add(qdo.province.eq(query.getProvince()));
        }
        /** 市 精确 */
        if (!ObjectUtils.isEmpty(query.getCity())) {
            list.add(qdo.city.eq(query.getCity()));
        }
        /** 区 精确 */
        if (!ObjectUtils.isEmpty(query.getDistrict())) {
            list.add(qdo.district.eq(query.getDistrict()));
        }
        /** 详细地址 精确 */
        if (!ObjectUtils.isEmpty(query.getDetailAddress())) {
            list.add(qdo.detailAddress.eq(query.getDetailAddress()));
        }
        /** 电话 精确 */
        if (!ObjectUtils.isEmpty(query.getPhone())) {
            list.add(qdo.phone.eq(query.getPhone()));
        }
        /** 邮箱 精确 */
        if (!ObjectUtils.isEmpty(query.getEmail())) {
            list.add(qdo.email.eq(query.getEmail()));
        }

        /** 传真 精确 */
        if (!ObjectUtils.isEmpty(query.getFax())) {
            list.add(qdo.fax.eq(query.getFax()));
        }
        /** 省 精确 */
        if (!ObjectUtils.isEmpty(query.getProvinceName())) {
            list.add(qdo.provinceName.eq(query.getProvinceName()));
        }
        /** 市 精确 */
        if (!ObjectUtils.isEmpty(query.getCityName())) {
            list.add(qdo.cityName.eq(query.getCityName()));
        }
        /** 区 精确 */
        if (!ObjectUtils.isEmpty(query.getDistrictName())) {
            list.add(qdo.districtName.eq(query.getDistrictName()));
        }
        /** 是否为默认地址信息 精确 */
        if (!ObjectUtils.isEmpty(query.getIsDefault())) {
            list.add(qdo.isDefault.eq(query.getIsDefault()));
        }
        /** 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标 精确 */
        if (!ObjectUtils.isEmpty(query.getLongitudeLatitude())) {
            list.add(qdo.longitudeLatitude.eq(query.getLongitudeLatitude()));
        }
        return ExpressionUtils.allOf(list);
    }

    /**
     * 根据主键查询
     *
     * @param id 主键
     * @return 结果
     */
    public BookAddressVO queryByKey(Long id) {
        JPAQuery<BookAddressVO> jpaQuery = getJpaQuerySelect();
            jpaQuery.where(qdo.id.eq(id));
            jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 动态查询集合
     *
     * @param query 查询参数
     * @return 结果集合
     */
    public List<BookAddressVO> queryListDynamic(BookAddressQuery query) {
        JPAQuery<BookAddressVO> jpaQuery = getJpaQueryWhere(query);
        OrderItem sortNoOrderItem = OrderItem.desc("isDefault");
        OrderItem createTimeOrderItem = OrderItem.desc("createTime");
        List<OrderItem> OrderItemList = new ArrayList<>();
        OrderItemList.add(sortNoOrderItem);
        OrderItemList.add(createTimeOrderItem);
        query.setOrders(OrderItemList);
        jpaQuery.orderBy(SqlUtil.getSortedColumn(qdo, query.getOrders()));
        return jpaQuery.fetch();
    }

    /**
     * 分页查询
     *
     * @param query 查询参数
     * @return 分页结果
     */
    public PagingVO<BookAddressVO> queryPaging(BookAddressQuery query) {
        long total = count(query);
        if (total == 0) {
             return PagingVO.empty();
        }
        JPAQuery<BookAddressVO> jpaQuery = getJpaQueryWhere(query);
        List<BookAddressVO> result = jpaQuery
                .offset(query.getPageRequest().getOffset())
                .limit(query.getPageRequest().getPageSize())
                .fetch();
        return PagingVO.<BookAddressVO>builder().records(result).total(total).build();
    }

    /**
     * 调用jpa的保存
     *
     * @param ado do对象
     * @return 保存后的对象
     */
    public BookAddressDO save(BookAddressDO ado) {
        return repo.save(ado);
    }

    /**
     * 调用jpa的保存所有
     *
     * @param dos 多个do对象
     * @return 保存后的对象集合
     */
    public List<BookAddressDO> saveAll(List<BookAddressDO> dos) {
        return repo.saveAll(dos);
    }

    /**
     * 按主键动态修改（只修非null字段，如果需要将某些字段修改为null，请添加nullFields）
     *
     * @param payload 要修改的对象
     * @return 修改的行数
     */
    @Transactional
    public long updateByKeyDynamic(BookAddressPayload payload) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
        .where(qdo.id.eq(payload.getId()));
        // 记录唯一ID
        if (payload.getId() != null) {
            update.set(qdo.id, payload.getId());
        }
        // 地址薄id
        if (payload.getBookId() != null) {
            update.set(qdo.bookId, payload.getBookId());
        }
        // 地址类型
        if (payload.getAddressType() != null) {
            update.set(qdo.addressType, payload.getAddressType());
        }
        // 国家
        if (payload.getCountry() != null) {
            update.set(qdo.country, payload.getCountry());
        }
        // 省
        if (payload.getProvince() != null) {
            update.set(qdo.province, payload.getProvince());
        }
        // 市
        if (payload.getCity() != null) {
            update.set(qdo.city, payload.getCity());
        }
        // 区
        if (payload.getDistrict() != null) {
            update.set(qdo.district, payload.getDistrict());
        }
        // 详细地址
        if (payload.getDetailAddress() != null) {
            update.set(qdo.detailAddress, payload.getDetailAddress());
        }
        // 电话
        if (payload.getPhone() != null) {
            update.set(qdo.phone, payload.getPhone());
        }
        // 邮箱
        if (payload.getEmail() != null) {
            update.set(qdo.email, payload.getEmail());
        }

        // 邮箱
        if (payload.getFax() != null) {
            update.set(qdo.fax, payload.getFax());
        }
        // 联系人名称
        if (payload.getContractName() != null) {
            update.set(qdo.contractName, payload.getContractName());
        }

        // 省
        if (payload.getProvinceName() != null) {
            update.set(qdo.provinceName, payload.getProvinceName());
        }
        // 市
        if (payload.getCityName() != null) {
            update.set(qdo.cityName, payload.getCityName());
        }
        // 区
        if (payload.getDistrictName() != null) {
            update.set(qdo.districtName, payload.getDistrictName());
        }
        // 是否为默认地址信息
        if (payload.getIsDefault() != null) {
            update.set(qdo.isDefault, payload.getIsDefault());
        }
        // 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标
        if (payload.getLongitudeLatitude() != null) {
            update.set(qdo.longitudeLatitude, payload.getLongitudeLatitude());
        }
        // 处理要设置成空的字段
        List<String> nullFields = payload.getNullFields();
        if (nullFields != null && nullFields.size() > 0) {
            // 记录唯一ID
            if (nullFields.contains("id")) {
                update.setNull(qdo.id);
            }
            // 地址薄id
            if (nullFields.contains("bookId")) {
                update.setNull(qdo.bookId);
            }
            // 地址类型
            if (nullFields.contains("addressType")) {
                update.setNull(qdo.addressType);
            }
            // 国家
            if (nullFields.contains("country")) {
                update.setNull(qdo.country);
            }
            // 省
            if (nullFields.contains("province")) {
                update.setNull(qdo.province);
            }
            // 市
            if (nullFields.contains("city")) {
                update.setNull(qdo.city);
            }
            // 区
            if (nullFields.contains("district")) {
                update.setNull(qdo.district);
            }
            // 详细地址
            if (nullFields.contains("detailAddress")) {
                update.setNull(qdo.detailAddress);
            }
            // 电话
            if (nullFields.contains("phone")) {
                update.setNull(qdo.phone);
            }
            // 邮箱
            if (nullFields.contains("email")) {
                update.setNull(qdo.email);
            }

            // 邮箱
            if (nullFields.contains("fax")) {
                update.setNull(qdo.fax);
            }
            // 省
            if (nullFields.contains("provinceName")) {
                update.setNull(qdo.provinceName);
            }
            // 市
            if (nullFields.contains("cityName")) {
                update.setNull(qdo.cityName);
            }
            // 区
            if (nullFields.contains("districtName")) {
                update.setNull(qdo.districtName);
            }
            // 是否为默认地址信息
            if (nullFields.contains("isDefault")) {
                update.setNull(qdo.isDefault);
            }
            // 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标
            if (nullFields.contains("longitudeLatitude")) {
                update.setNull(qdo.longitudeLatitude);
            }
        }
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        // 执行修改
        return update.execute();
    }

    /**
     * 逻辑删除
     *
     * @param keys 主集合
     * @return 删除的行数
     */
    public long deleteSoft(List<Long> keys) {
        JPAUpdateClause update = jpaQueryFactory.update(qdo)
            .set(qdo.deleteFlag, 1)
            .where(qdo.id.in(keys));
        //拼装更新
        SqlUtil.updateCommonJpaQuery(update, qdo._super);
        return update.execute();
    }
    // 通过bookId查询公司地址
    public List<BookAddressVO> queryAddressByBookId(List<Long> bookIds){
        JPAQuery<BookAddressVO> from = jpaQueryFactory.select(Projections.bean(BookAddressVO.class,
                // 省
                qdo.province,
                // 市
                qdo.city,
                // 区
                qdo.district,
                qdo.bookId
        )).from(qdo).where(qdo.bookId.in(bookIds).and(qdo.addressType.eq(BookAddressTypeEnum.company_addr.getCode()))).limit(1);
        return from.fetch();
    }

    /**
     * 根据bookId查询默认地址
     *
     * @param bookId bookId
     * @return {@link BookAddressVO}
     */
    public BookAddressVO queryDefaultByBookId(Long bookId) {
        JPAQuery<BookAddressVO> jpaQuery = getJpaQuerySelect();
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.isDefault.eq(Boolean.TRUE));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetchFirst();
    }

    /**
     * 根据bookId查询列表
     *
     * @param bookId bookId
     * @return {@link BookAddressDO}
     */
    public List<BookAddressDO> queryByBookId(Long bookId) {
        JPAQuery<BookAddressDO> jpaQuery = jpaQueryFactory.select(qdo).from(qdo);
        jpaQuery.where(qdo.bookId.eq(bookId));
        jpaQuery.where(qdo.deleteFlag.eq(0));
        return jpaQuery.fetch();
    }
//    /**
//     * 4.0同步地址信息查询
//     *
//     * @param bookIdList bookId
//     * @return {@link BookAddressDO}
//     */
//    public List<PrdAbAddressPayload> queryTwBookAddressListByBookId(List<Long> bookIdList){
//        return jpaQueryFactory.select(Projections.bean(PrdAbAddressPayload.class,
//                qdo.id,
//                qdo.remark,
//               // qdo.createUserId,
//               // qdo.creator,
//               // qdo.createTime,
//                //qdo.modifyUserId,
//                //qdo.updater,
//                //qdo.modifyTime,
//                // 地址薄id
//                qdo.bookId,
//                // 地址类型
//                qdo.addressType,
//                // 国家
//                qdo.country,
//                // 省
//                qdo.province,
//                // 市
//                qdo.city,
//                // 区
//                qdo.district,
//                // 详细地址
//                qdo.detailAddress,
//                // 电话
//                qdo.phone,
//                // 邮箱
//                qdo.email.as("addressEmail"),
//
//                // 省
//                qdo.provinceName,
//                // 市
//                qdo.cityName,
//                // 区
//                qdo.districtName,
//                // 是否为默认地址信息
//                qdo.isDefault.as("defaultAddress"),
//                // 经度和纬度用,分割，经度在前，纬度在后，经纬度小数点后不得超过6位。多个坐标对之间用”|”进行分隔最多支持40对坐标
//                qdo.longitudeLatitude
//        )).from(qdo).where(qdo.deleteFlag.eq(0)).where(qdo.bookId.in(bookIdList)).fetch();
//    }
}

